/*******************************************************************************
  XDG desktop portal implementation for TDE
  Copyright © 2024 Mavridis Philippe <mavridisf@gmail.com>

  Partially based on code from kdbusnotification
  Copyright © 2021 Emanoil Kotsev <deloptes@gmail.com>

  This program or library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public License as
  published by the Free Software Foundation; either version 2.1 of the License,
  or (at your option) any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
  FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
  details.

  You should have received a copy of the GNU Lesser General Public License
  along with this library; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

  Improvements and feedback are welcome!
*******************************************************************************/

// TQt
#include <tqdbusmessage.h>

// TDE
#include <tdemessagebox.h>
#include <kdebug.h>

// Portal
#include "account_portal.h"
#include "email_portal.h"
#include "file_chooser_portal.h"
#include "portal_service.h"


static const char *dbusObjectPath = "/org/freedesktop/portal/desktop";
static const char *dbusInterfaceRoot = "org.freedesktop.impl.portal";

DesktopNodeService::DesktopNodeService(TQT_DBusConnection &connection)
: org::freedesktop::portal::desktopNode(),
  m_connection(connection)
{
    m_interfaces.insert("org.freedesktop.DBus.Introspectable", this);

    REGISTER_PORTAL(TDEAccountPortal)
    REGISTER_PORTAL(TDEEmailPortal)
    REGISTER_PORTAL(TDEFileChooserPortal)

    registerObject(connection, dbusObjectPath);
}

DesktopNodeService::~DesktopNodeService()
{
    DESTROY_PORTAL(TDEAccountPortal)
    DESTROY_PORTAL(TDEEmailPortal)
    DESTROY_PORTAL(TDEFileChooserPortal)
}

TQT_DBusObjectBase* DesktopNodeService::createInterface(const TQString& iface)
{
    return (TQT_DBusObjectBase*) m_interfaces[iface];
}

// ----------------------------------------------------------------------------------------

PortalNodeService::PortalNodeService(TQT_DBusConnection &connection)
: DBusBaseNode(), m_connection(connection)
{
    addChildNode("desktop");
    registerObject(m_connection, "/org/freedesktop/portal");
}

PortalNodeService::~PortalNodeService()
{
}

TQT_DBusObjectBase* PortalNodeService::createInterface(const TQString& iface)
{
    return (TQT_DBusObjectBase*) m_interfaces[iface];
}

// ----------------------------------------------------------------------------------------

FreeDesktopNodeService::FreeDesktopNodeService(TQT_DBusConnection &connection)
: DBusBaseNode(), m_connection(connection)
{
    addChildNode("portal");
    registerObject(m_connection, "/org/freedesktop");
}

FreeDesktopNodeService::~FreeDesktopNodeService()
{
}

TQT_DBusObjectBase* FreeDesktopNodeService::createInterface(const TQString& iface)
{
    return (TQT_DBusObjectBase*) m_interfaces[iface];
}

// ----------------------------------------------------------------------------------------

OrgNodeService::OrgNodeService(TQT_DBusConnection &connection)
: DBusBaseNode(), m_connection(connection)
{
    addChildNode("freedesktop");
    registerObject(m_connection, "/org");
}

OrgNodeService::~OrgNodeService()
{
}

TQT_DBusObjectBase* OrgNodeService::createInterface(const TQString& iface)
{
    return (TQT_DBusObjectBase*) m_interfaces[iface];
}

// ----------------------------------------------------------------------------------------

RootNodeService::RootNodeService(TQT_DBusConnection &connection)
: DBusBaseNode(), m_connection(connection)
{
    addChildNode("org");
    registerObject(m_connection, "/");
}

RootNodeService::~RootNodeService()
{
}

TQT_DBusObjectBase* RootNodeService::createInterface(const TQString& iface)
{
    return (TQT_DBusObjectBase*) m_interfaces[iface];
}

// kate: replace-tabs true; tab-width 4; indent-width 4;