/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
*/

/*
  Copyright (C) 2007 Eike Hein <hein@kde.org>
*/


#ifndef SKIN_SETTINGS_H
#define SKIN_SETTINGS_H


#include "skin_settings_ui.h"

#include <tdeio/job.h>


class SkinSettings : public SkinSettingsUI
{
    Q_OBJECT
  

    public:
        explicit SkinSettings(TQWidget* parent, const char* name=NULL, bool translucency = false);
        ~SkinSettings();


    public slots:
        void slotResetSelection();


    signals:
        void settingsChanged();


    protected:
        void showEvent(TQShowEvent* e);


    private:
        void checkForExistingSkin();
        void failInstall(const TQString& error);
        void cleanupAfterInstall();

        TQString selected;

        TQString skins_dir;
        TQString install_skin_file;
        TQString install_skin_name;
        TQStringList install_skin_file_list;


    private slots:
        void slotPopulate();

        void slotInstallSkin();
        void slotListSkinArchive(TDEIO::Job* job, const TDEIO::UDSEntryList& list);
        void slotValidateSkinArchive(TDEIO::Job* job);
        void slotInstallSkinArchive(TDEIO::Job* delete_job = 0);

        void slotRemoveSkin();

        void slotUpdateRemoveButton();
        void slotUpdateSkinSetting();
        void slotUpdateSelection(const TQString&);
};


#endif /* SKIN_SETTINGS_H */
