/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
*/

/*
  Copyright (C) 2007 Eike Hein <hein@kde.org>
*/


#include "skin_list_item.h"

#include <tqsimplerichtext.h>
#include <tqrect.h>
#include <tqpainter.h>
#include <tqpixmap.h>
#include <tqpalette.h>

#include <tdeglobalsettings.h>
#include <tdelocale.h>


SkinListItem::SkinListItem(TDEListView* parent, const TQString& fancy_name,
    const TQString& author, const TQPixmap& icon, const TQString& name, const TQString& dir)
    : TDEListViewItem(parent, fancy_name)
{
    setName(name);
    setAuthor(author);
    setDir(dir);

    TQString fancy_author = i18n("by %1").arg(author);
    TQString text = TQString("<qt><b>%1</b><br>%2</qt>").arg(fancy_name).arg(fancy_author);

    item_text = new TQSimpleRichText(text, listView()->font());
    item_text->adjustSize();

    setPixmap(0, icon);

}

SkinListItem::~SkinListItem()
{
}

void SkinListItem::setName(const TQString& name)
{
    skin_name = name;
}

TQString SkinListItem::name()
{
    return skin_name;
}

void SkinListItem::setAuthor(const TQString& author)
{
    skin_author = author;
}

TQString SkinListItem::author()
{
    return skin_author;
}

void SkinListItem::setDir(const TQString& dir)
{
    skin_dir = dir;
}

TQString SkinListItem::dir()
{
    return skin_dir;
}

void SkinListItem::setup()
{
    widthChanged();

    item_text->setDefaultFont(listView()->font());
    item_text->setWidth(listView()->columnWidth(0));
    int text_height = item_text->height()+(MARGIN*2);

    if (text_height < 32)
        setHeight(32+(MARGIN*2));
    else
        setHeight(text_height);
}

void SkinListItem::paintCell(TQPainter* p, const TQColorGroup& /* cg */, int /* column */, int width, int /* align */)
{
    if (width <= 0) return;

    TQColor textColor = isSelected() ? TDEGlobalSettings::highlightedTextColor() : TDEGlobalSettings::textColor();
    TQColor background = isSelected() ? TDEGlobalSettings::highlightColor() : listView()->paletteBackgroundColor();

    TQColorGroup colors;
    colors.setColor(TQColorGroup::Foreground, textColor);
    colors.setColor(TQColorGroup::Text, textColor);
    colors.setColor(TQColorGroup::Background, background);
    colors.setColor(TQColorGroup::Base, background);

    p->fillRect(0, 0, width, height(), background);


    if (pixmap(0))
    {
        int y = (height() - 32) / 2;
        p->drawPixmap(MARGIN, y, *pixmap(0));
    }

    item_text->setWidth(width);
    item_text->draw(p, MARGIN+32+MARGIN+MARGIN, MARGIN, TQRect(0, 0, width-MARGIN-32-MARGIN, height()), colors);
}
