/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
*/

/*
  Copyright (C) 2007 Eike Hein <hein@kde.org>
*/


#include "first_run_dialog.h"
#include "first_run_dialog.moc"

#include <kkeybutton.h>
#include <tdeshortcut.h>
#include <kkeydialog.h>


FirstRunDialog::FirstRunDialog(TQWidget* parent, const char* name)
 : FirstRunDialogUI(parent, name)
{
    connect(key_button, TQ_SIGNAL(capturedShortcut(const TDEShortcut&)),
        this, TQ_SLOT(validateShortcut(const TDEShortcut&)));
}

FirstRunDialog::~FirstRunDialog()
{
}

TDEShortcut FirstRunDialog::shortcut()
{
    return key_button->shortcut();
}

void FirstRunDialog::setShortcut(const TDEShortcut& shortcut)
{
    key_button->setShortcut(shortcut, false);
}

void FirstRunDialog::validateShortcut(const TDEShortcut& shortcut)
{
    if (!KKeyChooser::checkGlobalShortcutsConflict(shortcut, true, this)
        && !KKeyChooser::KKeyChooser::checkStandardShortcutsConflict(shortcut, true, this))
    {
        key_button->setShortcut(shortcut, false);
    }
}
