// Author:    Max Howell <max.howell@methylblue.com>, (C) 2005
// Copyright: See COPYING file that comes with this distribution

#ifndef CODEINE_PART_H
#define CODEINE_PART_H

#include <tdeparts/statusbarextension.h>
#include <tdeparts/part.h>
#include <kurl.h>

class TDEAboutData;
class TQSlider;


namespace Codeine
{
   class Part : public KParts::ReadOnlyPart
   {
   public:
      Part( TQWidget*, const char*, TQObject*, const char*, const TQStringList& );

      virtual bool openFile() { return false; } //pure virtual in base class
      virtual bool openURL( const KURL& );
      virtual bool closeURL();

      static TDEAboutData *createAboutData();

   private:
      KParts::StatusBarExtension *m_statusBarExtension;
      TQSlider *m_slider;

      KStatusBar *statusBar() { return m_statusBarExtension->statusBar(); }

      virtual void timerEvent( TQTimerEvent* );
   };
}

#endif
