/***************************************************************************
                          rectsettingsdlg.cpp  -  description
                             -------------------
    begin                : Mit Jun 18 2003
    copyright            : (C) 2003 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "rectsettingsdlg.h"

// TQt includes
#include <tqcheckbox.h>
#include <tqlabel.h>
#include <tqlayout.h>
#include <tqpainter.h>
#include <tqpen.h>

// KDE includes
#include <kcolorbutton.h>
#include <kcombobox.h>
#include <tdelocale.h>
#include <knuminput.h>

void fillLineCombo( KComboBox* box )
{
    /* A small helper function to fill
     * a combobox with all by TQt
     * supported pen styles.
     */

    TQPainter p;
    for( int i = 1; i < 6; i++ ) {
        TQPixmap pixmap( 60, 20 );
        pixmap.fill( TQt::white );
        p.begin( &pixmap );
        p.setPen( TQPen( TQt::black, 3, (TQt::PenStyle)i ) );
        p.drawLine( 5, 10, 55, 10 );
        p.end();

        box->insertItem( pixmap );
    }
}

RectSettingsDlg::RectSettingsDlg(TQWidget *parent, const char *name )
    : KDialogBase( KDialogBase::Plain, i18n("Settings"),
      KDialogBase::Ok | KDialogBase::Cancel, KDialogBase::Ok, parent,name)
{
    TQFrame* frame = plainPage();
    TQGridLayout* grid = new TQGridLayout( frame, 6, 6 );
    TQSpacerItem* spacer = new TQSpacerItem( 0, 0, TQSizePolicy::Expanding, TQSizePolicy::Minimum );

    
    buttonBorder = new KColorButton( frame );
    buttonFill = new KColorButton( frame );

    spinWidth = new KIntNumInput( frame );
    spinWidth->setRange( 1, 100, 1, false );

    comboLine = new KComboBox( false, frame );
    fillLineCombo( comboLine );
    
    checkBorder = new TQCheckBox( i18n("&Enable Border"), frame );
    
    grid->addWidget( new TQLabel( i18n("Fill Color:"), frame ), 0, 0 );
    grid->addWidget( buttonFill, 0, 1 );
    grid->addItem( spacer, 1, 0 );
    grid->addWidget( checkBorder, 2, 0 );            
    grid->addWidget( new TQLabel( i18n("Border Color:"), frame ), 3, 0 );
    grid->addWidget( buttonBorder, 3, 1 );
    grid->addWidget( new TQLabel( i18n("Border Width:"), frame ), 4, 0 );
    grid->addWidget( spinWidth, 4, 1 );
    grid->addWidget( new TQLabel( i18n("Line Style:"), frame ), 5, 0 );
    grid->addWidget( comboLine, 5, 1 );

    connect( checkBorder, TQ_SIGNAL( clicked() ), this, TQ_SLOT( enableControls() ) );
}

RectSettingsDlg::~RectSettingsDlg()
{
}

void RectSettingsDlg::enableControls()
{
    buttonBorder->setEnabled( checkBorder->isChecked() );
    spinWidth->setEnabled( checkBorder->isChecked() );
    comboLine->setEnabled( checkBorder->isChecked() );
}

void RectSettingsDlg::setBorderColor( const TQColor & c )
{
    buttonBorder->setColor( c );
}

void RectSettingsDlg::setFillColor( const TQColor & c )
{
    buttonFill->setColor( c );
}

void RectSettingsDlg::setBorderWidth( int w )
{
    spinWidth->setValue( w );
}

void RectSettingsDlg::setPenStyle( int s )
{
    if( s ) {
        comboLine->setCurrentItem( s - 1 );
        checkBorder->setChecked( true );
    } else
        checkBorder->setChecked( false );

    enableControls();    
}

const TQColor RectSettingsDlg::borderColor() const
{
    return buttonBorder->color();
}

const TQColor RectSettingsDlg::fillColor() const
{
    return buttonFill->color();
}

int RectSettingsDlg::borderWidth() const
{
    return spinWidth->value();
}

int RectSettingsDlg::penStyle() const
{
    return checkBorder->isChecked() ? comboLine->currentItem() + 1 : 0;
}

LineSettingsDlg::LineSettingsDlg(TQWidget *parent, const char *name )
    : KDialogBase( KDialogBase::Plain, i18n("Settings"),
      KDialogBase::Ok | KDialogBase::Cancel, KDialogBase::Ok, parent,name)
{
    TQFrame* frame = plainPage();
    TQGridLayout* grid = new TQGridLayout( frame, 6, 6 );

    buttonColor = new KColorButton( frame );

    spinWidth = new KIntNumInput( frame );
    spinWidth->setRange( 1, 100, 1, false );

    comboLine = new KComboBox( false, frame );
    fillLineCombo( comboLine );    

    grid->addWidget( new TQLabel( i18n("Color:"), frame ), 0, 0 );
    grid->addWidget( buttonColor, 0, 1 );
    grid->addWidget( new TQLabel( i18n("Line Width:"), frame ), 1, 0 );
    grid->addWidget( spinWidth, 1, 1 );
    grid->addWidget( new TQLabel( i18n("Line Style:"), frame ), 2, 0 );
    grid->addWidget( comboLine, 2, 1 );
}

LineSettingsDlg::~LineSettingsDlg()
{
}

TQPen LineSettingsDlg::pen() const
{
    return TQPen( buttonColor->color(), spinWidth->value(), (TQt::PenStyle)(comboLine->currentItem() + 1) );
}

void LineSettingsDlg::setPen( const TQPen p )
{
    buttonColor->setColor( p.color() );
    spinWidth->setValue( p.width() );
    comboLine->setCurrentItem( p.style() - 1 );
}

#include "rectsettingsdlg.moc"
