/**************************************************************************
*   Copyright (C) 2005 by Christian Hubinger                              *
*   e9806056@student.tuwien.ac.at                                         *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
***************************************************************************/


// TQt includes
#include <tqlcdnumber.h>
#include <tqlayout.h>

// KDE includes
#include <tdeglobal.h>
#include <tdelocale.h>
#include <tdeaboutdata.h>
#include <tdeconfig.h>
#include <tdemessagebox.h>
#include <tdeapplication.h>
#include <tdemessagebox.h>
#include <dcopclient.h>
#include <kdebug.h>
#include <tdepopupmenu.h>
#include <kiconloader.h>
#include <tdeprocess.h>

// Project includes
#include "kmfsystray.h"
#include "kmfiptwatcher.h"
#include "mainwidget.h"

#include "../core/kmfiptdoc.h"
#include "../core/kmfappstate.h"

KMFSysTray::KMFSysTray( TQWidget* w ) :  KSystemTray ( w ) , DCOPObject( "KMFSysTray" ) {
	mainView = w;
	ksConfig = tdeApp->config();
	KMFIPTWatcher *watch = new KMFIPTWatcher( this, "KMFIPTWatcher" );

	baseIcon = KSystemTray::loadIcon( "kmyfirewall" );
	setPixmap( baseIcon );
	
	// Connect the watch deamon
	connect( watch, TQ_SIGNAL( sigUpdateActive( bool ) ), this, TQ_SLOT( slotSetRunningStatus( bool ) ) );
	connect( watch, TQ_SIGNAL( sigUpdateRuleCount( const TQString&, const TQString&, int ) ), 
		this, TQ_SIGNAL( sigUpdateRuleCount( const TQString&, const TQString&, int ) ) );

	connect( watch, TQ_SIGNAL( sigUpdateIPTDoc( KMFIPTDoc* ) ), 
		this, TQ_SIGNAL( sigUpdateIPTDoc( KMFIPTDoc* ) ) );

	connect( this, TQ_SIGNAL( sigQueryDetails( bool ) ), watch, TQ_SLOT( slotQueryDetails( bool ) ) );

	// Connect view
	connect( w, TQ_SIGNAL( closing() ), this, TQ_SLOT ( slotDetailsClosed() ) );
	connect( w, TQ_SIGNAL( showing() ), this, TQ_SLOT ( slotQueryDetails() ) );
	connect( this, TQ_SIGNAL( sigUpdateIPTDoc( KMFIPTDoc* ) ), w, TQ_SLOT( slotLoadDoc( KMFIPTDoc* ) ) );


	initMenu();
	
	show();
	emit sigQueryDetails( false );
	KMFAppState::setUpAndRunning( true );
	KMFAppState::setHasOpenDoc( true );
}


KMFSysTray::~KMFSysTray() {}

void KMFSysTray::initMenu() {
	TDEPopupMenu* menu = contextMenu ();
	menu->insertItem( TDEGlobal::iconLoader()->loadIcon( "kmyfirewall", TDEIcon::Small ), i18n( "Launch KMyFirewall..."), this, TQ_SLOT( slotLaunchKMF() ), CTRL+Key_K );
	
}

void KMFSysTray::slotSetRunningStatus( bool on ) {
	if ( on ) {
		baseIcon = KSystemTray::loadIcon( "kmyfirewall" );
	} else {
		baseIcon = KSystemTray::loadIcon( "kmyfirewall" );
	}
	setPixmap( baseIcon );	
}



void KMFSysTray::slotLaunchKMF () {
	TDEProcess *childproc = new TDEProcess();
	*childproc << "tdesu";
 	*childproc << "kmyfirewall";
	childproc->start( TDEProcess:: DontCare, TDEProcess::NoCommunication );
}

void KMFSysTray::slotShowDetails() {
	kdDebug() << "MFSysTray::slotshowDetails()" <<  endl;
	slotQueryDetails();
	mainView->show();
	
}

void KMFSysTray::slotQueryDetails() {
	emit sigQueryDetails( true );
}

void KMFSysTray::slotDetailsClosed() {
	kdDebug() << "KMFSysTray::slotDetailsClosed()" <<  endl;
	emit sigQueryDetails( false );	
}

void KMFSysTray::about() {
/*	if(!_aboutData) {
      _aboutData = new TDEAboutData("KMFSysTray", I18N_NOOP("KMFSysTray"), 
              "1.0", I18N_NOOP("KMyFirewall Pannel Applet.\n\n"
              "Some basic inform<tion about your running iptables rules"),
              TDEAboutData::License_GPL_V2, "(c) 2005, Christian Hubinger");
      _aboutData->addAuthor("Christian Hubinger", 0, "e9806056@student.tuwien.ac.at");
			
	}
 	TDEAboutApplication dialog(_aboutData);
	dialog.show();*/
}


void KMFSysTray::help() {
	KMessageBox::information( 0, i18n( "This is a help box" ) );
}


void KMFSysTray::preferences() {
	KMessageBox::information( 0, i18n( "This is a preferences box" ) );
}

int KMFSysTray::widthForHeight( int  ) const {
	return width();
}

int KMFSysTray::heightForWidth( int  ) const {
	return height();
}

void KMFSysTray::resizeEvent( TQResizeEvent *e ) {}


// extern "C" {
// 	KPanelApplet * init( TQWidget * parent, const TQString & configFile ) {
// 		TDEGlobal::locale() ->insertCatalogue( "kmfsystray" );
// 		return new KMFSysTray( configFile, KPanelApplet::Normal,
// 		                       KPanelApplet::About | KPanelApplet::Help | KPanelApplet::Preferences,
// 		                       parent, "kmfsystray" );
// 	}
// }


