/***************************************************************************
 begin                : Sun May 26 2002
 copyright            : (C) 2002 by Christian Hubinger
 email                : chubinger@irrsinnig.org
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMFRULEEDITORTARGETNAT_H
#define KMFRULEEDITORTARGETNAT_H
#include "kmyfirewallruleeditortargetnat.h"

#include <tqwidget.h>

/**
  *@author Christian Hubinger
  */

namespace KMF {
class IPTRule;
class KMFCheckInput;
class KMFErrorHandler;
class KMFError;

class KMFRuleEditorTargetNat : public KMyFirewallRuleEditorTargetNat {
	TQ_OBJECT
  
public:
	KMFRuleEditorTargetNat( TQWidget *parent = 0, const char *name = 0, WFlags fl = 0 );
	~KMFRuleEditorTargetNat();


	void loadRule( IPTRule *rule );
	void setMode( bool isSnat ) {
		mbsnat = isSnat;
	};

public slots:
	void accept();
	void reject();
	void slotHelp();

signals:
/*	void sigAddRuleOpt( TQString*, TQPtrList<TQString>* );
	void sigAddTargetOpt( TQString*, TQPtrList<TQString>* );*/
	void sigDocumentChanged();
	void sigHideMe();
private:
	bool mbsnat;
	IPTRule* m_rule;
	KMFCheckInput *m_CheckInput;
	KMFErrorHandler *m_ErrorHandler;
	KMFError *m_err;

};
}
#endif
