/***************************************************************************
                          tabpage.h  -  description
                             -------------------
    begin                : Fri Sep 13 2002
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TABPAGE_H
#define TABPAGE_H

#include <tqframe.h>
#include <tqwidget.h>
#include <tqvbox.h>
#include <tqhbox.h>
#include <tqstring.h>
#include "tabbox.h"

/**
  *@author Troy Corbin Jr.
  */
class resource;
class TQToolButton;
class TabGrip;

class TabPage : public TQVBox
{
	TQ_OBJECT
  
	public:
								TabPage( TQWidget *parent, TQWidget *child, resource *rsrc );
								~TabPage();
		void				setCaption( const TQString& );
		TQWidget*		getChild( void );

	protected slots:
		void				tabDragged( const TQPoint&, const TQPoint& );

	signals:
		void				newParent( TabBox* );
		void				requestDestruction( void );

	protected:
		TabBox*			parentTabBox( void );

	private:
		TQString			myCaption;
		TQHBox				*actionBar;
		TabGrip			*grip;
		TQToolButton	*closeButton;

		TQWidget			*myChild;
		resource		*myResource;
};

#endif
