/*
	confirmation.cpp - A confirmation dialog
	Copyright (C) 2005  Konrad Twardowski <kdtonline@poczta.onet.pl>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "confirmation.h"
#include "miscutils.h"
#include "mmainwindow.h"
#include "msystemtray.h"

#include <dcopclient.h>
#include <kdialogbase.h>
#include <kiconloader.h>
#include <tdelocale.h>
#include <tdemessagebox.h>
#include <twin.h>

// public

bool Confirmation::confirm(const Action::Type action, const TQString &delay)
{
	KWin::setOnDesktop(ks_main->winId(), KWin::currentDesktop());

	TQWidget *parent;
	if (ks_main->isVisible())
		parent = ks_main;
	else if (MSystemTray::isInstance() && ks_tray->isVisible())
		parent = ks_tray;
	else
		parent = 0;

	/*
	TQWidget *background = new TQWidget(0, "TQWidget::background", TQt::WType_Popup);
	background->setBackgroundMode(TQt::NoBackground);
	background->setGeometry(tdeApp->desktop()->geometry());
	// Take screenshot - based on the aKregator's TrayIcon::takeScreenshot() (trayicon.cpp)
	// and "ksmserver/shutdown.cpp".
	TQPixmap shot = TQPixmap::grabWindow(
		tqt_xrootwin(),
		0, 0, // x, y
		tdeApp->desktop()->width(), tdeApp->desktop()->height()
	);
	TQImage shotImage = shot.convertToImage();
	KImageEffect::flatten(shotImage, TQt::green, TQt::black);
	bitBlt(background, 0, 0, &shotImage);
	background->show();
	*/

	KDialogBase *dialog = new KDialogBase(
		i18n("Confirm"), // caption
		KDialogBase::Yes | KDialogBase::No, // button mask
		KDialogBase::Yes, // default button
		KDialogBase::No, // escape button
		parent,
		"Action::confirm",
		true, // modal
		false, // separator
		KGuiItem(ks_actions->getName(action), ks_actions->getIcon(action)),
		KGuiItem(i18n("&Cancel"), SmallIcon("button_cancel"))
	);
	bool checkboxResultDummy = false;
	TQString selectedTime = delay.isNull() ? i18n("Unknown") : delay;
	TQString text =
		i18n("Are you sure?<br><br>Selected Action: <b>%1</b><br>Selected Time: <b>%2</b>")
			.arg(ks_actions->getName(action))
			.arg(selectedTime);

	tdeApp->dcopClient()->suspend();

	bool result = (KMessageBox::createKMessageBox(
		dialog,
		MainBarIcon(ks_actions->getIconName(action), 32),
		MiscUtils::HTML(text),
		TQStringList(),
		TQString::null,
		&checkboxResultDummy,
		KMessageBox::Notify
	) == KDialogBase::Yes);

	tdeApp->dcopClient()->resume();

	return result;
}
