/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : � �c 10 12:39:26 CEST 2001
    copyright            : (C) 2001, 2002, 2003 by The KXMLEditor Team
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <tdeapplication.h>
#include <tdecmdlineargs.h>
#include <tdeaboutdata.h>
#include <tdelocale.h>
#include <kdebug.h>
#include <tdemessagebox.h>
#include <dcopclient.h>

//#include "kxmleditor.h"
#include "../part/kxmleditorabout.h"
#include "kxmleditorshell.h"


static TDECmdLineOptions options[] =
{
  { "+[File(s)]", I18N_NOOP("XML file(s) to open"), 0 },
  { 0, 0, 0 }
};

#define USE_KPART 1
	// if set to true makes kxmleditor to be kpart based (currently developement version only)

/** @short Main application function that starts-up the application */
int main(int argc, char *argv[])
{
	TDECmdLineArgs::init( argc, argv, new KXMLEditorAboutData() );
	TDECmdLineArgs::addCmdLineOptions( options ); // Add our own options.

	TDEApplication app;

  // comment the following lines to use KXMLEditorShell instead of KXMLEditorApp
#if ! USE_KPART
  if (app.isRestored())
  	{ RESTORE(KXMLEditorApp);
  	}
  else
  {
    KXMLEditorApp *kxmleditor = new KXMLEditorApp();
    kxmleditor->show();

    TDECmdLineArgs *args = TDECmdLineArgs::parsedArgs();

		if(args->count())
			{ TQString strPath;

			  if(args->count() > 1)
					{ strPath = args->arg(1);
					}
          KURL url(args->arg(0));
					if ( ! url.isValid() )
						{ // probably user entered just filename
							url.setProtocol("file");
							url.setPath(args->arg(0));
						}
					kxmleditor->openDocumentFile(url, strPath);
			}
		else
			{ kxmleditor->openDocumentFile();
			}
		args->clear();
  }
#else // USE_KPART

	if (app.isRestored())
	{
		RESTORE(KXMLEditorShell);
	}
	else
	{
		TDECmdLineArgs * pArgs = TDECmdLineArgs::parsedArgs();
		KXMLEditorShell * pShell;
		bool bNoCorrectInstance = true;
		if ( pArgs->count() > 0 )
		{
			for( int i = 0; i < pArgs->count(); i++ )
			{
				KURL url(pArgs->arg(i));
				if ( ! url.isValid() )
				{
					url.setProtocol("file");
					url.setPath(pArgs->arg(i));
				}
				pShell = new KXMLEditorShell();
				if ( pShell->openURL(url) )
				{
					pShell->show();
					bNoCorrectInstance = false;
				}
				else
					{
            kdDebug() << "Couldn't open file " << url.path() << endl;
            KMessageBox::sorry(0, i18n("Couldn't open file !") + "\n" + url.path());
            delete pShell;
          }
			}
		}
		else
		{
			pShell = new KXMLEditorShell();
			KParts::ReadWritePart* pPart = KXMLEditorShell::createXMLPart(pShell);
			pShell->setPart(pPart);
			pShell->show();
			bNoCorrectInstance = false;
		}
		pArgs->clear();

		if ( bNoCorrectInstance )
			return 1;
	}

	// registration as multi-instance DCOP client
	DCOPClient *client = app.dcopClient();
	client->attach();
	client->registerAs(tdeApp->name());

  // uncomment end
#endif // USE_KPART

  int iRetVal = app.exec();
  return iRetVal;
}

