#include "colordialog.h"
#include <tqlabel.h>
#include <tqdir.h>
#include <tqcombobox.h>
#include <tqlayout.h>
#include <tqpainter.h>
#include <tqpixmap.h>
#include <tqpushbutton.h>
#include <tqstyle.h>
#include <tdeglobal.h>
#include <tdeglobalsettings.h>
#include <kcolordialog.h>
#include <kiconloader.h>
#include "colorpicker.h"
#include "pixmaps.h"
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#ifndef CLAMP
#define CLAMP(x,l,u) x < l ? l :\
x > u ? u :\
x
#endif

#define SATURATION_COLOR2(S,R,G,B) \
int max = (int)(255+0.65*(100-S)); \
destR = CLAMP((srcR + R - 128), 0, max); \
destG = CLAMP((srcG + G - 128), 0, max); \
destB = CLAMP((srcB + B - 128), 0, max); \
destR = (S*destR + (100-S)*R)/100; \
destG = (S*destG + (100-S)*G)/100; \
destB = (S*destB + (100-S)*B)/100;

#define COLOR_SPACE(R,G,B) \
if ( R < 0 ) R = 0; else if ( R > 255 ) R = 255; \
if ( G < 0 ) G = 0; else if ( G > 255 ) G = 255; \
if ( B < 0 ) B = 0; else if ( B > 255 ) B = 255;

ColorDialog::ColorDialog(TQWidget* parent, const char* name) : TQDialog( parent, name)
{
   TQVBoxLayout *vertical = new TQVBoxLayout(this);
   TQHBoxLayout *top = new TQHBoxLayout(vertical);
   demo = new DemoWindow(this);
   top->addWidget(demo);
   TQVBoxLayout *topRight = new TQVBoxLayout(top);
   TQLabel *info = new TQLabel("<qt>Select custom colors or grab directly from screen.<br>Click image left to switch between items.</qt>",this);
   topRight->addWidget(info);
   TQIconSet icon = TDEGlobal::iconLoader()->loadIconSet("colorpicker", TDEIcon::Small);
   buttonCP = new TQPushButton(icon, TQString::null, this);
   topRight->addWidget(buttonCP);
   TQLabel *lb = new TQLabel("From other app:",this);
   topRight->addWidget(lb);
   other = new TQComboBox(this);
   topRight->addWidget(other);
   topRight->addStretch();
   buttonOk = new TQPushButton("&Ok", this);
   topRight->addWidget(buttonOk);
   buttonCancel = new TQPushButton("&Cancel", this);
   topRight->addWidget(buttonCancel);
   const char *title[NUMCOLORS] = {"Background", "Button", "Base", "Text", "Highlight", "Highlighted Text", "Button Text", "Alternate Background"};
   for (int i = 0; i < NUMCOLORS; i++)
   {
      picker[i] = new ColorPicker(this, title[i]);
      vertical->addWidget(picker[i]);
      connect (picker[i], TQ_SIGNAL(colorChanged(TQColor)), demo, TQ_SLOT(smartRepaint()));
      picker[i]->hide();
   }
   for (int i = 0; i < NUMCOLORS; i++)
      picker[i]->blockSignals(true);
   picker[Back]->setColor(colorGroup().background());
   picker[Button]->setColor(colorGroup().button());
   picker[Base]->setColor(colorGroup().base());
   picker[Text]->setColor(colorGroup().text());
   picker[High]->setColor(colorGroup().highlight());
   picker[HighText]->setColor(colorGroup().highlightedText());
   picker[ButText]->setColor(colorGroup().buttonText ());
   picker[Alternate]->setColor(TDEGlobalSettings::alternateBackgroundColor());
   for (int i = 0; i < NUMCOLORS; i++)
      picker[i]->blockSignals(false);
//    demo->repaint(false);

   picker[Button]->show();
   connect (buttonOk, TQ_SIGNAL(clicked()), this, TQ_SLOT(close()));
   connect (buttonCP, TQ_SIGNAL(clicked()), this, TQ_SLOT(grabColor()));
   connect (buttonCancel, TQ_SIGNAL(clicked()), this, TQ_SLOT(close()));
   connect (other, TQ_SIGNAL(activated (const TQString &)), this, TQ_SLOT(getFromOther(const TQString &)));
}

ColorDialog::~ColorDialog()
{
}

void ColorDialog::show()
{
   other->clear();
   TQDir d( TQDir::homeDirPath() + "/.baghira", 0L, TQDir::Name | TQDir::IgnoreCase, TQDir::Files | TQDir::Readable | TQDir::Writable );
   if (d.exists())
   {
      for ( uint i = 0; i < d.count(); i++ )
         other->insertItem(d[i]);
   }
   TQDialog::show();
   demo->show();
//    demo->repaint(false);
}

void ColorDialog::getFromOther( const TQString & string )
{
   FILE *file = NULL;
   TQString tmpString = TQDir::homeDirPath() + "/.baghira/" + string;
   if( (file = fopen(tmpString.latin1(), "r")) != NULL )
   {
      uint k;
      int colors[NUMCOLORS];
      for (int i = 0; i < NUMCOLORS; i++)
         colors[i] = -1;
      fscanf(file,"%u\n%u\n%u\n%u\n%u\n%u\n%d\n%d\n%d\n%d\n%d\n%d\n%d\n%d\n",&k,&k,&k,&k,&k,&k,&colors[0],&colors[1],&colors[2],&colors[3],&colors[4],&colors[5],&colors[6],&colors[7]);
      fclose(file);
      for (int i = 0; i < NUMCOLORS; i++)
      {
         picker[i]->blockSignals(true);
         if (colors[i] != -1) picker[i]->setColor(TQColor(colors[i]));
         picker[i]->blockSignals(false);
      }
      demo->repaint(false);
   }
}

void ColorDialog::grabColor()
{
   gettingColorFromScreen = true;
   grabMouse(crossCursor);
   grabKeyboard();
}

void ColorDialog::mouseReleaseEvent(TQMouseEvent* me)
{
   if (gettingColorFromScreen)
   {
      gettingColorFromScreen = false;
      releaseMouse();
      releaseKeyboard();
      for (int i = 0; i < NUMCOLORS; i++)
      {
         if (picker[i]->isShown())
         {
            picker[i]->setColor(KColorDialog::grabColor(me->globalPos()));
            break;
         }
      }
   }
   else
      TQDialog::mouseReleaseEvent(me);
}

//extern TQImage uic_findiImage(const TQString& name);
//extern void qInitImages_baghira();
//extern void qCleanupImages_baghira();


DemoWindow::DemoWindow( ColorDialog* parent, const char* name) : TQWidget(parent, name)
{
   setBackgroundMode ( TQt::NoBackground );
   colorDialog_ = parent;
   setFixedSize(320,120);
   pm = new TQPixmap(320,120);
   pp = new TQPainter();
   p = new TQPainter();
   (const_cast<TQFont*>(&p->font()))->setPixelSize(16);
   baseRect = TQRect(20, 10, 200, 100);
   buttonRect = TQRect(230, 90, 37, 21);
   buttonTextRect = TQRect(236, 91, 20, 18);
   highlightRect = TQRect(21, 42, 198, 22);
   textRect = TQRect(25, 21, 100, 18);
   highTextRect = TQRect(25, 42, 120, 22);
   alternateRect = TQRect(21, 86, 198, 22);
   baseImage = uic_findImage("button-base");
   dest = TQImage( baseImage.width(), baseImage.height(), 32 );
   dest.setAlphaBuffer( true );
}

DemoWindow::~DemoWindow(){}

void DemoWindow::mousePressEvent ( TQMouseEvent * me )
{
   for (int i = 0; i < NUMCOLORS; i++)
      colorDialog_->picker[i]->hide();
   
   if (buttonTextRect.contains(me->pos()))
      colorDialog_->picker[ButText]->show();
   else if (buttonRect.contains(me->pos()))
      colorDialog_->picker[Button]->show();
   else if (textRect.contains(me->pos()))
      colorDialog_->picker[Text]->show();
   else if (highTextRect.contains(me->pos()))
      colorDialog_->picker[HighText]->show();
   else if (highlightRect.contains(me->pos()))
      colorDialog_->picker[High]->show();
   else if (alternateRect.contains(me->pos()))
      colorDialog_->picker[Alternate]->show();
   else if (baseRect.contains(me->pos()))
      colorDialog_->picker[Base]->show();
   else
      colorDialog_->picker[Back]->show();
}

void DemoWindow::paintEvent ( TQPaintEvent * )
{
   pp->begin(pm);
   pp->fillRect(0,0,pm->width(),pm->height(), colorDialog_->picker[Back]->color());
   style().drawPrimitive( TQStyle::PE_PanelLineEdit, pp, rect(), colorGroup() );
   pp->fillRect(baseRect, colorDialog_->picker[Base]->color());
   pp->fillRect(highlightRect, colorDialog_->picker[High]->color());
   pp->fillRect(alternateRect, colorDialog_->picker[Alternate]->color());
   pp->setPen ( colorDialog_->picker[Text]->color() );
   pp->drawText ( textRect, TQt::AlignAuto | TQt::AlignVCenter, "Common Text");
   pp->drawText ( alternateRect, TQt::AlignAuto | TQt::AlignVCenter, "Alt. Background");
   pp->setPen ( colorDialog_->picker[HighText]->color() );
   pp->drawText ( highTextRect, TQt::AlignAuto | TQt::AlignVCenter, "Highlighted Text");
   pp->drawPixmap(buttonRect, tintButton(baseImage, colorDialog_->picker[Button]->color()));
   pp->setPen ( colorDialog_->picker[ButText]->color() );
   pp->drawText ( buttonTextRect, TQt::AlignCenter, "B");
   style().drawPrimitive( TQStyle::PE_PanelLineEdit, pp, baseRect, colorGroup());
   pp->end();
   p->begin(this);
   p->drawPixmap(0,0, *pm);
   p->end();
}

void DemoWindow::smartRepaint()
{
   if (colorDialog_->picker[Back]->isShown())
   {
      TQWidget::repaint(false);
      return;
   }
   if (colorDialog_->picker[Button]->isShown())
   {
      TQWidget::repaint(buttonRect, false);
      return;
   }
   if (colorDialog_->picker[Base]->isShown())
   {
      TQWidget::repaint(false);
      return;
   }
   if (colorDialog_->picker[Text]->isShown())
   {
      TQWidget::repaint(textRect, false);
      return;
   }
   if (colorDialog_->picker[High]->isShown())
   {
      TQWidget::repaint(highlightRect, false);
      return;
   }
   if (colorDialog_->picker[HighText]->isShown())
   {
      TQWidget::repaint(highTextRect, false);
      return;
   }
   if (colorDialog_->picker[Alternate]->isShown())
   {
      TQWidget::repaint(alternateRect, false);
      return;
   }
   if (colorDialog_->picker[ButText]->isShown())
   {
      TQWidget::repaint(buttonTextRect, false);
      return;
   }
}

TQImage & DemoWindow::tintButton(TQImage &src, TQColor & c)
{
//    dest = TQImage( src.width(), src.height(), 32, 0, _ENDIAN_ );
   unsigned int *data = ( unsigned int * ) src.bits();
   unsigned int *destData = ( unsigned int* ) dest.bits();
   int total = src.width() * src.height();
   int red, green, blue;
   int destR, destG, destB, alpha;
   int srcR = c.red();
   int srcG = c.green();
   int srcB = c.blue();
   int hue, s, v;
   c.getHsv( &hue, &s, &v );
   int sq = CLAMP((int)((45.0/128.0)*s+55),0,100);
    // float srcPercent, destPercent;
   for ( int current = 0 ; current < total ; ++current ) {
      alpha = tqAlpha( data[ current ] );
      blue = tqBlue( data[ current ] );
      red = tqRed( data[ current ] );
      green = tqGreen( data[ current ] );
      SATURATION_COLOR2(sq, red, green, blue);
	// force back to valid colorspace !
      COLOR_SPACE(destR, destG, destB);
      destData[ current ] = tqRgba( destR, destG, destB, alpha );
   }
   return ( dest );
}

#include "colordialog.moc"
