#include "dcopiface.h"

#include <noatun/player.h>
#include <noatun/app.h>
#include <noatunarts/noatunarts.h>
#include <noatun/engine.h>

#include <dcopclient.h>

extern "C"
{
	TDE_EXPORT NIF *create_plugin()
	{
		return new NIF();
	}
}


NIF::NIF() : Plugin(), DCOPObject("Noatun")
{
	mLastVolume = 0;
//	connect(napp->player(), TQ_SIGNAL(newSong()), TQ_SLOT(newSongPlaying()));
}

NIF::~NIF()
{
	tdeApp->dcopClient()->emitDCOPSignal("exiting()", TQByteArray());
}

void NIF::toggleListView()
{
	napp->player()->toggleListView();
}

void NIF::handleButtons()
{
	napp->player()->handleButtons();
}

void NIF::removeCurrent()
{
	napp->player()->removeCurrent();
}

void NIF::back()
{
	napp->player()->back();
}

void NIF::stop()
{
	napp->player()->stop();
}

void NIF::play()
{
	napp->player()->play();
}

void NIF::playpause()
{
	napp->player()->playpause();
}

void NIF::forward()
{
	napp->player()->forward();
}

void NIF::skipTo(int msec)
{
	napp->player()->skipTo(msec);
}

void NIF::loop()
{
	napp->player()->loop();
}

void NIF::setVolume(int i)
{
	napp->player()->setVolume(i);
}

int NIF::volume()
{
	return napp->player()->volume();
}

void NIF::volumeUp()
{
	napp->player()->setVolume(napp->player()->volume() + 5);
}

void NIF::volumeDown()
{
	napp->player()->setVolume(napp->player()->volume() - 5);
}

void NIF::toggleMute()
{
	int currVol = napp->player()->volume();
	if (currVol == 0)
	{
		napp->player()->setVolume(mLastVolume);
	}
	else
	{
		mLastVolume = currVol;
		napp->player()->setVolume(0);
	}
}

int NIF::length() // returns -1 if there's no playobject
{
	return napp->player()->getLength();
}

int NIF::position() // returns -1 if there's no playobject
{
	return napp->player()->getTime();
}

int NIF::state()
{
	if (napp->player()->isPlaying())
		return 2;
	if (napp->player()->isPaused())
		return 1;

	return 0; // default to stopped
}

TQString NIF::lengthString()
{
	return napp->player()->current() ? napp->player()->current().lengthString() : "";
}

TQString NIF::timeString()
{
	return napp->player()->lengthString();
}

TQString NIF::title()
{
	return napp->player()->current() ? napp->player()->current().title() : "";
}

void NIF::setCurrentProperty(const TQString &key, const TQString &value)
{
	if (!napp->player()->current()) return;

	napp->player()->current().setProperty(key, value);
}

TQString NIF::currentProperty(const TQString &key)
{
	if (!napp->player()->current()) return "";

	return napp->player()->current().property(key);
}

void NIF::clearCurrentProperty(const TQString &key)
{
	if (!napp->player()->current()) return;

	return napp->player()->current().clearProperty(key);
}


TQCString NIF::visStack()
{
	return napp->player()->engine()->visualizationStack()->toString().c_str();
}

TQCString NIF::session()
{
	return napp->player()->engine()->session()->toString().c_str();
}

// adds one file to the playlist
void NIF::addFile(const TQString& f, bool autoplay)
{
	napp->player()->openFile(f, false, autoplay);
}

// Adds a bunch of files to the playlist
void NIF::addFile(const TQStringList &f, bool autoplay)
{
	for (TQStringList::ConstIterator it = f.begin(); it != f.end(); ++it )
		napp->player()->openFile(*it, false, autoplay);
}

void NIF::loadPlugin(const TQString &spec)
{
	napp->libraryLoader()->add(spec);
}

TQStringList NIF::availablePlugins() {
	TQStringList available_spec_files;
        TQValueList<NoatunLibraryInfo> available;

	available = napp->libraryLoader()->available();

	TQValueList<NoatunLibraryInfo>::iterator it;
	for (it = available.begin();it != available.end();it++) {
		available_spec_files += (*it).specfile;
	}

	return available_spec_files;
}

TQStringList NIF::loadedPlugins() {
	TQStringList loaded_spec_files;
        TQValueList<NoatunLibraryInfo> loaded;

	loaded = napp->libraryLoader()->loaded();

	TQValueList<NoatunLibraryInfo>::iterator it;
	for (it = loaded.begin();it != loaded.end();it++) {
		loaded_spec_files += (*it).specfile;
	}

	return loaded_spec_files;
}

bool NIF::unloadPlugin(const TQString &spec)
{
	return napp->libraryLoader()->remove(spec);
}

TQStringList NIF::mimeTypes()
{
	return napp->mimeTypes();
}

TQCString NIF::version()
{
	return napp->version();
}

void NIF::newSongPlaying()
{
	tdeApp->dcopClient()->emitDCOPSignal("newFile()", TQByteArray());
}

void NIF::clear()
{
	napp->playlist()->clear();
}
