#include <noatun/pref.h>

#include <tdelocale.h>
#include <tqpushbutton.h>
#include <tqlayout.h>
#include <tqlabel.h>
#include <tqpixmap.h>
#include <tdeglobal.h>
#include <tdeconfig.h>
#include <tqslider.h>
#include <tqframe.h>
#include <tqstringlist.h>
#include <tdefile.h>
#include <tdefiledialog.h>
#include <tdemessagebox.h>
#include <tdestandarddirs.h>
#include <kurlrequester.h>
#include <kurlrequesterdlg.h>
#include <tqdir.h>

#include "waSkin.h"
#include "waInfo.h"
#include "waSkinManager.h"
#include "winSkinConfig.h"

WinSkinConfig::WinSkinConfig(TQWidget * parent, WaSkinManager *waSkinManager) :
        CModule(i18n("Winskin"),
	        i18n("Skin Selection for the Winskin Plugin"),
	        "style",
	        parent)
{
    // Make a token horizontal layout box
    vbox = new TQVBoxLayout(this);
    vbox->setSpacing( 6 );
    vbox->setMargin( 0 );

    // Add a simple list of skins, populated in WinSkinConfig::reopen()
    skin_list = new TQListBox(this, "skin_list");
    vbox->addWidget(skin_list);

    TQHBoxLayout* hbox = new TQHBoxLayout( 0, 6, 6 );

    TQPushButton* buttonInstall = new TQPushButton( i18n("&Install New Skin..."), this );
    hbox->addWidget(buttonInstall);

    buttonRemove = new TQPushButton( i18n("&Remove Skin"), this );
    buttonRemove->setEnabled(false);
    hbox->addWidget(buttonRemove);
    vbox->addLayout(hbox);

    connect( skin_list, TQ_SIGNAL(highlighted(const TQString &)), this, TQ_SLOT(selected()));
    connect( buttonInstall, TQ_SIGNAL(clicked()), this, TQ_SLOT(install()));
    connect( buttonRemove, TQ_SIGNAL(clicked()), this, TQ_SLOT(remove()));
    connect(waSkinManager, TQ_SIGNAL(updateSkinList()), this, TQ_SLOT(reopen()));

    mWaSkinManager = waSkinManager;

    TQGroupBox *settingsBox = new TQGroupBox( 1,TQt::Vertical, i18n("Settings"), this );
    vbox->addWidget(settingsBox);

    TQHBox *box = new TQHBox(settingsBox);
    TQLabel *label = new TQLabel(i18n("T&itle scrolling speed:"), box);
    new TQLabel(i18n("None"), box);

    scrollSpeed = new TQSlider(box);
    label->setBuddy(scrollSpeed);
    scrollSpeed->setMinimumSize( TQSize( 80, 0 ) );
    scrollSpeed->setMinValue( 0 );
    scrollSpeed->setMaxValue( 50 );
    scrollSpeed->setPageStep( 1 );
    scrollSpeed->setOrientation( TQt::Horizontal );
    scrollSpeed->setTickmarks( TQSlider::NoMarks );

	label = new TQLabel(i18n("Fast"), box);

    reopen();
}

void WinSkinConfig::save()
{
    TDEConfig *config=TDEGlobal::config();
    config->setGroup("Winskin");
    config->writeEntry("CurrentSkin", skin_list->currentText());
    config->writeEntry("ScrollDelay", scrollSpeed->value());
    config->sync();

    if (skin_list->currentText() != orig_skin) {
        _waskin_instance->loadSkin(skin_list->currentText());
        orig_skin = skin_list->currentText();
    }
    else
    {
      _waskin_instance->skinInfo()->scrollerSetup();
    }
}

void WinSkinConfig::reopen() {
    // Wipe out the old list
    skin_list->clear(); 

    // Get a list of skins
    TQStringList skins = mWaSkinManager->availableSkins();

    // This loop adds them all to our skin list
    for(unsigned int x = 0;x < skins.count();x++) {
        // Add ourselves to the list
        skin_list->insertItem(skins[x]);
    }

    // Figure out our current skin
    TQString orig_skin = mWaSkinManager->currentSkin();

    // Where is that skin in our big-list-o-skins?
    TQListBoxItem *item = skin_list->findItem(orig_skin);

    if (item) {
        // Aha, found it... make it the currently selected skin
        skin_list->setCurrentItem( item );
    }
    else {
        // Er, it's not there... select the current item
        // Maybe this should emit a warning? Oh well, it's not harmful
        skin_list->setCurrentItem( 0 );
    }
	
    TDEConfig *config=TDEGlobal::config();
    config->setGroup("Winskin");
	scrollSpeed->setValue(config->readNumEntry("ScrollDelay", 15));
}

void WinSkinConfig::selected()
{
    buttonRemove->setEnabled(mWaSkinManager->skinRemovable( skin_list->currentText() ));
}

void WinSkinConfig::install()
{
   TQString url;

    // Ask the user for directory containing a skin
    KURLRequesterDlg* udlg = new KURLRequesterDlg( TQString(), this, "udlg", true );
    udlg->urlRequester()->setFilter(mWaSkinManager->skinMimeTypes().join(" "));
    udlg->urlRequester()->setMode( KFile::File | KFile::Directory | KFile::ExistingOnly );

    if( udlg->exec() == TQDialog::Accepted ) {
        url = udlg->urlRequester()->url();
        mWaSkinManager->installSkin( url );
    }
}

void WinSkinConfig::remove()
{
    // Is there any item selected ??
    if( skin_list->currentText().isEmpty() )
        return;

    // We can't remove every skin
    if( !mWaSkinManager->skinRemovable( skin_list->currentText() ) ) {
        KMessageBox::information( this, i18n("You cannot remove this skin.") );
        // Reload skin list, perhaps the skin is already removed!
        return;
    }

    // Ask the user first
    if( KMessageBox::warningContinueCancel( this,
        i18n("<qt>Are you sure you want to remove the <b>%1</b> skin?</qt>").arg( skin_list->currentText() ), TQString(), KStdGuiItem::del() )
        == KMessageBox::Continue ) {

        mWaSkinManager->removeSkin( skin_list->currentText() );
        reopen();
    }
}

#include <winSkinConfig.moc>
