/******************************************************************************
 *
 *  file:  StandardTraits.h
 *
 *  Copyright (c) 2007, Daniel Aarno, Michael E. Smoot .
 *  All rights reverved.
 *
 *  See the file COPYING in the top directory of this distribution for
 *  more information.
 *
 *  THE SOFTWARE IS PROVIDED _AS IS_, WITHOUT WARRANTY OF ANY KIND, EXPRESS
 *  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 *  DEALINGS IN THE SOFTWARE.
 *
 *****************************************************************************/

#ifndef TCLAP_STANDARD_TRAITS_H
#define TCLAP_STANDARD_TRAITS_H

// This is an internal tclap file, you should probably not have to
// include this directly

#ifdef HAVE_CONFIG_H
 #include <config.h> // To check for long long
#endif

#include <tclap/ArgTraits.h>

#include <string>

namespace TCLAP
{
	// ======================================================================
	// Integer types
	// ======================================================================

	/**
	 * longs have value-like semantics.
	 */
	template<>
	struct ArgTraits<long>
	{
		typedef ValueLike ValueCategory;
	};

	/**
	 * ints have value-like semantics.
	 */
	template<>
	struct ArgTraits<int>
	{
		typedef ValueLike ValueCategory;
	};

	/**
	 * shorts have value-like semantics.
	 */
	template<>
	struct ArgTraits<short>
	{
		typedef ValueLike ValueCategory;
	};

	/**
	 * chars have value-like semantics.
	 */
	template<>
	struct ArgTraits<char>
	{
		typedef ValueLike ValueCategory;
	};

#ifdef HAVE_LONG_LONG
	/**
	 * long longs have value-like semantics.
	 */
	template<>
	struct ArgTraits<long long>
	{
		typedef ValueLike ValueCategory;
	};

#endif

	// ======================================================================
	// Unsigned integer types
	// ======================================================================

	/**
	 * unsigned longs have value-like semantics.
	 */
	template<>
	struct ArgTraits<unsigned long>
	{
		typedef ValueLike ValueCategory;
	};

	/**
	 * unsigned ints have value-like semantics.
	 */
	template<>
	struct ArgTraits<unsigned int>
	{
		typedef ValueLike ValueCategory;
	};

	/**
	 * unsigned shorts have value-like semantics.
	 */
	template<>
	struct ArgTraits<unsigned short>
	{
		typedef ValueLike ValueCategory;
	};

	/**
	 * unsigned chars have value-like semantics.
	 */
	template<>
	struct ArgTraits<unsigned char>
	{
		typedef ValueLike ValueCategory;
	};

#ifdef HAVE_LONG_LONG
	/**
	 * unsigned long longs have value-like semantics.
	 */
	template<>
	struct ArgTraits<unsigned long long>
	{
		typedef ValueLike ValueCategory;
	};

#endif

	// ======================================================================
	// Float types
	// ======================================================================

	/**
	 * floats have value-like semantics.
	 */
	template<>
	struct ArgTraits<float>
	{
		typedef ValueLike ValueCategory;
	};

	/**
	 * doubles have value-like semantics.
	 */
	template<>
	struct ArgTraits<double>
	{
		typedef ValueLike ValueCategory;
	};

	// ======================================================================
	// Other types
	// ======================================================================

	/**
	 * bools have value-like semantics.
	 */
	template<>
	struct ArgTraits<bool>
	{
		typedef ValueLike ValueCategory;
	};

	/**
	 * wchar_ts have value-like semantics.
	 */
	/*
	template<>
	struct ArgTraits<wchar_t> {
	    typedef ValueLike ValueCategory;
	};
	*/

	/**
	 * Strings have string like argument traits.
	 */
	template<>
	struct ArgTraits<std::string>
	{
		typedef StringLike ValueCategory;
	};

	template<typename T>
	void SetString(T &dst, const std::string &src)
	{
		dst = src;
	}
}

#endif
