/***************************************************************************
    copyright            : (C) 2005-2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#include "choicefieldwidget.h"
#include "../field.h"

#include <kcombobox.h>

#include <tqlabel.h>
#include <tqlayout.h>

using Tellico::GUI::ChoiceFieldWidget;

ChoiceFieldWidget::ChoiceFieldWidget(Data::FieldPtr field_, TQWidget* parent_, const char* name_/*=0*/)
    : FieldWidget(field_, parent_, name_), m_comboBox(0) {

  m_comboBox = new KComboBox(this);
  connect(m_comboBox, TQ_SIGNAL(activated(int)), TQ_SIGNAL(modified()));
  // always have empty choice
  m_comboBox->insertItem(TQString());
  m_comboBox->insertStringList(field_->allowed());
  m_comboBox->setMinimumWidth(5*fontMetrics().maxWidth());

  registerWidget();
}

TQString ChoiceFieldWidget::text() const {
  return m_comboBox->currentText();
}

void ChoiceFieldWidget::setText(const TQString& text_) {
  blockSignals(true);

  m_comboBox->blockSignals(true);
  m_comboBox->setCurrentItem(text_);
  m_comboBox->blockSignals(false);

  blockSignals(false);
}

void ChoiceFieldWidget::clear() {
  m_comboBox->setCurrentItem(0); // first item is empty
  editMultiple(false);
}

void ChoiceFieldWidget::updateFieldHook(Data::FieldPtr, Data::FieldPtr newField_) {
  TQString value = text();
  m_comboBox->clear();
  // always have empty choice
  m_comboBox->insertItem(TQString());
  m_comboBox->insertStringList(newField_->allowed());
  m_comboBox->setCurrentText(value);
}

TQWidget* ChoiceFieldWidget::widget() {
  return m_comboBox;
}

#include "choicefieldwidget.moc"
