#include <tqstyle.h>
#include <tqpainter.h>
#include <tqpushbutton.h>
#include <tqimage.h>
#include <tqstylefactory.h>
#include <tqtabbar.h>
#include <tqcheckbox.h>
#include <tqradiobutton.h>
#include <tqscrollbar.h>
#include <tqmenubar.h>
#include <tqcombobox.h>
#include <tqprogressbar.h>
#include <tqslider.h>
#include <tqtoolbutton.h>
#include <tqapplication.h>
#include <tqdir.h>
#include <tqregexp.h>
#include <tqbitmap.h>
#include <tqeventloop.h>

#include <kiconloader.h>
#include <tdeapplication.h>
#include <tdecmdlineargs.h>
#include <tdeaboutdata.h>
#include <tdeconfig.h>
#include <tdeglobal.h>
#include <kcrash.h>
#include <kstandarddirs.h>

#undef signals
#include <gdk/gdkx.h>
#include <gtk/gtk.h>

#include <cstdlib>
#include <fcntl.h>
#include <sys/types.h>
#include <unistd.h>

#ifdef USE_FREEBSD
#include <kvm.h>
#include <paths.h>
#include <sys/param.h>
#include <sys/sysctl.h>
#include <sys/user.h>
#include <sys/file.h>
#endif

#ifdef USE_SOLARIS
#include <procfs.h>
#endif

#include <gtk/gtkgc.h>

#include "qt_qt_wrapper.h"
#include "qt_style.h"

#define RC_CACHE_VERSION TQString("1")

bool gtkQtEnable = false;
bool tqAppOwner = false;
gboolean tde_showIconsOnPushButtons = false;

TQStringList appDirList;
typedef TQMap<TQString, TQString> IconMap;
IconMap iconMap[4];
extern int errno;

TQScrollBar* scrollBar = 0;
TQWidget* meepWidget = 0;
TQWidget* meepWidgetP = 0;
TQSlider* meepSlider = 0;
TQTabBar* meepTabBar = 0;
GdkGC* altBackGC = 0;
TQWidget* smw = 0;

GtkRcStyle* gtkRcStyle = 0;

TQStringList kdeSearchPaths;
TQString iconTheme;
TQStringList iconThemeDirs;
TQColor alternateBackgroundColour;
int showIconsOnButtons;
int toolbarStyle;

const TQPixmap* backgroundTile;
GdkPixmap* backgroundTileGdk;
TQPixmap* menuBackgroundPixmap;
GdkPixmap* menuBackgroundPixmapGdk;

TQPixmap* fillPixmap;

int scrollBarSpacingLeft = 0;
int scrollBarSpacingRight = 0;

int isBaghira;
int isKeramik;
int isAlloy;
int isDomino;
int isPolyester;
int eclipseFix;
int openOfficeFix;
int mozillaFix;
int chromiumFix;
int gtkQtDebug;

Atom kipcCommAtom;
Atom desktopWindowAtom;

static const int argc_fake = 2;
static char** argv_fake;

static TDEAboutData aboutData("gtk2-tqt-engine", I18N_NOOP("gtk2-tqt-engine"), "v0.1",
	"GTK2 TQt theme engine", TDEAboutData::License_GPL,
	"(c) 2011-2014, Trinity Desktop Project",
	"A TQt theme engine for GTK2 Applications", "https://www.trinitydesktop.org/", 0);

void setFillPixmap(GdkPixbuf* buf)
{
	if (!gtkQtEnable)
		return;

	// This code isn't very robust.  It doesn't handle depths other than 24 bits.
	// It sure is fast though!
	int depth = gdk_pixbuf_get_n_channels(buf) * gdk_pixbuf_get_bits_per_sample(buf);
	int width = gdk_pixbuf_get_width(buf);
	int height = gdk_pixbuf_get_height(buf);
	int excess = gdk_pixbuf_get_rowstride(buf) - (width*3);

	if (depth != 24)
		return;

	TQImage fillImage(width, height, 32);

	uchar* source = gdk_pixbuf_get_pixels(buf);
	uchar* dest = fillImage.bits();

	for (int y=0 ; y<height ; y++)
	{
		for (int x=0 ; x<width ; x++)
		{
			// TODO: Make good on other endiannesses
			dest[0] = source[2];
			dest[1] = source[1];
			dest[2] = source[0];
			dest[3] = '\0';

			dest += 4;
			source += 3;
		}
		source += excess;
	}

	if (fillPixmap)
		delete fillPixmap;
	fillPixmap = 0;
	fillPixmap = new TQPixmap();
	fillPixmap->convertFromImage(fillImage);
	return;
}


/* Now to get rid of a ton of un-needed new's across the board.  `new' and `delete' are
 * non-trivial operations.  You normally just don't notice it; until you're painting a window
 * with 50 widgets, with each paint operation requiring 3-4 news and 3-4 delete's.  The cost
 * of indirection is `not insubstantial'. */


static int dummy_x_errhandler( Display *dpy, XErrorEvent *err )
{
	return 0;
}
static int dummy_xio_errhandler( Display * )
{
	return 0;
}

void createTQApp()
{
	TQString cmdLine;

#ifdef USE_FREEBSD
/*
   procfs(5) is deprecated on FreeBSD.
   We use the kvm(3) library to get argv[0] of the current pid.
*/
	int cnt = 0;
	int ret = 0;
	kvm_t *kd;
	struct kinfo_proc *pbase;
	char ** arg;
	const char *msg = "";

	kd = kvm_open(NULL, _PATH_DEVNULL, NULL, O_RDONLY, "kvm_open");
	if (kd == NULL )
	{
		msg = "kvm_open failed\n";
		ret = -1;
	}
	else
	{
		pbase = kvm_getprocs(kd, KERN_PROC_PID, getpid(), &cnt);
		if (( pbase == NULL ) || ( cnt != 1 ))
		{
			msg = "kvm_getprocs failed\n";
			ret = -1;
		}
		else
		{
			arg = kvm_getargv(kd, pbase, 1024);
			if (arg == NULL)
			{
				msg = "kvm_getargv failed\n";
				ret = -1;
			}
			else
			{
				cmdLine += arg[0];
			}
		}
		kvm_close(kd);
	}
	if (ret == -1)
	{
		printf("Gtk-Qt theme engine warning:\n");
		printf(msg);
		printf("  This may cause problems for the GNOME window manager\n");
	}
#endif // USE_FREEBSD

#ifdef USE_SOLARIS
	int pid=getpid();
	char filen[256];
	psinfo_t pfi;
	uintptr_t addr;
	uintptr_t addr2;
	int  i,count,readl, ret=0;
	const char *msg;

	sprintf(filen, "/proc/%d/psinfo",pid);
	int fd=open(filen, O_RDONLY);
	if (fd == -1)
	{
		msg = "Open of psinfo failed\n";
		ret = -1;
	}
	else
	{
		readl=read(fd, (void *)&pfi, sizeof(psinfo_t));
		if (readl < 0)
		{
			msg = "Read on as failed\n";
			close(fd);
			ret = -1;
		}
		else
		{
			addr=pfi.pr_argv;
			count=pfi.pr_argc;
		}
		close(fd);
	}
	/* if read of psinfo was success */
	if (!ret)
	{
		sprintf(filen, "/proc/%d/as",pid);
		fd=open(filen, O_RDONLY);
		if (fd == -1)
		{
			msg = "Open of as failed\n";
			ret = -1;
		}
		else
		{
			for (i=0;i<count;i++)
			{
				lseek(fd, addr, SEEK_SET);
				if (pfi.pr_dmodel == PR_MODEL_ILP32)
				{
					addr=addr+4;
					readl=read(fd, (void *)&addr2, 4);
				}
				else
				{
					addr=addr+8;
					readl=read(fd, (void *)&addr2,8);
				}
				if (readl < 0)
				{
					msg = "Read on as failed\n";
					close(fd);
					ret = -1;
					break;
				}
				if (addr2 != 0)
				{
					cmdLine += (char *)addr2;
					cmdLine += " ";
				}
				else
					break;
			}
			close(fd);
		}
	}

	if (ret == -1)
	{
		printf("Gtk-Qt theme engine warning:\n");
		printf(msg);
		printf("  This may cause problems for the GNOME window manager\n");
	}
#else // USE_SOLARIS
#ifndef USE_FREEBSD
	TQCString cmdlinePath;
	cmdlinePath.sprintf("/proc/%d/cmdline", getpid());
	int fd = open(cmdlinePath, O_RDONLY);
	if (fd == -1)
	{
		printf("Gtk-Qt theme engine warning:\n");
		printf("  Could not open %s\n", (const char*)cmdlinePath);
		printf("  This may cause problems for the GNOME window manager\n");
	}
	else
	{
		while (1)
		{
			char data[80];
			int len = read(fd, data, 80);
			if (len == 0)
				break;
			cmdLine += data;
		}
		close(fd);
	}
#endif // USE_FREEBSD
#endif // USE_SOLARIS

	TQString cmdlineAppName = "unknown-gtk-tqt-application";
	TQString cmdlineCrashHandler = "--crashhandler";
	TQStringList cmdlineArgs = TQStringList::split(" ", cmdLine, false);
	if (cmdlineArgs.count() > 0) {
		TQFileInfo fi(cmdlineArgs[0]);
        	cmdlineAppName = fi.fileName();
		cmdlineAppName.append("-gtk-tqt-application");
	}
	int cmdlineAppNameLength = cmdlineAppName.length() + 1;

	// Process hacks
	mozillaFix = (cmdLine.contains("mozilla") || cmdLine.contains("firefox") || cmdLine.contains("iceweasel") || cmdLine.contains("thunderbird") || cmdLine.contains("icedove"));
	chromiumFix = (cmdLine.contains("chromium-browser") || cmdLine.contains("chrome-browser"));

	openOfficeFix = (cmdLine.endsWith("soffice.bin"))
	              | (cmdLine.endsWith("swriter.bin"))
	              | (cmdLine.endsWith("scalc.bin"))
	              | (cmdLine.endsWith("sdraw.bin"))
	              | (cmdLine.endsWith("spadmin.bin"))
	              | (cmdLine.endsWith("simpress.bin"));

	eclipseFix = cmdLine.contains("eclipse");

	if (mozillaFix || chromiumFix) {
		// Without these lines Firefox WILL crash in EnterBaseline on first startup
		// Does baseline internally generate SIGSEGVs as part of normal operation?
		cmdlineCrashHandler = "--nocrashhandler";
	}

	int cmdlineCrashHandlerLength = cmdlineCrashHandler.length() + 1;

	// Create a new TDEApplication and supply it with fake data to keep its constructor happy
	argv_fake = (char**) malloc(sizeof(char*)*argc_fake);
	argv_fake[0] = (char*) malloc(sizeof(char) * cmdlineAppNameLength);
	argv_fake[1] = (char*) malloc(sizeof(char) * cmdlineCrashHandlerLength);
	strncpy(argv_fake[0], cmdlineAppName.ascii(), cmdlineAppNameLength);
	strncpy(argv_fake[1], cmdlineCrashHandler.ascii(), cmdlineCrashHandlerLength);
	aboutData.setAppName(cmdlineAppName.ascii());

	aboutData.addAuthor("Timothy Pearson", I18N_NOOP("Maintainer"), "kb9vqf@pearsoncomputing.net", 0);
	aboutData.addAuthor("David Sansome", I18N_NOOP("Original Author"), "me@davidsansome.com", 0);
	TDECmdLineArgs::init(argc_fake, argv_fake, &aboutData);

	TDEApplication::disableAutoDcopRegistration();

	gtkQtDebug = (getenv("GTK_TQT_ENGINE_DEBUG") != NULL) ? 1 : 0;

	if (gtkQtDebug) {
		printf("createTQApp()\n");
	}

	char* sessionEnv = getenv("SESSION_MANAGER");
	if (TQString(sessionEnv).endsWith(TQString::number(getpid())) || cmdLine.contains("notification-daemon-tde") || cmdLine.contains("nspluginviewer") || cmdLine.contains("gnome-wm") || cmdLine.contains("metacity") || cmdLine.contains("xfwm4") || (getenv("GTK_TQT_ENGINE_DISABLE") != NULL))
	{
		printf("Not initializing the Gtk-Qt theme engine\n");
	}
	else
	{
		int (*original_x_errhandler)( Display *dpy, XErrorEvent * );
		int (*original_xio_errhandler)( Display *dpy );
		original_x_errhandler = XSetErrorHandler( dummy_x_errhandler );
		original_xio_errhandler = XSetIOErrorHandler( dummy_xio_errhandler );

#ifndef USE_SOLARIS
		unsetenv("SESSION_MANAGER");
#else
		putenv("SESSION_MANAGER=");
#endif

		if (!tqApp)
		{
			new TDEApplication(gdk_x11_get_default_xdisplay(), true, 0, 0, true);
			tqAppOwner = true;
		}

		initKdeSettings();

#ifndef USE_SOLARIS
		if (sessionEnv) {
			setenv("SESSION_MANAGER", sessionEnv, 1);
		}
#else
		char *tempEnv=(char *)malloc(strlen(sessionEnv)+strlen("SESSION_MANAGER")+2);
		sprintf(tempEnv, "SESSION_MANAGER=%s", sessionEnv);
		putenv(tempEnv);
#endif

		XSetErrorHandler( original_x_errhandler );
		XSetIOErrorHandler( original_xio_errhandler );

		gtkQtEnable = true;
	}

	// Propagate glib events to GTK as needed
	if (tqApp) {
		TQEventLoop* loop = tqApp->eventLoop();
		if (loop) {
			loop->setSingleToolkitEventHandling(false);
		}
	}

	if (!gtkQtEnable)
		return;

	isBaghira   = (TQString(tqApp->style().name()).lower() == "baghira");
	isKeramik   = (TQString(tqApp->style().name()).lower() == "keramik");
	isAlloy     = (TQString(tqApp->style().name()).lower() == "alloy");
	isDomino    = (TQString(tqApp->style().name()).lower() == "domino");
	isPolyester = (TQString(tqApp->style().name()).lower() == "polyester");

	if (isDomino)
	{
		TQScrollBar sbar(NULL);
		sbar.setOrientation(TQt::Horizontal);
		sbar.setValue(1);
		sbar.resize(200,25);

		TQRect rect = tqApp->style().querySubControlMetrics(TQStyle::CC_ScrollBar, &sbar, TQStyle::SC_ScrollBarGroove);
		scrollBarSpacingLeft = rect.x();
		scrollBarSpacingRight = 200 - rect.x() - rect.width();
	}

	// Set Gtk fonts and icons
	/*setGnomeFonts();
	setGnomeIcons();*/

	if (!cmdLine.contains("xfce-mcs-manager"))
	{
		// Get KDE related atoms from the X server
		kipcCommAtom = XInternAtom ( gdk_x11_get_default_xdisplay() , "KIPC_COMM_ATOM" , false );
		desktopWindowAtom = XInternAtom ( gdk_x11_get_default_xdisplay() , "KDE_DESKTOP_WINDOW" , false );

		// Create a new window, and set the KDE_DESKTOP_WINDOW property on it
		// This window will then receive events from KDE when the style changes
		smw = new TQWidget(0,0);
		long data = 1;
		XChangeProperty(gdk_x11_get_default_xdisplay(), smw->winId(),
			desktopWindowAtom, desktopWindowAtom,
			32, PropModeReplace, (unsigned char *)&data, 1);

		// This filter will intercept those events
		gdk_window_add_filter( NULL, gdkEventFilter, 0);
	}

	meepWidgetP = new TQWidget(0);
	meepWidget = new TQWidget(meepWidgetP);
	meepSlider = new TQSlider(meepWidget);
	meepWidget->polish();

	meepTabBar = new TQTabBar(meepWidget);

	menuBackgroundPixmap = NULL;
	backgroundTile = meepWidget->paletteBackgroundPixmap();
	if (backgroundTile != NULL)
		backgroundTileGdk = gdk_pixmap_foreign_new(backgroundTile->handle());
}

void destroyTQApp()
{
	if (!gtkQtEnable)
		return;
	delete meepWidget;
	delete meepWidgetP;
	delete menuBackgroundPixmap;
	delete smw;
	if (tqAppOwner)
	{
		delete tqApp;
		tqApp = 0;
	}
	if (altBackGC != 0)
		gtk_gc_release(altBackGC);

	free(argv_fake[1]);
	free(argv_fake[0]);
	free(argv_fake);
}

GdkFilterReturn gdkEventFilter(GdkXEvent *xevent, GdkEvent *gevent, gpointer data)
{
	XEvent* event = (XEvent*) xevent;

	// Is the event a KIPC message?
	if ((event->type == ClientMessage) && (event->xclient.message_type == kipcCommAtom))
	{
		// This data variable contains the type of KIPC message
		// As defined in tdelibs/tdecore/kipc.h, 2 = StyleChanged
		if (event->xclient.data.l[0] != 2)
			return GDK_FILTER_REMOVE;

		if (gtkQtDebug)
			printf("StyleChanged IPC message\n");

		// Find out the new widget style
		TQString styleName = kdeConfigValue("General", "widgetStyle", "");
		TQStyle* style = TQStyleFactory::create(styleName);
		if (!style)
			return GDK_FILTER_REMOVE;

		// Tell the TQApplication about this new style
		tqApp->setStyle(style);

		// Now we need to update GTK's properties
		setRcProperties(gtkRcStyle, 1); // Rewrite our cache file
		gtk_rc_reparse_all(); // Tell GTK to parse the cache file

		return GDK_FILTER_REMOVE;
	}
	return GDK_FILTER_CONTINUE;
}

TQString kdeConfigValue(const TQString& section, const TQString& name, const TQString& def)
{
	TDEConfig currentConfig;
	currentConfig.setGroup(section);
	return currentConfig.readEntry(name, def);
}

bool kdeBoolConfigValue(const TQString& section, const TQString& name, bool def)
{
	TDEConfig currentConfig;
	currentConfig.setGroup(section);
	return currentConfig.readBoolEntry(name, def);
}

TQString kdeFindDir(const TQString& suffix, const TQString& file1, const TQString& file2)
{
	for ( TQStringList::Iterator it = kdeSearchPaths.begin(); it != kdeSearchPaths.end(); ++it )
	{
		if ((TQFile::exists((*it) + suffix + file1)) || (TQFile::exists((*it) + suffix + file2)))
			return (*it) + suffix;
	}
	return TQString();
}

TQString runCommand(const TQString& command)
{
	FILE* p = popen(command.latin1(), "r");
	if (p == NULL) {
		return TQString();
	}

	TQString ret;
	while (!feof(p))
	{
		char buffer[256];
		int n = fread(buffer, 1, 255, p);
		buffer[n] = '\0';
		ret += buffer;
	}
	pclose(p);

	return ret.stripWhiteSpace();
}

void initKdeSettings()
{
	kdeSearchPaths.clear();

	TQString kdeHome = getenv("TDEHOME");
	TQString kdeDirs = getenv("TDEDIRS");
	TQString kdeDir = getenv("TDEDIR");

	if (!kdeHome.isEmpty())
		kdeSearchPaths.append(kdeHome);
	kdeSearchPaths.append(runCommand("tde-config --localprefix"));

	if (!kdeDirs.isEmpty())
		kdeSearchPaths += TQStringList::split(':', kdeDirs);
	if (!kdeDir.isEmpty())
		kdeSearchPaths.append(kdeDir);
	kdeSearchPaths.append(runCommand("tde-config --prefix"));

	iconTheme = kdeConfigValue("Icons", "Theme", "crystalsvg");
	tde_showIconsOnPushButtons = kdeBoolConfigValue("KDE", "ShowIconsOnPushButtons", false);

	TQStringList back = TQStringList::split(',', kdeConfigValue("General", "alternateBackground", "238,246,255"));
	alternateBackgroundColour.setRgb(back[0].toInt(), back[1].toInt(), back[2].toInt());

	showIconsOnButtons = (kdeConfigValue("KDE", "ShowIconsOnPushButtons", "true").lower() == "true");


	TQString tmp = kdeConfigValue("Toolbar style", "IconText", "true").lower();
	if (tmp == "icononly")
		toolbarStyle = 0;
	else if (tmp == "icontextright")
		toolbarStyle = 3;
	else if (tmp == "textonly")
		toolbarStyle = 1;
	else if (tmp == "icontextbottom")
		toolbarStyle = 2;
	else // Should never happen, but just in case we fallback to KDE's default "icononly"
		toolbarStyle = 0;
}

TQStyle::SFlags stateToSFlags(GtkStateType state)
{
	switch (state)
	{
		case GTK_STATE_ACTIVE:
			return TQStyle::Style_Enabled | TQStyle::Style_Down;
		case GTK_STATE_PRELIGHT:
			return TQStyle::Style_Enabled | TQStyle::Style_MouseOver | TQStyle::Style_Raised;
		case GTK_STATE_SELECTED:
			return TQStyle::Style_Enabled | TQStyle::Style_HasFocus | TQStyle::Style_Raised;
		case GTK_STATE_INSENSITIVE:
			return TQStyle::Style_Default | TQStyle::Style_Raised;
		default:
			return TQStyle::Style_Enabled | TQStyle::Style_Raised;
	}
}

TQColor gdkColorToTQColor(GdkColor* c)
{
	return TQColor(c->red / 256, c->green / 256, c->blue / 256);
}


// The drawing functions follow the same pattern:
//  * Set the appropriate flags
//  * Ask TQt to paint the widget to a pixmap
//  * Create a GdkPixmap that points to our TQPixmap
//  * Paint the pixmap on the window


void drawButton(GdkWindow* window, GtkStyle* style, GtkStateType state, int defaultButton, int x, int y, int w, int h, GtkButton* gwidget)
{
	if (!gtkQtEnable)
		return;

	if ((w < 1) || (h < 1))
		return;

#ifdef USE_NATIVE_GTK_BUTTON_DRAWING
	gwidget = NULL;
#endif

	if (gtkQtDebug) {
		GtkWidget* parent;
		parent = gtk_widget_get_parent(GTK_WIDGET(gwidget));
		printf("drawButton Parent 1: %s\n",gtk_widget_get_name(parent));
		parent = gtk_widget_get_parent(GTK_WIDGET(parent));
		printf("drawButton Parent 2: %s\n",gtk_widget_get_name(parent));
		parent = gtk_widget_get_parent(GTK_WIDGET(parent));
		printf("drawButton Parent 3: %s\n",gtk_widget_get_name(parent));
		parent = gtk_widget_get_parent(GTK_WIDGET(parent));
		printf("drawButton Parent 4: %s\n",gtk_widget_get_name(parent));
	}

	if (gwidget) {
		TQString gwLabel(gtk_button_get_label(gwidget));
		if (gtk_button_get_use_stock(gwidget)) {
			GtkStockItem stockData;
			gtk_stock_lookup(gwLabel.ascii(), &stockData);
			gwLabel = TQString(stockData.label);
		}
		gwLabel.replace("&", "&&");
		gwLabel.replace("_", "&");

		TQPixmap buttonicon;
		TQBitmap buttonicon_mask;

		GtkWidget* giconwidget = gtk_button_get_image(gwidget);
		if (giconwidget) {
			GtkIconSize giconSize;
			gint iconWidth;
			gint iconHeight;

			GtkImageType giconStorageType = gtk_image_get_storage_type(GTK_IMAGE(giconwidget));
			if (giconStorageType == GTK_IMAGE_STOCK) {
				gchar *stock_id;
				gtk_image_get_stock(GTK_IMAGE(giconwidget), &stock_id, &giconSize);
				GdkPixbuf* pixbuf = gtk_widget_render_icon(GTK_WIDGET(gwidget), stock_id, giconSize, NULL);
				iconWidth=gdk_pixbuf_get_width(pixbuf);
				iconHeight=gdk_pixbuf_get_height(pixbuf);
				buttonicon = TQPixmap(iconWidth, iconHeight);
				buttonicon_mask = TQBitmap(iconWidth, iconHeight);
				buttonicon.fill(tqApp->palette().active().background());
				buttonicon_mask.fill(TQt::color0);
				GdkPixmap* pix = gdk_pixmap_foreign_new(buttonicon.handle());
				GdkBitmap* bmp = gdk_pixmap_foreign_new(buttonicon_mask.handle());
				gdk_drawable_set_colormap(pix, gdk_drawable_get_colormap(window));
				gdk_drawable_set_colormap(bmp, gdk_drawable_get_colormap(window));
				gdk_draw_pixbuf(pix, NULL, pixbuf, 0, 0, 0, 0, -1, -1, GDK_RGB_DITHER_NONE, 0, 0);
				gdk_pixbuf_render_threshold_alpha(pixbuf, bmp, 0, 0, 0, 0, -1, -1, 128);
				buttonicon.setMask(buttonicon_mask);
				g_object_unref(pixbuf);
				g_object_unref(bmp);
				g_object_unref(pix);
			}
			else {
				// FIXME
				// Implement pixmap loading here for non-stock icons
			}
		}

		TQIconSet    buttonIconSet(buttonicon);
		TQPixmap     pixmap(w, h);
		TQPainter    painter(&pixmap);
		TQPushButton button(meepWidget);
		button.setBackgroundOrigin(TQWidget::ParentOrigin);
		button.setGeometry(x, y, w, h);
		if (style->rc_style->bg[GTK_STATE_NORMAL].pixel != 0) {
			button.setPaletteBackgroundColor(gdkColorToTQColor(&style->rc_style->bg[GTK_STATE_NORMAL]));
		}

		TQStyle::SFlags sflags = stateToSFlags(state);

		if (defaultButton)
			sflags |= TQStyle::Style_ButtonDefault;
		button.setDefault(defaultButton);

		painter.fillRect(0, 0, w, h, tqApp->palette().active().background());

		button.setText(gwLabel);
		if (tde_showIconsOnPushButtons)
			button.setIconSet(buttonIconSet);
		button.setDown(sflags&TQStyle::Style_Down);
		button.setOn(sflags&TQStyle::Style_On);

		// This emulates ::drawButton() in the TQt qbutton.cpp file
		tqApp->style().drawControl(TQStyle::CE_PushButton, &painter, &button,
		                          TQRect(0,0,w,h), button.palette().active(), sflags);
		tqApp->style().drawControl(TQStyle::CE_PushButtonLabel, &painter, &button,
					tqApp->style().subRect(TQStyle::SR_PushButtonContents, &button),
					button.colorGroup(), sflags);

		GdkPixmap* pix = gdk_pixmap_foreign_new(pixmap.handle());
		gdk_draw_drawable(window, style->bg_gc[state], pix, 0, 0, x, y, w, h);
		g_object_unref(pix);
	}
	else {
		TQPixmap     pixmap(w, h);
		TQPainter    painter(&pixmap);
		TQPushButton button(meepWidget);
		button.setBackgroundOrigin(TQWidget::ParentOrigin);
		button.setGeometry(x, y, w, h);
		if (style->rc_style->bg[GTK_STATE_NORMAL].pixel != 0)
			button.setPaletteBackgroundColor(gdkColorToTQColor(&style->rc_style->bg[GTK_STATE_NORMAL]));

		TQStyle::SFlags sflags = stateToSFlags(state);

		if (defaultButton)
			sflags |= TQStyle::Style_ButtonDefault;
		button.setDefault(defaultButton);

		painter.fillRect(0, 0, w, h, tqApp->palette().active().background());

		tqApp->style().drawControl(TQStyle::CE_PushButton, &painter, &button,
		                          TQRect(0,0,w,h), button.palette().active(), sflags);

		GdkPixmap* pix = gdk_pixmap_foreign_new(pixmap.handle());
		gdk_draw_drawable(window, style->bg_gc[state], pix, 0, 0, x, y, w, h);
		g_object_unref(pix);
	}
}

// Thanks Peter Hartshorn <peter@dimtech.com.au>
void drawToolbar(GdkWindow* window, GtkStyle* style, GtkStateType state, int x, int y, int w, int h)
{
	if (!gtkQtEnable)
		return;

	int w1, h1;
	TQStyle::SFlags sflags = stateToSFlags(state) | TQStyle::Style_Raised;


	// Keramik hack...
	// Keramik only draws the toolbar border, and not the gradient
	// so we also draw a separator, but make sure the line is off the
	// widget

	if (w > h)
	{
		sflags |= TQStyle::Style_Horizontal;
		w1 = w * 3;
		h1 = h;
	}
	else
	{
		w1 = h;
		h1 = h * 3;
	}

	if ((w1 < 1) || (h1 < 1) ||
	    (w < 1) || (h < 1))
		return;

	TQPixmap     pixmap(w1, h1);
	TQPixmap     p(w, h);
	TQPainter    painter(&pixmap);

        if ((backgroundTile) && (!backgroundTile->isNull()))
                painter.fillRect(0, 0, w1, h1, TQBrush(TQColor(255,255,255), *backgroundTile));
        else
                painter.fillRect(0, 0, w1, h1, tqApp->palette().active().brush(TQColorGroup::Background));

	tqApp->style().drawPrimitive(TQStyle::PE_PanelDockWindow, &painter,
			TQRect(0,0,w1,h1), tqApp->palette().active(),sflags);

	if (isKeramik)
	{
		tqApp->style().drawPrimitive(TQStyle::PE_DockWindowSeparator, &painter,
				TQRect(0,0,w1,h1), tqApp->palette().active(),sflags);
	}

	bitBlt(&p, 0, 0, &pixmap, 0, 0, w, h);

	GdkPixmap* pix = gdk_pixmap_foreign_new(pixmap.handle());
	gdk_draw_drawable(window, style->bg_gc[state], pix, 0, 0, x, y, w, h);
	g_object_unref(pix);
}

void drawMenubar(GdkWindow* window, GtkStyle* style, GtkStateType state, int x, int y, int w, int h)
{
	if (!gtkQtEnable)
		return;

	int w1, h1;
	TQStyle::SFlags sflags = stateToSFlags(state);


	// Keramik hack...
	// Keramik only draws the toolbar border, and not the gradient
	// so we also draw a separator, but make sure the line is off the
	// widget

	if (w > h)
	{
		sflags |= TQStyle::Style_Horizontal;
		w1 = w * 3;
		h1 = h;
	}
	else
	{
		w1 = h;
		h1 = h * 3;
	}

	if ((w1 < 1) || (h1 < 1) ||
	    (w < 1) || (h < 1))
		return;

	TQPixmap     pixmap(w1, h1);
	TQPixmap     p(w, h);
	TQPainter    painter(&pixmap);

        if ((backgroundTile) && (!backgroundTile->isNull()))
                painter.fillRect(0, 0, w1, h1, TQBrush(TQColor(255,255,255), *backgroundTile));
        else
                painter.fillRect(0, 0, w1, h1, tqApp->palette().active().brush(TQColorGroup::Background));

	tqApp->style().drawPrimitive(TQStyle::PE_PanelMenuBar, &painter,
			TQRect(0,0,w1,h1), tqApp->palette().active(),sflags);

	bitBlt(&p, 0, 0, &pixmap, 0, 0, w, h);

	GdkPixmap* pix = gdk_pixmap_foreign_new(pixmap.handle());
	gdk_draw_drawable(window, style->bg_gc[state], pix, 0, 0, x, y, w, h);
	g_object_unref(pix);
}

void drawTab(GdkWindow* window, GtkStyle* style, GtkStateType state, int x, int y, int w, int h)
{
	if (!gtkQtEnable)
		return;

	if ((w < 1) || (h < 1))
		return;

	TQPixmap pixmap(w,h);
	TQPainter painter(&pixmap);

	// GTK doesn't tell us if our tab is on the left, right, or middle of the tabbar
	// So, let's always assume it's in the middle - it looks pretty
	TQTab* tab = new TQTab;
	meepTabBar->insertTab(tab,1);

	TQStyle::SFlags sflags = stateToSFlags(state);

	if (state != GTK_STATE_ACTIVE)
		sflags = TQStyle::Style_Selected;

	painter.fillRect(0, 0, w, h, tqApp->palette().active().brush(TQColorGroup::Background));
	tqApp->style().drawControl(TQStyle::CE_TabBarTab, &painter, meepTabBar, TQRect(0,0,w,h), tqApp->palette().active(), sflags, TQStyleOption(tab));

	GdkPixmap* pix = gdk_pixmap_foreign_new(pixmap.handle());
	gdk_draw_drawable(window, style->bg_gc[state], pix, 0, 0, x, y, w, h);
	g_object_unref(pix);

	meepTabBar->removeTab(tab);
}

void drawVLine(GdkWindow* window, GtkStyle* style, GtkStateType state, int x, int ySource, int yDest)
{
	if (!gtkQtEnable)
		return;

	int width = style->xthickness;
	int height = abs(ySource-yDest);

	if (width < 2) width = 2;

	if ((width < 1) || (height < 1))
		return;

	TQPixmap pixmap(width, height);
	TQPainter painter(&pixmap);

	painter.fillRect(2, 0, width - 2, height, tqApp->palette().active().brush(TQColorGroup::Background));
	painter.setPen( tqApp->palette().active().mid() );
	painter.drawLine( 0, 0, 0, height );
	painter.setPen( tqApp->palette().active().light() );
	painter.drawLine( 1, 0, 1, height );

	GdkPixmap* pix = gdk_pixmap_foreign_new(pixmap.handle());
	gdk_draw_drawable(window, style->bg_gc[state], pix, 0, 0, x, ySource, width, height);
	g_object_unref(pix);
}

void drawHLine(GdkWindow* window, GtkStyle* style, GtkStateType state, int y, int xSource, int xDest)
{
	if (!gtkQtEnable)
		return;

	int width = abs(xSource-xDest);
	int height = style->ythickness;

	if ((width < 1) || (height < 1))
		return;

	TQPixmap pixmap(width, height);
	TQPainter painter(&pixmap);

	painter.fillRect(0, 2, width, height-2, tqApp->palette().active().brush(TQColorGroup::Background));
	painter.setPen(tqApp->palette().active().mid() );
	painter.drawLine(0, 0, width, 0);
	painter.setPen(tqApp->palette().active().light());
	painter.drawLine(0, 1, width, 1);

	GdkPixmap* pix = gdk_pixmap_foreign_new(pixmap.handle());
	gdk_draw_drawable(window, style->bg_gc[state], pix, 0, 0, xSource, y, width, height);
	g_object_unref(pix);
}

void drawLineEdit(GdkWindow* window, GtkStyle* style, GtkStateType state, int hasFocus, int x, int y, int w, int h)
{
	if (!gtkQtEnable)
		return;

	if ((w < 1) || (h < 1))
		return;

	TQPixmap pixmap(w, h);
	TQPainter painter(&pixmap);

	TQStyle::SFlags sflags = stateToSFlags(state);
	if (hasFocus)
		sflags |= TQStyle::Style_HasFocus;

	painter.fillRect(0, 0, w, h, tqApp->palette().active().base());
	tqApp->style().drawPrimitive(TQStyle::PE_PanelLineEdit, &painter, TQRect(0, 0, w, h), tqApp->palette().active(), sflags, TQStyleOption(1,1));

	GdkPixmap* pix = gdk_pixmap_foreign_new(pixmap.handle());
	gdk_draw_drawable(window, style->bg_gc[state], pix, 0, 0, x, y, w, h);
	g_object_unref(pix);
}

void drawFrame(GdkWindow* window, GtkStyle* style, GtkStateType state, GtkShadowType shadow_type, int x, int y, int w, int h)
{
	if (!gtkQtEnable)
		return;

	if ((w < 1) || (h < 1)) // Caused crash in gaim file transfers window
		return;

	TQPixmap pixmap(w, h);
	TQPainter painter(&pixmap);

	TQStyle::SFlags sflags = stateToSFlags(state);
	if ((shadow_type == GTK_SHADOW_IN) || (shadow_type == GTK_SHADOW_ETCHED_IN))
		sflags |= TQStyle::Style_Sunken;

	if ((backgroundTile) && (!backgroundTile->isNull()))
		painter.fillRect(0, 0, w, h, TQBrush(TQColor(255,255,255), *backgroundTile));
	else
		painter.fillRect(0, 0, w, h, tqApp->palette().active().brush(TQColorGroup::Background));

	tqApp->style().drawPrimitive(TQStyle::PE_Panel, &painter, TQRect(0, 0, w, h), tqApp->palette().active(), sflags, TQStyleOption(2,2) );

	GdkPixmap* pix = gdk_pixmap_foreign_new(pixmap.handle());
	gdk_draw_drawable(window, style->bg_gc[state], pix, 0, 0, x, y, w, h);
	g_object_unref(pix);
}

void drawComboBox(GdkWindow* window, GtkStyle* style, GtkStateType state, int x, int y, int w, int h)
{
	if (!gtkQtEnable)
		return;

	if ((w < 1) || (h < 1))
		return;

	TQPixmap pixmap(w,h);
	TQPainter painter(&pixmap);
	TQComboBox cb(false, 0);
	cb.resize(w,h);

	TQStyle::SFlags sflags = stateToSFlags(state);
	TQStyle::SCFlags scflags = TQStyle::SC_ComboBoxArrow | TQStyle::SC_ComboBoxFrame | TQStyle::SC_ComboBoxListBoxPopup;
	TQStyle::SCFlags activeflags = TQStyle::SC_None;

	if (state == GTK_STATE_PRELIGHT)
		activeflags = TQStyle::Style_MouseOver;

	painter.fillRect(0,0, w, h, tqApp->palette().active().brush(TQColorGroup::Background));
	tqApp->style().drawComplexControl(TQStyle::CC_ComboBox, &painter, &cb, TQRect(0, 0, w, h), tqApp->palette().active(), sflags, scflags, activeflags);

	GdkPixmap* pix = gdk_pixmap_foreign_new(pixmap.handle());
	gdk_draw_drawable(window, style->bg_gc[state], pix, 0, 0, x, y, w, h);
	g_object_unref(pix);
}

void drawCheckBox(GdkWindow* window, GtkStyle* style, GtkStateType state, int checked, int x, int y, int w, int h)
{
	if (!gtkQtEnable)
		return;

	int realH = tqApp->style().pixelMetric(TQStyle::PM_IndicatorHeight);
	int realW = tqApp->style().pixelMetric(TQStyle::PM_IndicatorWidth);

	if ((realW < 1) || (realH < 1))
		return;

	TQPixmap pixmap(realW, realH);
	TQPainter painter(&pixmap);
	TQCheckBox checkbox(0);

	TQStyle::SFlags sflags = stateToSFlags(state);
	sflags |= (checked ? TQStyle::Style_On : TQStyle::Style_Off);

	painter.fillRect(0, 0, realW, realH, tqApp->palette().active().brush(TQColorGroup::Background));
	tqApp->style().drawControl(TQStyle::CE_CheckBox, &painter, &checkbox, TQRect(0, 0, realW, realH), tqApp->palette().active(), sflags);

	// TQt checkboxes are usually bigger than GTK wants.
	// We cheat, and draw them over the expected area.
	int xOffset = (realW - w) / 2;
	int yOffset = (realH - h) / 2;

	GdkPixmap* pix = gdk_pixmap_foreign_new(pixmap.handle());
	gdk_draw_drawable(window, style->bg_gc[state], pix, 0, 0, x - xOffset, y - yOffset, realW, realH);
	g_object_unref(pix);
}

void drawMenuCheck(GdkWindow* window, GtkStyle* style, GtkStateType state, int x, int y, int w, int h)
{
	if (!gtkQtEnable)
		return;

	TQCheckBox checkbox(0);

	/* A previous version of the function followed the sizehints exclusively
	   Now follow w and h provided by GTK, but if the checkmark is too big we might have to scale it */
	/*
	int w1 = checkbox.sizeHint().width();
	int h1 = checkbox.sizeHint().height(); */

	if ((w < 1) || (h < 1))
		return;

	TQPixmap pixmap(w,h);
	TQPainter painter(&pixmap);

	TQStyle::SFlags sflags = stateToSFlags(state);
	sflags |= TQStyle::Style_On;

	if (fillPixmap && (!fillPixmap->isNull()))
		painter.fillRect(0, 0, w, h, TQBrush(TQColor(255,255,255), *fillPixmap));
	else if ((backgroundTile) && (!backgroundTile->isNull()))
                painter.fillRect(0, 0, w, h, TQBrush(TQColor(255,255,255), *backgroundTile));
        else
	painter.fillRect(0, 0, w, h, tqApp->palette().active().brush(TQColorGroup::Background));
	tqApp->style().drawPrimitive(TQStyle::PE_CheckMark, &painter, TQRect(0, 0, w, h), tqApp->palette().active(), sflags);

	GdkPixmap* pix = gdk_pixmap_foreign_new(pixmap.handle());
	gdk_draw_drawable(window, style->bg_gc[state], pix, 0, 0, x, y, w, h);
	g_object_unref(pix);
}

void drawRadioButton(GdkWindow* window, GtkStyle* style, GtkStateType state, int checked, int x, int y, int w, int h)
{
	if (!gtkQtEnable)
		return;

	int realH = tqApp->style().pixelMetric(TQStyle::PM_IndicatorHeight);
	int realW = tqApp->style().pixelMetric(TQStyle::PM_IndicatorWidth);

	if ((realW < 1) || (realH < 1))
		return;

	TQPixmap pixmap(realH, realW);
	TQPainter painter(&pixmap);
	TQRadioButton radio(0);

	TQStyle::SFlags sflags = stateToSFlags(state);
	sflags |= checked ? TQStyle::Style_On : TQStyle::Style_Off;

	if (fillPixmap && (!fillPixmap->isNull()))
		painter.fillRect(0, 0, realW, realH, TQBrush(TQColor(255,255,255), *fillPixmap));
	else if ((backgroundTile) && (!backgroundTile->isNull()))
                painter.fillRect(0, 0, realW, realH, TQBrush(TQColor(255,255,255), *backgroundTile));
        else
                painter.fillRect(0, 0, realW, realH, tqApp->palette().active().brush(TQColorGroup::Background));

	tqApp->style().drawControl(TQStyle::CE_RadioButton, &painter, &radio, TQRect(0,0,realH,realW), tqApp->palette().active(), sflags);

	// TQt checkboxes are usually bigger than GTK wants.
	// We cheat, and draw them over the expected area.
	int xOffset = (realW - w) / 2;
	int yOffset = (realH - h) / 2;

	GdkPixmap* pix = gdk_pixmap_foreign_new(pixmap.handle());
	gdk_draw_drawable(window, style->bg_gc[state], pix, 0, 0, x - xOffset, y - yOffset, realW, realH);
	g_object_unref(pix);
}


void drawScrollBarSlider(GdkWindow* window, GtkStyle* style, GtkStateType state, int orientation, GtkAdjustment* adj, int x, int y, int w, int h, int offset, int totalExtent)
{
	if (!gtkQtEnable)
		return;

	if ((w < 1) || (h < 1))
		return;

	int wCorrected = w;
	int hCorrected = h;
	if (isDomino)
	{
		if (orientation == GTK_ORIENTATION_HORIZONTAL)
		    wCorrected = w + 14;
		else
		    hCorrected = h + 14;
	}
	TQPixmap pixmap(wCorrected, hCorrected);
	TQPainter painter(&pixmap);

	TQStyle::SFlags sflags = stateToSFlags(state);
	if (orientation == GTK_ORIENTATION_HORIZONTAL)
		sflags |= TQStyle::Style_Horizontal;

	tqApp->style().drawPrimitive(TQStyle::PE_ScrollBarSlider, &painter, TQRect(0,0,wCorrected,hCorrected), tqApp->palette().active(), sflags);

	// The domino style doesn't draw the entire slider in PE_ScrollBarSlider
	// We have to draw PE_ScrollBarAddPage and PE_ScrollBarSubPage and piece the bits together
	if (isDomino && !mozillaFix && !eclipseFix)
	{
		TQPixmap leftPix, rightPix;
		TQRect leftRect, rightRect;
		if (orientation == GTK_ORIENTATION_HORIZONTAL)
		{
			leftRect = TQRect(0, 0, offset-scrollBarSpacingLeft, h);
			rightRect = TQRect(6, 0, totalExtent-offset-w-scrollBarSpacingRight+2, h);
			leftPix.resize(6 + leftRect.width(), h);
			rightPix.resize(6 + rightRect.width(), h);
		}
		else
		{
			leftRect = TQRect(0, 0, w, offset-scrollBarSpacingLeft);
			rightRect = TQRect(0, 6, w, totalExtent-offset-h-scrollBarSpacingRight+2);
			leftPix.resize(w, 6 + leftRect.height());
			rightPix.resize(w, 6 + rightRect.height());
		}

		TQPainter dominoPainter(&leftPix);
		tqApp->style().drawPrimitive(TQStyle::PE_ScrollBarSubPage, &dominoPainter, leftRect, tqApp->palette().active(), sflags);

		dominoPainter.end();
		dominoPainter.begin(&rightPix);
		tqApp->style().drawPrimitive(TQStyle::PE_ScrollBarAddPage, &dominoPainter, rightRect, tqApp->palette().active(), sflags);

		if (orientation == GTK_ORIENTATION_HORIZONTAL)
		{
			bitBlt(&pixmap, 1, 0, &leftPix, leftRect.width(), 0, 6, h, TQt::CopyROP, true);
			bitBlt(&pixmap, w-7, 0, &rightPix, 0, 0, 7, h, TQt::CopyROP, true);
		}
		else
		{
			bitBlt(&pixmap, 0, 1, &leftPix, 0, leftRect.height(), w, 6, TQt::CopyROP, true);
			bitBlt(&pixmap, 0, h-7, &rightPix, 0, 0, w, 7, TQt::CopyROP, true);
		}
	}

	GdkPixmap* pix = gdk_pixmap_foreign_new(pixmap.handle());

	if (isDomino)
	{
		int endsSkip = mozillaFix ? 7 : 1;
		if (orientation == GTK_ORIENTATION_HORIZONTAL)
			gdk_draw_drawable(window, style->bg_gc[state], pix, endsSkip, 0, x, y, w-1, h);
		else
			gdk_draw_drawable(window, style->bg_gc[state], pix, 0, endsSkip, x, y, w, h-1);
	}
	else
		gdk_draw_drawable(window, style->bg_gc[state], pix, 0, 0, x, y, w, h);
	g_object_unref(pix);
}

void drawScrollBar(GdkWindow* window, GtkStyle* style, GtkStateType state, int orientation, GtkAdjustment* adj, int x, int y, int w, int h)
{
	if (!gtkQtEnable)
		return;

	if ((w < 1) || (h < 1))
		return;

	if (scrollBar != 0)
		delete scrollBar;
	scrollBar = new TQScrollBar(NULL);

	scrollBar->resize(w,h);

	// Patch from Chad Kitching <chadk@cmanitoba.com>
	// Patch from Peter Hartshorn <peter@dimtech.com.au>

	// another check for mozilla is step_increment and page_increment
	// are set to zero for mozilla, and have values set by all other
	// gtk applications I've tested this with.

	// Why oh why couldn't mozilla use native widgets instead of
	// handling everything in cross platform.

	scrollBar->setOrientation(orientation ? TQt::Vertical : TQt::Horizontal);


	TQStyle::SFlags sflags = stateToSFlags(state);
	if (sflags |= TQStyle::Style_Down) sflags = TQStyle::Style_Enabled;
	if (orientation == GTK_ORIENTATION_HORIZONTAL) sflags |= TQStyle::Style_Horizontal;

	TQPixmap pixmap(w,h);

	scrollBar->setMinValue(0);
	scrollBar->setMaxValue(65535);
	scrollBar->setValue(32767);
	scrollBar->setPageStep(1);

	int offset = 0;
	int thumbSize = 0;


	if (orientation == GTK_ORIENTATION_VERTICAL) {
		TQRect r;
		r = tqApp->style().querySubControlMetrics(TQStyle::CC_ScrollBar,
				scrollBar, TQStyle::SC_ScrollBarSlider);
		offset = r.y();
		thumbSize = r.height();
                if (thumbSize < 0)
                  thumbSize = -thumbSize;

		if (!r.isValid()) // Fix a crash bug in Eclipse where it was trying to draw tiny scrollbars.
			return;

		TQPixmap tmpPixmap(w, h + thumbSize);
		TQPainter painter2(&tmpPixmap);
		scrollBar->resize(w, h + thumbSize);

		painter2.fillRect(0, 0, w, h + thumbSize,
				tqApp->palette().active().brush(TQColorGroup::Background));
		tqApp->style().drawComplexControl(TQStyle::CC_ScrollBar,
				&painter2, scrollBar, TQRect(0, 0, w, h+thumbSize),
				tqApp->palette().active(), sflags);

		bitBlt(&pixmap, 0, 0, &tmpPixmap, 0, 0, w, offset, TQt::CopyROP);
		bitBlt(&pixmap, 0, offset, &tmpPixmap, 0, offset + thumbSize,
				w, h - offset, TQt::CopyROP);
	} else {
		TQRect r;
		r = tqApp->style().querySubControlMetrics(TQStyle::CC_ScrollBar,
				scrollBar, TQStyle::SC_ScrollBarSlider);
		offset = r.x();
		thumbSize = r.width();
		if (thumbSize < 0)
		  thumbSize = -thumbSize;

		if (!r.isValid()) // Fix a crash bug in Eclipse when it was trying to draw tiny scrollbars.
			return;

		TQPixmap tmpPixmap(w + thumbSize, h);
		TQPainter painter2(&tmpPixmap);
		scrollBar->resize(w + thumbSize, h);

		painter2.fillRect(0, 0, w + thumbSize, h,
				tqApp->palette().active().brush(TQColorGroup::Background));
		tqApp->style().drawComplexControl(TQStyle::CC_ScrollBar,
				&painter2, scrollBar, TQRect(0, 0, w+thumbSize, h),
				tqApp->palette().active(), sflags);

		bitBlt(&pixmap, 0, 0, &tmpPixmap, 0, 0, offset, h, TQt::CopyROP);
		bitBlt(&pixmap, offset, 0, &tmpPixmap, offset + thumbSize, 0,
				w - offset, h, TQt::CopyROP);
	}

	GdkPixmap* pix = gdk_pixmap_foreign_new(pixmap.handle());
	gdk_draw_drawable(window, style->bg_gc[state], pix, 0, 0, x, y, w, h);
	g_object_unref(pix);
}

void drawToolButton(GdkWindow* window, GtkStyle* style, GtkStateType state, int x, int y, int w, int h)
{
	if (!gtkQtEnable)
		return;

	if ((w < 1) || (h < 1))
		return;

	TQToolButton button(NULL);
	button.resize(w, h);

	/*
	int realW = button.sizeHint().width();
	int realH = button.sizeHint().height();	 */

	TQStyle::SFlags sflags = stateToSFlags(state);
	TQStyle::SCFlags activeflags = TQStyle::SC_None;
	if (state == GTK_STATE_ACTIVE)
	{
		sflags |= TQStyle::Style_AutoRaise;
		activeflags = TQStyle::SC_ToolButton;
	}
	else
		sflags |= TQStyle::Style_AutoRaise | TQStyle::Style_Raised;

	TQPixmap pixmap(w,h);
	TQPainter painter(&pixmap);

	if ((backgroundTile) && (!backgroundTile->isNull()))
		painter.fillRect(0, 0, w, h, TQBrush(TQColor(255,255,255), *backgroundTile));
	else
		painter.fillRect(0, 0, w, h, tqApp->palette().active().brush(TQColorGroup::Background));
	tqApp->style().drawComplexControl(TQStyle::CC_ToolButton, &painter, &button, TQRect(0, 0, w, h), tqApp->palette().active(), sflags, TQStyle::SC_ToolButton, activeflags);

	GdkPixmap* pix = gdk_pixmap_foreign_new(pixmap.handle());
	gdk_draw_drawable(window, style->bg_gc[state], pix, 0, 0, x, y, w, h);
	g_object_unref(pix);
}

void drawMenuBarItem(GdkWindow* window, GtkStyle* style, GtkStateType state, int x, int y, int w, int h)
{
	if (!gtkQtEnable)
		return;

	if ((w < 1) || (h < 1))
		return;

	TQPixmap pixmap(w, h);
	TQPainter painter(&pixmap);
	TQMenuItem mi;
	TQMenuBar mb(0);

	TQStyle::SFlags sflags = TQStyle::Style_Down | TQStyle::Style_Enabled | TQStyle::Style_Active | TQStyle::Style_HasFocus;

	tqApp->style().drawControl(TQStyle::CE_MenuBarItem, &painter, &mb, TQRect(0, 0, w, h), tqApp->palette().active(), sflags, TQStyleOption(&mi));

	GdkPixmap* pix = gdk_pixmap_foreign_new(pixmap.handle());
	gdk_draw_drawable(window, style->bg_gc[state], pix, 0, 0, x, y, w, h);
	g_object_unref(pix);
}

void drawMenuItem(GdkWindow* window, GtkStyle* style, GtkStateType state, int x, int y, int w, int h)
{
	if (!gtkQtEnable)
		return;

	if ((w < 1) || (h < 1))
		return;

	TQPixmap pixmap(w,h);
	TQPainter painter(&pixmap);
	TQPopupMenu pm;
	TQMenuData md;
	TQMenuItem* mi = md.findItem(md.insertItem(""));

	TQStyleOption opt(mi, 16, 16);
	TQStyle::SFlags sflags = TQStyle::Style_Active | TQStyle::Style_Enabled;

	painter.fillRect(0, 0, w, h, tqApp->palette().active().brush(TQColorGroup::Background));
	tqApp->style().drawControl(TQStyle::CE_PopupMenuItem, &painter, &pm, TQRect(0,0,w,h), tqApp->palette().active(), sflags, opt);

	GdkPixmap* pix = gdk_pixmap_foreign_new(pixmap.handle());
	gdk_draw_drawable(window, style->bg_gc[state], pix, 0, 0, x, y, w, h);
	g_object_unref(pix);
}

void drawSplitter(GdkWindow* window, GtkStyle* style, GtkStateType state, int orientation, int x, int y, int w, int h)
{
	if (!gtkQtEnable)
		return;

	if ((w < 1) || (h < 1))
		return;

	TQPixmap pixmap(w,h);
	TQPainter painter(&pixmap);

	TQStyle::SFlags sflags = stateToSFlags(state);
	// No idea why this works...
	if (orientation != GTK_ORIENTATION_HORIZONTAL) sflags |= TQStyle::Style_Horizontal;

	painter.fillRect(0, 0, w, h, tqApp->palette().active().brush(TQColorGroup::Background));
	tqApp->style().drawPrimitive(TQStyle::PE_Splitter, &painter, TQRect(0,0,w,h), tqApp->palette().active(), sflags);

	GdkPixmap* pix = gdk_pixmap_foreign_new(pixmap.handle());
	gdk_draw_drawable(window, style->bg_gc[state], pix, 0, 0, x, y, w, h);
	g_object_unref(pix);
}

void drawTabFrame(GdkWindow* window, GtkStyle* style, GtkStateType state, int x, int y, int w, int h, GtkPositionType pos)
{
	if (!gtkQtEnable)
		return;

	if ((w < 1) || (h < 1))
		return;

	TQStyle::SFlags sflags = stateToSFlags(state);

	TQPixmap pixmap(w, h);
	TQPainter painter(&pixmap);
	TQStyleOption opt(2, 2); // line width

	if ((backgroundTile) && (!backgroundTile->isNull()))
		painter.fillRect(0, 0, w, h, TQBrush(TQColor(255,255,255), *backgroundTile));
	else
		painter.fillRect(0, 0, w, h, tqApp->palette().active().brush(TQColorGroup::Background));
	tqApp->style().drawPrimitive(TQStyle::PE_PanelTabWidget, &painter, TQRect(0,0,w,h), tqApp->palette().active(), sflags, opt);

	GdkPixmap* pix = gdk_pixmap_foreign_new(pixmap.handle());
	gdk_draw_drawable(window, style->bg_gc[state], pix, 0, 0, x, y, w, h);
	g_object_unref(pix);

	// Drawing tab base
        int th = tqApp->style().pixelMetric(TQStyle::PM_TabBarBaseHeight, meepTabBar);
	int tw = w;

	if ((tw < 1) || (th < 1))
		return;

        TQPixmap pixmap1(tw,th);
        TQPainter painter1(&pixmap1);
	if ((backgroundTile) && (!backgroundTile->isNull()))
		painter1.fillRect(0, 0, tw, th, TQBrush(TQColor(255,255,255), *backgroundTile));
	else
		painter1.fillRect(0, 0, tw, th, tqApp->palette().active().brush(TQColorGroup::Background));


        tqApp->style().drawPrimitive(TQStyle::PE_TabBarBase, &painter1, TQRect(0, 0, tw, th), tqApp->palette().active(), sflags, TQStyleOption(1,1));
	if (pos == GTK_POS_BOTTOM)
	{
		TQWMatrix m;
		m.scale(1, -1);
		pixmap1 = pixmap1.xForm(m);

		GdkPixmap* pix = gdk_pixmap_foreign_new(pixmap1.handle());
		gdk_draw_drawable(window, style->bg_gc[state], pix, 0, 0, x, y+h+tqApp->style().pixelMetric(TQStyle::PM_TabBarBaseOverlap, meepTabBar), tw, th);
		g_object_unref(pix);
	}
	else
	{
		GdkPixmap* pix = gdk_pixmap_foreign_new(pixmap1.handle());
		gdk_draw_drawable(window, style->bg_gc[state], pix, 0, 0, x, y-tqApp->style().pixelMetric(TQStyle::PM_TabBarBaseOverlap, meepTabBar), tw, th);
		g_object_unref(pix);
	}
}

void drawMenu(GdkWindow* window, GtkStyle* style, GtkStateType state, int x, int y, int w, int h)
{
	if (!gtkQtEnable)
		return;

	if ((w < 1) || (h < 1))
		return;

	TQPixmap pixmap(w, h);
	TQPainter painter(&pixmap);
	TQStyle::SFlags sflags = stateToSFlags(state);

	if ((backgroundTile) && (!backgroundTile->isNull()))
		painter.fillRect(0, 0, w, h, TQBrush(TQColor(255,255,255), *backgroundTile));
	else
		painter.fillRect(0, 0, w, h, tqApp->palette().active().brush(TQColorGroup::Background));
	tqApp->style().drawPrimitive(TQStyle::PE_PanelPopup, &painter, TQRect(0,0,w,h), tqApp->palette().active(), sflags);

	GdkPixmap* pix = gdk_pixmap_foreign_new(pixmap.handle());
	gdk_draw_drawable(window, style->bg_gc[state], pix, 0, 0, x, y, w, h);
	g_object_unref(pix);
}

// Note: In GTK, the drawing of a progress bar is in two parts:
// First the progress "container" is drawn
// Second the actually percent bar is drawn
// Mozilla requires this to be done in two steps as it first
// asks gtk to draw an EMPTY progress bar, then it asks to draw
// the contents, or percent bar, over the empty progress bar.
// So, although this function is not required for any gtk application
// except mozilla based apps, doing it this way is following the gtk
// theme structure more.
//
// See also drawScrollbar/drawScrollbarSlider pair.
//
// Peter Hartshorn (peter@dimtech.com.au)

void drawProgressChunk(GdkWindow * window, GtkStyle * style, GtkStateType state, int x, int y, int w, int h)
{
	// This is only for Mozilla/Firefox
	if (!mozillaFix || !gtkQtEnable)
		return;

	if ((w<=1) || (h<=1))
		return; // Trying to draw something that small caused a segfault

	// Dirty hack: When using the Alloy style, tweak the position and size of progress bar "filling"
	int w2 = isAlloy ? w+4 : w;
	int h2 = isAlloy ? h+4 : h;

	TQProgressBar bar(100, NULL);
	bar.resize(w2, h2);
	bar.setProgress(100);
	bar.setCenterIndicator(false);
	bar.setPercentageVisible(false);
	bar.setFrameStyle(TQFrame::NoFrame);

	if ((w2 < 1) || (h2 < 1))
		return;

	TQPixmap pixmap(w2, h2);
	TQPainter painter(&pixmap);

	TQStyle::SFlags sflags = stateToSFlags(state);

	painter.fillRect(0, 0, w, h, tqApp->palette().active().brush(TQColorGroup::Background));

	tqApp->style().drawControl(TQStyle::CE_ProgressBarContents, &painter, &bar, TQRect(0,0,w2,h2), tqApp->palette().active(), sflags);

	GdkPixmap* pix = gdk_pixmap_foreign_new(pixmap.handle());
	if (isAlloy)
		gdk_draw_drawable(window, style->bg_gc[state], pix, 4, 4, x+2, y+2, w-3, h-3);
	else
		gdk_draw_drawable(window, style->bg_gc[state], pix, 0, 0, x, y, w, h);
	g_object_unref(pix);
}

void drawProgressBar(GdkWindow * window, GtkStyle * style, GtkStateType state, GtkProgressBarOrientation orientation, gfloat percentage, int x, int y, int w, int h)
{
	if (!gtkQtEnable)
		return;

	if ((w<=1) || (h<=1))
		return; // Trying to draw something that small caused a segdault

	TQProgressBar bar(100, NULL);
	if ((orientation == GTK_PROGRESS_BOTTOM_TO_TOP) || (orientation == GTK_PROGRESS_TOP_TO_BOTTOM))
		bar.resize(h, w);
	else
		bar.resize(w, h);
	bar.setProgress((int)(percentage*100.0));
	bar.setCenterIndicator(false);
	bar.setPercentageVisible(false);

	TQPixmap pixmap = TQPixmap::grabWidget(&bar);

	TQWMatrix matrix;
	switch (orientation)
	{
		case GTK_PROGRESS_RIGHT_TO_LEFT: matrix.rotate(180); break;
		case GTK_PROGRESS_BOTTOM_TO_TOP: matrix.rotate(270);  break;
		case GTK_PROGRESS_TOP_TO_BOTTOM: matrix.rotate(90); break;
		default: break;
	}

	if (orientation != GTK_PROGRESS_LEFT_TO_RIGHT)
		pixmap = pixmap.xForm(matrix);

	GdkPixmap* pix = gdk_pixmap_foreign_new(pixmap.handle());
	gdk_draw_drawable(window, style->bg_gc[state], pix, 0, 0, x, y, w, h);
	g_object_unref(pix);
}

void drawSlider(GdkWindow * window, GtkStyle * style, GtkStateType state, GtkAdjustment *adj, int x, int y, int w, int h, GtkOrientation orientation, int inverted)
{
	if (!gtkQtEnable)
		return;

	meepSlider->setBackgroundOrigin(TQWidget::ParentOrigin);

	meepSlider->setOrientation((orientation == GTK_ORIENTATION_HORIZONTAL) ? TQt::Horizontal : TQt::Vertical);
	meepSlider->setEnabled(state != GTK_STATE_INSENSITIVE);

	meepSlider->setGeometry(x, y, w, h);
	meepSlider->setMinValue(0);
	meepSlider->setMaxValue(100);

	if (!inverted) // Normal sliders
		meepSlider->setValue((int)((adj->value-adj->lower)/(adj->upper-adj->lower)*100));
	else // Inverted sliders... where max is at the left/top and min is at the right/bottom
		meepSlider->setValue(100-(int)((adj->value-adj->lower)/(adj->upper-adj->lower)*100));

	TQPixmap pixmap = TQPixmap::grabWidget(meepSlider);
	GdkPixmap* pix = gdk_pixmap_foreign_new(pixmap.handle());
	gdk_draw_drawable(window, style->bg_gc[state], pix, 0, 0, x, y, w, h);
	g_object_unref(pix);
}

void drawSpinButton(GdkWindow * window, GtkStyle * style, GtkStateType state, int direction, int x, int y, int w, int h)
{
	if (!gtkQtEnable)
		return;

	if ((w < 1) || (h < 1))
		return;

	TQPixmap pixmap(w, h);
	TQPainter painter(&pixmap);

	TQStyle::SFlags sflags = stateToSFlags(state);

	painter.fillRect(0, 0, w, h, tqApp->palette().active().brush(TQColorGroup::Background));
	tqApp->style().drawPrimitive((direction ? TQStyle::PE_SpinWidgetDown : TQStyle::PE_SpinWidgetUp), &painter, TQRect(0,0,w,h), tqApp->palette().active(), sflags);

	GdkPixmap* pix = gdk_pixmap_foreign_new(pixmap.handle());
	gdk_draw_drawable(window, style->bg_gc[state], pix, 0, 0, x, y, w, h);
	g_object_unref(pix);
}

void drawListHeader(GdkWindow* window, GtkStyle* style, GtkStateType state, int x, int y, int w, int h)
{
	if (!gtkQtEnable)
		return;

	if ((w < 1) || (h < 1))
		return;

	TQPixmap pixmap(w,h);
	TQPainter painter(&pixmap);

	TQStyle::SFlags sflags = stateToSFlags(state) | TQStyle::Style_Horizontal;

	painter.fillRect(0, 0, w, h, tqApp->palette().active().brush(TQColorGroup::Background));
	tqApp->style().drawPrimitive(TQStyle::PE_HeaderSection, &painter, TQRect(0,0,w,h), tqApp->palette().active(), sflags);

	GdkPixmap* pix = gdk_pixmap_foreign_new(pixmap.handle());
	gdk_draw_drawable(window, style->bg_gc[state], pix, 0, 0, x, y, w, h);
	g_object_unref(pix);
}


void drawListViewItem(GdkWindow* window, GtkStyle* style, GtkStateType state, int x, int y, int w, int h)
{
        if (!gtkQtEnable)
                return;

	if ((w < 1) || (h < 1))
		return;

        TQPixmap     pixmap(w, h);
        TQPainter    painter(&pixmap);

	/* Get the brush corresponding to highlight color */
	TQBrush brush = tqApp->palette().brush(TQPalette::Active, TQColorGroup::Highlight);
	painter.setBrush(brush);
	painter.setPen(TQt::NoPen);
	painter.drawRect(0, 0, w, h);

	GdkPixmap* pix = gdk_pixmap_foreign_new(pixmap.handle());
	gdk_draw_drawable(window, style->bg_gc[state], pix, 0, 0, x, y, w, h);
	g_object_unref(pix);
}

void drawSquareButton(GdkWindow* window, GtkStyle* style, GtkStateType state, int x, int y, int w, int h)
{
	if (!gtkQtEnable)
		return;

	TQPixmap     pixmap(20, 20);
	TQPainter    painter(&pixmap);
	TQPushButton button(0);

	TQStyle::SFlags sflags = stateToSFlags(state);
	if (fillPixmap && (!fillPixmap->isNull()))
		painter.fillRect(0, 0, 20, 20, TQBrush(TQColor(255,255,255), *fillPixmap));
	else if ((backgroundTile) && (!backgroundTile->isNull()))
		painter.fillRect(0, 0, 20, 20, TQBrush(TQColor(255,255,255), *backgroundTile));
	else
		painter.fillRect(0, 0, 20, 20, tqApp->palette().active().brush(TQColorGroup::Background));

	tqApp->style().drawControl(TQStyle::CE_PushButton, &painter, &button,
					TQRect(0,0,20,20), tqApp->palette().active(), sflags);

	TQImage image = pixmap.convertToImage().smoothScale(w,h);

	GdkPixmap* pix = gdk_pixmap_foreign_new(pixmap.handle());
	gdk_draw_drawable(window, style->bg_gc[state], pix, 0, 0, x, y, w, h);
	g_object_unref(pix);
}

void initDrawTabNG(int count)
{
	if (!gtkQtEnable)
		return;

	delete meepTabBar;
	meepTabBar = 0;
	meepTabBar = new TQTabBar(meepWidget);

	for ( int i = 0; i < count; i++ )
		meepTabBar->addTab(new TQTab);

	return;
}

void drawTabNG(GdkWindow *window, GtkStyle* style, GtkStateType state, int x, int y, int w, int h, GtkNotebook *notebook)
{
	if (!gtkQtEnable)
		return;

	GtkPositionType tpos = gtk_notebook_get_tab_pos(notebook);

	// Find tab position
	int sdiff = 10000, pos = -1, diff = 1;
	for ( unsigned int i = 0; i < g_list_length(notebook->children); i++ )
	{
		GtkWidget *tab_label=gtk_notebook_get_tab_label(notebook,gtk_notebook_get_nth_page(notebook,i));
		if (tab_label) diff = tab_label->allocation.x - x;
		if ((diff > 0) && (diff < sdiff))
		{
			sdiff = diff; pos = i;
		}
	}

	TQTab *tab = meepTabBar->tabAt(pos);

	if (!tab)
	{
		// This happens in Firefox.  Just draw a normal tab instead
		if (state == GTK_STATE_ACTIVE)
			drawTab(window, style, state, x, y - 2, w, h + 2);
		else
			drawTab(window, style, state, x, y, w, h);
		return;
	}

	TQStyle::SFlags sflags = stateToSFlags(state);

	if (state != GTK_STATE_ACTIVE)
	{
		sflags = TQStyle::Style_Selected;
		if (tpos == GTK_POS_TOP)
			y += 3;
		h -= 3;
	}

	if ((w < 1) || (h < 1))
		return;

	TQPixmap pixmap(w,h);
	TQPainter painter(&pixmap);

	if ((backgroundTile) && (!backgroundTile->isNull()))
		painter.fillRect(0, 0, w, h, TQBrush(TQColor(255,255,255), *backgroundTile));
	else

	painter.fillRect(0, 0, w, h, tqApp->palette().active().brush(TQColorGroup::Background));
	tqApp->style().drawControl(TQStyle::CE_TabBarTab, &painter, (TQTabBar *)meepTabBar, TQRect(0,0,w,h), tqApp->palette().active(), sflags, TQStyleOption(tab));

	painter.end(); // So the pixmap assignment below won't give an error
	// Account for tab position -- if its in the bottom flip the image
	if (tpos == GTK_POS_BOTTOM)
	{
		TQWMatrix m;
		m.scale(1, -1);
		pixmap = pixmap.xForm(m);
	}

	GdkPixmap* pix = gdk_pixmap_foreign_new(pixmap.handle());
	gdk_draw_drawable(window, style->bg_gc[state], pix, 0, 0, x, y, w, h);
	g_object_unref(pix);
}

void drawArrow(GdkWindow* window, GtkStyle* style, GtkStateType state, GtkArrowType direction, int x, int y, int w, int h)
{
	if (!gtkQtEnable)
		return;

	if ((w < 1) || (h < 1))
		return;

	TQStyle::SFlags sflags = stateToSFlags(state);
	if (state == GTK_STATE_INSENSITIVE)
		sflags |= TQStyle::Style_Off;
	else if (state == GTK_STATE_PRELIGHT)
		sflags |= TQStyle::Style_On;

	TQStyle::PrimitiveElement element;
	switch(direction)
	{
		case GTK_ARROW_UP:    element = TQStyle::PE_ArrowUp;    break;
		case GTK_ARROW_DOWN:  element = TQStyle::PE_ArrowDown;  break;
		case GTK_ARROW_LEFT:  element = TQStyle::PE_ArrowLeft;  break;
		case GTK_ARROW_RIGHT: element = TQStyle::PE_ArrowRight; break;
		case GTK_ARROW_NONE:  return;
		default:              return;
	}


	TQPixmap pixmap(w,h);
	TQPainter painter(&pixmap);

	if (fillPixmap && (!fillPixmap->isNull()))
		painter.fillRect(0, 0, w, h, TQBrush(TQColor(255,255,255), *fillPixmap));
	else if ((backgroundTile) && (!backgroundTile->isNull()))
		painter.fillRect(0, 0, w, h, TQBrush(TQColor(255,255,255), *backgroundTile));
	else
		painter.fillRect(0, 0, w, h, tqApp->palette().active().brush(TQColorGroup::Background));

	tqApp->style().drawPrimitive(element, &painter, TQRect(0,0,w,h), tqApp->palette().active(), sflags);

	GdkPixmap* pix = gdk_pixmap_foreign_new(pixmap.handle());
	gdk_draw_drawable(window, style->bg_gc[state], pix, 0, 0, x, y, w, h);
	g_object_unref(pix);
}

void drawFocusRect(GdkWindow * window, GtkStyle * style, int x, int y, int w, int h)
{
//	if (!gtkQtEnable)
		return;

	if ((w < 1) || (h < 1))
		return;

	TQPixmap pixmap(w,h);
	TQPainter painter(&pixmap);
	TQColor bg(tqApp->palette().active().background());

	painter.fillRect(0,0,w,h,bg);
	tqApp->style().drawPrimitive(TQStyle::PE_FocusRect, &painter, TQRect(0,0,w,h), tqApp->palette().active(), TQStyle::Style_Default, TQStyleOption(bg));

	GdkPixmap* pix = gdk_pixmap_foreign_new(pixmap.handle());
	gdk_draw_drawable(window, style->bg_gc[GTK_STATE_NORMAL], pix, 0, 0, x, y, w, h);
	g_object_unref(pix);
}

GdkGC* alternateBackgroundGc(GtkStyle* style)
{
	// Alternate background color for listviews
	if (altBackGC != 0)
		return altBackGC;

	GdkColor altBackColor;
	altBackColor.red = alternateBackgroundColour.red() * 257;
	altBackColor.green = alternateBackgroundColour.green() * 257;
	altBackColor.blue = alternateBackgroundColour.blue() * 257;

	gdk_colormap_alloc_color(style->colormap, &altBackColor, FALSE, TRUE);

	GdkGCValues gc_values;
	GdkGCValuesMask gc_values_mask;
	gc_values_mask = GDK_GC_FOREGROUND;
	gc_values.foreground = altBackColor;

	altBackGC = (GdkGC*) gtk_gc_get (style->depth, style->colormap, &gc_values, gc_values_mask);

	return altBackGC;
}


// Thanks Martin Dvorak of metatheme
TQString parse_rc_string(const TQString& defs, const TQString& pattern, bool widgetClass = true)
{
	static int dynamic_counter = 0;
	++dynamic_counter;

	return "style \"gtk-qt-dynamic-" + TQString::number(dynamic_counter) + "\" { " + defs + " } " + (widgetClass ? "widget_class" : "widget") + " \"" + pattern + "\" style \"gtk-qt-dynamic-" + TQString::number(dynamic_counter) + "\"\n";
}

TQString doIconMapping(const TQString& stockName, const TQString& path, int sizes)
{
	TQString fullPath;
	bool has16 = false, has22 = false, has32 = false;

	for( TQStringList::ConstIterator it = iconThemeDirs.begin();
			it != iconThemeDirs.end();
			++it )
	{
		fullPath = *it + "16x16/" + path;
		if (access(fullPath.latin1(), R_OK) == 0)
			has16 = true;
		fullPath = *it + "22x22/" + path;
		if (access(fullPath.latin1(), R_OK) == 0)
			has22 = true;
		fullPath = *it + "32x32/" + path;
		if (access(fullPath.latin1(), R_OK) == 0)
			has32 = true;
	}

	if (!has16 && !has22 && !has32) return "";

	// sizes is an addition of 1=16, 2=22 and 4=32
	TQString ret = "stock[\"" + stockName + "\"]={\n";

	if (has22)
		ret += "\t{ \"22x22/" + path +"\", *, *, \"gtk-large-toolbar\" },\n";

	if (has32)
	{
		ret += "\t{ \"32x32/" + path +"\", *, *, \"gtk-dnd\" },\n";
		ret += "\t{ \"32x32/" + path +"\", *, *, \"gtk-dialog\" },\n";
	}

	if (has16)
	{
		ret += "\t{ \"16x16/" + path +"\", *, *, \"gtk-button\" },\n";
		ret += "\t{ \"16x16/" + path +"\", *, *, \"gtk-menu\" },\n";
		ret += "\t{ \"16x16/" + path +"\", *, *, \"gtk-small-toolbar\" },\n";
	}

	if (has22)
		ret += "\t{ \"22x22/" + path +"\" }\n";
	else if (has32)
		ret += "\t{ \"32x32/" + path +"\" }\n";
	else
		ret += "\t{ \"16x16/" + path +"\" }\n";

	ret += "}\n";
	return ret;
}

TQString colorString(TQColor color)
{
	TQString ret = "{";
	ret += TQString::number(color.red() * 257) + ", ";
	ret += TQString::number(color.green() * 257) + ", ";
	ret += TQString::number(color.blue() * 257) + "}";

	return ret;
}

void setColour(TQString name, TQColor color)
{
	gtk_rc_parse_string(parse_rc_string(name + " = " + colorString(color), "*").latin1());
}

static TQStringList iconInheritsDirs( const TQString& icondir )
{
	TQFile index;
	index.setName( icondir + "index.theme" );
	if( !index.open( IO_ReadOnly ))
	{
		index.setName( icondir + "index.desktop" );
		if( !index.open( IO_ReadOnly ))
			return TQStringList();
	}
	char buf[ 1024 ];
	TQRegExp reg( "^\\s*Inherits=([^\\n]*)" );
	for(;;)
	{
		if( index.readLine( buf, 1023 ) <= 0 )
			break;
		if( reg.search( buf, 0 ) >= 0 )
			return TQStringList::split(",", reg.cap(1));
	}
	return TQStringList();
}

void setRcProperties(GtkRcStyle* rc_style, int forceRecreate)
{
	if (!gtkQtEnable)
		return;

	if (gtkQtDebug)
		printf("setRcProperties()\n");

	gtkRcStyle = rc_style;

	// Set colors
	// Normal
	setColour("fg[NORMAL]",     tqApp->palette().active().text());
	setColour("bg[NORMAL]",     tqApp->palette().active().background());
	setColour("text[NORMAL]",   tqApp->palette().active().text());
	setColour("base[NORMAL]",   tqApp->palette().active().base());

	// Active (on)
	setColour("fg[ACTIVE]",     tqApp->palette().active().text());
	setColour("bg[ACTIVE]",     tqApp->palette().active().background());
	setColour("text[ACTIVE]",   tqApp->palette().active().text());
	setColour("base[ACTIVE]",   tqApp->palette().active().base());

	// Mouseover
	setColour("fg[PRELIGHT]",   tqApp->palette().active().text()); // menu items - change?
	setColour("bg[PRELIGHT]",   tqApp->palette().active().highlight());
	setColour("text[PRELIGHT]", tqApp->palette().active().text());
	setColour("base[PRELIGHT]", tqApp->palette().active().base());

	// Selected
	setColour("fg[SELECTED]",   tqApp->palette().active().highlightedText());
	setColour("bg[SELECTED]",   tqApp->palette().active().highlight());
	setColour("text[SELECTED]", tqApp->palette().active().highlightedText());
	setColour("base[SELECTED]", tqApp->palette().active().highlight());

	// Disabled
	setColour("fg[INSENSITIVE]",    tqApp->palette().disabled().text());
	setColour("bg[INSENSITIVE]",    tqApp->palette().disabled().background());
	setColour("text[INSENSITIVE]",  tqApp->palette().disabled().text());
	setColour("base[INSENSITIVE]",  tqApp->palette().disabled().background());

	gtk_rc_parse_string(("gtk-button-images = " + TQString::number(showIconsOnButtons)).latin1());

	gtk_rc_parse_string(("gtk-toolbar-style = " + TQString::number(toolbarStyle)).latin1());

	// This function takes quite a long time to execute, and is run at the start of every app.
	// In order to speed it up, we can store the results in a file, along with the name of icon
	// theme and style.  This file can then be regenerated when the icon theme or style change.

	TQString cacheFilePath = TDEGlobal::dirs()->saveLocation("cache")+"/gtk_qt_engine_rc";
	TQFile cacheFile(cacheFilePath);
	TQTextStream stream;

	if (!forceRecreate && cacheFile.exists())
	{
		cacheFile.open(IO_ReadOnly);
		stream.setDevice(&cacheFile);

		if (stream.readLine() == "# " + iconTheme + ", " + tqApp->style().name() + ", " + RC_CACHE_VERSION)
		{
			// This cache matches the current icon theme and style
			// Let's load it and return
			gtk_rc_add_default_file(cacheFilePath.latin1());
			return;
		}

		stream.unsetDevice();
		cacheFile.close();
	}

	cacheFile.open(IO_WriteOnly | IO_Truncate);
	stream.setDevice(&cacheFile);

	stream << "# " << iconTheme << ", " << tqApp->style().name() << ", " << RC_CACHE_VERSION << "\n\n";
	stream << "# This file was generated by the Gtk Qt Theme Engine\n";
	stream << "# It will be recreated when you change your KDE icon theme or widget style\n\n";

	TQScrollBar sbar(NULL);
	sbar.setOrientation(TQt::Horizontal);
	sbar.setValue(1);
	sbar.resize(200,25);

	// The following code determines how many buttons are on a scrollbar
	// It works by looking at each pixel of the scrollbar's area not taken up by the groove,
	// and asking the style which subcontrol is at that location.
	TQRect rect = tqApp->style().querySubControlMetrics(TQStyle::CC_ScrollBar, &sbar, TQStyle::SC_ScrollBarGroove);

	bool back1 = false;
	bool forward1 = false;
	bool back2 = false;
	bool forward2 = false;

	TQStyle::SubControl sc = TQStyle::SC_None;
	for (TQPoint pos(0,7) ; pos.x()<rect.x() ; pos.setX(pos.x()+1))
	{
		TQStyle::SubControl sc2 = tqApp->style().querySubControl(TQStyle::CC_ScrollBar, &sbar, pos);
		if (sc != sc2)
		{
			if (sc2 == TQStyle::SC_ScrollBarAddLine) forward1 = true;
			if (sc2 == TQStyle::SC_ScrollBarSubLine) back1 = true;
			sc = sc2;
		}
	}
	sc = TQStyle::SC_None;
	for (TQPoint pos(rect.x()+rect.width(),7) ; pos.x()<200 ; pos.setX(pos.x()+1))
	{
		TQStyle::SubControl sc2 = tqApp->style().querySubControl(TQStyle::CC_ScrollBar, &sbar, pos);
		if (sc != sc2)
		{
			if (sc2 == TQStyle::SC_ScrollBarAddLine) forward2 = true;
			if (sc2 == TQStyle::SC_ScrollBarSubLine) back2 = true;
			sc = sc2;
		}
	}

	stream << parse_rc_string(TQString("GtkComboBox::appears-as-list = 1"), "*");

	stream << parse_rc_string(TQString("GtkScrollbar::has-backward-stepper = ") + (back1 ? "1" : "0"), "*");
	stream << parse_rc_string(TQString("GtkScrollbar::has-forward-stepper = ") + (forward2 ? "1" : "0"), "*");
	stream << parse_rc_string(TQString("GtkScrollbar::has-secondary-forward-stepper = ") + (forward1 ? "1" : "0"), "*");
	stream << parse_rc_string(TQString("GtkScrollbar::has-secondary-backward-stepper = ") + (back2 ? "1" : "0"), "*");

	stream << parse_rc_string("GtkScrollbar::stepper-size = " + TQString::number(tqApp->style().querySubControlMetrics(TQStyle::CC_ScrollBar, &sbar, TQStyle::SC_ScrollBarSubLine).width() - 1), "*");

	stream << parse_rc_string("GtkScrollbar::min-slider-length = " + TQString::number(tqApp->style().pixelMetric(TQStyle::PM_ScrollBarSliderMin)), "*");
	stream << parse_rc_string("GtkScrollbar::slider-width = " + TQString::number(tqApp->style().pixelMetric(TQStyle::PM_ScrollBarExtent)), "*");

	stream << parse_rc_string("GtkButton::child-displacement-x = " + TQString::number(tqApp->style().pixelMetric(TQStyle::PM_ButtonShiftHorizontal)), "*");
	stream << parse_rc_string("GtkButton::child-displacement-y = " + TQString::number(tqApp->style().pixelMetric(TQStyle::PM_ButtonShiftVertical)), "*");
	stream << parse_rc_string("GtkButton::default-border = { 0, 0, 0, 0 }", "*");
	stream << parse_rc_string("GtkButton::default-outside-border = {0, 0, 0, 0}", "*");
#ifdef USE_NATIVE_GTK_BUTTON_DRAWING
	stream << parse_rc_string("GtkButton::inner-border = {2, 2, 2, 2}", "*");
#else
	if (tde_showIconsOnPushButtons) {
		stream << parse_rc_string("GtkButton::inner-border = {10, 10, 2, 2}", "*");	// Allow space for the icon on either side of the text
	}
	else {
		stream << parse_rc_string("GtkButton::inner-border = {2, 2, 2, 2}", "*");
	}
#endif

	stream << parse_rc_string("GtkButtonBox::child_min_height     = 0", "*");
	stream << parse_rc_string("GtkButtonBox::child_internal_pad_x = 0", "*");
	stream << parse_rc_string("GtkButtonBox::child_internal_pad_y = 0", "*");

	TQSlider slider(NULL); // To keep BlueCurve happy
	stream << parse_rc_string("GtkScale::slider-length = " + TQString::number(tqApp->style().pixelMetric(TQStyle::PM_SliderLength, &slider)), "*");

	stream << parse_rc_string("xthickness = " + TQString::number(tqApp->style().pixelMetric(TQStyle::PM_DefaultFrameWidth)), "*.GtkMenu");
	stream << parse_rc_string("ythickness = " + TQString::number(tqApp->style().pixelMetric(TQStyle::PM_DefaultFrameWidth)), "*.GtkMenu");
	stream << parse_rc_string("xthickness = 5", "*.GtkMenu.Gtk*MenuItem");
	stream << parse_rc_string("xthickness = 3", "*.GtkNotebook");
	stream << parse_rc_string("ythickness = 3", "*.GtkNotebook");
	stream << parse_rc_string("ythickness = 1", "*.GtkButton");
	stream << parse_rc_string("fg[NORMAL] = {0, 0, 0}", "gtk-tooltips.GtkLabel", false);

	stream << parse_rc_string("xthickness = 1", "*.GtkButton.*");
	stream << parse_rc_string("ythickness = 1", "*.GtkButton.*");

//	stream << parse_rc_string("GtkTreeView::allow-rules = 0", "*");
//	stream << parse_rc_string("GtkTreeView::tree-line-width = 1", "*");
//	stream << parse_rc_string("GtkTreeView::vertical-separator = 30", "*");
//	//stream << parse_rc_string("GtkTreeView::odd-row-color = { 0.0, 0.0, 0.0 }", "*");

	stream << parse_rc_string("GtkButton::inner-border = {0, 0, 0, 0}", "*GtkToolbar*GtkButton*");
	stream << parse_rc_string("GtkButton::inner-border = {0, 0, 0, 0}", "*GtkToolbar*GtkToggleButton*");
	stream << parse_rc_string("GtkButton::inner-border = {0, 0, 0, 0}", "*GtkNotebook*GtkButton*");
	stream << parse_rc_string("GtkButton::inner-border = {0, 0, 0, 0}", "*GtkNotebook*GtkToggleButton*");

	// TQt calls them tab boxes, GTK calls them notebooks (!??!?)  Either way they are a pain...
	stream << parse_rc_string("GtkNotebook::tab-overlap = " + TQString::number(tqApp->style().pixelMetric(TQStyle::PM_TabBarTabOverlap)), "*");

	// This one may not work...
	//insertIntProperty(rc_style, "GtkCheckButton", "indicator-size", tqApp->style().pixelMetric(TQStyle::PM_IndicatorHeight) );

	// For icons

	// Build the list of icon theme directories.
	// This function is recursive - it gets the directories of all the inherited themes as well
	addIconThemeDir(iconTheme);

	if (iconThemeDirs.isEmpty())
	{
		cacheFile.close();
		gtk_rc_add_default_file(cacheFilePath.latin1());
		return;
	}

	stream << "\npixmap_path \"" + iconThemeDirs.join( ":" ) + "\"\n\n";

	stream << "style \"KDE-icons\" {\n";
        stream << doIconMapping("gtk-about", "actions/about_kde.png");
        stream << doIconMapping("gtk-add", "actions/add.png");
        stream << doIconMapping("gtk-apply", "actions/apply.png");
	stream << doIconMapping("gtk-bold", "actions/text_bold.png");
	stream << doIconMapping("gtk-cancel", "actions/button_cancel.png");
	stream << doIconMapping("gtk-cdrom", "devices/cdrom_unmount.png");
	stream << doIconMapping("gtk-clear", "actions/editclear.png");
	stream << doIconMapping("gtk-close", "actions/fileclose.png");
	stream << doIconMapping("gtk-color-picker", "actions/colorpicker.png", 3);
	stream << doIconMapping("gtk-copy", "actions/editcopy.png");
	stream << doIconMapping("gtk-convert", "actions/gtk-convert.png");
	stream << doIconMapping("gtk-connect", "actions/connect_creating.png");
	stream << doIconMapping("gtk-cut", "actions/editcut.png");
	stream << doIconMapping("gtk-delete", "actions/editdelete.png");
	stream << doIconMapping("gtk-dialog-authentication", "status/gtk-dialog-authentication");
	stream << doIconMapping("gtk-dialog-error", "actions/messagebox_critical.png", 4);
	stream << doIconMapping("gtk-dialog-info", "actions/messagebox_info.png", 4);
	stream << doIconMapping("gtk-dialog-question", "actions/help.png");
	stream << doIconMapping("gtk-dialog-warning", "actions/messagebox_warning.png", 4);
	stream << doIconMapping("gtk-directory", "filesystems/folder.png");
	stream << doIconMapping("gtk-disconnect", "actions/connect_no.png");
	stream << doIconMapping("gtk-dnd", "mimetypes/empty.png");
	stream << doIconMapping("gtk-dnd-multiple", "mimetypes/tdemultiple.png");
	stream << doIconMapping("gtk-edit", "actions/edit.png");  //2.6
	stream << doIconMapping("gtk-execute", "actions/exec.png");
	stream << doIconMapping("gtk-file", "mimetypes/empty.png");
	stream << doIconMapping("gtk-find", "actions/find.png");
	stream << doIconMapping("gtk-find-and-replace", "actions/find.png");	// Is there a TDE "find and replace" icon? FIXME
	stream << doIconMapping("gtk-floppy", "devices/3floppy_unmount.png");
	stream << doIconMapping("gtk-fullscreen", "actions/window-fullscreen.png");
	stream << doIconMapping("gtk-goto-bottom", "actions/bottom.png");
	stream << doIconMapping("gtk-goto-first", "actions/start.png");
	stream << doIconMapping("gtk-goto-last", "actions/finish.png");
	stream << doIconMapping("gtk-goto-top", "actions/top.png");
	stream << doIconMapping("gtk-go-back", "actions/back.png");
	stream << doIconMapping("gtk-go-down", "actions/down.png");
	stream << doIconMapping("gtk-go-forward", "actions/forward.png");
	stream << doIconMapping("gtk-go-up", "actions/up.png");
	stream << doIconMapping("gtk-harddisk", "devices/hdd_unmount.png");
	stream << doIconMapping("gtk-help", "apps/khelpcenter.png");
	stream << doIconMapping("gtk-home", "filesystems/folder_home.png");
	stream << doIconMapping("gtk-indent", "actions/indent.png");
	stream << doIconMapping("gtk-index", "actions/contents.png");
	stream << doIconMapping("gtk-info", "actions/messagebox_info.png");
	stream << doIconMapping("gtk-italic", "actions/text_italic.png");
	stream << doIconMapping("gtk-jump-to", "actions/goto.png");
	stream << doIconMapping("gtk-justify-center", "actions/text_center.png");
	stream << doIconMapping("gtk-justify-fill", "actions/text_block.png");
	stream << doIconMapping("gtk-justify-left", "actions/text_left.png");
	stream << doIconMapping("gtk-justify-right", "actions/text_right.png");
	stream << doIconMapping("gtk-leave-fullscreen", "actions/window-nofullscreen.png");
	stream << doIconMapping("gtk-media-forward", "player-fwd.png");
	stream << doIconMapping("gtk-media-next", "actions/player-end.png");
	stream << doIconMapping("gtk-media-pause", "actions/player-pause.png");
	stream << doIconMapping("gtk-media-previous", "actions/player-start.png");
	stream << doIconMapping("gtk-media-record", "actions/gtk-media-record.png");	// FIXME
	stream << doIconMapping("gtk-media-rewind", "actions/player-rew.png");
	stream << doIconMapping("gtk-media-stop", "actions/player-stop.png");
	stream << doIconMapping("gtk-missing-image", "mimetypes/unknown.png");
	stream << doIconMapping("gtk-network", "filesystems/network.png");
	stream << doIconMapping("gtk-new", "actions/filenew.png");
	stream << doIconMapping("gtk-no", "actions/gtk-no.png");
	stream << doIconMapping("gtk-ok", "actions/button_ok.png");
	stream << doIconMapping("gtk-open", "actions/fileopen.png");
	//stream << doIconMapping("gtk-orientation-landscape", "??");			// FIXME
	//stream << doIconMapping("gtk-orientation-portrait", "??");			// FIXME
	//stream << doIconMapping("gtk-orientation-reverse-landscape", "??");		// FIXME
	//stream << doIconMapping("gtk-orientation-reverse-portrait", "??");		// FIXME
	stream << doIconMapping("gtk-paste", "actions/editpaste.png");
	stream << doIconMapping("gtk-preferences", "actions/configure.png");
	stream << doIconMapping("gtk-print", "actions/fileprint.png");
	stream << doIconMapping("gtk-print-preview", "actions/filequickprint.png");
	stream << doIconMapping("gtk-properties", "actions/configure.png");
	stream << doIconMapping("gtk-quit", "actions/exit.png");
	stream << doIconMapping("gtk-redo", "actions/redo.png");
	stream << doIconMapping("gtk-refresh", "actions/reload.png");
	stream << doIconMapping("gtk-remove", "actions/remove.png");
	stream << doIconMapping("gtk-revert-to-saved", "actions/revert.png");
	stream << doIconMapping("gtk-save", "actions/filesave.png");
	stream << doIconMapping("gtk-save-as", "actions/filesaveas.png");
	stream << doIconMapping("gtk-select-all", "actions/gtk-select-all.png");	// FIXME
	stream << doIconMapping("gtk-select-color", "actions/colorize.png");
	stream << doIconMapping("gtk-select-font", "mimetypes/font.png");
	//stream << doIconMapping("gtk-sort-ascending", "??");				// FIXME
	//stream << doIconMapping("gtk-sort-descending", "??");				// FIXME
	stream << doIconMapping("gtk-spell-check", "actions/spellcheck.png");
	stream << doIconMapping("gtk-stop", "actions/stop.png");
	stream << doIconMapping("gtk-strikethrough", "actions/text_strike.png", 3);
	stream << doIconMapping("gtk-undelete", "actions/gtk-undelete.png");		// FIXME
	stream << doIconMapping("gtk-underline", "actions/text_under.png");
	stream << doIconMapping("gtk-undo", "actions/undo.png");
	stream << doIconMapping("gtk-unindent", "actions/unindent.png");
	stream << doIconMapping("gtk-yes", "actions/button_ok.png");			// Verify mapping here
	stream << doIconMapping("gtk-zoom-100", "actions/viewmag1.png");
	stream << doIconMapping("gtk-zoom-fit", "actions/viewmagfit.png");
	stream << doIconMapping("gtk-zoom-in", "actions/viewmag+.png");
	stream << doIconMapping("gtk-zoom-out", "actions/viewmag-.png");

	// Other icons that really should have Trinity equivalents in tdelibs
	stream << doIconMapping("list-add", "actions/add.png");
	stream << doIconMapping("list-remove", "actions/remove.png");

	stream << "} class \"*\" style \"KDE-icons\"";

	cacheFile.close();

	gtk_rc_add_default_file(cacheFilePath.latin1());
}

void addIconThemeDir(const TQString& theme)
{
	// Try to find this theme's directory
	TQString icondir = kdeFindDir("/share/icons/" + theme + "/", "index.theme", "index.desktop");
	if(icondir.isEmpty())
		return;
	if (iconThemeDirs.contains(icondir))
		return;

	// Add this theme to the list
	iconThemeDirs.append(icondir);

	// Do it again for any parent themes
	TQStringList parents = iconInheritsDirs(icondir);
	for ( TQStringList::Iterator it=parents.begin() ; it!=parents.end(); ++it)
		addIconThemeDir((*it).stripWhiteSpace());
}

void setMenuBackground(GtkStyle* style)
{
	if (!gtkQtEnable)
		return;

	if (menuBackgroundPixmap == NULL)
	{
		// Get the menu background image
		menuBackgroundPixmap = new TQPixmap(1024, 25); // Meh
		TQPainter painter(menuBackgroundPixmap);
		TQPopupMenu pm;
		TQMenuData md;
		TQMenuItem* mi = md.findItem(md.insertItem(""));

		tqApp->style().polish(&pm);

		TQStyleOption opt(mi, 16, 16);
		TQStyle::SFlags sflags = TQStyle::Style_Default;

		if ((backgroundTile) && (!backgroundTile->isNull()))
			painter.fillRect(0, 0, 1024, 25, TQBrush(TQColor(255,255,255), *backgroundTile));
		else
			painter.fillRect(0, 0, 1024, 25, tqApp->palette().active().brush(TQColorGroup::Background));
		tqApp->style().drawControl(TQStyle::CE_PopupMenuItem, &painter, &pm, TQRect(0,0,1024,25), tqApp->palette().active(), sflags, opt);

		menuBackgroundPixmapGdk = gdk_pixmap_foreign_new(menuBackgroundPixmap->handle());
	}

	TQTENGINE_STYLE(style)->menuBackground = menuBackgroundPixmapGdk;
	g_object_ref(menuBackgroundPixmapGdk);
}

// It has a 'u' damnit
void setColour(GdkColor* g, TQColor q)
{
	g->red = q.red() * 257;
	g->green = q.green() * 257;
	g->blue = q.blue() * 257;
}

void setColors(GtkStyle* style)
{
	if (!gtkQtEnable)
		return;

	if (gtkQtDebug)
		printf("setColors()\n");

	/*gtkStyle = style;*/

	bool useBg = ((backgroundTile) && (!backgroundTile->isNull()));

	if (useBg)
	{
		style->bg_pixmap[GTK_STATE_NORMAL] = backgroundTileGdk;
		g_object_ref(backgroundTileGdk);
	}

	setMenuBackground(style);
}

void getTextColor(GdkColor *color, GtkStateType state_type)
{
	if (!gtkQtEnable)
		return;

	if ((state_type == GTK_STATE_PRELIGHT) || (state_type == GTK_STATE_ACTIVE) || (state_type == GTK_STATE_SELECTED))
		setColour(color, tqApp->palette().active().highlightedText());
	else if (state_type == GTK_STATE_NORMAL)
		setColour(color, tqApp->palette().active().text());
	else if (state_type == GTK_STATE_INSENSITIVE)
		setColour(color, tqApp->palette().disabled().text());
}
