/***************************************************************************
*   Copyright (C) 2004 by Christoph Thielecke                             *
*   crissi99@gmx.de                                                       *
*                                                                         *
*   Contains parts of code from klcc project                              *
*   (Peter Simonsson <psn@linux.se>).                                      *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
//BEGIN #includes
#ifndef __KVPNC_H__
#define __KVPNC_H__

#include <tqwidget.h>
#include <tqstrlist.h>
#include <tqpixmap.h>
#include <tqtimer.h>
#include <tqfile.h>
#include <tqdatetime.h>
#include <tqptrlist.h>
#include <tqlabel.h>
#include <tqtextstream.h>
#include <tqpixmap.h>
#include <tqpoint.h>
#include <tqsize.h>
#include <tqpopupmenu.h>
#include <tdeapplication.h>
#include <tdemainwindow.h>
#include <tdeaction.h>
#include <kprocess.h>
#include <kwizard.h>
#include <kprocess.h>
#include <knotifyclient.h>
#include <knotifydialog.h>
#include <kfeedback.h>
#include <dcopobject.h>
#include "kvpnckicker.h"
#include "preferencesdialog.h"
#include "mainview.h"
#include "vpnaccountdata.h"
#include "networkinterface.h"
#include "kvpncconfig.h"
#include "toolinfo.h"
#include "openvpnmanagementhandler.h"

// ID for statusbar
#define ID_STATUS_MSG 1
#define ID_CONNECTION_MSG 2
#define ID_FLASH_MSG 3
//END #includes



/**
* main class of kvpnc
* @author Christoph Thielecke
*/
class KVpnc : public TDEMainWindow , DCOPObject
{
	TQ_OBJECT
  
	K_DCOP
public:
	/**
	* Konstruktor
	* @param parent Parent widget
	* @param name Name of the Mainwindow
	*/
	KVpnc( TDEApplication *parent, TQWidget *qparent = 0, const char *name = 0 );

	/**
	* Destruktor
	*/
	~KVpnc();
protected:
	/**
	* init the actions
	*/
	void initAction();

	/**
	* init the main view
	*/
	void initView();

	/**
	* init the statusbar
	*/
	void initStatusbar();

	/**
	* init the kicker system tray icon
	*/
	void initDockWindow();

	/**
	* sets the gui status
	* @param status The status that will be set
	*/
	void setGuiStatus( int status );

	/**
	* terminates the connection
	* @param proc the connect process
	*/
	void terminateConnection ( TQProcess *proc );
	/**
	* called when quit requested
	*/
	virtual bool queryExit();

	void saveProperties( TDEConfig* );
	void readProperties( TDEConfig* );

public:
	void restore(TDEConfig *config, int i);
	void restore();

	/**
	* return the user id of the certificate
	*	@param Cert certificate from wich should be extracted
	* @param user true if user id, false if issuer id
	*/
	TQString getX509CertificateID( TQString Cert, bool user );

	void profileAddedOrDeleted();
	bool setVirtualIP();

private:
	// FIXME also declared at kvpncconfig -> made it only in one place
	enum ConnectionStatus {disconnected=0, connecting=1, connected=2};
	enum LogType {info=0, remote=1, error=2, success=3, debug=4};

	TDEApplication *parent;
	TQStringList *env;

	KVpncConfig *GlobalConfig;
	KVpncKicker* KVpncDock; //< kicker menu
	TDEAction* ConnectAction; //< connect action
	TDEAction* DisconnectAction; //< disconnect action
	TDEAction *NewSessionAction;
	TDEAction *SaveSessionAction;
	TDEAction *DeleteSessionAction;
	TDEAction *RenameSessionAction;
	TDEAction *ImportSessionAction;
	TDEAction *ImportOpenvpnProfileAction;
	TDEAction *ExportOpenvpnProfileAction;
	TDEAction *ImportFreeswanProfileAction;
	TDEAction *ImportFritzboxProfileAction;
	TDEAction *ImportKvpncSettingsAction;
	TDEAction *ExportKvpncSettingsAction;
	TDEAction *ImportCertAction;
	TDEAction *SelectAction; //< line select action
	TDEAction *ProfileManagerAction;
	TDEAction *NewProfileWizardAction;
	TDEAction *HelpAction;
	TDEAction *PrefAction;
//	TDEAction *DonateAction;
	TDEAction *ReportBugAction;
	TDEAction *SendFeedbackMailAction;
	TDEAction *PreferencesAction; //< show preferences dialog
	TDEAction *ManageCiscoCertAction; //< show cisco cert manager
	TDEAction *CiscoCertEnrollmentAction; //< show cisco cert enrollment dialog
	TDEToggleAction *ToolsInfoAction;
	TDEToggleAction *VpnTypesInfoAction;
	TDEToggleAction *LogViewerAction;
	TDEToggleAction *ShowToolbarAction; //< toggle toolbar on/off
	TDEToggleAction *ShowStatusbarAction; //< toggle statusbar on/off
	TDEToggleAction *DebugconsoleAction; //< toggle debug console
	TDEToggleAction *GenerateOpenvpnKeyAction; //< generate OpenVPN key
	MainView* mw; //< Main gui
	TQTimer timer;
	TQTimer durationTimer; //< timer for counting connection time
	TQTimer IpsecWhackStatusTimer; //< getting ipsec status periodically
	TQTimer L2tpWaitForPppUpTimer; //< getting ppp device
	int connectCounter; //< counter for connecting
	int RacoonctlConnectCounter; //<< counter for waiting of adminsock
	int sec, min, hour;
	int racoon_tunnel_state; // 0 => no tunnel, 1 => first tunnel, 2 => second tunnel
	int prevConnectionState; //< needed for setGuiStatus(), holds previous state before disconnect (connected, connecting)

	bool cancelClicked;
	bool deviceaddrstr2addr;
	bool pingtest;
	bool getUserID;
	bool X509CertificateExtractRunning;
	bool X509CertificateExtractUser;
	bool setVirtualIPSuccess;
	bool AuthRetry;
	bool quitFromKicker;
	bool shutdownIsCalled;
	bool stopContinue; //< if something happens that causes to abort now
	bool ciscoVpncRunning; //< true if vpnclient is started and cipsec0 is up
	bool showProfilesOnly; //< if true only the profiles will shown in preferencesdialog
	bool IpsecStartingInProgress;
	bool IpsecGotError;

	bool IpsecPhase1Up;
	bool IpsecPhase2Up;

	bool IpsecStatusCheck;

	bool pppdHasReplacedefaultrouteSupport;

	TQString OldDefaultroute;
	TQString VpncConnectScript;
	TQString VpncDisconnectScript;
	TQString tmpPath;
	TQString ProcessMsg_connect;
	TQString ProcessMsg_disconnect;
	TQString deviceaddrstr;
	TQString deviceaddr;
	TQString tmpInterface;
	TQString LocalIP;
	TQString VpncGateway;
	TQString PptpGateway;
	TQString VpncScript;
	TQString issuerID; // for id extract
	TQString userID;   // for id extract
	TQString TunnelInterfaceIP;
	TQString TmpDns1;
	TQString TmpDns2;
	TQString VpncDevice;
	TQString CiscoVpncDevice;
	TQString L2tpPppDevice;
	TQString PppdDevice;
	TQString OpenvpnDevice;
	TQString SshDevice;
	TQString IpsecType; //< openswan, strongswan, freeswan
	TQString Pkcs11PIN;
	TQString PrettyTypeString;
	TQString PrettyStatusMessage;

	TQProcess *VpncProcess;
	TDEProcess *IpsecConnectProcess;
	TQProcess *DisconnectProcess;
	TQProcess *CiscoVpncProcess; //< vpnclient
	TQProcess *RacoonProcess; //< racoon
	TQProcess *RacoonHelperProcess;
	TQProcess *IpsecProcess; //< freeswan/openswan/strongswan
	TQProcess *IpsecStartProcess;
	TQProcess *IpsecWhackProcess; //< ipsec whack --initate
	TQProcess *IpsecWhackStatusProcess; //< ipsec whack --status
	TQProcess *IpsecWhackListenProcess; //< ipsec whack --listen
	TQProcess *IpsecWhackDeleteProcess; //< ipsec whack --delete
	TQProcess *PingProcess;
	TQProcess *RacoonTailProcess;
	TQProcess *RacoonctlProcess; //< racoonctl
	TQProcess *X509CertificateExtractProcess;
	TQProcess *PptpProcess;
	TQProcess *OpenvpnProcess;
	TQProcess *CmdBeforeConnectProcess;
	TQProcess *CmdBeforeDisconnectProcess;
	TQProcess *CmdAfterConnectProcess;
	TQProcess *CmdAfterDisconnectProcess;
	TQProcess *SetFirewallAfterConnectProcess;
	TQProcess *SetFirewallBeforeDisconnectProcess;
	TQProcess *RouteProcess;
	TQProcess *SetVirtualIPProcess;
	TQProcess *ReplaceDefaultRouteProcess;
	TQProcess *ConnectionStatusCheckProcess;
	TQProcess *TestCiscoVpncProcess;
	TQProcess *IptablesProcess;
	TQProcess *KillProcess;
	TQProcess *PptpRouteProcess;
	TQProcess *ChmodProcess;
	TQProcess *pppdUpProcess;
	TQProcess *pppdDelDefaultRouteProcess;
	TQProcess *L2tpdProcess;
	TQProcess *OpenL2tpProcess;
	TQProcess *RemoveSetkeyProcess;
	TQProcess *BugReportProcess;
//	TQProcess *DonateProcess;
	TQProcess *VtundProcess;
	TQProcess *StartStopOpenl2tpProcess;
	TDEProcess *SshProcess;
	TQProcess *backupDefaultRouteProcess;
	TQProcess *pptpdKillProcess;
	TQProcess *SshDownProcess;
	TQProcess *pppdDownProcess;
	TQProcess *killracoonprocess;
	TQProcess *killl2tpdprocess;
	TQProcess *SshUpProcess;

	int TimeOutProcess; //< for timeout
	int ConnectingProcess; //< for killing process
	TQPixmap connectedIcon;
	TQPixmap disconnectedIcon;
	TQPixmap connectingIcon;
	TQPixmap *connectingStatusPixmap;
	TQPixmap *disconnectedStatusPixmap;
	TQPixmap *connectedStatusPixmap;

	TQLabel *statusColorLabel;
	TQPopupMenu *QuickConnectMenu;

	OpenvpnManagementHandler *managementhandler ;
	KFeedbackDialog *FeedbackDialog;

	TQString L2tpdBufferStdoutString;
	TQString L2tpdBufferStderrString;
	
	PreferencesDialog *prefDlg;


public slots:
	/** setup KVpnc */
	void slotSettings();
	/** show / hide toolbar */
	void slotShowToolbar();
	/** show / hide statusbar */
	void slotShowStatusbar();
	/** configure key bindings */
	void slotKeyBindings();
	/** configure toolbars */
	void slotConfigToolbars();

	void slotConfigNotifications();


	/**
	* Slot for status message
	* @param text The text that will be set
	* @param id What type its is
	*/
	void slotStatusMsg( const TQString &text, int id = ID_STATUS_MSG );

	void connectClicked();
	void disconnectClicked();
	void saveSessionClicked();
	void newSessionClicked();
	void deleteSessionClicked();
	void renameSessionClicked ();
	void sessionToggled( const TQString& );
	void helpClicked();
	void toolsInfoClicked();
	void vpnTypesInfoClicked();
//	void donateClicked();
	void reportBugClicked();
	void saveGuiOptions();
	void showNewProfileWizardClicked();


private slots:

	/**
	 *   called if close clicked
	 * @param e the event which happen
	 */
	void closeEvent( TQCloseEvent* e );
	bool queryClose();
	void shutdownCalled();
	void slotCancelClicked();
	void slotConnectTimedOut();
	void slotDurationEvent();
	void showDockTooltip();
	void readOutputFrom_vpnc();
	void readOutputFrom_ciscovpnc();
	void wroteToStdin_vpncConfig();
	void readFromStdout_disconnect();
	void readFromStderr_disconnect();
	void readFromStdout_racoon();
	void readFromStderr_racoon();
	void readFromStdout_racoon_helper();
	void readFromStderr_racoon_helper();
	void readFromStdout_ipsec();
	void readFromStderr_ipsec();
	void readFromStdout_ipsecwhack();
	void readFromStderr_ipsecwhack();
	void readFromStdout_ipsecwhacklisten();
	void readFromStderr_ipsecwhacklisten();
	void readFromStdout_ipsecwhackstatus();
	void readFromStderr_ipsecwhackstatus();
	void readFromStdout_ipsecwhackdelete();
	void readFromStderr_ipsecwhackdelete();
	void readFromStdout_pptp();
	void readFromStderr_pptp();
	void readFromStdout_l2tpd();
	void readFromStderr_l2tpd();
	void processStdout_l2tpd();
	void processStderr_l2tpd();
	void readFromStdout_openl2tp();
	void readFromStderr_openl2tp();
	void readFromStdout_startstopOpenl2tp();
	void readFromStderr_startstopOpenl2tp();
	void checkL2tpPppUp();
	void readOutput_openvpn();
	void readFromStdout_vtun();
	void readFromStderr_vtun();
	void readFromStdout_ssh(TDEProcess *proc, char *buffer, int buflen);
	void readFromStderr_ssh(TDEProcess *proc, char *buffer, int buflen);
	void readFromStdout_executeCommandBeforeConnect();
	void readFromStderr_executeCommandBeforeConnect();
	void readFromStdout_executeCommandAfterConnect();
	void readFromStderr_executeCommandAfterConnect();
	void readFromStdout_executeCommandBeforeDisconnect();
	void readFromStderr_executeCommandBeforeDisconnect();
	void readFromStdout_executeCommandAfterDisconnect();
	void readFromStderr_executeCommandAfterDisconnect();


	void readFromStdout_tail_racoon();
	void readFromStderr_tail_racoon();
	void readFromStdout_racoonctl();
	void readFromStderr_racoonctl();
	void readFromStdout_ping();
	void readFromStderr_ping();
	void readFromStdout_route();
	void readFromStderr_route();
	void readFromStdout_getX509CertificateID();
	void readFromStderr_getX509CertificateID();
	void readFromStdout_setVirtualIP();
	void readFromStderr_setVirtualIP();
	void readFromStdout_connectionStatusCheck();
	void readFromStderr_connectionStatusCheck();
	void readCiscoVpncTestProcessOutput();
	void quitCalled();
	void quitCalledKicker();
	void pptpProcessExited();
	void vtun_exited(); //< vtund has been exited
	void openvpn_exited(); //< openvpn has been exited
	void ipsecwhack_exited(); //< ipsec whack has been exited
	void IpsecWhackStatusProcessExited();
	void racoonctlExited();
	void prepareL2tpd(); //< write l2tpd conf etc.
	void start_ipsec_initiate();
	void doAddRemoveVirtualIp(TQString action);
	
	void importProfileClicked(); //< PCF import
	void importIpsecProfileClicked();
	void importFritzboxProfileClicked();
	void importKvpncSettingsClicked();
	void exportKvpncSettingsClicked();

	void importOpenvpnProfileClicked(); //< OpenVPN config file import
	void doRacoon();
	void stopRacoon();
	void doRoutePptp();
	void addRouteIpsec();
	void delRouteIpsec();
	void doTailRacoonLog();
	void doIptablesRacoon();
	void doIptablesFreeswan();
	void addRouteRacoon();
	void delRouteRacoon();
	void doPingKickupTunnel();
	void removeIptablesRacoon();
	void removeIptablesFreeswan();
	void removeSetkey();
	void connectionEnded();
	void doPingTest();
	void pingTestExited();
	void sshExited();
	void vpncStarted();
	void ipsecStarted();
	void ipsecPhase2Established();
	void checkIpsecWhackStatus();
	void addIpsecConnection();
	void racoonStarted();
	void pppdStarted();
	void openvpnStarted();
	void openSSLEnded();
	void importCertClicked();
	void manageCiscoCertClicked();
	void enrollCiscoCertClicked();
	void showProfileManagerClicked();
	void executeCommandBeforeConnect();
	void executeCommandAfterConnect();
	void executeCommandBeforeDisconnect();
	void executeCommandAfterDisconnect();
	void setFirewallAfterConnect();
	void setFirewallBeforeDisconnect();
	void slotConnecting();
	void toggleDebugConsole();
	void addAdditionalNetworkRoutes();
	void removeAdditionalNetworkRoutes();
	void showLogViewer();
	void doQuickConnect(int id);
	void startConnectionStatusCheck();
	void generateOpenvpnKey();
	void preserveNetworkEnvironment(); //< save route and resolv.conf
	void restoreNetworkEnvironment(); //< restore route and resolv.conf
	void backupIpsecSystemConfig(); // backup ipsec.conf and  ipsec.secrets
	void backupDefaultRoute();
	void exportOpenvpnProfileClicked();
	void addFeatureList( KFeedbackQuestion * question );
	void sendFeedbackMail();
	void feedbackMailSent();
	void start_l2tpd();
	bool checkCiscoVpncStatus();
	void startCiscoVpnc();
	void startStopIpsec(bool stop=false, bool silent=false);
	void startStopOpenl2tp(bool stop=false, bool silent=false);

signals:
        void L2tpdStdoutRecieved();
	void L2tpdStderrRecieved();
	void newProfileCreated(TQString Name);
	
public:
	void importOpenvpnProfileClicked(TQString file); //< OpenVPN config file import
	void importProfileClicked(TQString file); //< PCF import

	bool backupResolvConf();
	bool restoreResolvConf();

public:
k_dcop:
	TQString getVersion();
	void doConnect();
	void doDisconnect();
	uint getConnectedTime();
	TQString getStatus();
	TQString getCurrentProfile();
	void setProfile(TQString profilename);
	void createNewProfile();
	void createNewProfileWithWizard();
	void deleteCurrentProfile();
	void openPreferences();
	void doImportCert();
	void doImportPcf();
	void doImportPcf(TQString file);
	void doImportOpenvpnConfig();
	void doImportOpenvpnConfig(TQString file);
	TQStringList profiles();
	TQStringList toolinfo();
	void doQuit();
	void doGenerateOpenvpnKey();
	void doSendFeedbackMail();
	TQStringList getProfileTypes();

};

#endif

