/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** TQt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/

#ifndef TRANSACTIONSORTOPTION_UI_H
#define TRANSACTIONSORTOPTION_UI_H

// ----------------------------------------------------------------------------
// TQt Includes

// ----------------------------------------------------------------------------
// TDE Includes

#include <kiconloader.h>
#include <tdelocale.h>
#include <kpushbutton.h>

// ----------------------------------------------------------------------------
// Project Includes

#include <kmymoney/register.h>
#include "sortoptionlistitem.h"


void TransactionSortOption::init()
{
  TDEIconLoader* il = TDEGlobal::iconLoader();
  m_addButton->setIconSet(TQIconSet(il->loadIcon("1rightarrow", TDEIcon::Small, TDEIcon::SizeSmall)));
  m_removeButton->setIconSet(TQIconSet(il->loadIcon("1leftarrow", TDEIcon::Small, TDEIcon::SizeSmall)));
  m_upButton->setIconSet(TQIconSet(il->loadIcon("1uparrow", TDEIcon::Small, TDEIcon::SizeSmall)));
  m_downButton->setIconSet(TQIconSet(il->loadIcon("1downarrow", TDEIcon::Small, TDEIcon::SizeSmall)));

  // don't allow sorting of the selected entries
  m_selectedList->setSortColumn(-1);

  // defaults to "post date, value" sorting
  // setSettings(TQString("1,4"));
  setSettings(TQString());

  TQListViewItem* p;
  if((p = m_availableList->firstChild()) != 0) {
    m_availableList->setSelected(p, true);
  }
}

/**
  * Setup the two lists according to the elements found in @a list.
  * If an item is negative, it will show up in the available list,
  * if positive, it shows up in the selected list.
  *
  * Special care is taken about the two values @a EntryDateSort and
  * @a EntryOrderSort. These two entries cannot (should not) exist
  * alone. Inside this widget, only the @a EntryOrderSort is used.
  *
  * setSettings() takes care of hiding the @a EntryDateSort item and if
  * it exists in @p settings without @a EntryOrderSort being present, it
  * will add @a EntryOrderSort.
  */
void TransactionSortOption::setSettings(const TQString& settings)
{
  m_availableList->clear();
  m_selectedList->clear();

  TQStringList list = TQStringList::split(',', settings);
  TQMap<int, bool> selectedMap;

  // fill selected list
  TQStringList::const_iterator it_s;
  TQListViewItem* last = 0;
  int dateSign = 1;
  for(it_s = list.begin(); it_s != list.end(); ++it_s) {
    int val = (*it_s).toInt();
    selectedMap[abs(val)] = true;
    // skip EntryDateSort but keep sign
    if(abs(val) == static_cast<int>(KMyMoneyRegister::EntryDateSort)) {
      dateSign = (val < 0) ? -1 : 1;
      continue;
    }
    last = addEntry(m_selectedList, last, val);
  }

  // make sure to create EntryOrderSort if missing but required
  if(selectedMap.find(static_cast<int>(KMyMoneyRegister::EntryDateSort)) != selectedMap.end()
  && selectedMap.find(static_cast<int>(KMyMoneyRegister::EntryOrderSort)) == selectedMap.end()) {
    int val = dateSign * static_cast<int>(KMyMoneyRegister::EntryOrderSort);
    selectedMap[static_cast<int>(KMyMoneyRegister::EntryOrderSort)] = true;
    last = addEntry(m_selectedList, last, val);
  }

  // fill available list
  TQMap<int, bool>::const_iterator it_m;
  for(int i = static_cast<int>(KMyMoneyRegister::PostDateSort);
      i < static_cast<int>(KMyMoneyRegister::MaxSortFields); ++i) {
    // Never add EntryDateSort
    if(i == static_cast<int>(KMyMoneyRegister::EntryDateSort))
      continue;
    // Only add those, that are not present in the list of selected items
    if(selectedMap.find(i) == selectedMap.end()) {
      int val = i;
      if(i == static_cast<int>(KMyMoneyRegister::ValueSort))
        val = -val;
      addEntry(m_availableList, 0, val);
    }
  }
}

TQListViewItem* TransactionSortOption::addEntry( TDEListView * p, TQListViewItem* after, int idx )
{
  TQString txt = KMyMoneyRegister::sortOrderToText(static_cast<KMyMoneyRegister::TransactionSortField>(abs(idx)));
  if(txt.isEmpty())
    txt = "Unknown";    // i18n should be handled in sortOptionToText()

  return new SortOptionListItem(p, after, txt, idx);
}

void TransactionSortOption::toggleDirection(TQListViewItem* item)
{
  SortOptionListItem* p = dynamic_cast<SortOptionListItem*>(item);
  if(p) {
    p->toggleDirection();
    emit settingsChanged(settings());
  }
}

TQString TransactionSortOption::settings( void ) const
{
  TQString rc;
  SortOptionListItem* item = dynamic_cast<SortOptionListItem*>(m_selectedList->firstChild());
  while(item) {
    int option = KMyMoneyRegister::textToSortOrder(item->text(0));
    // if we look at the EntryOrderSort option, we have to make
    // sure, that the EntryDateSort is prepended
    if(option == KMyMoneyRegister::EntryOrderSort) {
      rc  += TQString::number(static_cast<int>(KMyMoneyRegister::EntryDateSort)*item->direction())+",";
    }
    rc += TQString::number(KMyMoneyRegister::textToSortOrder(item->text(0))*item->direction());
    item = dynamic_cast<SortOptionListItem*>(item->itemBelow());
    if(item != 0)
      rc += ",";
  }
  return rc;
}

void TransactionSortOption::slotAvailableSelected( TQListViewItem * item )
{
  m_addButton->setEnabled(item != 0);
  m_removeButton->setDisabled(true);
  m_upButton->setDisabled(true);
  m_downButton->setDisabled(true);

  TQListViewItem* p = m_selectedList->currentItem();
  if(p) {
    m_selectedList->setSelected(p, false);
  }
}

void TransactionSortOption::slotSelectedSelected( TQListViewItem * item )
{
  m_addButton->setDisabled(true);
  m_removeButton->setEnabled(item != 0);
  if(item) {
    m_upButton->setEnabled(item->itemAbove() != 0);
    m_downButton->setEnabled(item->itemBelow() != 0);
  } else {
    m_upButton->setEnabled(false);
    m_downButton->setEnabled(false);
  }

  TQListViewItem* p = m_availableList->currentItem();
  if(p) {
    m_availableList->setSelected(p, false);
  }
}

void TransactionSortOption::slotAddItem( void )
{
  TQListViewItem* item;
  if((item = m_availableList->currentItem()) != 0) {
    TQListViewItem* next = item->itemBelow();
    if(!next)
      next = item->itemAbove();
    m_availableList->takeItem(item);
    m_selectedList->insertItem(item);
    m_addButton->setEnabled(m_availableList->firstChild() != 0);
    if(next) {
      m_availableList->setCurrentItem(next);
      m_availableList->setSelected(next, true);
    }
    emit settingsChanged(settings());
  }
}

void TransactionSortOption::slotRemoveItem( void )
{
  TQListViewItem* item;
  if((item = m_selectedList->currentItem()) != 0) {
    TQListViewItem* next = item->itemBelow();
    if(!next)
      next = item->itemAbove();
    m_selectedList->takeItem(item);
    m_availableList->insertItem(item);
    m_removeButton->setEnabled(m_selectedList->firstChild() != 0);
    if(next) {
      m_selectedList->setCurrentItem(next);
      m_selectedList->setSelected(next, true);
    }
    emit settingsChanged(settings());
  }
}

void TransactionSortOption::slotUpItem( void )
{
  TQListViewItem* item;
  if((item = m_selectedList->currentItem()) != 0) {
    TQListViewItem* prev = item->itemAbove();
    if(prev) {
      prev->moveItem(item);
      m_selectedList->setCurrentItem(item);
      m_selectedList->setSelected(item, true);
      m_upButton->setEnabled(item->itemAbove() != 0);
      m_downButton->setEnabled(item->itemBelow() != 0);
      emit settingsChanged(settings());
    }
  }
}

void TransactionSortOption::slotDownItem( void )
{
  TQListViewItem* item;
  if((item = m_selectedList->currentItem()) != 0) {
    TQListViewItem* next = item->itemBelow();
    if(next) {
      item->moveItem(next);
      m_selectedList->setCurrentItem(item);
      m_selectedList->setSelected(item, true);
      m_upButton->setEnabled(item->itemAbove() != 0);
      m_downButton->setEnabled(item->itemBelow() != 0);
      emit settingsChanged(settings());
    }
  }
}

#endif
