/* This file is part of the KDE project
   Copyright (C) 1998, 1999 Reginald Stadlbauer <reggie@kde.org>
   Copyright (C) 2005 Thomas Zander <zander@kde.org>

   This library is free software; you can redistribute it and/m_or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, m_or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY m_or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef framedia_h
#define framedia_h

#include "defs.h"
#include "KWTextFrameSet.h"
#include <kdialogbase.h>
#include <KoUnit.h>
#include <KoUnitWidgets.h>
#include <tqgroupbox.h>

class KoBorderPreview;
class KWFrame;
class KWDocument;
class KWPage;
class TQWidget;
class TQGridLayout;
class TQGroupBox;
class TQRadioButton;
class TQCheckBox;
class TQLabel;
class TQCloseEvent;
class TQListView;
class TQListViewItem;
class TQLineEdit;
class KColorButton;
class KDoubleNumInput;

/******************************************************************/
/* Class: KWBrushStylePreview                                     */
/******************************************************************/
class KWBrushStylePreview : public TQFrame
{
    TQ_OBJECT
  
public:
    KWBrushStylePreview( TQWidget* );
    ~KWBrushStylePreview() {}
    void setBrush( const TQBrush& _brush ) { brush = _brush; }
protected:
    void drawContents( TQPainter* );
private:
    TQBrush brush;
};

/**
 * A widget showing unitwidgets for 4 doubles (for left/right/top/bottom values)
 * and a checkbox to synchronize changes to all values
 */
class KWFourSideConfigWidget : public TQGroupBox
{
    TQ_OBJECT
  
public:
    KWFourSideConfigWidget( KWDocument* m_doc, const TQString& title, TQWidget*, const char* name = 0 );

    bool changed() const { return m_changed; }

    void setValues( double left, double right, double top, double bottom ); // in pt
    double leftValue() const; // in pt
    double rightValue() const; // in pt
    double topValue() const; // in pt
    double bottomValue() const; // in pt

signals:

public slots:
    void slotValueChanged( double );

private:
    KoUnitDoubleSpinBox *m_inputLeft, *m_inputRight, *m_inputTop, *m_inputBottom;
    TQCheckBox *m_synchronize;
    KWDocument *m_doc;
    bool m_changed;
    bool m_noSignal;
};

/******************************************************************/
/* Class: KWFrameDia                                              */
/******************************************************************/
class KWFrameDia : public KDialogBase
{
    TQ_OBJECT
  
public:
    /** Contructor when the dialog is used on creation of m_frame */
    KWFrameDia( TQWidget *parent, KWFrame *_frame,KWDocument *_doc,FrameSetType _ft);
    KWFrameDia( TQWidget *parent, KWFrame *_frame);
    KWFrameDia( TQWidget *parent, TQPtrList<KWFrame> allFrames);
    //KWFrameDia( TQWidget *parent, KWCanvas *_canvas);

    //void setCanvas(KWCanvas *_canvas) {canvas =_canvas;}

protected:
    void init();
    bool applyChanges();
    void setupTab1();
    void setupTab2();
    void setupTab3();
    void setupTab4();
    void setupTab5();
    void setupTab6();
    void initBorderSettings();
    void initGeometrySettings();

    void updateFrames();
    void enableOnNewPageOptions();
    void initBrush();
    bool mayDeleteFrameSet(KWTextFrameSet *fs);
    void enableSizeAndPosition();

    TQBrush frameBrushStyle() const;
    void calcRatio();

protected slots:
    virtual void slotApply();
    virtual void slotOk();
    void connectListSelected( TQListViewItem * );
    void setFrameBehaviorInputOn();
    void setFrameBehaviorInputOff();
    void slotFloatingToggled(bool);
    void slotProtectSizeToggled(bool);
    void textNameFrameChanged ( const TQString & );
    //void updateBrushPreview();
    void slotProtectContentChanged( bool );
    void enableRunAround();
    void selectExistingFrameset();
    void selectNewFrameset(bool on);
    void slotUpdateWidthForHeight(double height);
    void slotUpdateHeightForWidth( double width );
    void slotKeepRatioToggled(bool on);
    void ensureValidFramesetSelected();
    void brdLeftToggled( bool );
    void brdRightToggled( bool );
    void brdTopToggled( bool );
    void brdBottomToggled( bool );
    void slotPressEvent(TQMouseEvent *_ev);
private:
    // TAB 1:
    TQWidget *m_tab1;
    TQGridLayout *m_grid1, *m_eofGrid, *m_onpGrid, *m_sideGrid;
    TQGroupBox *m_endOfFrame, *m_onNewPage, *m_sideHeads;
    TQCheckBox *m_cbCopy, *m_cbAspectRatio, *m_cbAllFrames;
    TQCheckBox *m_cbProtectContent;
    TQRadioButton *m_rResizeFrame, *m_rAppendFrame, *m_rNoShow, *m_reconnect, *m_noFollowup, *m_copyRadio;
    TQLabel *sideTitle1, *sideTitle2;
    TQLineEdit *m_sideWidth, *m_sideGap;
    TQComboBox *m_sideAlign;

    // TAB 2:
    TQWidget *m_tab2;
    TQRadioButton *m_rRunNo, *m_rRunBounding, *m_rRunSkip;
    TQRadioButton *m_rRunLeft, *m_rRunRight, *m_rRunBiggest;
    TQGroupBox *m_runGroup, *m_runSideGroup;
    KWFourSideConfigWidget* m_raDistConfigWidget;

    // TAB 3:
    TQWidget *m_tab3;
    TQLineEdit *m_eFrameSetName;
    TQListView *m_lFrameSList;
    TQRadioButton *m_rExistingFrameset, *m_rNewFrameset;


    // TAB 4:
    TQWidget *m_tab4;
    TQGroupBox *m_grp1;
    TQLabel *m_lx, *m_ly, *m_lw, *m_lh;
    KoUnitDoubleSpinBox *m_sx, *m_sy, *m_sw, *m_sh;
    KWFourSideConfigWidget* m_paddingConfigWidget;
    TQCheckBox *m_floating;
    TQCheckBox *m_protectSize;

    // TAB 5:
    TQWidget *m_tab5;

    // TAB 6:
    TQWidget *m_tab6;
    TQComboBox *m_cWidth, *m_cStyle;
    TQPushButton *m_bLeft, *m_bRight, *m_bTop, *m_bBottom;
    KColorButton *m_bColor;
    KoBorder m_leftBorder, m_rightBorder, m_topBorder, m_bottomBorder;
    KoBorderPreview *m_prev3;

    //TQComboBox *brushStyle;
    TQCheckBox* m_transparentCB;
    KColorButton *m_brushColor;
    //KWBrushStylePreview *brushPreview;
    TQCheckBox *m_overwriteColor;

    KWFrame *m_frame;
    KWFrame *m_mainFrame;
    TQPtrList<KWFrame> m_allFrames;
    KWDocument *m_doc;
    FrameSetType m_frameType;
    bool m_frameSetFloating;
    bool m_frameSetProtectedSize;
    bool m_mainFrameSetIncluded;
    bool m_defaultFrameSetIncluded; // header, m_footer m_or m_footnote
    double m_oldX, m_oldY, m_oldW, m_oldH;
    double m_heightByWidthRatio;
    int /*FrameBehavior*/ m_frameBehavior;
    KoUnit::Unit m_frameUnits;
    TQString m_oldFrameSetName;
    TQBrush m_newBrushStyle;
    bool m_noSignal;
};

#endif
