/*
 *   Copyright (C) 2006
 *   Siraj Razick <siraj@kdemail.net>
 *   PhobosK <phobosk@mail.kbfx.net>
 *   see Also AUTHORS
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License version 2 as
 *   published by the Free Software Foundation
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef KBFX_PLASMA_CANVAS_VIEW_H
#define KBFX_PLASMA_CANVAS_VIEW_H

#include <tqcanvas.h>
#include <tqcursor.h>
#include <tqdragobject.h>
#include <tqpainter.h>

#include <kimageeffect.h>

#include <kbfxconfig.h>
#include <kbfxdatastack.h>
#include <kbfxplasmapixmapprovider.h>
#include <kbfxplasmapluginloader.h>

//#include "kbfxplasmacanvasrtti.h"
#include "kbfxplasmacanvasgroup.h"
#include "kbfxplasmacanvasgroupview.h"
#include "kbfxplasmacanvasitem.h"
#include "kbfxplasmacanvasitemwrapper.h"

#include "kbfxplasmacanvasstack.h"
#include "kbfxplasmacanvasview.h"
#include "kbfxsignal.h"
#include "kbfxspinxscrollbar.h"


class TQCanvasView;


class KbfxPlasmaCanvasView : public TQCanvasView
{
		TQ_OBJECT
  

	public:
		typedef TQMap<TQString,KbfxPlasmaCanvasStack*> stackMap;
		typedef TQMap<TQString,KbfxDataStack*> dataStack;
		typedef TQMap<int,KbfxPlasmaCanvasItem*> searchMap;

		KbfxPlasmaCanvasView ( TQWidget * parent = 0, const char * name = 0, WFlags f = 0 );
		virtual	~KbfxPlasmaCanvasView();
		void addStack ( KbfxPlasmaCanvasStack*stk,TQString name );
		void addStack ( KbfxDataStack*stk,TQString name );
		
		void setKbfxCanvas ( TQCanvas*cnv );
		void loadGroup ( KbfxDataGroupList * src,KbfxPlasmaCanvasGroupView * dest );
		void contentsDragLeaveEvent ( TQDragEnterEvent *event );
		void contentsDragEnterEvent ( TQDragEnterEvent *event );
		

	public slots:

		void clearAll();
		virtual void contentsMousePressEvent ( TQMouseEvent * me );
		virtual void contentsMouseMoveEvent ( TQMouseEvent * e );
		virtual void contentsMouseReleaseEvent ( TQMouseEvent * e );
		virtual void mouseMoveEvent ( TQMouseEvent * me );
		virtual void enterEvent ( TQEvent * e );
		virtual void keyPressEvent ( TQKeyEvent * ke );
		virtual void emulatedKeyPress ( TQKeyEvent * k ) {keyPressEvent ( k );}
		virtual void resizeEvent ( TQResizeEvent * ) ;
		virtual void leaveEvent ( TQEvent * e );
//		virtual void leaveEvent(TQEvent e );
		void handleLoadRequest ( KbfxSignal );
		void search ( const TQString & );
		void search_R ( const TQString key );
		void execFirst();
		void execAt ( int  i );
		void expandAll();
		void reload();
	signals:
		void clicked();
	protected:
		void clearAllButOne ( KbfxPlasmaCanvasItem * i );

	private:
		void clearSearch();
		void startDrag();
		void placeScrollBars();

		TQPoint m_clickPos;
		KbfxPlasmaCanvasItem  * m_currentItem;
		KbfxPlasmaCanvasStack * m_currentStack;
		KbfxPlasmaCanvasStack * m_stack;
		TQString m_lastSignalData;
		stackMap m_appletMap;
		dataStack m_dataStack;
		searchMap m_searchMap;
		KbfxPlasmaCanvasStack * gstack ;
		KbfxPlasmaCanvasItem * m_exeCandidate;
		TQCanvas * m_default;
		TQCanvas * m_search;
		bool m_findDone;
		KbfxSpinxScrollBar * m_scrollbar_top;
		KbfxSpinxScrollBar * m_scrollbar_bot;
		TQPoint m_dragPos;
		KbfxPlasmaCanvasGroupView * m_currentView;
		TQString m_currentViewName;
		KbfxPlasmaCanvasItem * m_selectedItem;
};

#endif

