###########################################
#                                         #
#  Improvements and feedback are welcome  #
#                                         #
#  This file is released under GPL >= 3   #
#                                         #
###########################################

# required stuff

tde_setup_architecture_flags( )

include(TestBigEndian)
test_big_endian(WORDS_BIGENDIAN)

tde_setup_largefiles( )


##### check for gcc visibility support

if( WITH_GCC_VISIBILITY )
  tde_setup_gcc_visibility( )
endif( WITH_GCC_VISIBILITY )


##### check for gnutls

pkg_search_module( GNUTLS gnutls )
if( NOT GNUTLS_FOUND )
  tde_message_fatal( "GNUTLS is required but was not found on your system" )
endif( NOT GNUTLS_FOUND )


##### check for OpenSSL

pkg_search_module( SSL openssl )
if( NOT SSL_FOUND )
   check_include_file( openssl/ssl.h HAVE_OPENSSL_H )
   check_library_exists( ssl OPENSSL_init_ssl "" HAVE_LIBSSL_11 )
   if( NOT HAVE_LIBSSL_11 )
      check_library_exists( ssl SSL_library_init "" HAVE_LIBSSL )
   endif( )
   check_library_exists( crypto EVP_EncryptInit_ex "" HAVE_LIBCRYPTO )
   if( HAVE_OPENSSL_H AND (HAVE_LIBSSL_11 OR HAVEL_LIBSSL) AND HAVE_LIBCRYPTO )
      set( SSL_FOUND 1 CACHE INTERNAL "" FORCE )
      find_file( OPENSSLV_H openssl/opensslv.h )
      file( STRINGS "${OPENSSLV_H}" SSL_VERSION REGEX "#[ \t]*define[ \t]*OPENSSL_VERSION_TEXT" )
      string( REGEX REPLACE "# *define[ \t]*OPENSSL_VERSION_TEXT[ \t]*\"[^0-9 ]* *([^ ]*).*" "\\1"
              SSL_VERSION "${SSL_VERSION}" )
      set( SSL_VERSION "${SSL_VERSION}" CACHE INTERNAL "" FORCE )
      message( STATUS "Found OpenSSL: version ${SSL_VERSION}" )
   endif( HAVE_OPENSSL_H AND (HAVE_LIBSSL_11 OR HAVEL_LIBSSL) AND HAVE_LIBCRYPTO )
endif( NOT SSL_FOUND )
if( NOT SSL_FOUND )
  tde_message_fatal( "SSL support is required but was not found on your system" )
endif( NOT SSL_FOUND )


##### check for pkcs11-helper

pkg_search_module( LIBPKCS11-HELPER libpkcs11-helper-1 )
if( NOT LIBPKCS11-HELPER_FOUND )
  tde_message_fatal( "libpkcs11-helper-1 is required but was not found on your system" )
endif( NOT LIBPKCS11-HELPER_FOUND )


