/***************************************************************************
                       splashscreen.h  -  description
                            -------------------
   begin                : Fri Nov 30 2001
   copyright            : (C) 2001 by Matthias Messmer &
                                      Carsten Niehaus &
                                      Robert Gogolok
   email                : bmlmessmer@web.de &
                          cniehaus@gmx.de &
                          mail@robert-gogolok.de
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// TQt includes
#include <tqcanvas.h>
#include <tqtimer.h>

// KDE includes
#include <kstandarddirs.h>

// local includes
#include "kpercentage.h"
#include "ksplashscreen.h"

/* creates the splash window without titlebar and border */
KSplashScreen::KSplashScreen( KPercentage *percentage, const char *name ) :
        KDialog( 0L, name, false, TQWidget::WStyle_Customize | TQWidget::WStyle_NoBorder )
{
    percentage_window = percentage;
    resize( 380, 300 );
    /* load the background pixmap */
    TQPixmap bgp( locate( "data", "kpercentage/pics/splash.png" ) );
    /* wait some time and start the main window */
    TQCanvas *canvas = new TQCanvas( this );
    canvas->resize( 400, 300 );
    /* set the background pixmap */
    canvas->setBackgroundPixmap( bgp );
    //remove version number from splash annma 14/02/2005
    //TQCanvasText *t = new TQCanvasText( KPERCENTAGE_VERSION, canvas );
    //t->move( 330.0, 260.0 );
    //t->show();
    canvas->setAllChanged();
    canvas->update();
    TQCanvasView *view = new TQCanvasView( canvas, this, "", TQCanvasView::WStyle_Customize | TQCanvasView::WStyle_NoBorder );
    view->resize( 380, 300 );
    view->setVScrollBarMode( TQCanvasView::AlwaysOff );
    view->setHScrollBarMode( TQCanvasView::AlwaysOff );
    view->setFrameStyle( TQCanvasView::NoFrame );
    view->show();
    TQTimer::singleShot( 2000, this, TQ_SLOT( showPercentage() ) );
}

/* show the main window and close the splah window */
void KSplashScreen::showPercentage()
{
    percentage_window->show();
    delete( this );
}

#include "ksplashscreen.moc"
