/*
        Copyright (C) 2001 Jeff Tranter
                           tranter@kde.org
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
 
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
 
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.


------------------------------------------------------------------------

This application displays an error, warning, or informational message
in a dialog. It is normally used by artsd in conjunction with the -m
option.  By abstracting this out of artsd, we keep it independent of
any particular graphics toolkit.

This version uses KDE. Equivalent versions could be written using Qt,
Gnome, etc. and used instead.

*/

#include <tqregexp.h>

#include <tdelocale.h>
#include <tdeglobal.h>
#include <tdeapplication.h>
#include <tdeaboutdata.h>
#include <tdemessagebox.h>
#include <tdecmdlineargs.h>

// command line options
static TDECmdLineOptions options[] = 
  {
	  { "e", 0,0 },
	  { "error", I18N_NOOP("Display error message (default)"), 0 },
	  { "w", 0, 0},
	  { "warning", I18N_NOOP("Display warning message"), 0 },
	  { "i", 0, 0 },
	  { "info", I18N_NOOP("Display informational message"), 0 },
	  { "+message", I18N_NOOP("Message string to be displayed"), 0 },
	  TDECmdLineLastOption // End of options.
  };

TDEAboutData aboutData("artsmessage", I18N_NOOP("artsmessage"), "0.1",
					 I18N_NOOP("Utility to display aRts error messages"),
					 TDEAboutData::License_GPL, "(c) 2001, Jeff Tranter", 0, 0, "tranter@kde.org");

int main(int argc, char **argv) {
	aboutData.addAuthor("Jeff Tranter", 0, "tranter@kde.org");
	TDEGlobal::locale()->setMainCatalogue("tdelibs");
	TDECmdLineArgs::init(argc, argv, &aboutData);
	TDECmdLineArgs::addCmdLineOptions(options);
	TDEApplication app;
	
	TDECmdLineArgs *args = TDECmdLineArgs::parsedArgs();
	TQString msg;

	// must be at least one argument
	if (args->count() == 0) {
		args->usage();
	}

	// build up message string from remaining arguments
	for (int i = 0; i < args->count(); i++) {
		if (i == 0)
			msg = args->arg(i);
		else
			msg += TQString(" ") + args->arg(i);
	}

	const int notifyOptions = 0; // never activate KNotify
	if (args->isSet("w")) {
		KMessageBox::sorry(0, msg, i18n("Warning"), notifyOptions);
	} else if (args->isSet("i")) {
		TQString id = msg;
		id.replace(TQRegExp("[\\[\\]\\s=]"), "_");
		KMessageBox::information(0, msg, i18n("Informational"), id, notifyOptions);
	} else {
		KMessageBox::error(0, msg, i18n("Error"), notifyOptions);
	}
	
	return 0;
}
