// This module implements the TQextScintillaLexerBatch class.
//
// Copyright (c) 2006
// 	Riverbank Computing Limited <info@riverbankcomputing.co.uk>
// 
// This file is part of TQScintilla.
// 
// This copy of TQScintilla is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// TQScintilla is supplied in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
// details.
// 
// You should have received a copy of the GNU General Public License along with
// TQScintilla; see the file LICENSE.  If not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <tqcolor.h>
#include <tqfont.h>
#include <tqsettings.h>

#include "tqextscintillalexerbatch.h"


// The ctor.
TQextScintillaLexerBatch::TQextScintillaLexerBatch(TQObject *parent,
						 const char *name)
	: TQextScintillaLexer(parent,name)
{
}


// The dtor.
TQextScintillaLexerBatch::~TQextScintillaLexerBatch()
{
}


// Returns the language name.
const char *TQextScintillaLexerBatch::language() const
{
	return "Batch";
}


// Returns the lexer name.
const char *TQextScintillaLexerBatch::lexer() const
{
	return "batch";
}


// Return the string of characters that comprise a word.
const char *TQextScintillaLexerBatch::wordCharacters() const
{
	return "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ-";
}


// Returns the foreground colour of the text for a style.
TQColor TQextScintillaLexerBatch::color(int style) const
{
	switch (style)
	{
	case Default:
	case Operator:
		return TQColor(0x00,0x00,0x00);

	case Comment:
		return TQColor(0x00,0x7f,0x00);

	case Keyword:
	case ExternalCommand:
		return TQColor(0x00,0x00,0x7f);

	case Label:
		return TQColor(0x7f,0x00,0x7f);

	case HideCommandChar:
		return TQColor(0x7f,0x7f,0x00);

	case Variable:
		return TQColor(0x80,0x00,0x80);
	}

	return TQextScintillaLexer::color(style);
}


// Returns the end-of-line fill for a style.
bool TQextScintillaLexerBatch::eolFill(int style) const
{
	return (style == Label);
}


// Returns the font of the text for a style.
TQFont TQextScintillaLexerBatch::font(int style) const
{
	TQFont f;

	switch (style)
	{
	case Comment:
#if defined(Q_OS_WIN)
		f = TQFont("Comic Sans MS",9);
#else
		f = TQFont("Bitstream Vera Serif",9);
#endif
		break;

	case Keyword:
		f = TQextScintillaLexer::font(style);
		f.setBold(true);
		break;

	case ExternalCommand:
#if defined(Q_OS_WIN)
		f = TQFont("Courier New",10);
#else
		f = TQFont("Bitstream Vera Sans Mono",9);
#endif
		f.setBold(true);
		break;

	default:
		f = TQextScintillaLexer::font(style);
	}

	return f;
}


// Returns the set of keywords.
const char *TQextScintillaLexerBatch::keywords(int set) const
{
	if (set == 1)
		return
			"rem set if exist errorlevel for in do break call "
			"chcp cd chdir choice cls country ctty date del "
			"erase dir echo exit goto loadfix loadhigh mkdir md "
			"move path pause prompt rename ren rmdir rd shift "
			"time type ver verify vol com con lpt nul";

	return 0;
}


// Returns the user name of a style.
TQString TQextScintillaLexerBatch::description(int style) const
{
	switch (style)
	{
	case Default:
		return tr("Default");

	case Comment:
		return tr("Comment");

	case Keyword:
		return tr("Keyword");

	case Label:
		return tr("Label");

	case HideCommandChar:
		return tr("Hide command character");

	case ExternalCommand:
		return tr("External command");

	case Variable:
		return tr("Variable");

	case Operator:
		return tr("Operator");
	}

	return TQString();
}


// Returns the background colour of the text for a style.
TQColor TQextScintillaLexerBatch::paper(int style) const
{
	switch (style)
	{
	case Label:
		return TQColor(0x60,0x60,0x60);
	}

	return TQextScintillaLexer::paper(style);
}

#include "tqextscintillalexerbatch.moc"
