/* ============================================================
 *
 * This file is a part of kipi-plugins project
 * http://www.kipi-plugins.org
 *
 * Date        : 2003-02-17
 * Description : a kipi plugin to slide images.
 *
 * Copyright (C) 2006-2007 by Valerio Fuoglio <valerio dot fuoglio at gmail dot com>
 * Copyright (C) 2003-2005 by Renchi Raju <renchi@pooh.tam.uiuc.edu>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#ifndef SLIDESHOWCONFIG_H
#define SLIDESHOWCONFIG_H

// TQt includes.

#include <tqstring.h>
#include <tqlistbox.h>

// KDE includes

#include <tdeconfig.h>
#include <tdeio/previewjob.h>
#include <kurl.h>

// libkipi includes

#include <libkipi/imagedialog.h>
#include <libkipi/interface.h>

// Local includes

#include "slideshowconfigbase.h"

namespace KIPISlideShowPlugin
{
    
class SlideShowConfig : public SlideShowConfigBase
{
    TQ_OBJECT
  

public:

    SlideShowConfig(bool allowSelectedOnly, KIPI::Interface* interface,
                    TQWidget *parent, const char* name, bool ImagesHasComments,
                    KURL::List* urlList);
    ~SlideShowConfig();
    
private slots:

    void slotStartClicked();
    void slotHelp();
    void slotOpenGLToggled();
    void slotEffectChanged();
    void slotDelayChanged();
    void slotUseMillisecondsToggled();
    void slotPrintCommentsToggled();
    void slotCommentsFontColorChanged();
    void slotCommentsBgColorChanged();
    
    void slotSelection();
    void slotCacheToggled();
   
    void SlotPortfolioDurationChanged ( int );
    void slotImagesFilesSelected( TQListBoxItem *item );
    void slotAddDropItems(KURL::List filesUrl);
    void slotImagesFilesButtonAdd( void );
    void slotImagesFilesButtonDelete( void );
    void slotImagesFilesButtonUp( void );
    void slotImagesFilesButtonDown( void );
    void slotGotPreview(const KFileItem* , const TQPixmap &pixmap);
    void slotFailedPreview(const KFileItem*);

signals:

    void buttonStartClicked(); // Signal needed by plugin_slideshow class

private:

    void loadEffectNames();
    void loadEffectNamesGL();
    void readSettings();
    void saveSettings();
    
    void ShowNumberImages( int Number );
    void addItems(const KURL::List& fileList);

private:

    int              m_delayMsMaxValue;
    int              m_delayMsMinValue;
    int              m_delayMsLineStep;
    
    uint             m_cacheSize;
    
    TDEConfig*         m_config;
    
    TQString          m_effectName;
    TQString          m_effectNameGL;
    
    TDEIO::PreviewJob* m_thumbJob;
    KURL::List*      m_urlList;
    
    KIPI::Interface* m_interface;
};

}  // NameSpace KIPISlideShowPlugin

#endif // SLIDESHOWCONFIG_H
