BEGIN { print "1..3\n" }

package MyApp;
use TQt;
use TQt::isa qw(TQt::Application);
use TQt::slots
        foo => ['int'],
        baz => [];
use TQt::signals
        bar => ['int'];

sub NEW {
     shift->SUPER::NEW(@_);

     # 1) testing correct subclassing of TQt::Application and this pointer
     print +(ref(this) eq " MyApp")? "ok 1\n" : "not ok\n";
     
     this->connect(this, TQ_SIGNAL 'bar(int)', TQ_SLOT 'foo(int)');

     # 3) automatic quitting will test TQt sig to custom slot 
     this->connect(this, TQ_SIGNAL 'aboutToQuit()', TQ_SLOT 'baz()');

     # 2) testing custom sig to custom slot 
     emit bar(3);
}

sub foo
{
    print +($_[0] == 3) ? "ok 2\n" : "not ok\n";
}

sub baz
{
    print "ok 3\n";
}     

1;

package main;

use TQt;
use MyApp;

$a = 0;
$a = MyApp(\@ARGV);

TQt::Timer::singleShot( 300, TQt::app(), TQ_SLOT "quit()" );

exit TQt::app()->exec;
