/*
 * Remote Laboratory Authentication Server
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * (c) 2012-2019 Timothy Pearson
 * Raptor Engineering
 * http://www.raptorengineeringinc.com
 */

#include <tqsocket.h>
#include <tqserversocket.h>
#include <tqapplication.h>
#include <tqvbox.h>
#include <tqtextview.h>
#include <tqlabel.h>
#include <tqpushbutton.h>
#include <tqtextstream.h>
#include <tqsqldatabase.h>
#include <tqsqlcursor.h>

#include <ksimpleconfig.h>

#include <tdekrbserversocket.h>
#include <tdekrbclientsocket.h>

#include <tqtrla.h>

#define MAGIC_NUMBER 1
#define PROTOCOL_VERSION 1

class AuthSocket : public TDEKerberosServerSocket
{
	Q_OBJECT

	public:
		AuthSocket(int sock, TQString localMachineFQDN, TQObject *parent=0, const char *name=0);
		~AuthSocket();

	public:
		void close();
		void initiateKerberosHandshake();
		int enterCommandLoop();

	private slots:
		void finishKerberosHandshake();
		int connectToDatabase();
		void connectionClosedHandler();
		void commandLoop();
		int servLoop();
		void pollFlags();

	private:
		void updateStatistics(int eventType);

	private:
		int line;
		int m_criticalSection;
		TQString m_remoteHost;
		int m_stationID;
		bool m_bound;
		int m_serviceID;
		TQString m_localMachineFQDN;
		int m_pollInterval;
		TQ_ULLONG m_terminationStamp;

		bool m_servActive;
		int m_servState;
		TDEKerberosClientSocket* m_servClientSocket;
		TQTimer* m_servClientTimeout;
		TQString m_srvServiceHostName;
		int m_srvServicePort;

		TQTimer* m_kerberosInitTimer;
		TQTimer* m_loopTimer;
		TQTimer* m_pollTimer;
		TQByteArray m_loopBuffer;

		KSimpleConfig* m_config;
		TQSqlDatabase* m_database;
		TQSqlCursor* m_databaseStationsCursor;
		TQSqlCursor* m_databaseServicesCursor;
		TQSqlCursor* m_databaseServiceTypesCursor;
		TQSqlCursor* m_databasePermissionsCursor;
		TQSqlCursor* m_databaseActivityCursor;
		TQSqlCursor* m_databaseStatisticsCursor;
		TQSqlCursor* m_databaseStatusCursor;

		StationList m_slist;

		friend class AuthServer;
};

class AuthServer : public TQServerSocket
{
	Q_OBJECT

	public:
		AuthServer(TQObject* parent=0);
		~AuthServer();
	
		void newConnection(int socket);

	private slots:
		int connectToDatabase();
		void pingSQLServer();
	
	signals:
		void newConnect(AuthSocket*);

	private:
		TQString getLocalMachineFQDN();

	private:
		KSimpleConfig* m_config;
		TQSqlDatabase* m_database;
		TQTimer* m_sqlPingTimer;
		TQString m_localMachineFQDN;

		friend class AuthSocket;

};
