/*
 * Remote Laboratory Authentication Server
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * (c) 2012-2019 Timothy Pearson
 * Raptor Engineering
 * http://www.raptorengineeringinc.com
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <pwd.h>
#include <limits.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>

#include <tdeapplication.h>
#include <tdestartupinfo.h>
#include <tdecmdlineargs.h>
#include <tdeaboutdata.h>

#include <ksimpleconfig.h>

#include <tqdatetime.h>
#include <tqfile.h>

#include "auth_conn.h"

static const TDECmdLineOptions options[] =
{
	{ "+[id]", I18N_NOOP( "Set server id to 'id'" ), 0 },
	{ 0, 0, 0 }
};

static const char description[] = I18N_NOOP("uLab Kerberos Authentication Server");

static const char version[] = "v0.0.1";

int main(int argc, char *argv[])
{
	TDEAboutData aboutData( "ulab_auth_server", I18N_NOOP("uLab AuthServer"),
		version, description, TDEAboutData::License_GPL,
		"(c) 2012-2013, Timothy Pearson");
		aboutData.addAuthor("Timothy Pearson",0, "kb9vqf@pearsoncomputing.net");
	TDECmdLineArgs::init( argc, argv, &aboutData );
	TDECmdLineArgs::addCmdLineOptions(options);
	TDEApplication::disableAutoDcopRegistration();

	TDEApplication app(false, false);

	TDEStartupInfo::appStarted();

	AuthServer authsvr(0);
	return app.exec();

}
