/*
 * Remote Laboratory Instrumentation Server
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * (c) 2009 - 2015 Timothy Pearson
 * Raptor Engineering
 * http://www.raptorengineeringinc.com
 */

namespace companalyzer_status {
	typedef enum companalyzer_status {
		ok = 		0x00000001,
		overflow = 	0x00000002,
		invalid = 	0x00000004,
		cal_req = 	0x00000008
	} companalyzer_status_t;
}

namespace companalyzer_measurement {
	typedef enum companalyzer_measurement {
		resistance =		0,	/* R */
		reactance =		1,	/* X */
		conductance =		2,	/* G */
		susceptance =		3,	/* B */
		inductance =		4,	/* L */
		capacitance =		5,	/* C */
		dissipation_factor =	6,	/* D */
		quality_factor =	7,	/* Q */
		impedance =		8,	/* |Z| */
		admittance =		9,	/* |Y| */
		reflection_absolute =	10,	/* |Γ| */
		reflection_x =		11,	/* Γx */
		reflection_y =		12,	/* Γy */
		phase_angle_deg =	13,	/* Ө (d) */
		phase_angle_rad =	14	/* Ө (r) */
	} companalyzer_measurement_t;
}

namespace companalyzer_measurement_type {
	typedef enum companalyzer_measurement_type {
		normal =		0,
		deviation =		1,
		deviation_percent =	2
	} companalyzer_measurement_type_t;
}

typedef struct companalyzer_measurements {
	companalyzer_status::companalyzer_status_t parameter_a_status;
	companalyzer_status::companalyzer_status_t parameter_b_status;
	companalyzer_measurement::companalyzer_measurement_t parameter_a;
	companalyzer_measurement::companalyzer_measurement_t parameter_b;
	companalyzer_measurement_type::companalyzer_measurement_type parameter_a_type;
	companalyzer_measurement_type::companalyzer_measurement_type parameter_b_type;
	double parameter_a_value;
	double parameter_b_value;
	double frequency;
} companalyzer_measurements_t;

int companalyzer_set_date(struct tm * datetime, const char * companalyzerType, int gpibDevice);
int companalyzer_set_time(struct tm * datetime, const char * companalyzerType, int gpibDevice);
int companalyzer_lock_local_controls (const char * companalyzerType, int gpibDevice);

int companalyzer_set_measurement_parameters(companalyzer_measurement::companalyzer_measurement_t parameter_a, companalyzer_measurement::companalyzer_measurement_t parameter_b, const char * companalyzerType, int gpibDevice, char * extendedError);
int companalyzer_set_measurement_frequency(double frequency, const char * companalyzerType, int gpibDevice, char * extendedError);
int companalyzer_get_max_measurement_frequency(double * frequency, const char * companalyzerType, int gpibDevice, char * extendedError);
int companalyzer_get_min_measurement_frequency(double * frequency, const char * companalyzerType, int gpibDevice, char * extendedError);
int companalyzer_get_parameter_measurement (companalyzer_measurements_t * retval, const char * companalyzerType, int gpibDevice);