# RUN: llvm-mc %s -triple=mips-unknown-linux -show-encoding -mcpu=mips32r2 | \
# RUN:   FileCheck %s
# RUN: llvm-mc %s -triple=mips-unknown-linux -show-encoding -mcpu=mips32r6 | \
# RUN:   FileCheck %s
# RUN: llvm-mc %s -triple=mips64-unknown-linux -show-encoding -mcpu=mips64r2 | \
# RUN:   FileCheck %s
# RUN: llvm-mc %s -triple=mips64-unknown-linux -show-encoding -mcpu=mips64r6 | \
# RUN:   FileCheck %s

li $5, 0x00000001 # CHECK: addiu $5, $zero, 1      # encoding: [0x24,0x05,0x00,0x01]
li $5, 0x00000002 # CHECK: addiu $5, $zero, 2      # encoding: [0x24,0x05,0x00,0x02]
li $5, 0x00004000 # CHECK: addiu $5, $zero, 16384  # encoding: [0x24,0x05,0x40,0x00]
li $5, 0x00008000 # CHECK: ori   $5, $zero, 32768  # encoding: [0x34,0x05,0x80,0x00]
li $5, 0xffffffff # CHECK: addiu $5, $zero, -1     # encoding: [0x24,0x05,0xff,0xff]
li $5, 0xfffffffe # CHECK: addiu $5, $zero, -2     # encoding: [0x24,0x05,0xff,0xfe]
li $5, 0xffffc000 # CHECK: addiu $5, $zero, -16384 # encoding: [0x24,0x05,0xc0,0x00]
li $5, 0xffff8000 # CHECK: addiu $5, $zero, -32768 # encoding: [0x24,0x05,0x80,0x00]

li $5, 0x00010000 # CHECK: lui $5, 1      # encoding: [0x3c,0x05,0x00,0x01]
li $5, 0x00020000 # CHECK: lui $5, 2      # encoding: [0x3c,0x05,0x00,0x02]
li $5, 0x40000000 # CHECK: lui $5, 16384  # encoding: [0x3c,0x05,0x40,0x00]
li $5, 0x80000000 # CHECK: lui $5, 32768  # encoding: [0x3c,0x05,0x80,0x00]
li $5, 0xffff0000 # CHECK: lui $5, 65535  # encoding: [0x3c,0x05,0xff,0xff]
li $5, 0xfffe0000 # CHECK: lui $5, 65534  # encoding: [0x3c,0x05,0xff,0xfe]
li $5, 0xc0000000 # CHECK: lui $5, 49152  # encoding: [0x3c,0x05,0xc0,0x00]
li $5, 0x80000000 # CHECK: lui $5, 32768  # encoding: [0x3c,0x05,0x80,0x00]

li $5, 0x00010001 # CHECK: lui $5, 1        # encoding: [0x3c,0x05,0x00,0x01]
                  # CHECK: ori $5, $5, 1    # encoding: [0x34,0xa5,0x00,0x01]
li $5, 0x00020001 # CHECK: lui $5, 2        # encoding: [0x3c,0x05,0x00,0x02]
                  # CHECK: ori $5, $5, 1    # encoding: [0x34,0xa5,0x00,0x01]
li $5, 0x40000001 # CHECK: lui $5, 16384    # encoding: [0x3c,0x05,0x40,0x00]
                  # CHECK: ori $5, $5, 1    # encoding: [0x34,0xa5,0x00,0x01]
li $5, 0x80000001 # CHECK: lui $5, 32768    # encoding: [0x3c,0x05,0x80,0x00]
                  # CHECK: ori $5, $5, 1    # encoding: [0x34,0xa5,0x00,0x01]
li $5, 0x00010002 # CHECK: lui $5, 1        # encoding: [0x3c,0x05,0x00,0x01]
                  # CHECK: ori $5, $5, 2    # encoding: [0x34,0xa5,0x00,0x02]
li $5, 0x00020002 # CHECK: lui $5, 2        # encoding: [0x3c,0x05,0x00,0x02]
                  # CHECK: ori $5, $5, 2    # encoding: [0x34,0xa5,0x00,0x02]
li $5, 0x40000002 # CHECK: lui $5, 16384    # encoding: [0x3c,0x05,0x40,0x00]
                  # CHECK: ori $5, $5, 2    # encoding: [0x34,0xa5,0x00,0x02]
li $5, 0x80000002 # CHECK: lui $5, 32768    # encoding: [0x3c,0x05,0x80,0x00]
                  # CHECK: ori $5, $5, 2    # encoding: [0x34,0xa5,0x00,0x02]
li $5, 0x00014000 # CHECK: lui $5, 1        # encoding: [0x3c,0x05,0x00,0x01]
                  # CHECK: ori $5, $5, 16384    # encoding: [0x34,0xa5,0x40,0x00]
li $5, 0x00024000 # CHECK: lui $5, 2            # encoding: [0x3c,0x05,0x00,0x02]
                  # CHECK: ori $5, $5, 16384    # encoding: [0x34,0xa5,0x40,0x00]
li $5, 0x40004000 # CHECK: lui $5, 16384        # encoding: [0x3c,0x05,0x40,0x00]
                  # CHECK: ori $5, $5, 16384    # encoding: [0x34,0xa5,0x40,0x00]
li $5, 0x80004000 # CHECK: lui $5, 32768        # encoding: [0x3c,0x05,0x80,0x00]
                  # CHECK: ori $5, $5, 16384    # encoding: [0x34,0xa5,0x40,0x00]
li $5, 0x00018000 # CHECK: lui $5, 1            # encoding: [0x3c,0x05,0x00,0x01]
                  # CHECK: ori $5, $5, 32768    # encoding: [0x34,0xa5,0x80,0x00]
li $5, 0x00028000 # CHECK: lui $5, 2            # encoding: [0x3c,0x05,0x00,0x02]
                  # CHECK: ori $5, $5, 32768    # encoding: [0x34,0xa5,0x80,0x00]
li $5, 0x40008000 # CHECK: lui $5, 16384        # encoding: [0x3c,0x05,0x40,0x00]
                  # CHECK: ori $5, $5, 32768    # encoding: [0x34,0xa5,0x80,0x00]
li $5, 0x80008000 # CHECK: lui $5, 32768        # encoding: [0x3c,0x05,0x80,0x00]
                  # CHECK: ori $5, $5, 32768    # encoding: [0x34,0xa5,0x80,0x00]
li $5, 0xffff4000 # CHECK: lui $5, 65535        # encoding: [0x3c,0x05,0xff,0xff]
                  # CHECK: ori $5, $5, 16384    # encoding: [0x34,0xa5,0x40,0x00]
li $5, 0xfffe8000 # CHECK: lui $5, 65534        # encoding: [0x3c,0x05,0xff,0xfe]
                  # CHECK: ori $5, $5, 32768    # encoding: [0x34,0xa5,0x80,0x00]
li $5, 0xc0008000 # CHECK: lui $5, 49152        # encoding: [0x3c,0x05,0xc0,0x00]
                  # CHECK: ori $5, $5, 32768    # encoding: [0x34,0xa5,0x80,0x00]
li $5, 0x80008000 # CHECK: lui $5, 32768        # encoding: [0x3c,0x05,0x80,0x00]
                  # CHECK: ori $5, $5, 32768    # encoding: [0x34,0xa5,0x80,0x00]
li $4, ~0xffffffff # CHECK; addiu $4, $zero, 0  # encoding: [0x24,0x04,0x00,0x00]
li $4, ~0x80000001 # CHECK: lui $4, 32767       # encoding: [0x3c,0x04,0x7f,0xff]
                   # CHECK: ori $4, $4, 65534   # encoding: [0x34,0x84,0xff,0xfe]
li $4, ~0x80000000 # CHECK: lui $4, 32767       # encoding: [0x3c,0x04,0x7f,0xff]
                   # CHECK: ori $4, $4, 65535   # encoding: [0x34,0x84,0xff,0xff]
li $4, ~0x7fffffff # CHECK: lui $4, 32768       # encoding: [0x3c,0x04,0x80,0x00]
li $4, ~0x00000001 # CHECK: addiu $4, $zero, -2 # encoding: [0x24,0x04,0xff,0xfe]
li $4, ~0x00000000 # CHECK: addiu $4, $zero, -1 # encoding: [0x24,0x04,0xff,0xff]
