/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.testing.SampleElements;
import com.google.common.collect.testing.TestListGenerator;
import com.google.common.collect.testing.TestStringMapGenerator;
import com.google.common.collect.testing.TestUnhashableCollectionGenerator;
import com.google.common.collect.testing.UnhashableObject;
import java.util.Collection;
import java.util.List;
import java.util.Map;

@GwtCompatible
public class MapGenerators {
    private static String toStringOrNull(Object o) {
        return o == null ? null : o.toString();
    }

    public static class ImmutableMapValueListGenerator
    implements TestListGenerator<String> {
        @Override
        public SampleElements<String> samples() {
            return new SampleElements.Strings();
        }

        @Override
        public List<String> create(Object ... elements) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (int i = 0; i < elements.length; ++i) {
                builder.put((Object)i, (Object)MapGenerators.toStringOrNull(elements[i]));
            }
            return builder.build().values().asList();
        }

        public String[] createArray(int length) {
            return new String[length];
        }

        @Override
        public Iterable<String> order(List<String> insertionOrder) {
            return insertionOrder;
        }
    }

    public static class ImmutableMapUnhashableValuesGenerator
    extends TestUnhashableCollectionGenerator<Collection<UnhashableObject>> {
        @Override
        public Collection<UnhashableObject> create(UnhashableObject[] elements) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            int key = 1;
            for (UnhashableObject value : elements) {
                builder.put((Object)key++, (Object)value);
            }
            return builder.build().values();
        }
    }

    public static class ImmutableMapGenerator
    extends TestStringMapGenerator {
        @Override
        protected Map<String, String> create(Map.Entry<String, String>[] entries) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry<String, String> entry : entries) {
                builder.put((Object)entry.getKey(), (Object)entry.getValue());
            }
            return builder.build();
        }
    }
}

