/* ContainerSourceCollection.c generated by valac 0.36.6, the Vala compiler
 * generated from ContainerSourceCollection.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */
/* A ContainerSourceCollection is for DataSources which maintain links to one or more other*/
/* DataSources, assumed to be of a different type.  ContainerSourceCollection automates the task*/
/* of handling unlinking and relinking and maintaining backlinks.  Unlinked DataSources are*/
/* held in a holding tank, until they are either relinked or destroyed.*/
/**/
/* If the ContainerSourceCollection's DataSources are types that "evaporate" (i.e. they disappear*/
/* when they hold no items), they should use the evaporate() method, which will either destroy*/
/* the DataSource or hold it in the tank (if backlinks are outstanding).*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;
typedef struct _DataCollectionPrivate DataCollectionPrivate;

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_ALTERATION (alteration_get_type ())
#define ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALTERATION, Alteration))
#define ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALTERATION, AlterationClass))
#define IS_ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALTERATION))
#define IS_ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALTERATION))
#define ALTERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALTERATION, AlterationClass))

typedef struct _Alteration Alteration;
typedef struct _AlterationClass AlterationClass;

#define TYPE_MARKER (marker_get_type ())
#define MARKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MARKER, Marker))
#define IS_MARKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MARKER))
#define MARKER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MARKER, MarkerIface))

typedef struct _Marker Marker;
typedef struct _MarkerIface MarkerIface;

#define TYPE_SOURCE_COLLECTION (source_collection_get_type ())
#define SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_COLLECTION, SourceCollection))
#define SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_COLLECTION, SourceCollectionClass))
#define IS_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_COLLECTION))
#define IS_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_COLLECTION))
#define SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_COLLECTION, SourceCollectionClass))

typedef struct _SourceCollection SourceCollection;
typedef struct _SourceCollectionClass SourceCollectionClass;
typedef struct _SourceCollectionPrivate SourceCollectionPrivate;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_SOURCE_BACKLINK (source_backlink_get_type ())
#define SOURCE_BACKLINK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_BACKLINK, SourceBacklink))
#define SOURCE_BACKLINK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_BACKLINK, SourceBacklinkClass))
#define IS_SOURCE_BACKLINK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_BACKLINK))
#define IS_SOURCE_BACKLINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_BACKLINK))
#define SOURCE_BACKLINK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_BACKLINK, SourceBacklinkClass))

typedef struct _SourceBacklink SourceBacklink;
typedef struct _SourceBacklinkClass SourceBacklinkClass;

#define TYPE_DATABASE_SOURCE_COLLECTION (database_source_collection_get_type ())
#define DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection))
#define DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))
#define IS_DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_SOURCE_COLLECTION))
#define IS_DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_SOURCE_COLLECTION))
#define DATABASE_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))

typedef struct _DatabaseSourceCollection DatabaseSourceCollection;
typedef struct _DatabaseSourceCollectionClass DatabaseSourceCollectionClass;
typedef struct _DatabaseSourceCollectionPrivate DatabaseSourceCollectionPrivate;

#define TYPE_CONTAINER_SOURCE_COLLECTION (container_source_collection_get_type ())
#define CONTAINER_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection))
#define CONTAINER_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollectionClass))
#define IS_CONTAINER_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONTAINER_SOURCE_COLLECTION))
#define IS_CONTAINER_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONTAINER_SOURCE_COLLECTION))
#define CONTAINER_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollectionClass))

typedef struct _ContainerSourceCollection ContainerSourceCollection;
typedef struct _ContainerSourceCollectionClass ContainerSourceCollectionClass;
typedef struct _ContainerSourceCollectionPrivate ContainerSourceCollectionPrivate;

#define TYPE_CONTAINER_SOURCE (container_source_get_type ())
#define CONTAINER_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONTAINER_SOURCE, ContainerSource))
#define IS_CONTAINER_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONTAINER_SOURCE))
#define CONTAINER_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_CONTAINER_SOURCE, ContainerSourceIface))

typedef struct _ContainerSource ContainerSource;
typedef struct _ContainerSourceIface ContainerSourceIface;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))
#define _source_backlink_unref0(var) ((var == NULL) ? NULL : (var = (source_backlink_unref (var), NULL)))

#define TYPE_TAG (tag_get_type ())
#define TAG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAG, Tag))
#define TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAG, TagClass))
#define IS_TAG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAG))
#define IS_TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAG))
#define TAG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAG, TagClass))

typedef struct _Tag Tag;
typedef struct _TagClass TagClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;
enum  {
	CONTAINER_SOURCE_COLLECTION_CONTAINER_CONTENTS_ADDED_SIGNAL,
	CONTAINER_SOURCE_COLLECTION_CONTAINER_CONTENTS_REMOVED_SIGNAL,
	CONTAINER_SOURCE_COLLECTION_CONTAINER_CONTENTS_ALTERED_SIGNAL,
	CONTAINER_SOURCE_COLLECTION_BACKLINK_TO_CONTAINER_REMOVED_SIGNAL,
	CONTAINER_SOURCE_COLLECTION_LAST_SIGNAL
};
static guint container_source_collection_signals[CONTAINER_SOURCE_COLLECTION_LAST_SIGNAL] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef gint64 (*Comparator) (void* a, void* b, void* user_data);
typedef gboolean (*ComparatorPredicate) (DataObject* object, Alteration* alteration, void* user_data);
typedef gboolean (*ProgressMonitor) (guint64 current, guint64 total, gboolean do_event_loop, void* user_data);
struct _MarkerIface {
	GTypeInterface parent_iface;
	void (*mark) (Marker* self, DataObject* object);
	void (*unmark) (Marker* self, DataObject* object);
	gboolean (*toggle) (Marker* self, DataObject* object);
	void (*mark_many) (Marker* self, GeeCollection* list);
	void (*unmark_many) (Marker* self, GeeCollection* list);
	void (*mark_all) (Marker* self);
	gint (*get_count) (Marker* self);
	GeeCollection* (*get_all) (Marker* self);
};

struct _DataCollection {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DataCollectionPrivate * priv;
};

struct _DataCollectionClass {
	GTypeClass parent_class;
	void (*finalize) (DataCollection *self);
	gchar* (*to_string) (DataCollection* self);
	void (*notify_items_added) (DataCollection* self, GeeIterable* added);
	void (*notify_items_removed) (DataCollection* self, GeeIterable* removed);
	void (*notify_contents_altered) (DataCollection* self, GeeIterable* added, GeeIterable* removed);
	void (*notify_items_altered) (DataCollection* self, GeeMap* items);
	void (*notify_ordering_changed) (DataCollection* self);
	void (*notify_property_set) (DataCollection* self, const gchar* name, GValue* old, GValue* val);
	void (*notify_property_cleared) (DataCollection* self, const gchar* name);
	gboolean (*valid_type) (DataCollection* self, DataObject* object);
	void (*set_comparator) (DataCollection* self, Comparator comparator, void* comparator_target, ComparatorPredicate predicate, void* predicate_target);
	void (*reset_comparator) (DataCollection* self);
	GeeCollection* (*get_all) (DataCollection* self);
	gint (*get_count) (DataCollection* self);
	DataObject* (*get_at) (DataCollection* self, gint index);
	gint (*index_of) (DataCollection* self, DataObject* object);
	gboolean (*contains) (DataCollection* self, DataObject* object);
	gboolean (*add) (DataCollection* self, DataObject* object);
	GeeCollection* (*add_many) (DataCollection* self, GeeCollection* objects, ProgressMonitor monitor, void* monitor_target);
	void (*remove_marked) (DataCollection* self, Marker* m);
	void (*clear) (DataCollection* self);
	void (*close) (DataCollection* self);
	void (*notify_frozen) (DataCollection* self);
	void (*notify_thawed) (DataCollection* self);
	void (*items_added) (DataCollection* self, GeeIterable* added);
	void (*items_removed) (DataCollection* self, GeeIterable* removed);
	void (*contents_altered) (DataCollection* self, GeeIterable* added, GeeIterable* removed);
	void (*items_altered) (DataCollection* self, GeeMap* items);
	void (*ordering_changed) (DataCollection* self);
	void (*property_set) (DataCollection* self, const gchar* name, GValue* old, GValue* val);
	void (*property_cleared) (DataCollection* self, const gchar* name);
	void (*frozen) (DataCollection* self);
	void (*thawed) (DataCollection* self);
};

struct _SourceCollection {
	DataCollection parent_instance;
	SourceCollectionPrivate * priv;
};

struct _SourceCollectionClass {
	DataCollectionClass parent_class;
	gboolean (*holds_type_of_source) (SourceCollection* self, DataSource* source);
	void (*notify_items_unlinking) (SourceCollection* self, GeeCollection* unlinking);
	void (*notify_items_relinked) (SourceCollection* self, GeeCollection* relinked);
	void (*notify_item_destroyed) (SourceCollection* self, DataSource* source);
	void (*notify_items_destroyed) (SourceCollection* self, GeeCollection* destroyed);
	void (*notify_unlinked_destroyed) (SourceCollection* self, DataSource* unlinked);
	void (*notify_backlink_removed) (SourceCollection* self, SourceBacklink* backlink, GeeCollection* sources);
	gboolean (*has_backlink) (SourceCollection* self, SourceBacklink* backlink);
	void (*remove_backlink) (SourceCollection* self, SourceBacklink* backlink);
	void (*items_unlinking) (SourceCollection* self, GeeCollection* unlinking);
	void (*items_relinked) (SourceCollection* self, GeeCollection* relinked);
	void (*item_destroyed) (SourceCollection* self, DataSource* source);
	void (*items_destroyed) (SourceCollection* self, GeeCollection* destroyed);
	void (*unlinked_destroyed) (SourceCollection* self, DataSource* source);
	void (*backlink_removed) (SourceCollection* self, SourceBacklink* backlink, GeeCollection* sources);
};

struct _DatabaseSourceCollection {
	SourceCollection parent_instance;
	DatabaseSourceCollectionPrivate * priv;
};

struct _DatabaseSourceCollectionClass {
	SourceCollectionClass parent_class;
};

struct _ContainerSourceIface {
	GTypeInterface parent_iface;
	gboolean (*has_links) (ContainerSource* self);
	SourceBacklink* (*get_backlink) (ContainerSource* self);
	void (*break_link) (ContainerSource* self, DataSource* source);
	void (*break_link_many) (ContainerSource* self, GeeCollection* sources);
	void (*establish_link) (ContainerSource* self, DataSource* source);
	void (*establish_link_many) (ContainerSource* self, GeeCollection* sources);
};

struct _ContainerSourceCollection {
	DatabaseSourceCollection parent_instance;
	ContainerSourceCollectionPrivate * priv;
};

struct _ContainerSourceCollectionClass {
	DatabaseSourceCollectionClass parent_class;
	void (*notify_container_contents_added) (ContainerSourceCollection* self, ContainerSource* container, GeeCollection* added, gboolean relinked);
	void (*notify_container_contents_removed) (ContainerSourceCollection* self, ContainerSource* container, GeeCollection* removed, gboolean unlinked);
	void (*notify_container_contents_altered) (ContainerSourceCollection* self, ContainerSource* container, GeeCollection* added, gboolean relinked, GeeCollection* removed, gboolean unlinked);
	void (*notify_backlink_to_container_removed) (ContainerSourceCollection* self, ContainerSource* container, GeeCollection* sources);
	GeeCollection* (*get_containers_holding_source) (ContainerSourceCollection* self, DataSource* source);
	ContainerSource* (*convert_backlink_to_container) (ContainerSourceCollection* self, SourceBacklink* backlink);
	void (*container_contents_added) (ContainerSourceCollection* self, ContainerSource* container, GeeCollection* added, gboolean relinked);
	void (*container_contents_removed) (ContainerSourceCollection* self, ContainerSource* container, GeeCollection* removed, gboolean unlinked);
	void (*container_contents_altered) (ContainerSourceCollection* self, ContainerSource* container, GeeCollection* added, gboolean relinked, GeeCollection* removed, gboolean unlinked);
	void (*backlink_to_container_removed) (ContainerSourceCollection* self, ContainerSource* container, GeeCollection* sources);
};

struct _ContainerSourceCollectionPrivate {
	GeeHashSet* attached_collections;
	gchar* backlink_name;
	GeeHashSet* holding_tank;
};

typedef gint64 (*GetSourceDatabaseKey) (DataSource* source, void* user_data);

static gpointer container_source_collection_parent_class = NULL;

gpointer data_collection_ref (gpointer instance);
void data_collection_unref (gpointer instance);
GParamSpec* param_spec_data_collection (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_data_collection (GValue* value, gpointer v_object);
void value_take_data_collection (GValue* value, gpointer v_object);
gpointer value_get_data_collection (const GValue* value);
GType data_collection_get_type (void) G_GNUC_CONST;
GType data_object_get_type (void) G_GNUC_CONST;
gpointer alteration_ref (gpointer instance);
void alteration_unref (gpointer instance);
GParamSpec* param_spec_alteration (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_alteration (GValue* value, gpointer v_object);
void value_take_alteration (GValue* value, gpointer v_object);
gpointer value_get_alteration (const GValue* value);
GType alteration_get_type (void) G_GNUC_CONST;
GType marker_get_type (void) G_GNUC_CONST;
GType source_collection_get_type (void) G_GNUC_CONST;
GType data_source_get_type (void) G_GNUC_CONST;
gpointer source_backlink_ref (gpointer instance);
void source_backlink_unref (gpointer instance);
GParamSpec* param_spec_source_backlink (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_source_backlink (GValue* value, gpointer v_object);
void value_take_source_backlink (GValue* value, gpointer v_object);
gpointer value_get_source_backlink (const GValue* value);
GType source_backlink_get_type (void) G_GNUC_CONST;
GType database_source_collection_get_type (void) G_GNUC_CONST;
GType container_source_collection_get_type (void) G_GNUC_CONST;
GType container_source_get_type (void) G_GNUC_CONST;
#define CONTAINER_SOURCE_COLLECTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollectionPrivate))
enum  {
	CONTAINER_SOURCE_COLLECTION_DUMMY_PROPERTY
};
void container_source_collection_detach_all_collections (ContainerSourceCollection* self);
ContainerSourceCollection* container_source_collection_construct (GType object_type, const gchar* backlink_name, const gchar* name, GetSourceDatabaseKey source_key_func, void* source_key_func_target);
DatabaseSourceCollection* database_source_collection_construct (GType object_type, const gchar* name, GetSourceDatabaseKey source_key_func, void* source_key_func_target);
static void container_source_collection_real_notify_backlink_removed (SourceCollection* base, SourceBacklink* backlink, GeeCollection* sources);
void source_collection_notify_backlink_removed (SourceCollection* self, SourceBacklink* backlink, GeeCollection* sources);
ContainerSource* container_source_collection_convert_backlink_to_container (ContainerSourceCollection* self, SourceBacklink* backlink);
void container_source_collection_notify_backlink_to_container_removed (ContainerSourceCollection* self, ContainerSource* container, GeeCollection* sources);
void container_source_collection_notify_container_contents_added (ContainerSourceCollection* self, ContainerSource* container, GeeCollection* added, gboolean relinked);
static void container_source_collection_real_notify_container_contents_added (ContainerSourceCollection* self, ContainerSource* container, GeeCollection* added, gboolean relinked);
void source_collection_relink (SourceCollection* self, DataSource* source);
void container_source_collection_notify_container_contents_removed (ContainerSourceCollection* self, ContainerSource* container, GeeCollection* removed, gboolean unlinked);
static void container_source_collection_real_notify_container_contents_removed (ContainerSourceCollection* self, ContainerSource* container, GeeCollection* removed, gboolean unlinked);
void container_source_collection_notify_container_contents_altered (ContainerSourceCollection* self, ContainerSource* container, GeeCollection* added, gboolean relinked, GeeCollection* removed, gboolean unlinked);
static void container_source_collection_real_notify_container_contents_altered (ContainerSourceCollection* self, ContainerSource* container, GeeCollection* added, gboolean relinked, GeeCollection* removed, gboolean unlinked);
static void container_source_collection_real_notify_backlink_to_container_removed (ContainerSourceCollection* self, ContainerSource* container, GeeCollection* sources);
GeeCollection* container_source_collection_get_containers_holding_source (ContainerSourceCollection* self, DataSource* source);
static GeeCollection* container_source_collection_real_get_containers_holding_source (ContainerSourceCollection* self, DataSource* source);
static ContainerSource* container_source_collection_real_convert_backlink_to_container (ContainerSourceCollection* self, SourceBacklink* backlink);
void container_source_collection_freeze_attached_notifications (ContainerSourceCollection* self);
void data_collection_freeze_notifications (DataCollection* self);
void container_source_collection_thaw_attached_notifications (ContainerSourceCollection* self);
void data_collection_thaw_notifications (DataCollection* self);
GeeCollection* container_source_collection_get_holding_tank (ContainerSourceCollection* self);
void container_source_collection_init_add_unlinked (ContainerSourceCollection* self, ContainerSource* unlinked);
void container_source_collection_init_add_many_unlinked (ContainerSourceCollection* self, GeeCollection* unlinked);
gboolean container_source_collection_relink_from_holding_tank (ContainerSourceCollection* self, ContainerSource* source);
static void container_source_collection_on_contained_sources_unlinking (ContainerSourceCollection* self, GeeCollection* unlinking);
void data_source_set_backlink (DataSource* self, SourceBacklink* backlink);
SourceBacklink* container_source_get_backlink (ContainerSource* self);
void container_source_break_link_many (ContainerSource* self, GeeCollection* sources);
static void container_source_collection_on_contained_sources_relinked (ContainerSourceCollection* self, GeeCollection* relinked);
GeeList* data_source_get_backlinks (DataSource* self, const gchar* name);
gchar* data_object_to_string (DataObject* self);
gchar* source_backlink_to_string (SourceBacklink* self);
void container_source_establish_link_many (ContainerSource* self, GeeCollection* sources);
static void container_source_collection_on_contained_source_destroyed (ContainerSourceCollection* self, DataSource* source);
gboolean container_source_has_links (ContainerSource* self);
GType tag_get_type (void) G_GNUC_CONST;
gboolean data_source_destroy_orphan (DataSource* self, gboolean delete_backing);
static void container_source_collection_real_notify_item_destroyed (SourceCollection* base, DataSource* source);
void source_collection_remove_backlink (SourceCollection* self, SourceBacklink* backlink);
void source_collection_notify_item_destroyed (SourceCollection* self, DataSource* source);
void container_source_collection_evaporate (ContainerSourceCollection* self, ContainerSource* container);
gboolean source_collection_has_backlink (SourceCollection* self, SourceBacklink* backlink);
GeeCollection* source_collection_unlink_marked (SourceCollection* self, Marker* marker, ProgressMonitor monitor, void* monitor_target);
Marker* data_collection_mark (DataCollection* self, DataObject* object);
GType thumbnail_source_get_type (void) G_GNUC_CONST;
GType media_source_get_type (void) G_GNUC_CONST;
gint source_collection_destroy_marked (SourceCollection* self, Marker* marker, gboolean delete_backing, ProgressMonitor monitor, void* monitor_target, GeeList* not_removed);
void container_source_collection_attach_collection (ContainerSourceCollection* self, SourceCollection* collection);
gchar* data_collection_to_string (DataCollection* self);
static void _container_source_collection_on_contained_sources_unlinking_source_collection_items_unlinking (SourceCollection* _sender, GeeCollection* unlinking, gpointer self);
static void _container_source_collection_on_contained_sources_relinked_source_collection_items_relinked (SourceCollection* _sender, GeeCollection* relinked, gpointer self);
static void _container_source_collection_on_contained_source_destroyed_source_collection_item_destroyed (SourceCollection* _sender, DataSource* source, gpointer self);
static void _container_source_collection_on_contained_source_destroyed_source_collection_unlinked_destroyed (SourceCollection* _sender, DataSource* source, gpointer self);
static void container_source_collection_real_container_contents_added (ContainerSourceCollection* self, ContainerSource* container, GeeCollection* added, gboolean relinked);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void container_source_collection_real_container_contents_removed (ContainerSourceCollection* self, ContainerSource* container, GeeCollection* removed, gboolean unlinked);
static void container_source_collection_real_container_contents_altered (ContainerSourceCollection* self, ContainerSource* container, GeeCollection* added, gboolean relinked, GeeCollection* removed, gboolean unlinked);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT_BOOLEAN_OBJECT_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void container_source_collection_real_backlink_to_container_removed (ContainerSourceCollection* self, ContainerSource* container, GeeCollection* sources);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void container_source_collection_finalize (DataCollection * obj);


ContainerSourceCollection* container_source_collection_construct (GType object_type, const gchar* backlink_name, const gchar* name, GetSourceDatabaseKey source_key_func, void* source_key_func_target) {
	ContainerSourceCollection* self = NULL;
	const gchar* _tmp0_;
	GetSourceDatabaseKey _tmp1_;
	void* _tmp1__target;
	const gchar* _tmp2_;
	gchar* _tmp3_;
#line 38 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	g_return_val_if_fail (backlink_name != NULL, NULL);
#line 38 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 40 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_tmp0_ = name;
#line 40 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_tmp1_ = source_key_func;
#line 40 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_tmp1__target = source_key_func_target;
#line 40 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	self = (ContainerSourceCollection*) database_source_collection_construct (object_type, _tmp0_, _tmp1_, _tmp1__target);
#line 42 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_tmp2_ = backlink_name;
#line 42 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 42 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_g_free0 (self->priv->backlink_name);
#line 42 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	self->priv->backlink_name = _tmp3_;
#line 38 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	return self;
#line 428 "ContainerSourceCollection.c"
}


static void container_source_collection_real_notify_backlink_removed (SourceCollection* base, SourceBacklink* backlink, GeeCollection* sources) {
	ContainerSourceCollection * self;
	SourceBacklink* _tmp0_;
	GeeCollection* _tmp1_;
	ContainerSource* container = NULL;
	SourceBacklink* _tmp2_;
	ContainerSource* _tmp3_;
	ContainerSource* _tmp4_;
#line 49 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection);
#line 49 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	g_return_if_fail (IS_SOURCE_BACKLINK (backlink));
#line 49 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	g_return_if_fail (GEE_IS_COLLECTION (sources));
#line 51 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_tmp0_ = backlink;
#line 51 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_tmp1_ = sources;
#line 51 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	SOURCE_COLLECTION_CLASS (container_source_collection_parent_class)->notify_backlink_removed (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection), TYPE_SOURCE_COLLECTION, SourceCollection), _tmp0_, _tmp1_);
#line 53 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_tmp2_ = backlink;
#line 53 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_tmp3_ = container_source_collection_convert_backlink_to_container (self, _tmp2_);
#line 53 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	container = _tmp3_;
#line 54 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_tmp4_ = container;
#line 54 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	if (_tmp4_ != NULL) {
#line 462 "ContainerSourceCollection.c"
		ContainerSource* _tmp5_;
		GeeCollection* _tmp6_;
#line 55 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_tmp5_ = container;
#line 55 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_tmp6_ = sources;
#line 55 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		container_source_collection_notify_backlink_to_container_removed (self, _tmp5_, _tmp6_);
#line 471 "ContainerSourceCollection.c"
	}
#line 49 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_g_object_unref0 (container);
#line 475 "ContainerSourceCollection.c"
}


static void container_source_collection_real_notify_container_contents_added (ContainerSourceCollection* self, ContainerSource* container, GeeCollection* added, gboolean relinked) {
	GeeHashSet* _tmp0_;
	ContainerSource* _tmp1_;
	gboolean _tmp2_;
	ContainerSource* _tmp8_;
	GeeCollection* _tmp9_;
	gboolean _tmp10_;
#line 58 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	g_return_if_fail (IS_CONTAINER_SOURCE (container));
#line 58 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	g_return_if_fail (GEE_IS_COLLECTION (added));
#line 61 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_tmp0_ = self->priv->holding_tank;
#line 61 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_tmp1_ = container;
#line 61 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_tmp2_ = gee_abstract_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp1_);
#line 61 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	if (_tmp2_) {
#line 498 "ContainerSourceCollection.c"
		gboolean removed = FALSE;
		GeeHashSet* _tmp3_;
		ContainerSource* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		ContainerSource* _tmp7_;
#line 62 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_tmp3_ = self->priv->holding_tank;
#line 62 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_tmp4_ = container;
#line 62 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_tmp5_ = gee_abstract_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp4_);
#line 62 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		removed = _tmp5_;
#line 63 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_tmp6_ = removed;
#line 63 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_vala_assert (_tmp6_, "removed");
#line 65 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_tmp7_ = container;
#line 65 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		source_collection_relink (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SOURCE_COLLECTION, SourceCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_DATA_SOURCE, DataSource));
#line 521 "ContainerSourceCollection.c"
	}
#line 68 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_tmp8_ = container;
#line 68 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_tmp9_ = added;
#line 68 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_tmp10_ = relinked;
#line 68 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	g_signal_emit (self, container_source_collection_signals[CONTAINER_SOURCE_COLLECTION_CONTAINER_CONTENTS_ADDED_SIGNAL], 0, _tmp8_, _tmp9_, _tmp10_);
#line 531 "ContainerSourceCollection.c"
}


void container_source_collection_notify_container_contents_added (ContainerSourceCollection* self, ContainerSource* container, GeeCollection* added, gboolean relinked) {
#line 58 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	g_return_if_fail (IS_CONTAINER_SOURCE_COLLECTION (self));
#line 58 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	CONTAINER_SOURCE_COLLECTION_GET_CLASS (self)->notify_container_contents_added (self, container, added, relinked);
#line 540 "ContainerSourceCollection.c"
}


static void container_source_collection_real_notify_container_contents_removed (ContainerSourceCollection* self, ContainerSource* container, GeeCollection* removed, gboolean unlinked) {
	ContainerSource* _tmp0_;
	GeeCollection* _tmp1_;
	gboolean _tmp2_;
#line 71 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	g_return_if_fail (IS_CONTAINER_SOURCE (container));
#line 71 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	g_return_if_fail (GEE_IS_COLLECTION (removed));
#line 73 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_tmp0_ = container;
#line 73 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_tmp1_ = removed;
#line 73 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_tmp2_ = unlinked;
#line 73 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	g_signal_emit (self, container_source_collection_signals[CONTAINER_SOURCE_COLLECTION_CONTAINER_CONTENTS_REMOVED_SIGNAL], 0, _tmp0_, _tmp1_, _tmp2_);
#line 560 "ContainerSourceCollection.c"
}


void container_source_collection_notify_container_contents_removed (ContainerSourceCollection* self, ContainerSource* container, GeeCollection* removed, gboolean unlinked) {
#line 71 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	g_return_if_fail (IS_CONTAINER_SOURCE_COLLECTION (self));
#line 71 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	CONTAINER_SOURCE_COLLECTION_GET_CLASS (self)->notify_container_contents_removed (self, container, removed, unlinked);
#line 569 "ContainerSourceCollection.c"
}


static void container_source_collection_real_notify_container_contents_altered (ContainerSourceCollection* self, ContainerSource* container, GeeCollection* added, gboolean relinked, GeeCollection* removed, gboolean unlinked) {
	ContainerSource* _tmp0_;
	GeeCollection* _tmp1_;
	gboolean _tmp2_;
	GeeCollection* _tmp3_;
	gboolean _tmp4_;
#line 76 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	g_return_if_fail (IS_CONTAINER_SOURCE (container));
#line 76 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	g_return_if_fail ((added == NULL) || GEE_IS_COLLECTION (added));
#line 76 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	g_return_if_fail ((removed == NULL) || GEE_IS_COLLECTION (removed));
#line 79 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_tmp0_ = container;
#line 79 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_tmp1_ = added;
#line 79 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_tmp2_ = relinked;
#line 79 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_tmp3_ = removed;
#line 79 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_tmp4_ = unlinked;
#line 79 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	g_signal_emit (self, container_source_collection_signals[CONTAINER_SOURCE_COLLECTION_CONTAINER_CONTENTS_ALTERED_SIGNAL], 0, _tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp4_);
#line 597 "ContainerSourceCollection.c"
}


void container_source_collection_notify_container_contents_altered (ContainerSourceCollection* self, ContainerSource* container, GeeCollection* added, gboolean relinked, GeeCollection* removed, gboolean unlinked) {
#line 76 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	g_return_if_fail (IS_CONTAINER_SOURCE_COLLECTION (self));
#line 76 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	CONTAINER_SOURCE_COLLECTION_GET_CLASS (self)->notify_container_contents_altered (self, container, added, relinked, removed, unlinked);
#line 606 "ContainerSourceCollection.c"
}


static void container_source_collection_real_notify_backlink_to_container_removed (ContainerSourceCollection* self, ContainerSource* container, GeeCollection* sources) {
	ContainerSource* _tmp0_;
	GeeCollection* _tmp1_;
#line 82 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	g_return_if_fail (IS_CONTAINER_SOURCE (container));
#line 82 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	g_return_if_fail (GEE_IS_COLLECTION (sources));
#line 84 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_tmp0_ = container;
#line 84 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_tmp1_ = sources;
#line 84 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	g_signal_emit (self, container_source_collection_signals[CONTAINER_SOURCE_COLLECTION_BACKLINK_TO_CONTAINER_REMOVED_SIGNAL], 0, _tmp0_, _tmp1_);
#line 623 "ContainerSourceCollection.c"
}


void container_source_collection_notify_backlink_to_container_removed (ContainerSourceCollection* self, ContainerSource* container, GeeCollection* sources) {
#line 82 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	g_return_if_fail (IS_CONTAINER_SOURCE_COLLECTION (self));
#line 82 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	CONTAINER_SOURCE_COLLECTION_GET_CLASS (self)->notify_backlink_to_container_removed (self, container, sources);
#line 632 "ContainerSourceCollection.c"
}


static GeeCollection* container_source_collection_real_get_containers_holding_source (ContainerSourceCollection* self, DataSource* source) {
#line 87 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	g_critical ("Type `%s' does not implement abstract method `container_source_collection_get_containers_holding_source'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 87 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	return NULL;
#line 641 "ContainerSourceCollection.c"
}


GeeCollection* container_source_collection_get_containers_holding_source (ContainerSourceCollection* self, DataSource* source) {
#line 87 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	g_return_val_if_fail (IS_CONTAINER_SOURCE_COLLECTION (self), NULL);
#line 87 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	return CONTAINER_SOURCE_COLLECTION_GET_CLASS (self)->get_containers_holding_source (self, source);
#line 650 "ContainerSourceCollection.c"
}


static ContainerSource* container_source_collection_real_convert_backlink_to_container (ContainerSourceCollection* self, SourceBacklink* backlink) {
#line 90 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	g_critical ("Type `%s' does not implement abstract method `container_source_collection_convert_backlink_to_container'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 90 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	return NULL;
#line 659 "ContainerSourceCollection.c"
}


ContainerSource* container_source_collection_convert_backlink_to_container (ContainerSourceCollection* self, SourceBacklink* backlink) {
#line 90 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	g_return_val_if_fail (IS_CONTAINER_SOURCE_COLLECTION (self), NULL);
#line 90 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	return CONTAINER_SOURCE_COLLECTION_GET_CLASS (self)->convert_backlink_to_container (self, backlink);
#line 668 "ContainerSourceCollection.c"
}


void container_source_collection_freeze_attached_notifications (ContainerSourceCollection* self) {
#line 92 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	g_return_if_fail (IS_CONTAINER_SOURCE_COLLECTION (self));
#line 675 "ContainerSourceCollection.c"
	{
		GeeIterator* _collection_it = NULL;
		GeeHashSet* _tmp0_;
		GeeIterator* _tmp1_;
#line 93 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_tmp0_ = self->priv->attached_collections;
#line 93 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_tmp1_ = gee_abstract_collection_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 93 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_collection_it = _tmp1_;
#line 93 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		while (TRUE) {
#line 688 "ContainerSourceCollection.c"
			GeeIterator* _tmp2_;
			gboolean _tmp3_;
			SourceCollection* collection = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			SourceCollection* _tmp6_;
#line 93 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp2_ = _collection_it;
#line 93 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp3_ = gee_iterator_next (_tmp2_);
#line 93 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			if (!_tmp3_) {
#line 93 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
				break;
#line 703 "ContainerSourceCollection.c"
			}
#line 93 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp4_ = _collection_it;
#line 93 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp5_ = gee_iterator_get (_tmp4_);
#line 93 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			collection = (SourceCollection*) _tmp5_;
#line 94 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp6_ = collection;
#line 94 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			data_collection_freeze_notifications (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_DATA_COLLECTION, DataCollection));
#line 93 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_data_collection_unref0 (collection);
#line 717 "ContainerSourceCollection.c"
		}
#line 93 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_g_object_unref0 (_collection_it);
#line 721 "ContainerSourceCollection.c"
	}
}


void container_source_collection_thaw_attached_notifications (ContainerSourceCollection* self) {
#line 97 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	g_return_if_fail (IS_CONTAINER_SOURCE_COLLECTION (self));
#line 729 "ContainerSourceCollection.c"
	{
		GeeIterator* _collection_it = NULL;
		GeeHashSet* _tmp0_;
		GeeIterator* _tmp1_;
#line 98 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_tmp0_ = self->priv->attached_collections;
#line 98 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_tmp1_ = gee_abstract_collection_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 98 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_collection_it = _tmp1_;
#line 98 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		while (TRUE) {
#line 742 "ContainerSourceCollection.c"
			GeeIterator* _tmp2_;
			gboolean _tmp3_;
			SourceCollection* collection = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			SourceCollection* _tmp6_;
#line 98 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp2_ = _collection_it;
#line 98 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp3_ = gee_iterator_next (_tmp2_);
#line 98 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			if (!_tmp3_) {
#line 98 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
				break;
#line 757 "ContainerSourceCollection.c"
			}
#line 98 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp4_ = _collection_it;
#line 98 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp5_ = gee_iterator_get (_tmp4_);
#line 98 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			collection = (SourceCollection*) _tmp5_;
#line 99 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp6_ = collection;
#line 99 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			data_collection_thaw_notifications (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_DATA_COLLECTION, DataCollection));
#line 98 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_data_collection_unref0 (collection);
#line 771 "ContainerSourceCollection.c"
		}
#line 98 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_g_object_unref0 (_collection_it);
#line 775 "ContainerSourceCollection.c"
	}
}


GeeCollection* container_source_collection_get_holding_tank (ContainerSourceCollection* self) {
	GeeCollection* result = NULL;
	GeeHashSet* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
#line 102 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	g_return_val_if_fail (IS_CONTAINER_SOURCE_COLLECTION (self), NULL);
#line 103 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_tmp0_ = self->priv->holding_tank;
#line 103 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_tmp1_ = gee_abstract_set_get_read_only_view (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_SET, GeeAbstractSet));
#line 103 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_tmp2_ = _tmp1_;
#line 103 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection);
#line 103 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	return result;
#line 797 "ContainerSourceCollection.c"
}


void container_source_collection_init_add_unlinked (ContainerSourceCollection* self, ContainerSource* unlinked) {
	GeeHashSet* _tmp0_;
	ContainerSource* _tmp1_;
#line 106 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	g_return_if_fail (IS_CONTAINER_SOURCE_COLLECTION (self));
#line 106 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	g_return_if_fail (IS_CONTAINER_SOURCE (unlinked));
#line 107 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_tmp0_ = self->priv->holding_tank;
#line 107 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_tmp1_ = unlinked;
#line 107 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp1_);
#line 814 "ContainerSourceCollection.c"
}


void container_source_collection_init_add_many_unlinked (ContainerSourceCollection* self, GeeCollection* unlinked) {
	GeeHashSet* _tmp0_;
	GeeCollection* _tmp1_;
#line 110 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	g_return_if_fail (IS_CONTAINER_SOURCE_COLLECTION (self));
#line 110 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	g_return_if_fail (GEE_IS_COLLECTION (unlinked));
#line 111 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_tmp0_ = self->priv->holding_tank;
#line 111 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_tmp1_ = unlinked;
#line 111 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	gee_collection_add_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), _tmp1_);
#line 831 "ContainerSourceCollection.c"
}


gboolean container_source_collection_relink_from_holding_tank (ContainerSourceCollection* self, ContainerSource* source) {
	gboolean result = FALSE;
	GeeHashSet* _tmp0_;
	ContainerSource* _tmp1_;
	gboolean _tmp2_;
	ContainerSource* _tmp3_;
#line 114 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	g_return_val_if_fail (IS_CONTAINER_SOURCE_COLLECTION (self), FALSE);
#line 114 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	g_return_val_if_fail (IS_CONTAINER_SOURCE (source), FALSE);
#line 115 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_tmp0_ = self->priv->holding_tank;
#line 115 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_tmp1_ = source;
#line 115 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_tmp2_ = gee_abstract_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp1_);
#line 115 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	if (!_tmp2_) {
#line 116 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		result = FALSE;
#line 116 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		return result;
#line 857 "ContainerSourceCollection.c"
	}
#line 118 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_tmp3_ = source;
#line 118 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	source_collection_relink (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SOURCE_COLLECTION, SourceCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_DATA_SOURCE, DataSource));
#line 120 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	result = TRUE;
#line 120 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	return result;
#line 867 "ContainerSourceCollection.c"
}


static void container_source_collection_on_contained_sources_unlinking (ContainerSourceCollection* self, GeeCollection* unlinking) {
	GeeHashMultiMap* map = NULL;
	GeeHashMultiMap* _tmp0_;
#line 123 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	g_return_if_fail (IS_CONTAINER_SOURCE_COLLECTION (self));
#line 123 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	g_return_if_fail (GEE_IS_COLLECTION (unlinking));
#line 124 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	container_source_collection_freeze_attached_notifications (self);
#line 126 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_tmp0_ = gee_hash_multi_map_new (TYPE_CONTAINER_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, TYPE_DATA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 126 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	map = _tmp0_;
#line 884 "ContainerSourceCollection.c"
	{
		GeeIterator* _source_it = NULL;
		GeeCollection* _tmp1_;
		GeeIterator* _tmp2_;
#line 129 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_tmp1_ = unlinking;
#line 129 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_tmp2_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ITERABLE, GeeIterable));
#line 129 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_source_it = _tmp2_;
#line 129 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		while (TRUE) {
#line 897 "ContainerSourceCollection.c"
			GeeIterator* _tmp3_;
			gboolean _tmp4_;
			DataSource* source = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			GeeCollection* containers = NULL;
			DataSource* _tmp7_;
			GeeCollection* _tmp8_;
			gboolean _tmp9_ = FALSE;
			GeeCollection* _tmp10_;
#line 129 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp3_ = _source_it;
#line 129 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp4_ = gee_iterator_next (_tmp3_);
#line 129 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			if (!_tmp4_) {
#line 129 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
				break;
#line 916 "ContainerSourceCollection.c"
			}
#line 129 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp5_ = _source_it;
#line 129 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp6_ = gee_iterator_get (_tmp5_);
#line 129 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			source = (DataSource*) _tmp6_;
#line 130 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp7_ = source;
#line 130 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp8_ = container_source_collection_get_containers_holding_source (self, _tmp7_);
#line 130 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			containers = _tmp8_;
#line 131 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp10_ = containers;
#line 131 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			if (_tmp10_ == NULL) {
#line 131 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
				_tmp9_ = TRUE;
#line 936 "ContainerSourceCollection.c"
			} else {
				GeeCollection* _tmp11_;
				gint _tmp12_;
				gint _tmp13_;
#line 131 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
				_tmp11_ = containers;
#line 131 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
				_tmp12_ = gee_collection_get_size (_tmp11_);
#line 131 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
				_tmp13_ = _tmp12_;
#line 131 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
				_tmp9_ = _tmp13_ == 0;
#line 949 "ContainerSourceCollection.c"
			}
#line 131 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			if (_tmp9_) {
#line 132 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
				_g_object_unref0 (containers);
#line 132 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
				_g_object_unref0 (source);
#line 132 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
				continue;
#line 959 "ContainerSourceCollection.c"
			}
			{
				GeeIterator* _container_it = NULL;
				GeeCollection* _tmp14_;
				GeeIterator* _tmp15_;
#line 134 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
				_tmp14_ = containers;
#line 134 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
				_tmp15_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_ITERABLE, GeeIterable));
#line 134 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
				_container_it = _tmp15_;
#line 134 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
				while (TRUE) {
#line 973 "ContainerSourceCollection.c"
					GeeIterator* _tmp16_;
					gboolean _tmp17_;
					ContainerSource* container = NULL;
					GeeIterator* _tmp18_;
					gpointer _tmp19_;
					GeeHashMultiMap* _tmp20_;
					ContainerSource* _tmp21_;
					DataSource* _tmp22_;
					DataSource* _tmp23_;
					ContainerSource* _tmp24_;
					SourceBacklink* _tmp25_;
					SourceBacklink* _tmp26_;
#line 134 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
					_tmp16_ = _container_it;
#line 134 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
					_tmp17_ = gee_iterator_next (_tmp16_);
#line 134 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
					if (!_tmp17_) {
#line 134 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
						break;
#line 994 "ContainerSourceCollection.c"
					}
#line 134 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
					_tmp18_ = _container_it;
#line 134 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
					_tmp19_ = gee_iterator_get (_tmp18_);
#line 134 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
					container = (ContainerSource*) _tmp19_;
#line 135 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
					_tmp20_ = map;
#line 135 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
					_tmp21_ = container;
#line 135 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
					_tmp22_ = source;
#line 135 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
					gee_multi_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, GEE_TYPE_MULTI_MAP, GeeMultiMap), _tmp21_, _tmp22_);
#line 136 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
					_tmp23_ = source;
#line 136 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
					_tmp24_ = container;
#line 136 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
					_tmp25_ = container_source_get_backlink (_tmp24_);
#line 136 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
					_tmp26_ = _tmp25_;
#line 136 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
					data_source_set_backlink (_tmp23_, _tmp26_);
#line 136 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
					_source_backlink_unref0 (_tmp26_);
#line 134 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
					_g_object_unref0 (container);
#line 1024 "ContainerSourceCollection.c"
				}
#line 134 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
				_g_object_unref0 (_container_it);
#line 1028 "ContainerSourceCollection.c"
			}
#line 129 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_g_object_unref0 (containers);
#line 129 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_g_object_unref0 (source);
#line 1034 "ContainerSourceCollection.c"
		}
#line 129 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_g_object_unref0 (_source_it);
#line 1038 "ContainerSourceCollection.c"
	}
	{
		GeeIterator* _container_it = NULL;
		GeeHashMultiMap* _tmp27_;
		GeeSet* _tmp28_;
		GeeSet* _tmp29_;
		GeeIterator* _tmp30_;
		GeeIterator* _tmp31_;
#line 140 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_tmp27_ = map;
#line 140 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_tmp28_ = gee_multi_map_get_keys (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, GEE_TYPE_MULTI_MAP, GeeMultiMap));
#line 140 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_tmp29_ = _tmp28_;
#line 140 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_tmp30_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, GEE_TYPE_ITERABLE, GeeIterable));
#line 140 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_tmp31_ = _tmp30_;
#line 140 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_g_object_unref0 (_tmp29_);
#line 140 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_container_it = _tmp31_;
#line 140 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		while (TRUE) {
#line 1063 "ContainerSourceCollection.c"
			GeeIterator* _tmp32_;
			gboolean _tmp33_;
			ContainerSource* container = NULL;
			GeeIterator* _tmp34_;
			gpointer _tmp35_;
			ContainerSource* _tmp36_;
			GeeHashMultiMap* _tmp37_;
			ContainerSource* _tmp38_;
			GeeCollection* _tmp39_;
			GeeCollection* _tmp40_;
#line 140 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp32_ = _container_it;
#line 140 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp33_ = gee_iterator_next (_tmp32_);
#line 140 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			if (!_tmp33_) {
#line 140 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
				break;
#line 1082 "ContainerSourceCollection.c"
			}
#line 140 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp34_ = _container_it;
#line 140 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp35_ = gee_iterator_get (_tmp34_);
#line 140 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			container = (ContainerSource*) _tmp35_;
#line 141 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp36_ = container;
#line 141 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp37_ = map;
#line 141 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp38_ = container;
#line 141 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp39_ = gee_multi_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, GEE_TYPE_MULTI_MAP, GeeMultiMap), _tmp38_);
#line 141 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp40_ = _tmp39_;
#line 141 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			container_source_break_link_many (_tmp36_, _tmp40_);
#line 141 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_g_object_unref0 (_tmp40_);
#line 140 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_g_object_unref0 (container);
#line 1106 "ContainerSourceCollection.c"
		}
#line 140 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_g_object_unref0 (_container_it);
#line 1110 "ContainerSourceCollection.c"
	}
#line 143 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	container_source_collection_thaw_attached_notifications (self);
#line 123 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_g_object_unref0 (map);
#line 1116 "ContainerSourceCollection.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 157 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	return self ? g_object_ref (self) : NULL;
#line 1123 "ContainerSourceCollection.c"
}


static void container_source_collection_on_contained_sources_relinked (ContainerSourceCollection* self, GeeCollection* relinked) {
	GeeHashMultiMap* map = NULL;
	GeeHashMultiMap* _tmp0_;
#line 146 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	g_return_if_fail (IS_CONTAINER_SOURCE_COLLECTION (self));
#line 146 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	g_return_if_fail (GEE_IS_COLLECTION (relinked));
#line 147 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	container_source_collection_freeze_attached_notifications (self);
#line 149 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_tmp0_ = gee_hash_multi_map_new (TYPE_CONTAINER_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, TYPE_DATA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 149 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	map = _tmp0_;
#line 1140 "ContainerSourceCollection.c"
	{
		GeeIterator* _source_it = NULL;
		GeeCollection* _tmp1_;
		GeeIterator* _tmp2_;
#line 152 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_tmp1_ = relinked;
#line 152 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_tmp2_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ITERABLE, GeeIterable));
#line 152 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_source_it = _tmp2_;
#line 152 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		while (TRUE) {
#line 1153 "ContainerSourceCollection.c"
			GeeIterator* _tmp3_;
			gboolean _tmp4_;
			DataSource* source = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			GeeList* backlinks = NULL;
			DataSource* _tmp7_;
			const gchar* _tmp8_;
			GeeList* _tmp9_;
			gboolean _tmp10_ = FALSE;
			GeeList* _tmp11_;
#line 152 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp3_ = _source_it;
#line 152 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp4_ = gee_iterator_next (_tmp3_);
#line 152 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			if (!_tmp4_) {
#line 152 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
				break;
#line 1173 "ContainerSourceCollection.c"
			}
#line 152 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp5_ = _source_it;
#line 152 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp6_ = gee_iterator_get (_tmp5_);
#line 152 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			source = (DataSource*) _tmp6_;
#line 153 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp7_ = source;
#line 153 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp8_ = self->priv->backlink_name;
#line 153 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp9_ = data_source_get_backlinks (_tmp7_, _tmp8_);
#line 153 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			backlinks = _tmp9_;
#line 154 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp11_ = backlinks;
#line 154 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			if (_tmp11_ == NULL) {
#line 154 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
				_tmp10_ = TRUE;
#line 1195 "ContainerSourceCollection.c"
			} else {
				GeeList* _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
#line 154 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
				_tmp12_ = backlinks;
#line 154 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
				_tmp13_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_COLLECTION, GeeCollection));
#line 154 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
				_tmp14_ = _tmp13_;
#line 154 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
				_tmp10_ = _tmp14_ == 0;
#line 1208 "ContainerSourceCollection.c"
			}
#line 154 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			if (_tmp10_) {
#line 155 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
				_g_object_unref0 (backlinks);
#line 155 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
				_g_object_unref0 (source);
#line 155 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
				continue;
#line 1218 "ContainerSourceCollection.c"
			}
			{
				GeeList* _backlink_list = NULL;
				GeeList* _tmp15_;
				GeeList* _tmp16_;
				gint _backlink_size = 0;
				GeeList* _tmp17_;
				gint _tmp18_;
				gint _tmp19_;
				gint _backlink_index = 0;
#line 157 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
				_tmp15_ = backlinks;
#line 157 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
				_tmp16_ = _g_object_ref0 (_tmp15_);
#line 157 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
				_backlink_list = _tmp16_;
#line 157 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
				_tmp17_ = _backlink_list;
#line 157 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
				_tmp18_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GEE_TYPE_COLLECTION, GeeCollection));
#line 157 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
				_tmp19_ = _tmp18_;
#line 157 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
				_backlink_size = _tmp19_;
#line 157 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
				_backlink_index = -1;
#line 157 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
				while (TRUE) {
#line 1247 "ContainerSourceCollection.c"
					gint _tmp20_;
					gint _tmp21_;
					gint _tmp22_;
					SourceBacklink* backlink = NULL;
					GeeList* _tmp23_;
					gint _tmp24_;
					gpointer _tmp25_;
					ContainerSource* container = NULL;
					SourceBacklink* _tmp26_;
					ContainerSource* _tmp27_;
					ContainerSource* _tmp28_;
#line 157 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
					_tmp20_ = _backlink_index;
#line 157 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
					_backlink_index = _tmp20_ + 1;
#line 157 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
					_tmp21_ = _backlink_index;
#line 157 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
					_tmp22_ = _backlink_size;
#line 157 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
					if (!(_tmp21_ < _tmp22_)) {
#line 157 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
						break;
#line 1271 "ContainerSourceCollection.c"
					}
#line 157 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
					_tmp23_ = _backlink_list;
#line 157 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
					_tmp24_ = _backlink_index;
#line 157 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
					_tmp25_ = gee_list_get (_tmp23_, _tmp24_);
#line 157 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
					backlink = (SourceBacklink*) _tmp25_;
#line 158 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
					_tmp26_ = backlink;
#line 158 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
					_tmp27_ = container_source_collection_convert_backlink_to_container (self, _tmp26_);
#line 158 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
					container = _tmp27_;
#line 159 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
					_tmp28_ = container;
#line 159 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
					if (_tmp28_ != NULL) {
#line 1291 "ContainerSourceCollection.c"
						GeeHashMultiMap* _tmp29_;
						ContainerSource* _tmp30_;
						DataSource* _tmp31_;
#line 160 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
						_tmp29_ = map;
#line 160 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
						_tmp30_ = container;
#line 160 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
						_tmp31_ = source;
#line 160 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
						gee_multi_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, GEE_TYPE_MULTI_MAP, GeeMultiMap), _tmp30_, _tmp31_);
#line 1303 "ContainerSourceCollection.c"
					} else {
						DataSource* _tmp32_;
						gchar* _tmp33_;
						gchar* _tmp34_;
						SourceBacklink* _tmp35_;
						gchar* _tmp36_;
						gchar* _tmp37_;
#line 162 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
						_tmp32_ = source;
#line 162 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
						_tmp33_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, TYPE_DATA_OBJECT, DataObject));
#line 162 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
						_tmp34_ = _tmp33_;
#line 162 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
						_tmp35_ = backlink;
#line 162 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
						_tmp36_ = source_backlink_to_string (_tmp35_);
#line 162 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
						_tmp37_ = _tmp36_;
#line 162 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
						g_warning ("ContainerSourceCollection.vala:162: Unable to relink %s to container b" \
"acklink %s", _tmp34_, _tmp37_);
#line 162 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
						_g_free0 (_tmp37_);
#line 162 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
						_g_free0 (_tmp34_);
#line 1329 "ContainerSourceCollection.c"
					}
#line 157 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
					_g_object_unref0 (container);
#line 157 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
					_source_backlink_unref0 (backlink);
#line 1335 "ContainerSourceCollection.c"
				}
#line 157 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
				_g_object_unref0 (_backlink_list);
#line 1339 "ContainerSourceCollection.c"
			}
#line 152 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_g_object_unref0 (backlinks);
#line 152 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_g_object_unref0 (source);
#line 1345 "ContainerSourceCollection.c"
		}
#line 152 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_g_object_unref0 (_source_it);
#line 1349 "ContainerSourceCollection.c"
	}
	{
		GeeIterator* _container_it = NULL;
		GeeHashMultiMap* _tmp38_;
		GeeSet* _tmp39_;
		GeeSet* _tmp40_;
		GeeIterator* _tmp41_;
		GeeIterator* _tmp42_;
#line 168 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_tmp38_ = map;
#line 168 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_tmp39_ = gee_multi_map_get_keys (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, GEE_TYPE_MULTI_MAP, GeeMultiMap));
#line 168 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_tmp40_ = _tmp39_;
#line 168 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_tmp41_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, GEE_TYPE_ITERABLE, GeeIterable));
#line 168 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_tmp42_ = _tmp41_;
#line 168 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_g_object_unref0 (_tmp40_);
#line 168 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_container_it = _tmp42_;
#line 168 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		while (TRUE) {
#line 1374 "ContainerSourceCollection.c"
			GeeIterator* _tmp43_;
			gboolean _tmp44_;
			ContainerSource* container = NULL;
			GeeIterator* _tmp45_;
			gpointer _tmp46_;
			ContainerSource* _tmp47_;
			GeeHashMultiMap* _tmp48_;
			ContainerSource* _tmp49_;
			GeeCollection* _tmp50_;
			GeeCollection* _tmp51_;
#line 168 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp43_ = _container_it;
#line 168 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp44_ = gee_iterator_next (_tmp43_);
#line 168 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			if (!_tmp44_) {
#line 168 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
				break;
#line 1393 "ContainerSourceCollection.c"
			}
#line 168 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp45_ = _container_it;
#line 168 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp46_ = gee_iterator_get (_tmp45_);
#line 168 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			container = (ContainerSource*) _tmp46_;
#line 169 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp47_ = container;
#line 169 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp48_ = map;
#line 169 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp49_ = container;
#line 169 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp50_ = gee_multi_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, GEE_TYPE_MULTI_MAP, GeeMultiMap), _tmp49_);
#line 169 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp51_ = _tmp50_;
#line 169 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			container_source_establish_link_many (_tmp47_, _tmp51_);
#line 169 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_g_object_unref0 (_tmp51_);
#line 168 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_g_object_unref0 (container);
#line 1417 "ContainerSourceCollection.c"
		}
#line 168 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_g_object_unref0 (_container_it);
#line 1421 "ContainerSourceCollection.c"
	}
#line 171 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	container_source_collection_thaw_attached_notifications (self);
#line 146 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_g_object_unref0 (map);
#line 1427 "ContainerSourceCollection.c"
}


static void container_source_collection_on_contained_source_destroyed (ContainerSourceCollection* self, DataSource* source) {
	GeeIterator* iter = NULL;
	GeeHashSet* _tmp0_;
	GeeIterator* _tmp1_;
#line 174 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	g_return_if_fail (IS_CONTAINER_SOURCE_COLLECTION (self));
#line 174 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	g_return_if_fail (IS_DATA_SOURCE (source));
#line 175 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_tmp0_ = self->priv->holding_tank;
#line 175 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_tmp1_ = gee_abstract_collection_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 175 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	iter = _tmp1_;
#line 176 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	while (TRUE) {
#line 1447 "ContainerSourceCollection.c"
		GeeIterator* _tmp2_;
		gboolean _tmp3_;
		ContainerSource* container = NULL;
		GeeIterator* _tmp4_;
		gpointer _tmp5_;
		gboolean _tmp6_ = FALSE;
		ContainerSource* _tmp7_;
		gboolean _tmp8_;
#line 176 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_tmp2_ = iter;
#line 176 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_tmp3_ = gee_iterator_next (_tmp2_);
#line 176 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		if (!_tmp3_) {
#line 176 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			break;
#line 1464 "ContainerSourceCollection.c"
		}
#line 177 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_tmp4_ = iter;
#line 177 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_tmp5_ = gee_iterator_get (_tmp4_);
#line 177 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		container = (ContainerSource*) _tmp5_;
#line 181 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_tmp7_ = container;
#line 181 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_tmp8_ = container_source_has_links (_tmp7_);
#line 181 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		if (!_tmp8_) {
#line 1478 "ContainerSourceCollection.c"
			ContainerSource* _tmp9_;
#line 181 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp9_ = container;
#line 181 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp6_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, TYPE_TAG);
#line 1484 "ContainerSourceCollection.c"
		} else {
#line 181 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp6_ = FALSE;
#line 1488 "ContainerSourceCollection.c"
		}
#line 181 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		if (_tmp6_) {
#line 1492 "ContainerSourceCollection.c"
			GeeIterator* _tmp10_;
			ContainerSource* _tmp11_;
#line 182 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp10_ = iter;
#line 182 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			gee_iterator_remove (_tmp10_);
#line 183 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp11_ = container;
#line 183 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			data_source_destroy_orphan (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_DATA_SOURCE, DataSource), TRUE);
#line 1503 "ContainerSourceCollection.c"
		}
#line 176 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_g_object_unref0 (container);
#line 1507 "ContainerSourceCollection.c"
	}
#line 174 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_g_object_unref0 (iter);
#line 1511 "ContainerSourceCollection.c"
}


static void container_source_collection_real_notify_item_destroyed (SourceCollection* base, DataSource* source) {
	ContainerSourceCollection * self;
	DataSource* _tmp10_;
#line 188 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection);
#line 188 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	g_return_if_fail (IS_DATA_SOURCE (source));
#line 1522 "ContainerSourceCollection.c"
	{
		GeeIterator* _collection_it = NULL;
		GeeHashSet* _tmp0_;
		GeeIterator* _tmp1_;
#line 189 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_tmp0_ = self->priv->attached_collections;
#line 189 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_tmp1_ = gee_abstract_collection_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 189 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_collection_it = _tmp1_;
#line 189 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		while (TRUE) {
#line 1535 "ContainerSourceCollection.c"
			GeeIterator* _tmp2_;
			gboolean _tmp3_;
			SourceCollection* collection = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			SourceCollection* _tmp6_;
			DataSource* _tmp7_;
			SourceBacklink* _tmp8_;
			SourceBacklink* _tmp9_;
#line 189 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp2_ = _collection_it;
#line 189 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp3_ = gee_iterator_next (_tmp2_);
#line 189 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			if (!_tmp3_) {
#line 189 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
				break;
#line 1553 "ContainerSourceCollection.c"
			}
#line 189 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp4_ = _collection_it;
#line 189 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp5_ = gee_iterator_get (_tmp4_);
#line 189 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			collection = (SourceCollection*) _tmp5_;
#line 190 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp6_ = collection;
#line 190 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp7_ = source;
#line 190 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp8_ = container_source_get_backlink (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_CONTAINER_SOURCE, ContainerSource));
#line 190 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp9_ = _tmp8_;
#line 190 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			source_collection_remove_backlink (_tmp6_, _tmp9_);
#line 190 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_source_backlink_unref0 (_tmp9_);
#line 189 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_data_collection_unref0 (collection);
#line 1575 "ContainerSourceCollection.c"
		}
#line 189 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_g_object_unref0 (_collection_it);
#line 1579 "ContainerSourceCollection.c"
	}
#line 193 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_tmp10_ = source;
#line 193 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	SOURCE_COLLECTION_CLASS (container_source_collection_parent_class)->notify_item_destroyed (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection), TYPE_SOURCE_COLLECTION, SourceCollection), _tmp10_);
#line 1585 "ContainerSourceCollection.c"
}


void container_source_collection_evaporate (ContainerSourceCollection* self, ContainerSource* container) {
	ContainerSource* _tmp21_;
	Marker* _tmp22_;
	Marker* _tmp23_;
#line 200 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	g_return_if_fail (IS_CONTAINER_SOURCE_COLLECTION (self));
#line 200 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	g_return_if_fail (IS_CONTAINER_SOURCE (container));
#line 1597 "ContainerSourceCollection.c"
	{
		GeeIterator* _collection_it = NULL;
		GeeHashSet* _tmp0_;
		GeeIterator* _tmp1_;
#line 201 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_tmp0_ = self->priv->attached_collections;
#line 201 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_tmp1_ = gee_abstract_collection_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 201 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_collection_it = _tmp1_;
#line 201 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		while (TRUE) {
#line 1610 "ContainerSourceCollection.c"
			GeeIterator* _tmp2_;
			gboolean _tmp3_;
			SourceCollection* collection = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			SourceCollection* _tmp6_;
			ContainerSource* _tmp7_;
			SourceBacklink* _tmp8_;
			SourceBacklink* _tmp9_;
			gboolean _tmp10_;
			gboolean _tmp11_;
#line 201 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp2_ = _collection_it;
#line 201 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp3_ = gee_iterator_next (_tmp2_);
#line 201 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			if (!_tmp3_) {
#line 201 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
				break;
#line 1630 "ContainerSourceCollection.c"
			}
#line 201 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp4_ = _collection_it;
#line 201 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp5_ = gee_iterator_get (_tmp4_);
#line 201 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			collection = (SourceCollection*) _tmp5_;
#line 202 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp6_ = collection;
#line 202 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp7_ = container;
#line 202 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp8_ = container_source_get_backlink (_tmp7_);
#line 202 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp9_ = _tmp8_;
#line 202 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp10_ = source_collection_has_backlink (_tmp6_, _tmp9_);
#line 202 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp11_ = _tmp10_;
#line 202 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_source_backlink_unref0 (_tmp9_);
#line 202 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			if (_tmp11_) {
#line 1654 "ContainerSourceCollection.c"
				ContainerSource* _tmp12_;
				Marker* _tmp13_;
				Marker* _tmp14_;
				GeeCollection* _tmp15_;
				GeeCollection* _tmp16_;
				gboolean added = FALSE;
				GeeHashSet* _tmp17_;
				ContainerSource* _tmp18_;
				gboolean _tmp19_;
				gboolean _tmp20_;
#line 203 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
				_tmp12_ = container;
#line 203 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
				_tmp13_ = data_collection_mark (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, TYPE_DATA_OBJECT, DataObject));
#line 203 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
				_tmp14_ = _tmp13_;
#line 203 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
				_tmp15_ = source_collection_unlink_marked (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SOURCE_COLLECTION, SourceCollection), _tmp14_, NULL, NULL);
#line 203 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
				_tmp16_ = _tmp15_;
#line 203 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
				_g_object_unref0 (_tmp16_);
#line 203 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
				_g_object_unref0 (_tmp14_);
#line 204 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
				_tmp17_ = self->priv->holding_tank;
#line 204 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
				_tmp18_ = container;
#line 204 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
				_tmp19_ = gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp18_);
#line 204 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
				added = _tmp19_;
#line 205 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
				_tmp20_ = added;
#line 205 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
				_vala_assert (_tmp20_, "added");
#line 206 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
				_data_collection_unref0 (collection);
#line 206 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
				_g_object_unref0 (_collection_it);
#line 206 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
				return;
#line 1697 "ContainerSourceCollection.c"
			}
#line 201 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_data_collection_unref0 (collection);
#line 1701 "ContainerSourceCollection.c"
		}
#line 201 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_g_object_unref0 (_collection_it);
#line 1705 "ContainerSourceCollection.c"
	}
#line 210 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_tmp21_ = container;
#line 210 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_tmp22_ = data_collection_mark (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, TYPE_DATA_OBJECT, DataObject));
#line 210 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_tmp23_ = _tmp22_;
#line 210 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	source_collection_destroy_marked (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SOURCE_COLLECTION, SourceCollection), _tmp23_, TRUE, NULL, NULL, NULL);
#line 210 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_g_object_unref0 (_tmp23_);
#line 1717 "ContainerSourceCollection.c"
}


static void _container_source_collection_on_contained_sources_unlinking_source_collection_items_unlinking (SourceCollection* _sender, GeeCollection* unlinking, gpointer self) {
#line 221 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	container_source_collection_on_contained_sources_unlinking ((ContainerSourceCollection*) self, unlinking);
#line 1724 "ContainerSourceCollection.c"
}


static void _container_source_collection_on_contained_sources_relinked_source_collection_items_relinked (SourceCollection* _sender, GeeCollection* relinked, gpointer self) {
#line 222 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	container_source_collection_on_contained_sources_relinked ((ContainerSourceCollection*) self, relinked);
#line 1731 "ContainerSourceCollection.c"
}


static void _container_source_collection_on_contained_source_destroyed_source_collection_item_destroyed (SourceCollection* _sender, DataSource* source, gpointer self) {
#line 223 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	container_source_collection_on_contained_source_destroyed ((ContainerSourceCollection*) self, source);
#line 1738 "ContainerSourceCollection.c"
}


static void _container_source_collection_on_contained_source_destroyed_source_collection_unlinked_destroyed (SourceCollection* _sender, DataSource* source, gpointer self) {
#line 224 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	container_source_collection_on_contained_source_destroyed ((ContainerSourceCollection*) self, source);
#line 1745 "ContainerSourceCollection.c"
}


void container_source_collection_attach_collection (ContainerSourceCollection* self, SourceCollection* collection) {
	GeeHashSet* _tmp0_;
	SourceCollection* _tmp1_;
	gboolean _tmp2_;
	GeeHashSet* _tmp8_;
	SourceCollection* _tmp9_;
	SourceCollection* _tmp10_;
	SourceCollection* _tmp11_;
	SourceCollection* _tmp12_;
	SourceCollection* _tmp13_;
#line 213 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	g_return_if_fail (IS_CONTAINER_SOURCE_COLLECTION (self));
#line 213 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	g_return_if_fail (IS_SOURCE_COLLECTION (collection));
#line 214 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_tmp0_ = self->priv->attached_collections;
#line 214 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_tmp1_ = collection;
#line 214 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_tmp2_ = gee_abstract_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp1_);
#line 214 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	if (_tmp2_) {
#line 1771 "ContainerSourceCollection.c"
		SourceCollection* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
#line 215 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_tmp3_ = collection;
#line 215 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_tmp4_ = data_collection_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_DATA_COLLECTION, DataCollection));
#line 215 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_tmp5_ = _tmp4_;
#line 215 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_tmp6_ = data_collection_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
#line 215 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_tmp7_ = _tmp6_;
#line 215 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		g_warning ("ContainerSourceCollection.vala:215: attempted to multiple-attach '%s' " \
"to '%s'", _tmp5_, _tmp7_);
#line 215 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_g_free0 (_tmp7_);
#line 215 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_g_free0 (_tmp5_);
#line 216 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		return;
#line 1795 "ContainerSourceCollection.c"
	}
#line 219 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_tmp8_ = self->priv->attached_collections;
#line 219 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_tmp9_ = collection;
#line 219 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp9_);
#line 221 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_tmp10_ = collection;
#line 221 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	g_signal_connect (_tmp10_, "items-unlinking", (GCallback) _container_source_collection_on_contained_sources_unlinking_source_collection_items_unlinking, self);
#line 222 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_tmp11_ = collection;
#line 222 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	g_signal_connect (_tmp11_, "items-relinked", (GCallback) _container_source_collection_on_contained_sources_relinked_source_collection_items_relinked, self);
#line 223 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_tmp12_ = collection;
#line 223 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	g_signal_connect (_tmp12_, "item-destroyed", (GCallback) _container_source_collection_on_contained_source_destroyed_source_collection_item_destroyed, self);
#line 224 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_tmp13_ = collection;
#line 224 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	g_signal_connect (_tmp13_, "unlinked-destroyed", (GCallback) _container_source_collection_on_contained_source_destroyed_source_collection_unlinked_destroyed, self);
#line 1819 "ContainerSourceCollection.c"
}


void container_source_collection_detach_all_collections (ContainerSourceCollection* self) {
	GeeHashSet* _tmp14_;
#line 227 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	g_return_if_fail (IS_CONTAINER_SOURCE_COLLECTION (self));
#line 1827 "ContainerSourceCollection.c"
	{
		GeeIterator* _collection_it = NULL;
		GeeHashSet* _tmp0_;
		GeeIterator* _tmp1_;
#line 228 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_tmp0_ = self->priv->attached_collections;
#line 228 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_tmp1_ = gee_abstract_collection_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 228 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_collection_it = _tmp1_;
#line 228 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		while (TRUE) {
#line 1840 "ContainerSourceCollection.c"
			GeeIterator* _tmp2_;
			gboolean _tmp3_;
			SourceCollection* collection = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			SourceCollection* _tmp6_;
			guint _tmp7_;
			SourceCollection* _tmp8_;
			guint _tmp9_;
			SourceCollection* _tmp10_;
			guint _tmp11_;
			SourceCollection* _tmp12_;
			guint _tmp13_;
#line 228 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp2_ = _collection_it;
#line 228 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp3_ = gee_iterator_next (_tmp2_);
#line 228 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			if (!_tmp3_) {
#line 228 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
				break;
#line 1862 "ContainerSourceCollection.c"
			}
#line 228 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp4_ = _collection_it;
#line 228 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp5_ = gee_iterator_get (_tmp4_);
#line 228 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			collection = (SourceCollection*) _tmp5_;
#line 229 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp6_ = collection;
#line 229 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			g_signal_parse_name ("items-unlinking", TYPE_SOURCE_COLLECTION, &_tmp7_, NULL, FALSE);
#line 229 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			g_signal_handlers_disconnect_matched (_tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _container_source_collection_on_contained_sources_unlinking_source_collection_items_unlinking, self);
#line 230 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp8_ = collection;
#line 230 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			g_signal_parse_name ("items-relinked", TYPE_SOURCE_COLLECTION, &_tmp9_, NULL, FALSE);
#line 230 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			g_signal_handlers_disconnect_matched (_tmp8_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, 0, NULL, (GCallback) _container_source_collection_on_contained_sources_relinked_source_collection_items_relinked, self);
#line 231 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp10_ = collection;
#line 231 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			g_signal_parse_name ("item-destroyed", TYPE_SOURCE_COLLECTION, &_tmp11_, NULL, FALSE);
#line 231 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			g_signal_handlers_disconnect_matched (_tmp10_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp11_, 0, NULL, (GCallback) _container_source_collection_on_contained_source_destroyed_source_collection_item_destroyed, self);
#line 232 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_tmp12_ = collection;
#line 232 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			g_signal_parse_name ("unlinked-destroyed", TYPE_SOURCE_COLLECTION, &_tmp13_, NULL, FALSE);
#line 232 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			g_signal_handlers_disconnect_matched (_tmp12_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp13_, 0, NULL, (GCallback) _container_source_collection_on_contained_source_destroyed_source_collection_unlinked_destroyed, self);
#line 228 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
			_data_collection_unref0 (collection);
#line 1896 "ContainerSourceCollection.c"
		}
#line 228 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		_g_object_unref0 (_collection_it);
#line 1900 "ContainerSourceCollection.c"
	}
#line 235 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_tmp14_ = self->priv->attached_collections;
#line 235 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	gee_abstract_collection_clear (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 1906 "ContainerSourceCollection.c"
}


static void container_source_collection_real_container_contents_added (ContainerSourceCollection* self, ContainerSource* container, GeeCollection* added, gboolean relinked) {
#line 20 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	g_return_if_fail (IS_CONTAINER_SOURCE (container));
#line 20 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	g_return_if_fail (GEE_IS_COLLECTION (added));
#line 1915 "ContainerSourceCollection.c"
}


static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT_BOOLEAN) (gpointer data1, gpointer arg_1, gpointer arg_2, gboolean arg_3, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 15 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	g_return_if_fail (n_param_values == 4);
#line 15 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 15 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		data1 = closure->data;
#line 15 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		data2 = param_values->data[0].v_pointer;
#line 1934 "ContainerSourceCollection.c"
	} else {
#line 15 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		data1 = param_values->data[0].v_pointer;
#line 15 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		data2 = closure->data;
#line 1940 "ContainerSourceCollection.c"
	}
#line 15 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
#line 15 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), g_value_get_boolean (param_values + 3), data2);
#line 1946 "ContainerSourceCollection.c"
}


static void container_source_collection_real_container_contents_removed (ContainerSourceCollection* self, ContainerSource* container, GeeCollection* removed, gboolean unlinked) {
#line 24 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	g_return_if_fail (IS_CONTAINER_SOURCE (container));
#line 24 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	g_return_if_fail (GEE_IS_COLLECTION (removed));
#line 1955 "ContainerSourceCollection.c"
}


static void container_source_collection_real_container_contents_altered (ContainerSourceCollection* self, ContainerSource* container, GeeCollection* added, gboolean relinked, GeeCollection* removed, gboolean unlinked) {
#line 28 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	g_return_if_fail (IS_CONTAINER_SOURCE (container));
#line 28 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	g_return_if_fail ((added == NULL) || GEE_IS_COLLECTION (added));
#line 28 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	g_return_if_fail ((removed == NULL) || GEE_IS_COLLECTION (removed));
#line 1966 "ContainerSourceCollection.c"
}


static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT_BOOLEAN_OBJECT_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT_BOOLEAN_OBJECT_BOOLEAN) (gpointer data1, gpointer arg_1, gpointer arg_2, gboolean arg_3, gpointer arg_4, gboolean arg_5, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT_BOOLEAN_OBJECT_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 15 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	g_return_if_fail (n_param_values == 6);
#line 15 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 15 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		data1 = closure->data;
#line 15 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		data2 = param_values->data[0].v_pointer;
#line 1985 "ContainerSourceCollection.c"
	} else {
#line 15 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		data1 = param_values->data[0].v_pointer;
#line 15 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		data2 = closure->data;
#line 1991 "ContainerSourceCollection.c"
	}
#line 15 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT_BOOLEAN_OBJECT_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
#line 15 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), g_value_get_boolean (param_values + 3), g_value_get_object (param_values + 4), g_value_get_boolean (param_values + 5), data2);
#line 1997 "ContainerSourceCollection.c"
}


static void container_source_collection_real_backlink_to_container_removed (ContainerSourceCollection* self, ContainerSource* container, GeeCollection* sources) {
#line 34 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	g_return_if_fail (IS_CONTAINER_SOURCE (container));
#line 34 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	g_return_if_fail (GEE_IS_COLLECTION (sources));
#line 2006 "ContainerSourceCollection.c"
}


static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 15 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	g_return_if_fail (n_param_values == 3);
#line 15 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 15 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		data1 = closure->data;
#line 15 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		data2 = param_values->data[0].v_pointer;
#line 2025 "ContainerSourceCollection.c"
	} else {
#line 15 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		data1 = param_values->data[0].v_pointer;
#line 15 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
		data2 = closure->data;
#line 2031 "ContainerSourceCollection.c"
	}
#line 15 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
#line 15 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), data2);
#line 2037 "ContainerSourceCollection.c"
}


static void container_source_collection_class_init (ContainerSourceCollectionClass * klass) {
#line 15 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	container_source_collection_parent_class = g_type_class_peek_parent (klass);
#line 15 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	((DataCollectionClass *) klass)->finalize = container_source_collection_finalize;
#line 15 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	g_type_class_add_private (klass, sizeof (ContainerSourceCollectionPrivate));
#line 15 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	((SourceCollectionClass *) klass)->notify_backlink_removed = (void (*) (SourceCollection *, SourceBacklink*, GeeCollection*)) container_source_collection_real_notify_backlink_removed;
#line 15 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	((ContainerSourceCollectionClass *) klass)->notify_container_contents_added = (void (*) (ContainerSourceCollection *, ContainerSource*, GeeCollection*, gboolean)) container_source_collection_real_notify_container_contents_added;
#line 15 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	((ContainerSourceCollectionClass *) klass)->notify_container_contents_removed = (void (*) (ContainerSourceCollection *, ContainerSource*, GeeCollection*, gboolean)) container_source_collection_real_notify_container_contents_removed;
#line 15 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	((ContainerSourceCollectionClass *) klass)->notify_container_contents_altered = (void (*) (ContainerSourceCollection *, ContainerSource*, GeeCollection*, gboolean, GeeCollection*, gboolean)) container_source_collection_real_notify_container_contents_altered;
#line 15 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	((ContainerSourceCollectionClass *) klass)->notify_backlink_to_container_removed = (void (*) (ContainerSourceCollection *, ContainerSource*, GeeCollection*)) container_source_collection_real_notify_backlink_to_container_removed;
#line 15 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	((ContainerSourceCollectionClass *) klass)->get_containers_holding_source = (GeeCollection* (*) (ContainerSourceCollection *, DataSource*)) container_source_collection_real_get_containers_holding_source;
#line 15 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	((ContainerSourceCollectionClass *) klass)->convert_backlink_to_container = (ContainerSource* (*) (ContainerSourceCollection *, SourceBacklink*)) container_source_collection_real_convert_backlink_to_container;
#line 15 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	((SourceCollectionClass *) klass)->notify_item_destroyed = (void (*) (SourceCollection *, DataSource*)) container_source_collection_real_notify_item_destroyed;
#line 15 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	((ContainerSourceCollectionClass *) klass)->container_contents_added = container_source_collection_real_container_contents_added;
#line 15 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	((ContainerSourceCollectionClass *) klass)->container_contents_removed = container_source_collection_real_container_contents_removed;
#line 15 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	((ContainerSourceCollectionClass *) klass)->container_contents_altered = container_source_collection_real_container_contents_altered;
#line 15 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	((ContainerSourceCollectionClass *) klass)->backlink_to_container_removed = container_source_collection_real_backlink_to_container_removed;
#line 15 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	container_source_collection_signals[CONTAINER_SOURCE_COLLECTION_CONTAINER_CONTENTS_ADDED_SIGNAL] = g_signal_new ("container-contents-added", TYPE_CONTAINER_SOURCE_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ContainerSourceCollectionClass, container_contents_added), NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT_BOOLEAN, G_TYPE_NONE, 3, TYPE_CONTAINER_SOURCE, GEE_TYPE_COLLECTION, G_TYPE_BOOLEAN);
#line 15 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	container_source_collection_signals[CONTAINER_SOURCE_COLLECTION_CONTAINER_CONTENTS_REMOVED_SIGNAL] = g_signal_new ("container-contents-removed", TYPE_CONTAINER_SOURCE_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ContainerSourceCollectionClass, container_contents_removed), NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT_BOOLEAN, G_TYPE_NONE, 3, TYPE_CONTAINER_SOURCE, GEE_TYPE_COLLECTION, G_TYPE_BOOLEAN);
#line 15 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	container_source_collection_signals[CONTAINER_SOURCE_COLLECTION_CONTAINER_CONTENTS_ALTERED_SIGNAL] = g_signal_new ("container-contents-altered", TYPE_CONTAINER_SOURCE_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ContainerSourceCollectionClass, container_contents_altered), NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT_BOOLEAN_OBJECT_BOOLEAN, G_TYPE_NONE, 5, TYPE_CONTAINER_SOURCE, GEE_TYPE_COLLECTION, G_TYPE_BOOLEAN, GEE_TYPE_COLLECTION, G_TYPE_BOOLEAN);
#line 15 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	container_source_collection_signals[CONTAINER_SOURCE_COLLECTION_BACKLINK_TO_CONTAINER_REMOVED_SIGNAL] = g_signal_new ("backlink-to-container-removed", TYPE_CONTAINER_SOURCE_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ContainerSourceCollectionClass, backlink_to_container_removed), NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, TYPE_CONTAINER_SOURCE, GEE_TYPE_COLLECTION);
#line 2080 "ContainerSourceCollection.c"
}


static void container_source_collection_instance_init (ContainerSourceCollection * self) {
	GeeHashSet* _tmp0_;
	GeeHashSet* _tmp1_;
#line 15 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	self->priv = CONTAINER_SOURCE_COLLECTION_GET_PRIVATE (self);
#line 16 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_tmp0_ = gee_hash_set_new (TYPE_SOURCE_COLLECTION, (GBoxedCopyFunc) data_collection_ref, (GDestroyNotify) data_collection_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 16 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	self->priv->attached_collections = _tmp0_;
#line 18 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_tmp1_ = gee_hash_set_new (TYPE_CONTAINER_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 18 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	self->priv->holding_tank = _tmp1_;
#line 2097 "ContainerSourceCollection.c"
}


static void container_source_collection_finalize (DataCollection * obj) {
	ContainerSourceCollection * self;
#line 15 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection);
#line 46 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	container_source_collection_detach_all_collections (self);
#line 16 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_g_object_unref0 (self->priv->attached_collections);
#line 17 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_g_free0 (self->priv->backlink_name);
#line 18 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	_g_object_unref0 (self->priv->holding_tank);
#line 15 "/home/jens/Source/shotwell/src/core/ContainerSourceCollection.vala"
	DATA_COLLECTION_CLASS (container_source_collection_parent_class)->finalize (obj);
#line 2115 "ContainerSourceCollection.c"
}


GType container_source_collection_get_type (void) {
	static volatile gsize container_source_collection_type_id__volatile = 0;
	if (g_once_init_enter (&container_source_collection_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ContainerSourceCollectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) container_source_collection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContainerSourceCollection), 0, (GInstanceInitFunc) container_source_collection_instance_init, NULL };
		GType container_source_collection_type_id;
		container_source_collection_type_id = g_type_register_static (TYPE_DATABASE_SOURCE_COLLECTION, "ContainerSourceCollection", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&container_source_collection_type_id__volatile, container_source_collection_type_id);
	}
	return container_source_collection_type_id__volatile;
}



