/* MediaInterfaces.c generated by valac 0.40.4, the Vala compiler
 * generated from MediaInterfaces.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */
/**/
/* Going forward, Shotwell will use MediaInterfaces, which allow for various operations and features*/
/* to be added only to the MediaSources that support them (or make sense for).  For example, adding*/
/* a library-mode photo or video to an Event makes perfect sense, but does not make sense for a*/
/* direct-mode photo.  All three are MediaSources, and to make DirectPhoto descend from another*/
/* base class is only inviting chaos and a tremendous amount of replicated code.*/
/**/
/* A key point to make of all MediaInterfaces is that they require MediaSource as a base class.*/
/* Thus, any code dealing with one of these interfaces knows they are also dealing with a*/
/* MediaSource.*/
/**/
/* TODO: Make Eventable and Taggable interfaces, which are the only types Event and Tag will deal*/
/* with (rather than MediaSources).*/
/**/
/* TODO: Make Trashable interface, which are much like Flaggable.*/
/**/
/* TODO: ContainerSources may also have specific needs in the future; an interface-based system*/
/* may make sense as well when that need arises.*/
/**/
/**/
/* TransactionController*/
/**/
/* Because many operations in Shotwell need to be performed on collections of objects all at once,*/
/* and that most of these objects are backed by a database, the TransactionController object gives */
/* a way to generically group a series of operations on one or more similar objects into a single*/
/* transaction. This class is listed here because it's used by the various media interfaces to offer*/
/* multiple operations.*/
/**/
/* begin() and commit() may be called multiple times in layering fashion.  The implementation*/
/* accounts for this.  If either throws an exception it should be assumed that the object is in*/
/* a "clean" state; that is, if begin() throws an exception, there is no need to call commit(),*/
/* and if commit() throws an exception, it does not need to be called again to revert the object*/
/* state.*/
/**/
/* This means that any user who calls begin() *must* match it with a corresponding commit(), even*/
/* if there is an error during the transaction.  It is up to the user to back out any undesired*/
/* changes.*/
/**/
/* Because of the nature of this object, it's assumed that every object type will share one*/
/* between all callers.*/
/**/
/* The object is thread-safe.  There is no guarantee that the underlying persistent store is,*/
/* however.*/


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>
#include <time.h>
#include <gobject/gvaluecollector.h>


#define TYPE_TRANSACTION_CONTROLLER (transaction_controller_get_type ())
#define TRANSACTION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRANSACTION_CONTROLLER, TransactionController))
#define TRANSACTION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRANSACTION_CONTROLLER, TransactionControllerClass))
#define IS_TRANSACTION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRANSACTION_CONTROLLER))
#define IS_TRANSACTION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRANSACTION_CONTROLLER))
#define TRANSACTION_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRANSACTION_CONTROLLER, TransactionControllerClass))

typedef struct _TransactionController TransactionController;
typedef struct _TransactionControllerClass TransactionControllerClass;
typedef struct _TransactionControllerPrivate TransactionControllerPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ParamSpecTransactionController ParamSpecTransactionController;

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;

#define TYPE_FLAGGABLE (flaggable_get_type ())
#define FLAGGABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FLAGGABLE, Flaggable))
#define IS_FLAGGABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FLAGGABLE))
#define FLAGGABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_FLAGGABLE, FlaggableIface))

typedef struct _Flaggable Flaggable;
typedef struct _FlaggableIface FlaggableIface;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_MONITORABLE (monitorable_get_type ())
#define MONITORABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MONITORABLE, Monitorable))
#define IS_MONITORABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MONITORABLE))
#define MONITORABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MONITORABLE, MonitorableIface))

typedef struct _Monitorable Monitorable;
typedef struct _MonitorableIface MonitorableIface;

#define TYPE_DATEABLE (dateable_get_type ())
#define DATEABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATEABLE, Dateable))
#define IS_DATEABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATEABLE))
#define DATEABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_DATEABLE, DateableIface))

typedef struct _Dateable Dateable;
typedef struct _DateableIface DateableIface;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _TransactionController {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TransactionControllerPrivate * priv;
};

struct _TransactionControllerClass {
	GTypeClass parent_class;
	void (*finalize) (TransactionController *self);
	void (*begin_impl) (TransactionController* self, GError** error);
	void (*commit_impl) (TransactionController* self, GError** error);
};

struct _TransactionControllerPrivate {
	gint count;
	GRecMutex __lock_count;
};

typedef enum  {
	DATABASE_ERROR_ERROR,
	DATABASE_ERROR_BACKING,
	DATABASE_ERROR_MEMORY,
	DATABASE_ERROR_ABORT,
	DATABASE_ERROR_LIMITS,
	DATABASE_ERROR_TYPESPEC
} DatabaseError;
#define DATABASE_ERROR database_error_quark ()
struct _ParamSpecTransactionController {
	GParamSpec parent_instance;
};

struct _FlaggableIface {
	GTypeInterface parent_iface;
	gboolean (*is_flagged) (Flaggable* self);
	void (*mark_flagged) (Flaggable* self);
	void (*mark_unflagged) (Flaggable* self);
};

struct _MonitorableIface {
	GTypeInterface parent_iface;
	gboolean (*is_offline) (Monitorable* self);
	void (*mark_online) (Monitorable* self);
	void (*mark_offline) (Monitorable* self);
	void (*set_master_file) (Monitorable* self, GFile* file);
	void (*set_master_timestamp) (Monitorable* self, GFileInfo* info);
};

struct _DateableIface {
	GTypeInterface parent_iface;
	void (*set_exposure_time) (Dateable* self, time_t target_time);
	time_t (*get_exposure_time) (Dateable* self);
};


static gpointer transaction_controller_parent_class = NULL;

gpointer transaction_controller_ref (gpointer instance);
void transaction_controller_unref (gpointer instance);
GParamSpec* param_spec_transaction_controller (const gchar* name,
                                               const gchar* nick,
                                               const gchar* blurb,
                                               GType object_type,
                                               GParamFlags flags);
void value_set_transaction_controller (GValue* value,
                                       gpointer v_object);
void value_take_transaction_controller (GValue* value,
                                        gpointer v_object);
gpointer value_get_transaction_controller (const GValue* value);
GType transaction_controller_get_type (void) G_GNUC_CONST;
#define TRANSACTION_CONTROLLER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TRANSACTION_CONTROLLER, TransactionControllerPrivate))
TransactionController* transaction_controller_construct (GType object_type);
void transaction_controller_begin (TransactionController* self);
void transaction_controller_begin_impl (TransactionController* self,
                                        GError** error);
GQuark database_error_quark (void);
void app_window_database_error (GError* err);
void app_window_panic (const gchar* msg);
static void transaction_controller_real_begin_impl (TransactionController* self,
                                             GError** error);
void transaction_controller_commit (TransactionController* self);
void transaction_controller_commit_impl (TransactionController* self,
                                         GError** error);
static void transaction_controller_real_commit_impl (TransactionController* self,
                                              GError** error);
static void transaction_controller_finalize (TransactionController * obj);
GType data_object_get_type (void) G_GNUC_CONST;
GType data_source_get_type (void) G_GNUC_CONST;
GType thumbnail_source_get_type (void) G_GNUC_CONST;
GType media_source_get_type (void) G_GNUC_CONST;
GType flaggable_get_type (void) G_GNUC_CONST;
gboolean flaggable_is_flagged (Flaggable* self);
void flaggable_mark_flagged (Flaggable* self);
void flaggable_mark_unflagged (Flaggable* self);
void flaggable_mark_many_flagged_unflagged (GeeCollection* flag,
                                            GeeCollection* unflag,
                                            TransactionController* controller,
                                            GError** error);
GType monitorable_get_type (void) G_GNUC_CONST;
gboolean monitorable_is_offline (Monitorable* self);
void monitorable_mark_online (Monitorable* self);
void monitorable_mark_offline (Monitorable* self);
void monitorable_mark_many_online_offline (GeeCollection* online,
                                           GeeCollection* offline,
                                           TransactionController* controller,
                                           GError** error);
void monitorable_set_master_file (Monitorable* self,
                                  GFile* file);
void monitorable_set_many_master_file (GeeMap* map,
                                       TransactionController* controller,
                                       GError** error);
void monitorable_set_master_timestamp (Monitorable* self,
                                       GFileInfo* info);
void monitorable_set_many_master_timestamp (GeeMap* map,
                                            TransactionController* controller,
                                            GError** error);
GType dateable_get_type (void) G_GNUC_CONST;
void dateable_set_exposure_time (Dateable* self,
                                 time_t target_time);
time_t dateable_get_exposure_time (Dateable* self);


TransactionController*
transaction_controller_construct (GType object_type)
{
	TransactionController* self = NULL;
#line 54 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	self = (TransactionController*) g_type_create_instance (object_type);
#line 54 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	return self;
#line 277 "MediaInterfaces.c"
}


void
transaction_controller_begin (TransactionController* self)
{
	GError * _inner_error_ = NULL;
#line 63 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	g_return_if_fail (IS_TRANSACTION_CONTROLLER (self));
#line 287 "MediaInterfaces.c"
	{
		gint _tmp0_;
#line 64 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
		_tmp0_ = self->priv->count;
#line 64 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
		g_rec_mutex_lock (&self->priv->__lock_count);
#line 294 "MediaInterfaces.c"
		{
			gint _tmp1_;
#line 65 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
			_tmp1_ = self->priv->count;
#line 65 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
			self->priv->count = _tmp1_ + 1;
#line 65 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
			if (_tmp1_ != 0) {
#line 303 "MediaInterfaces.c"
				{
					gint _tmp2_;
#line 64 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
					_tmp2_ = self->priv->count;
#line 64 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
					g_rec_mutex_unlock (&self->priv->__lock_count);
#line 310 "MediaInterfaces.c"
				}
#line 66 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
				return;
#line 314 "MediaInterfaces.c"
			}
			{
#line 69 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
				transaction_controller_begin_impl (self, &_inner_error_);
#line 69 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 321 "MediaInterfaces.c"
					goto __catch583_g_error;
				}
			}
			goto __finally583;
			__catch583_g_error:
			{
				GError* err = NULL;
				gint _tmp3_;
				GError* _tmp4_;
#line 68 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
				err = _inner_error_;
#line 68 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
				_inner_error_ = NULL;
#line 72 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
				_tmp3_ = self->priv->count;
#line 72 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
				self->priv->count = _tmp3_ - 1;
#line 74 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
				_tmp4_ = err;
#line 74 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
				if (_tmp4_->domain == DATABASE_ERROR) {
#line 343 "MediaInterfaces.c"
					GError* _tmp5_;
#line 75 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
					_tmp5_ = err;
#line 75 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
					app_window_database_error ((GError*) _tmp5_);
#line 349 "MediaInterfaces.c"
				} else {
					GError* _tmp6_;
					const gchar* _tmp7_;
					gchar* _tmp8_;
					gchar* _tmp9_;
#line 77 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
					_tmp6_ = err;
#line 77 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
					_tmp7_ = _tmp6_->message;
#line 77 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
					_tmp8_ = g_strdup_printf ("%s", _tmp7_);
#line 77 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
					_tmp9_ = _tmp8_;
#line 77 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
					app_window_panic (_tmp9_);
#line 77 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
					_g_free0 (_tmp9_);
#line 367 "MediaInterfaces.c"
				}
#line 68 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
				_g_error_free0 (err);
#line 371 "MediaInterfaces.c"
			}
			__finally583:
#line 68 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 376 "MediaInterfaces.c"
				{
					gint _tmp10_;
#line 64 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
					_tmp10_ = self->priv->count;
#line 64 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
					g_rec_mutex_unlock (&self->priv->__lock_count);
#line 383 "MediaInterfaces.c"
				}
#line 68 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 68 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
				g_clear_error (&_inner_error_);
#line 68 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
				return;
#line 391 "MediaInterfaces.c"
			}
		}
		__finally582:
		{
			gint _tmp11_;
#line 64 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
			_tmp11_ = self->priv->count;
#line 64 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
			g_rec_mutex_unlock (&self->priv->__lock_count);
#line 401 "MediaInterfaces.c"
		}
#line 64 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 64 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 64 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 64 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
			return;
#line 411 "MediaInterfaces.c"
		}
	}
}


static void
transaction_controller_real_begin_impl (TransactionController* self,
                                        GError** error)
{
#line 83 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	g_critical ("Type `%s' does not implement abstract method `transaction_controller_begin_impl'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 83 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	return;
#line 425 "MediaInterfaces.c"
}


void
transaction_controller_begin_impl (TransactionController* self,
                                   GError** error)
{
#line 83 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	g_return_if_fail (IS_TRANSACTION_CONTROLLER (self));
#line 83 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	TRANSACTION_CONTROLLER_GET_CLASS (self)->begin_impl (self, error);
#line 437 "MediaInterfaces.c"
}


void
transaction_controller_commit (TransactionController* self)
{
	GError * _inner_error_ = NULL;
#line 85 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	g_return_if_fail (IS_TRANSACTION_CONTROLLER (self));
#line 447 "MediaInterfaces.c"
	{
		gint _tmp0_;
#line 86 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
		_tmp0_ = self->priv->count;
#line 86 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
		g_rec_mutex_lock (&self->priv->__lock_count);
#line 454 "MediaInterfaces.c"
		{
			gint _tmp1_;
			gint _tmp2_;
			gint _tmp3_;
#line 87 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
			_tmp1_ = self->priv->count;
#line 87 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
			_vala_assert (_tmp1_ > 0, "count > 0");
#line 88 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
			_tmp2_ = self->priv->count;
#line 88 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
			self->priv->count = _tmp2_ - 1;
#line 88 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
			_tmp3_ = self->priv->count;
#line 88 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
			if (_tmp3_ != 0) {
#line 471 "MediaInterfaces.c"
				{
					gint _tmp4_;
#line 86 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
					_tmp4_ = self->priv->count;
#line 86 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
					g_rec_mutex_unlock (&self->priv->__lock_count);
#line 478 "MediaInterfaces.c"
				}
#line 89 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
				return;
#line 482 "MediaInterfaces.c"
			}
			{
#line 93 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
				transaction_controller_commit_impl (self, &_inner_error_);
#line 93 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 489 "MediaInterfaces.c"
					goto __catch585_g_error;
				}
			}
			goto __finally585;
			__catch585_g_error:
			{
				GError* err = NULL;
				GError* _tmp5_;
#line 92 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
				err = _inner_error_;
#line 92 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
				_inner_error_ = NULL;
#line 95 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
				_tmp5_ = err;
#line 95 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
				if (_tmp5_->domain == DATABASE_ERROR) {
#line 506 "MediaInterfaces.c"
					GError* _tmp6_;
#line 96 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
					_tmp6_ = err;
#line 96 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
					app_window_database_error ((GError*) _tmp6_);
#line 512 "MediaInterfaces.c"
				} else {
					GError* _tmp7_;
					const gchar* _tmp8_;
					gchar* _tmp9_;
					gchar* _tmp10_;
#line 98 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
					_tmp7_ = err;
#line 98 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
					_tmp8_ = _tmp7_->message;
#line 98 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
					_tmp9_ = g_strdup_printf ("%s", _tmp8_);
#line 98 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
					_tmp10_ = _tmp9_;
#line 98 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
					app_window_panic (_tmp10_);
#line 98 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
					_g_free0 (_tmp10_);
#line 530 "MediaInterfaces.c"
				}
#line 92 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
				_g_error_free0 (err);
#line 534 "MediaInterfaces.c"
			}
			__finally585:
#line 92 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 539 "MediaInterfaces.c"
				{
					gint _tmp11_;
#line 86 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
					_tmp11_ = self->priv->count;
#line 86 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
					g_rec_mutex_unlock (&self->priv->__lock_count);
#line 546 "MediaInterfaces.c"
				}
#line 92 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 92 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
				g_clear_error (&_inner_error_);
#line 92 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
				return;
#line 554 "MediaInterfaces.c"
			}
		}
		__finally584:
		{
			gint _tmp12_;
#line 86 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
			_tmp12_ = self->priv->count;
#line 86 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
			g_rec_mutex_unlock (&self->priv->__lock_count);
#line 564 "MediaInterfaces.c"
		}
#line 86 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 86 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 86 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 86 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
			return;
#line 574 "MediaInterfaces.c"
		}
	}
}


static void
transaction_controller_real_commit_impl (TransactionController* self,
                                         GError** error)
{
#line 104 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	g_critical ("Type `%s' does not implement abstract method `transaction_controller_commit_impl'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 104 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	return;
#line 588 "MediaInterfaces.c"
}


void
transaction_controller_commit_impl (TransactionController* self,
                                    GError** error)
{
#line 104 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	g_return_if_fail (IS_TRANSACTION_CONTROLLER (self));
#line 104 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	TRANSACTION_CONTROLLER_GET_CLASS (self)->commit_impl (self, error);
#line 600 "MediaInterfaces.c"
}


static void
value_transaction_controller_init (GValue* value)
{
#line 51 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	value->data[0].v_pointer = NULL;
#line 609 "MediaInterfaces.c"
}


static void
value_transaction_controller_free_value (GValue* value)
{
#line 51 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	if (value->data[0].v_pointer) {
#line 51 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
		transaction_controller_unref (value->data[0].v_pointer);
#line 620 "MediaInterfaces.c"
	}
}


static void
value_transaction_controller_copy_value (const GValue* src_value,
                                         GValue* dest_value)
{
#line 51 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	if (src_value->data[0].v_pointer) {
#line 51 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
		dest_value->data[0].v_pointer = transaction_controller_ref (src_value->data[0].v_pointer);
#line 633 "MediaInterfaces.c"
	} else {
#line 51 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
		dest_value->data[0].v_pointer = NULL;
#line 637 "MediaInterfaces.c"
	}
}


static gpointer
value_transaction_controller_peek_pointer (const GValue* value)
{
#line 51 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	return value->data[0].v_pointer;
#line 647 "MediaInterfaces.c"
}


static gchar*
value_transaction_controller_collect_value (GValue* value,
                                            guint n_collect_values,
                                            GTypeCValue* collect_values,
                                            guint collect_flags)
{
#line 51 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	if (collect_values[0].v_pointer) {
#line 659 "MediaInterfaces.c"
		TransactionController * object;
		object = collect_values[0].v_pointer;
#line 51 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
		if (object->parent_instance.g_class == NULL) {
#line 51 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 666 "MediaInterfaces.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 51 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 670 "MediaInterfaces.c"
		}
#line 51 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
		value->data[0].v_pointer = transaction_controller_ref (object);
#line 674 "MediaInterfaces.c"
	} else {
#line 51 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
		value->data[0].v_pointer = NULL;
#line 678 "MediaInterfaces.c"
	}
#line 51 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	return NULL;
#line 682 "MediaInterfaces.c"
}


static gchar*
value_transaction_controller_lcopy_value (const GValue* value,
                                          guint n_collect_values,
                                          GTypeCValue* collect_values,
                                          guint collect_flags)
{
	TransactionController ** object_p;
	object_p = collect_values[0].v_pointer;
#line 51 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	if (!object_p) {
#line 51 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 698 "MediaInterfaces.c"
	}
#line 51 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	if (!value->data[0].v_pointer) {
#line 51 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
		*object_p = NULL;
#line 704 "MediaInterfaces.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 51 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
		*object_p = value->data[0].v_pointer;
#line 708 "MediaInterfaces.c"
	} else {
#line 51 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
		*object_p = transaction_controller_ref (value->data[0].v_pointer);
#line 712 "MediaInterfaces.c"
	}
#line 51 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	return NULL;
#line 716 "MediaInterfaces.c"
}


GParamSpec*
param_spec_transaction_controller (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags)
{
	ParamSpecTransactionController* spec;
#line 51 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_TRANSACTION_CONTROLLER), NULL);
#line 51 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 51 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 51 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	return G_PARAM_SPEC (spec);
#line 736 "MediaInterfaces.c"
}


gpointer
value_get_transaction_controller (const GValue* value)
{
#line 51 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TRANSACTION_CONTROLLER), NULL);
#line 51 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	return value->data[0].v_pointer;
#line 747 "MediaInterfaces.c"
}


void
value_set_transaction_controller (GValue* value,
                                  gpointer v_object)
{
	TransactionController * old;
#line 51 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TRANSACTION_CONTROLLER));
#line 51 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	old = value->data[0].v_pointer;
#line 51 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	if (v_object) {
#line 51 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TRANSACTION_CONTROLLER));
#line 51 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 51 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
		value->data[0].v_pointer = v_object;
#line 51 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
		transaction_controller_ref (value->data[0].v_pointer);
#line 770 "MediaInterfaces.c"
	} else {
#line 51 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
		value->data[0].v_pointer = NULL;
#line 774 "MediaInterfaces.c"
	}
#line 51 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	if (old) {
#line 51 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
		transaction_controller_unref (old);
#line 780 "MediaInterfaces.c"
	}
}


void
value_take_transaction_controller (GValue* value,
                                   gpointer v_object)
{
	TransactionController * old;
#line 51 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TRANSACTION_CONTROLLER));
#line 51 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	old = value->data[0].v_pointer;
#line 51 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	if (v_object) {
#line 51 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TRANSACTION_CONTROLLER));
#line 51 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 51 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
		value->data[0].v_pointer = v_object;
#line 802 "MediaInterfaces.c"
	} else {
#line 51 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
		value->data[0].v_pointer = NULL;
#line 806 "MediaInterfaces.c"
	}
#line 51 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	if (old) {
#line 51 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
		transaction_controller_unref (old);
#line 812 "MediaInterfaces.c"
	}
}


static void
transaction_controller_class_init (TransactionControllerClass * klass)
{
#line 51 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	transaction_controller_parent_class = g_type_class_peek_parent (klass);
#line 51 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	((TransactionControllerClass *) klass)->finalize = transaction_controller_finalize;
#line 51 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	g_type_class_add_private (klass, sizeof (TransactionControllerPrivate));
#line 51 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	((TransactionControllerClass *) klass)->begin_impl = (void (*) (TransactionController *, GError**)) transaction_controller_real_begin_impl;
#line 51 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	((TransactionControllerClass *) klass)->commit_impl = (void (*) (TransactionController *, GError**)) transaction_controller_real_commit_impl;
#line 830 "MediaInterfaces.c"
}


static void
transaction_controller_instance_init (TransactionController * self)
{
#line 51 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	self->priv = TRANSACTION_CONTROLLER_GET_PRIVATE (self);
#line 52 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	g_rec_mutex_init (&self->priv->__lock_count);
#line 52 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	self->priv->count = 0;
#line 51 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	self->ref_count = 1;
#line 845 "MediaInterfaces.c"
}


static void
transaction_controller_finalize (TransactionController * obj)
{
	TransactionController * self;
	GError * _inner_error_ = NULL;
#line 51 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TRANSACTION_CONTROLLER, TransactionController);
#line 51 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	g_signal_handlers_destroy (self);
#line 858 "MediaInterfaces.c"
	{
		gint _tmp0_;
#line 58 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
		_tmp0_ = self->priv->count;
#line 58 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
		g_rec_mutex_lock (&self->priv->__lock_count);
#line 865 "MediaInterfaces.c"
		{
			gint _tmp1_;
#line 59 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
			_tmp1_ = self->priv->count;
#line 59 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
			_vala_assert (_tmp1_ == 0, "count == 0");
#line 872 "MediaInterfaces.c"
		}
		__finally581:
		{
			gint _tmp2_;
#line 58 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
			_tmp2_ = self->priv->count;
#line 58 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
			g_rec_mutex_unlock (&self->priv->__lock_count);
#line 881 "MediaInterfaces.c"
		}
#line 58 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 58 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 58 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 889 "MediaInterfaces.c"
		}
	}
#line 52 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	g_rec_mutex_clear (&self->priv->__lock_count);
#line 894 "MediaInterfaces.c"
}


GType
transaction_controller_get_type (void)
{
	static volatile gsize transaction_controller_type_id__volatile = 0;
	if (g_once_init_enter (&transaction_controller_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_transaction_controller_init, value_transaction_controller_free_value, value_transaction_controller_copy_value, value_transaction_controller_peek_pointer, "p", value_transaction_controller_collect_value, "p", value_transaction_controller_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TransactionControllerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) transaction_controller_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TransactionController), 0, (GInstanceInitFunc) transaction_controller_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType transaction_controller_type_id;
		transaction_controller_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TransactionController", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&transaction_controller_type_id__volatile, transaction_controller_type_id);
	}
	return transaction_controller_type_id__volatile;
}


gpointer
transaction_controller_ref (gpointer instance)
{
	TransactionController * self;
	self = instance;
#line 51 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	g_atomic_int_inc (&self->ref_count);
#line 51 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	return instance;
#line 923 "MediaInterfaces.c"
}


void
transaction_controller_unref (gpointer instance)
{
	TransactionController * self;
	self = instance;
#line 51 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 51 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
		TRANSACTION_CONTROLLER_GET_CLASS (self)->finalize (self);
#line 51 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 938 "MediaInterfaces.c"
	}
}


gboolean
flaggable_is_flagged (Flaggable* self)
{
#line 115 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	g_return_val_if_fail (IS_FLAGGABLE (self), FALSE);
#line 115 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	return FLAGGABLE_GET_INTERFACE (self)->is_flagged (self);
#line 950 "MediaInterfaces.c"
}


void
flaggable_mark_flagged (Flaggable* self)
{
#line 117 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	g_return_if_fail (IS_FLAGGABLE (self));
#line 117 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	FLAGGABLE_GET_INTERFACE (self)->mark_flagged (self);
#line 961 "MediaInterfaces.c"
}


void
flaggable_mark_unflagged (Flaggable* self)
{
#line 119 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	g_return_if_fail (IS_FLAGGABLE (self));
#line 119 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	FLAGGABLE_GET_INTERFACE (self)->mark_unflagged (self);
#line 972 "MediaInterfaces.c"
}


void
flaggable_mark_many_flagged_unflagged (GeeCollection* flag,
                                       GeeCollection* unflag,
                                       TransactionController* controller,
                                       GError** error)
{
#line 121 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	g_return_if_fail ((flag == NULL) || GEE_IS_COLLECTION (flag));
#line 121 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	g_return_if_fail ((unflag == NULL) || GEE_IS_COLLECTION (unflag));
#line 121 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	g_return_if_fail (IS_TRANSACTION_CONTROLLER (controller));
#line 123 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	transaction_controller_begin (controller);
#line 125 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	if (flag != NULL) {
#line 992 "MediaInterfaces.c"
		{
			GeeIterator* _flaggable_it = NULL;
			GeeIterator* _tmp0_;
#line 126 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
			_tmp0_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (flag, GEE_TYPE_ITERABLE, GeeIterable));
#line 126 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
			_flaggable_it = _tmp0_;
#line 126 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
			while (TRUE) {
#line 1002 "MediaInterfaces.c"
				GeeIterator* _tmp1_;
				Flaggable* flaggable = NULL;
				GeeIterator* _tmp2_;
				gpointer _tmp3_;
				Flaggable* _tmp4_;
#line 126 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
				_tmp1_ = _flaggable_it;
#line 126 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
				if (!gee_iterator_next (_tmp1_)) {
#line 126 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
					break;
#line 1014 "MediaInterfaces.c"
				}
#line 126 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
				_tmp2_ = _flaggable_it;
#line 126 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
				_tmp3_ = gee_iterator_get (_tmp2_);
#line 126 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
				flaggable = (Flaggable*) _tmp3_;
#line 127 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
				_tmp4_ = flaggable;
#line 127 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
				flaggable_mark_flagged (_tmp4_);
#line 126 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
				_g_object_unref0 (flaggable);
#line 1028 "MediaInterfaces.c"
			}
#line 126 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
			_g_object_unref0 (_flaggable_it);
#line 1032 "MediaInterfaces.c"
		}
	}
#line 130 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	if (unflag != NULL) {
#line 1037 "MediaInterfaces.c"
		{
			GeeIterator* _flaggable_it = NULL;
			GeeIterator* _tmp5_;
#line 131 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
			_tmp5_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (unflag, GEE_TYPE_ITERABLE, GeeIterable));
#line 131 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
			_flaggable_it = _tmp5_;
#line 131 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
			while (TRUE) {
#line 1047 "MediaInterfaces.c"
				GeeIterator* _tmp6_;
				Flaggable* flaggable = NULL;
				GeeIterator* _tmp7_;
				gpointer _tmp8_;
				Flaggable* _tmp9_;
#line 131 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
				_tmp6_ = _flaggable_it;
#line 131 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
				if (!gee_iterator_next (_tmp6_)) {
#line 131 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
					break;
#line 1059 "MediaInterfaces.c"
				}
#line 131 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
				_tmp7_ = _flaggable_it;
#line 131 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
				_tmp8_ = gee_iterator_get (_tmp7_);
#line 131 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
				flaggable = (Flaggable*) _tmp8_;
#line 132 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
				_tmp9_ = flaggable;
#line 132 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
				flaggable_mark_unflagged (_tmp9_);
#line 131 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
				_g_object_unref0 (flaggable);
#line 1073 "MediaInterfaces.c"
			}
#line 131 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
			_g_object_unref0 (_flaggable_it);
#line 1077 "MediaInterfaces.c"
		}
	}
#line 135 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	transaction_controller_commit (controller);
#line 1082 "MediaInterfaces.c"
}


static void
flaggable_base_init (FlaggableIface * iface)
{
#line 114 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	static gboolean initialized = FALSE;
#line 114 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	if (!initialized) {
#line 114 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
		initialized = TRUE;
#line 1095 "MediaInterfaces.c"
	}
}


GType
flaggable_get_type (void)
{
	static volatile gsize flaggable_type_id__volatile = 0;
	if (g_once_init_enter (&flaggable_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FlaggableIface), (GBaseInitFunc) flaggable_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType flaggable_type_id;
		flaggable_type_id = g_type_register_static (G_TYPE_INTERFACE, "Flaggable", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (flaggable_type_id, TYPE_MEDIA_SOURCE);
		g_once_init_leave (&flaggable_type_id__volatile, flaggable_type_id);
	}
	return flaggable_type_id__volatile;
}


gboolean
monitorable_is_offline (Monitorable* self)
{
#line 153 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	g_return_val_if_fail (IS_MONITORABLE (self), FALSE);
#line 153 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	return MONITORABLE_GET_INTERFACE (self)->is_offline (self);
#line 1122 "MediaInterfaces.c"
}


void
monitorable_mark_online (Monitorable* self)
{
#line 155 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	g_return_if_fail (IS_MONITORABLE (self));
#line 155 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	MONITORABLE_GET_INTERFACE (self)->mark_online (self);
#line 1133 "MediaInterfaces.c"
}


void
monitorable_mark_offline (Monitorable* self)
{
#line 157 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	g_return_if_fail (IS_MONITORABLE (self));
#line 157 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	MONITORABLE_GET_INTERFACE (self)->mark_offline (self);
#line 1144 "MediaInterfaces.c"
}


void
monitorable_mark_many_online_offline (GeeCollection* online,
                                      GeeCollection* offline,
                                      TransactionController* controller,
                                      GError** error)
{
#line 159 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	g_return_if_fail ((online == NULL) || GEE_IS_COLLECTION (online));
#line 159 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	g_return_if_fail ((offline == NULL) || GEE_IS_COLLECTION (offline));
#line 159 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	g_return_if_fail (IS_TRANSACTION_CONTROLLER (controller));
#line 161 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	transaction_controller_begin (controller);
#line 163 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	if (online != NULL) {
#line 1164 "MediaInterfaces.c"
		{
			GeeIterator* _monitorable_it = NULL;
			GeeIterator* _tmp0_;
#line 164 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
			_tmp0_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (online, GEE_TYPE_ITERABLE, GeeIterable));
#line 164 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
			_monitorable_it = _tmp0_;
#line 164 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
			while (TRUE) {
#line 1174 "MediaInterfaces.c"
				GeeIterator* _tmp1_;
				Monitorable* monitorable = NULL;
				GeeIterator* _tmp2_;
				gpointer _tmp3_;
				Monitorable* _tmp4_;
#line 164 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
				_tmp1_ = _monitorable_it;
#line 164 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
				if (!gee_iterator_next (_tmp1_)) {
#line 164 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
					break;
#line 1186 "MediaInterfaces.c"
				}
#line 164 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
				_tmp2_ = _monitorable_it;
#line 164 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
				_tmp3_ = gee_iterator_get (_tmp2_);
#line 164 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
				monitorable = (Monitorable*) _tmp3_;
#line 165 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
				_tmp4_ = monitorable;
#line 165 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
				monitorable_mark_online (_tmp4_);
#line 164 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
				_g_object_unref0 (monitorable);
#line 1200 "MediaInterfaces.c"
			}
#line 164 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
			_g_object_unref0 (_monitorable_it);
#line 1204 "MediaInterfaces.c"
		}
	}
#line 168 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	if (offline != NULL) {
#line 1209 "MediaInterfaces.c"
		{
			GeeIterator* _monitorable_it = NULL;
			GeeIterator* _tmp5_;
#line 169 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
			_tmp5_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (offline, GEE_TYPE_ITERABLE, GeeIterable));
#line 169 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
			_monitorable_it = _tmp5_;
#line 169 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
			while (TRUE) {
#line 1219 "MediaInterfaces.c"
				GeeIterator* _tmp6_;
				Monitorable* monitorable = NULL;
				GeeIterator* _tmp7_;
				gpointer _tmp8_;
				Monitorable* _tmp9_;
#line 169 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
				_tmp6_ = _monitorable_it;
#line 169 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
				if (!gee_iterator_next (_tmp6_)) {
#line 169 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
					break;
#line 1231 "MediaInterfaces.c"
				}
#line 169 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
				_tmp7_ = _monitorable_it;
#line 169 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
				_tmp8_ = gee_iterator_get (_tmp7_);
#line 169 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
				monitorable = (Monitorable*) _tmp8_;
#line 170 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
				_tmp9_ = monitorable;
#line 170 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
				monitorable_mark_offline (_tmp9_);
#line 169 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
				_g_object_unref0 (monitorable);
#line 1245 "MediaInterfaces.c"
			}
#line 169 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
			_g_object_unref0 (_monitorable_it);
#line 1249 "MediaInterfaces.c"
		}
	}
#line 173 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	transaction_controller_commit (controller);
#line 1254 "MediaInterfaces.c"
}


void
monitorable_set_master_file (Monitorable* self,
                             GFile* file)
{
#line 176 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	g_return_if_fail (IS_MONITORABLE (self));
#line 176 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	MONITORABLE_GET_INTERFACE (self)->set_master_file (self, file);
#line 1266 "MediaInterfaces.c"
}


void
monitorable_set_many_master_file (GeeMap* map,
                                  TransactionController* controller,
                                  GError** error)
{
	GeeMapIterator* map_iter = NULL;
	GeeMapIterator* _tmp0_;
#line 178 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	g_return_if_fail (GEE_IS_MAP (map));
#line 178 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	g_return_if_fail (IS_TRANSACTION_CONTROLLER (controller));
#line 180 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	transaction_controller_begin (controller);
#line 182 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	_tmp0_ = gee_map_map_iterator (map);
#line 182 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	map_iter = _tmp0_;
#line 183 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	while (TRUE) {
#line 1289 "MediaInterfaces.c"
		GeeMapIterator* _tmp1_;
		GeeMapIterator* _tmp2_;
		gpointer _tmp3_;
		Monitorable* _tmp4_;
		GeeMapIterator* _tmp5_;
		gpointer _tmp6_;
		GFile* _tmp7_;
#line 183 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
		_tmp1_ = map_iter;
#line 183 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
		if (!gee_map_iterator_next (_tmp1_)) {
#line 183 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
			break;
#line 1303 "MediaInterfaces.c"
		}
#line 184 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
		_tmp2_ = map_iter;
#line 184 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
		_tmp3_ = gee_map_iterator_get_key (_tmp2_);
#line 184 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
		_tmp4_ = (Monitorable*) _tmp3_;
#line 184 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
		_tmp5_ = map_iter;
#line 184 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
		_tmp6_ = gee_map_iterator_get_value (_tmp5_);
#line 184 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
		_tmp7_ = (GFile*) _tmp6_;
#line 184 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
		monitorable_set_master_file (_tmp4_, _tmp7_);
#line 184 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
		_g_object_unref0 (_tmp7_);
#line 184 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
		_g_object_unref0 (_tmp4_);
#line 1323 "MediaInterfaces.c"
	}
#line 186 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	transaction_controller_commit (controller);
#line 178 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	_g_object_unref0 (map_iter);
#line 1329 "MediaInterfaces.c"
}


void
monitorable_set_master_timestamp (Monitorable* self,
                                  GFileInfo* info)
{
#line 189 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	g_return_if_fail (IS_MONITORABLE (self));
#line 189 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	MONITORABLE_GET_INTERFACE (self)->set_master_timestamp (self, info);
#line 1341 "MediaInterfaces.c"
}


void
monitorable_set_many_master_timestamp (GeeMap* map,
                                       TransactionController* controller,
                                       GError** error)
{
	GeeMapIterator* map_iter = NULL;
	GeeMapIterator* _tmp0_;
#line 191 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	g_return_if_fail (GEE_IS_MAP (map));
#line 191 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	g_return_if_fail (IS_TRANSACTION_CONTROLLER (controller));
#line 193 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	transaction_controller_begin (controller);
#line 195 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	_tmp0_ = gee_map_map_iterator (map);
#line 195 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	map_iter = _tmp0_;
#line 196 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	while (TRUE) {
#line 1364 "MediaInterfaces.c"
		GeeMapIterator* _tmp1_;
		GeeMapIterator* _tmp2_;
		gpointer _tmp3_;
		Monitorable* _tmp4_;
		GeeMapIterator* _tmp5_;
		gpointer _tmp6_;
		GFileInfo* _tmp7_;
#line 196 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
		_tmp1_ = map_iter;
#line 196 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
		if (!gee_map_iterator_next (_tmp1_)) {
#line 196 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
			break;
#line 1378 "MediaInterfaces.c"
		}
#line 197 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
		_tmp2_ = map_iter;
#line 197 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
		_tmp3_ = gee_map_iterator_get_key (_tmp2_);
#line 197 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
		_tmp4_ = (Monitorable*) _tmp3_;
#line 197 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
		_tmp5_ = map_iter;
#line 197 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
		_tmp6_ = gee_map_iterator_get_value (_tmp5_);
#line 197 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
		_tmp7_ = (GFileInfo*) _tmp6_;
#line 197 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
		monitorable_set_master_timestamp (_tmp4_, _tmp7_);
#line 197 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
		_g_object_unref0 (_tmp7_);
#line 197 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
		_g_object_unref0 (_tmp4_);
#line 1398 "MediaInterfaces.c"
	}
#line 199 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	transaction_controller_commit (controller);
#line 191 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	_g_object_unref0 (map_iter);
#line 1404 "MediaInterfaces.c"
}


static void
monitorable_base_init (MonitorableIface * iface)
{
#line 152 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	static gboolean initialized = FALSE;
#line 152 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	if (!initialized) {
#line 152 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
		initialized = TRUE;
#line 1417 "MediaInterfaces.c"
	}
}


GType
monitorable_get_type (void)
{
	static volatile gsize monitorable_type_id__volatile = 0;
	if (g_once_init_enter (&monitorable_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MonitorableIface), (GBaseInitFunc) monitorable_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType monitorable_type_id;
		monitorable_type_id = g_type_register_static (G_TYPE_INTERFACE, "Monitorable", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (monitorable_type_id, TYPE_MEDIA_SOURCE);
		g_once_init_leave (&monitorable_type_id__volatile, monitorable_type_id);
	}
	return monitorable_type_id__volatile;
}


void
dateable_set_exposure_time (Dateable* self,
                            time_t target_time)
{
#line 212 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	g_return_if_fail (IS_DATEABLE (self));
#line 212 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	DATEABLE_GET_INTERFACE (self)->set_exposure_time (self, target_time);
#line 1445 "MediaInterfaces.c"
}


time_t
dateable_get_exposure_time (Dateable* self)
{
#line 214 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	g_return_val_if_fail (IS_DATEABLE (self), 0);
#line 214 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	return DATEABLE_GET_INTERFACE (self)->get_exposure_time (self);
#line 1456 "MediaInterfaces.c"
}


static void
dateable_base_init (DateableIface * iface)
{
#line 211 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	static gboolean initialized = FALSE;
#line 211 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
	if (!initialized) {
#line 211 "/home/jens/Source/shotwell/src/MediaInterfaces.vala"
		initialized = TRUE;
#line 1469 "MediaInterfaces.c"
	}
}


GType
dateable_get_type (void)
{
	static volatile gsize dateable_type_id__volatile = 0;
	if (g_once_init_enter (&dateable_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DateableIface), (GBaseInitFunc) dateable_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType dateable_type_id;
		dateable_type_id = g_type_register_static (G_TYPE_INTERFACE, "Dateable", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (dateable_type_id, TYPE_MEDIA_SOURCE);
		g_once_init_leave (&dateable_type_id__volatile, dateable_type_id);
	}
	return dateable_type_id__volatile;
}



