/* Thumbnail.c generated by valac 0.40.4, the Vala compiler
 * generated from Thumbnail.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <cairo.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gio/gio.h>
#include <gee.h>
#include <pango/pango.h>
#include <time.h>


#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;
typedef struct _DataObjectPrivate DataObjectPrivate;

#define TYPE_ALTERATION (alteration_get_type ())
#define ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALTERATION, Alteration))
#define ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALTERATION, AlterationClass))
#define IS_ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALTERATION))
#define IS_ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALTERATION))
#define ALTERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALTERATION, AlterationClass))

typedef struct _Alteration Alteration;
typedef struct _AlterationClass AlterationClass;

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;

#define TYPE_DATA_VIEW (data_view_get_type ())
#define DATA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_VIEW, DataView))
#define DATA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_VIEW, DataViewClass))
#define IS_DATA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_VIEW))
#define IS_DATA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_VIEW))
#define DATA_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_VIEW, DataViewClass))

typedef struct _DataView DataView;
typedef struct _DataViewClass DataViewClass;
typedef struct _DataViewPrivate DataViewPrivate;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_THUMBNAIL_VIEW (thumbnail_view_get_type ())
#define THUMBNAIL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_VIEW, ThumbnailView))
#define THUMBNAIL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_VIEW, ThumbnailViewClass))
#define IS_THUMBNAIL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_VIEW))
#define IS_THUMBNAIL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_VIEW))
#define THUMBNAIL_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_VIEW, ThumbnailViewClass))

typedef struct _ThumbnailView ThumbnailView;
typedef struct _ThumbnailViewClass ThumbnailViewClass;
typedef struct _ThumbnailViewPrivate ThumbnailViewPrivate;

#define TYPE_CHECKERBOARD_ITEM (checkerboard_item_get_type ())
#define CHECKERBOARD_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHECKERBOARD_ITEM, CheckerboardItem))
#define CHECKERBOARD_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHECKERBOARD_ITEM, CheckerboardItemClass))
#define IS_CHECKERBOARD_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHECKERBOARD_ITEM))
#define IS_CHECKERBOARD_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHECKERBOARD_ITEM))
#define CHECKERBOARD_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHECKERBOARD_ITEM, CheckerboardItemClass))

typedef struct _CheckerboardItem CheckerboardItem;
typedef struct _CheckerboardItemClass CheckerboardItemClass;
typedef struct _CheckerboardItemPrivate CheckerboardItemPrivate;

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;

#define TYPE_MEDIA_SOURCE_ITEM (media_source_item_get_type ())
#define MEDIA_SOURCE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE_ITEM, MediaSourceItem))
#define MEDIA_SOURCE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE_ITEM, MediaSourceItemClass))
#define IS_MEDIA_SOURCE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE_ITEM))
#define IS_MEDIA_SOURCE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE_ITEM))
#define MEDIA_SOURCE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE_ITEM, MediaSourceItemClass))

typedef struct _MediaSourceItem MediaSourceItem;
typedef struct _MediaSourceItemClass MediaSourceItemClass;
typedef struct _MediaSourceItemPrivate MediaSourceItemPrivate;

#define TYPE_THUMBNAIL (thumbnail_get_type ())
#define THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL, Thumbnail))
#define THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL, ThumbnailClass))
#define IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL))
#define IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL))
#define THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL, ThumbnailClass))

typedef struct _Thumbnail Thumbnail;
typedef struct _ThumbnailClass ThumbnailClass;
typedef struct _ThumbnailPrivate ThumbnailPrivate;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;
enum  {
	THUMBNAIL_0_PROPERTY,
	THUMBNAIL_NUM_PROPERTIES
};
static GParamSpec* thumbnail_properties[THUMBNAIL_NUM_PROPERTIES];

#define TYPE_SOURCE_COLLECTION (source_collection_get_type ())
#define SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_COLLECTION, SourceCollection))
#define SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_COLLECTION, SourceCollectionClass))
#define IS_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_COLLECTION))
#define IS_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_COLLECTION))
#define SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_COLLECTION, SourceCollectionClass))

typedef struct _SourceCollection SourceCollection;
typedef struct _SourceCollectionClass SourceCollectionClass;

#define TYPE_DATABASE_SOURCE_COLLECTION (database_source_collection_get_type ())
#define DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection))
#define DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))
#define IS_DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_SOURCE_COLLECTION))
#define IS_DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_SOURCE_COLLECTION))
#define DATABASE_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))

typedef struct _DatabaseSourceCollection DatabaseSourceCollection;
typedef struct _DatabaseSourceCollectionClass DatabaseSourceCollectionClass;

#define TYPE_CONTAINER_SOURCE_COLLECTION (container_source_collection_get_type ())
#define CONTAINER_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection))
#define CONTAINER_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollectionClass))
#define IS_CONTAINER_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONTAINER_SOURCE_COLLECTION))
#define IS_CONTAINER_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONTAINER_SOURCE_COLLECTION))
#define CONTAINER_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollectionClass))

typedef struct _ContainerSourceCollection ContainerSourceCollection;
typedef struct _ContainerSourceCollectionClass ContainerSourceCollectionClass;

#define TYPE_TAG_SOURCE_COLLECTION (tag_source_collection_get_type ())
#define TAG_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAG_SOURCE_COLLECTION, TagSourceCollection))
#define TAG_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAG_SOURCE_COLLECTION, TagSourceCollectionClass))
#define IS_TAG_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAG_SOURCE_COLLECTION))
#define IS_TAG_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAG_SOURCE_COLLECTION))
#define TAG_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAG_SOURCE_COLLECTION, TagSourceCollectionClass))

typedef struct _TagSourceCollection TagSourceCollection;
typedef struct _TagSourceCollectionClass TagSourceCollectionClass;

#define TYPE_CONTAINER_SOURCE (container_source_get_type ())
#define CONTAINER_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONTAINER_SOURCE, ContainerSource))
#define IS_CONTAINER_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONTAINER_SOURCE))
#define CONTAINER_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_CONTAINER_SOURCE, ContainerSourceIface))

typedef struct _ContainerSource ContainerSource;
typedef struct _ContainerSourceIface ContainerSourceIface;

#define TYPE_SOURCE_BACKLINK (source_backlink_get_type ())
#define SOURCE_BACKLINK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_BACKLINK, SourceBacklink))
#define SOURCE_BACKLINK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_BACKLINK, SourceBacklinkClass))
#define IS_SOURCE_BACKLINK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_BACKLINK))
#define IS_SOURCE_BACKLINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_BACKLINK))
#define SOURCE_BACKLINK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_BACKLINK, SourceBacklinkClass))

typedef struct _SourceBacklink SourceBacklink;
typedef struct _SourceBacklinkClass SourceBacklinkClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define PHOTO_TYPE_EXCEPTION (photo_exception_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_PHOTO_SOURCE (photo_source_get_type ())
#define PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_SOURCE, PhotoSource))
#define PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_SOURCE, PhotoSourceClass))
#define IS_PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_SOURCE))
#define IS_PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_SOURCE))
#define PHOTO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_SOURCE, PhotoSourceClass))

typedef struct _PhotoSource PhotoSource;
typedef struct _PhotoSourceClass PhotoSourceClass;

#define TYPE_PHOTO (photo_get_type ())
#define PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO, Photo))
#define PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO, PhotoClass))
#define IS_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO))
#define IS_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO))
#define PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO, PhotoClass))

typedef struct _Photo Photo;
typedef struct _PhotoClass PhotoClass;

#define TYPE_LIBRARY_PHOTO (library_photo_get_type ())
#define LIBRARY_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_PHOTO, LibraryPhoto))
#define LIBRARY_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_PHOTO, LibraryPhotoClass))
#define IS_LIBRARY_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_PHOTO))
#define IS_LIBRARY_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_PHOTO))
#define LIBRARY_PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_PHOTO, LibraryPhotoClass))

typedef struct _LibraryPhoto LibraryPhoto;
typedef struct _LibraryPhotoClass LibraryPhotoClass;

#define TYPE_VIDEO_SOURCE (video_source_get_type ())
#define VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_SOURCE, VideoSource))
#define VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_SOURCE, VideoSourceClass))
#define IS_VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_SOURCE))
#define IS_VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_SOURCE))
#define VIDEO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_SOURCE, VideoSourceClass))

typedef struct _VideoSource VideoSource;
typedef struct _VideoSourceClass VideoSourceClass;

#define TYPE_VIDEO (video_get_type ())
#define VIDEO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO, Video))
#define VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO, VideoClass))
#define IS_VIDEO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO))
#define IS_VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO))
#define VIDEO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO, VideoClass))

typedef struct _Video Video;
typedef struct _VideoClass VideoClass;

#define TYPE_TAG (tag_get_type ())
#define TAG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAG, Tag))
#define TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAG, TagClass))
#define IS_TAG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAG))
#define IS_TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAG))
#define TAG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAG, TagClass))

typedef struct _Tag Tag;
typedef struct _TagClass TagClass;

#define TYPE_RATING (rating_get_type ())

#define THUMBNAIL_CACHE_TYPE_SIZE (thumbnail_cache_size_get_type ())

#define TYPE_FLAGGABLE (flaggable_get_type ())
#define FLAGGABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FLAGGABLE, Flaggable))
#define IS_FLAGGABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FLAGGABLE))
#define FLAGGABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_FLAGGABLE, FlaggableIface))

typedef struct _Flaggable Flaggable;
typedef struct _FlaggableIface FlaggableIface;
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _DataObject {
	GObject parent_instance;
	DataObjectPrivate * priv;
};

struct _DataObjectClass {
	GObjectClass parent_class;
	void (*notify_altered) (DataObject* self, Alteration* alteration);
	void (*notify_membership_changed) (DataObject* self, DataCollection* collection);
	void (*notify_collection_property_set) (DataObject* self, const gchar* name, GValue* old, GValue* val);
	void (*notify_collection_property_cleared) (DataObject* self, const gchar* name);
	gchar* (*get_name) (DataObject* self);
	gchar* (*to_string) (DataObject* self);
};

struct _DataView {
	DataObject parent_instance;
	DataViewPrivate * priv;
};

struct _DataViewClass {
	DataObjectClass parent_class;
	void (*notify_view_altered) (DataView* self);
	void (*notify_geometry_altered) (DataView* self);
	void (*notify_unsubscribed) (DataView* self, DataSource* source);
	void (*state_changed) (DataView* self, gboolean selected);
	void (*visibility_changed) (DataView* self, gboolean visible);
	void (*view_altered) (DataView* self);
	void (*geometry_altered) (DataView* self);
	void (*unsubscribed) (DataView* self, DataSource* source);
};

struct _ThumbnailView {
	DataView parent_instance;
	ThumbnailViewPrivate * priv;
};

struct _ThumbnailViewClass {
	DataViewClass parent_class;
	void (*notify_thumbnail_altered) (ThumbnailView* self);
	void (*thumbnail_altered) (ThumbnailView* self);
};

struct _Dimensions {
	gint width;
	gint height;
};

struct _CheckerboardItem {
	ThumbnailView parent_instance;
	CheckerboardItemPrivate * priv;
	Dimensions requisition;
	GdkRectangle allocation;
};

struct _CheckerboardItemClass {
	ThumbnailViewClass parent_class;
	void (*exposed) (CheckerboardItem* self);
	void (*unexposed) (CheckerboardItem* self);
	gboolean (*is_exposed) (CheckerboardItem* self);
	void (*paint_shadow) (CheckerboardItem* self, cairo_t* ctx, Dimensions* dimensions, GdkPoint* origin, gint radius, gfloat initial_alpha);
	void (*paint_border) (CheckerboardItem* self, cairo_t* ctx, Dimensions* object_dimensions, GdkPoint* object_origin, gint border_width);
	void (*paint_image) (CheckerboardItem* self, cairo_t* ctx, GdkPixbuf* pixbuf, GdkPoint* origin);
	GdkPixbuf* (*get_top_left_trinket) (CheckerboardItem* self, gint scale);
	GdkPixbuf* (*get_top_right_trinket) (CheckerboardItem* self, gint scale);
	GdkPixbuf* (*get_bottom_left_trinket) (CheckerboardItem* self, gint scale);
	GdkPixbuf* (*get_bottom_right_trinket) (CheckerboardItem* self, gint scale);
};

struct _MediaSourceItem {
	CheckerboardItem parent_instance;
	MediaSourceItemPrivate * priv;
};

struct _MediaSourceItemClass {
	CheckerboardItemClass parent_class;
};

struct _Thumbnail {
	MediaSourceItem parent_instance;
	ThumbnailPrivate * priv;
};

struct _ThumbnailClass {
	MediaSourceItemClass parent_class;
};

struct _ThumbnailPrivate {
	MediaSource* media;
	gint scale;
	Dimensions original_dim;
	Dimensions dim;
	GdkPixbuf* unscaled_pixbuf;
	GCancellable* cancellable;
	gboolean hq_scheduled;
	gboolean hq_reschedule;
	gboolean exposure;
};

struct _ContainerSourceIface {
	GTypeInterface parent_iface;
	gboolean (*has_links) (ContainerSource* self);
	SourceBacklink* (*get_backlink) (ContainerSource* self);
	void (*break_link) (ContainerSource* self, DataSource* source);
	void (*break_link_many) (ContainerSource* self, GeeCollection* sources);
	void (*establish_link) (ContainerSource* self, DataSource* source);
	void (*establish_link_many) (ContainerSource* self, GeeCollection* sources);
};

typedef enum  {
	PHOTO_EXCEPTION_NONE = 0,
	PHOTO_EXCEPTION_ORIENTATION = 1 << 0,
	PHOTO_EXCEPTION_CROP = 1 << 1,
	PHOTO_EXCEPTION_REDEYE = 1 << 2,
	PHOTO_EXCEPTION_ADJUST = 1 << 3,
	PHOTO_EXCEPTION_STRAIGHTEN = 1 << 4,
	PHOTO_EXCEPTION_ALL = 0xFFFFFFFFLL
} PhotoException;

typedef enum  {
	RATING_REJECTED = -1,
	RATING_UNRATED = 0,
	RATING_ONE = 1,
	RATING_TWO = 2,
	RATING_THREE = 3,
	RATING_FOUR = 4,
	RATING_FIVE = 5
} Rating;

typedef void (*ThumbnailCacheAsyncFetchCallback) (GdkPixbuf* pixbuf, GdkPixbuf* unscaled, Dimensions* dim, GdkInterpType interp, GError* err, void* user_data);
typedef enum  {
	THUMBNAIL_CACHE_SIZE_LARGEST = 360,
	THUMBNAIL_CACHE_SIZE_BIG = 360,
	THUMBNAIL_CACHE_SIZE_MEDIUM = 128,
	THUMBNAIL_CACHE_SIZE_SMALLEST = 128
} ThumbnailCacheSize;

struct _FlaggableIface {
	GTypeInterface parent_iface;
	gboolean (*is_flagged) (Flaggable* self);
	void (*mark_flagged) (Flaggable* self);
	void (*mark_unflagged) (Flaggable* self);
};


static gpointer thumbnail_parent_class = NULL;
extern TagSourceCollection* tag_global;

GType data_object_get_type (void) G_GNUC_CONST;
gpointer alteration_ref (gpointer instance);
void alteration_unref (gpointer instance);
GParamSpec* param_spec_alteration (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
void value_set_alteration (GValue* value,
                           gpointer v_object);
void value_take_alteration (GValue* value,
                            gpointer v_object);
gpointer value_get_alteration (const GValue* value);
GType alteration_get_type (void) G_GNUC_CONST;
gpointer data_collection_ref (gpointer instance);
void data_collection_unref (gpointer instance);
GParamSpec* param_spec_data_collection (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
void value_set_data_collection (GValue* value,
                                gpointer v_object);
void value_take_data_collection (GValue* value,
                                 gpointer v_object);
gpointer value_get_data_collection (const GValue* value);
GType data_collection_get_type (void) G_GNUC_CONST;
GType data_view_get_type (void) G_GNUC_CONST;
GType data_source_get_type (void) G_GNUC_CONST;
GType thumbnail_view_get_type (void) G_GNUC_CONST;
GType checkerboard_item_get_type (void) G_GNUC_CONST;
GType dimensions_get_type (void) G_GNUC_CONST;
Dimensions* dimensions_dup (const Dimensions* self);
void dimensions_free (Dimensions* self);
GType media_source_item_get_type (void) G_GNUC_CONST;
GType thumbnail_get_type (void) G_GNUC_CONST;
GType thumbnail_source_get_type (void) G_GNUC_CONST;
GType media_source_get_type (void) G_GNUC_CONST;
#define THUMBNAIL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_THUMBNAIL, ThumbnailPrivate))
GType source_collection_get_type (void) G_GNUC_CONST;
GType database_source_collection_get_type (void) G_GNUC_CONST;
GType container_source_collection_get_type (void) G_GNUC_CONST;
GType tag_source_collection_get_type (void) G_GNUC_CONST;
gpointer source_backlink_ref (gpointer instance);
void source_backlink_unref (gpointer instance);
GParamSpec* param_spec_source_backlink (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
void value_set_source_backlink (GValue* value,
                                gpointer v_object);
void value_take_source_backlink (GValue* value,
                                 gpointer v_object);
gpointer value_get_source_backlink (const GValue* value);
GType source_backlink_get_type (void) G_GNUC_CONST;
GType container_source_get_type (void) G_GNUC_CONST;
static void thumbnail_on_tag_contents_altered (Thumbnail* self,
                                        ContainerSource* container,
                                        GeeCollection* added,
                                        gboolean relinking,
                                        GeeCollection* removed,
                                        gboolean unlinking);
static void _thumbnail_on_tag_contents_altered_container_source_collection_container_contents_altered (ContainerSourceCollection* _sender,
                                                                                                ContainerSource* container,
                                                                                                GeeCollection* added,
                                                                                                gboolean relinked,
                                                                                                GeeCollection* removed,
                                                                                                gboolean unlinked,
                                                                                                gpointer self);
static void thumbnail_on_tags_altered (Thumbnail* self,
                                GeeMap* altered);
static void _thumbnail_on_tags_altered_data_collection_items_altered (DataCollection* _sender,
                                                               GeeMap* items,
                                                               gpointer self);
#define CHECKERBOARD_ITEM_PROP_SHOW_SUBTITLES "show-subtitles"
#define THUMBNAIL_PROP_SHOW_TAGS CHECKERBOARD_ITEM_PROP_SHOW_SUBTITLES
#define THUMBNAIL_PROP_SIZE "thumbnail-size"
#define THUMBNAIL_PROP_SHOW_RATINGS "show-ratings"
#define THUMBNAIL_LOW_QUALITY_INTERP GDK_INTERP_NEAREST
#define THUMBNAIL_HIGH_QUALITY_INTERP GDK_INTERP_BILINEAR
#define THUMBNAIL_HQ_IMPROVEMENT_MSEC 100
Thumbnail* thumbnail_new (MediaSource* media,
                          gint scale);
Thumbnail* thumbnail_construct (GType object_type,
                                MediaSource* media,
                                gint scale);
GType photo_exception_get_type (void) G_GNUC_CONST;
void media_source_get_dimensions (MediaSource* self,
                                  PhotoException disallowed_steps,
                                  Dimensions* result);
void dimensions_get_scaled (Dimensions *self,
                            gint scale,
                            gboolean scale_up,
                            Dimensions* result);
gchar* data_object_get_name (DataObject* self);
gchar* media_source_get_comment (MediaSource* self);
MediaSourceItem* media_source_item_new (ThumbnailSource* source,
                                        Dimensions* initial_pixbuf_dim,
                                        const gchar* title,
                                        const gchar* comment,
                                        gboolean marked_up,
                                        PangoAlignment alignment);
MediaSourceItem* media_source_item_construct (GType object_type,
                                              ThumbnailSource* source,
                                              Dimensions* initial_pixbuf_dim,
                                              const gchar* title,
                                              const gchar* comment,
                                              gboolean marked_up,
                                              PangoAlignment alignment);
GType photo_source_get_type (void) G_GNUC_CONST;
GType photo_get_type (void) G_GNUC_CONST;
GType library_photo_get_type (void) G_GNUC_CONST;
GType video_source_get_type (void) G_GNUC_CONST;
GType video_get_type (void) G_GNUC_CONST;
void media_source_item_set_enable_sprockets (MediaSourceItem* self,
                                             gboolean enable_sprockets);
static void thumbnail_update_title (Thumbnail* self,
                             gboolean init);
static void thumbnail_update_comment (Thumbnail* self,
                               gboolean init);
static void thumbnail_update_tags (Thumbnail* self,
                            gboolean init);
GType tag_get_type (void) G_GNUC_CONST;
GeeSortedSet* tag_source_collection_fetch_sorted_for_source (TagSourceCollection* self,
                                                             MediaSource* photo);
void checkerboard_item_clear_tags (CheckerboardItem* self);
void checkerboard_item_set_tags (CheckerboardItem* self,
                                 GeeCollection* tags,
                                 PangoAlignment alignment);
gboolean tag_contains (Tag* self,
                       MediaSource* source);
gboolean is_string_empty (const gchar* s);
void checkerboard_item_clear_title (CheckerboardItem* self);
void media_source_item_set_title (MediaSourceItem* self,
                                  const gchar* text,
                                  gboolean marked_up,
                                  PangoAlignment alignment);
void checkerboard_item_clear_comment (CheckerboardItem* self);
void checkerboard_item_set_comment (CheckerboardItem* self,
                                    const gchar* text,
                                    gboolean marked_up,
                                    PangoAlignment alignment);
static void thumbnail_real_notify_altered (DataObject* base,
                                    Alteration* alteration);
gboolean alteration_has_detail (Alteration* self,
                                const gchar* subject,
                                const gchar* detail);
void data_object_notify_altered (DataObject* self,
                                 Alteration* alteration);
MediaSource* thumbnail_get_media_source (Thumbnail* self);
gint64 thumbnail_photo_id_ascending_comparator (void* a,
                                                void* b);
gint64 data_source_get_instance_id (DataSource* self);
gint64 thumbnail_photo_id_descending_comparator (void* a,
                                                 void* b);
gint64 thumbnail_title_ascending_comparator (void* a,
                                             void* b);
gchar* media_source_item_get_natural_collation_key (MediaSourceItem* self);
gint64 thumbnail_title_descending_comparator (void* a,
                                              void* b);
gboolean thumbnail_title_comparator_predicate (DataObject* object,
                                               Alteration* alteration);
gint64 thumbnail_exposure_time_ascending_comparator (void* a,
                                                     void* b);
time_t media_source_get_exposure_time (MediaSource* self);
gint64 thumbnail_filename_ascending_comparator (void* a,
                                                void* b);
gint64 thumbnail_exposure_time_desending_comparator (void* a,
                                                     void* b);
gint64 thumbnail_filename_descending_comparator (void* a,
                                                 void* b);
gboolean thumbnail_exposure_time_comparator_predicate (DataObject* object,
                                                       Alteration* alteration);
gboolean thumbnail_filename_comparator_predicate (DataObject* object,
                                                  Alteration* alteration);
GFile* media_source_get_file (MediaSource* self);
gint64 thumbnail_rating_ascending_comparator (void* a,
                                              void* b);
GType rating_get_type (void) G_GNUC_CONST;
Rating media_source_get_rating (MediaSource* self);
gint64 thumbnail_rating_descending_comparator (void* a,
                                               void* b);
gboolean thumbnail_rating_comparator_predicate (DataObject* object,
                                                Alteration* alteration);
static void thumbnail_real_thumbnail_altered (ThumbnailView* base);
static void thumbnail_delayed_high_quality_fetch (Thumbnail* self);
static void thumbnail_paint_empty (Thumbnail* self);
static void thumbnail_real_notify_collection_property_set (DataObject* base,
                                                    const gchar* name,
                                                    GValue* old,
                                                    GValue* val);
static void thumbnail_resize (Thumbnail* self,
                       gint new_scale);
void data_view_notify_view_altered (DataView* self);
void data_object_notify_collection_property_set (DataObject* self,
                                                 const gchar* name,
                                                 GValue* old,
                                                 GValue* val);
gint thumbnail_get_MIN_SCALE (void);
gint thumbnail_get_MAX_SCALE (void);
static void thumbnail_cancel_async_fetch (Thumbnail* self);
gboolean checkerboard_item_has_image (CheckerboardItem* self);
GdkPixbuf* checkerboard_item_get_image (CheckerboardItem* self);
void checkerboard_item_set_image (CheckerboardItem* self,
                                  GdkPixbuf* pixbuf);
GdkPixbuf* resize_pixbuf (GdkPixbuf* pixbuf,
                          Dimensions* resized,
                          GdkInterpType interp);
void checkerboard_item_clear_image (CheckerboardItem* self,
                                    Dimensions* dim);
static void thumbnail_schedule_low_quality_fetch (Thumbnail* self);
void thumbnail_cache_fetch_async_scaled (ThumbnailSource* source,
                                         gint scale,
                                         Dimensions* dim,
                                         GdkInterpType interp,
                                         ThumbnailCacheAsyncFetchCallback callback,
                                         void* callback_target,
                                         GCancellable* cancellable);
GType thumbnail_cache_size_get_type (void) G_GNUC_CONST;
static void thumbnail_on_low_quality_fetched (Thumbnail* self,
                                       GdkPixbuf* pixbuf,
                                       GdkPixbuf* unscaled,
                                       Dimensions* dim,
                                       GdkInterpType interp,
                                       GError* err);
static void _thumbnail_on_low_quality_fetched_thumbnail_cache_async_fetch_callback (GdkPixbuf* pixbuf,
                                                                             GdkPixbuf* unscaled,
                                                                             Dimensions* dim,
                                                                             GdkInterpType interp,
                                                                             GError* err,
                                                                             gpointer self);
static gboolean thumbnail_on_schedule_high_quality (Thumbnail* self);
static gboolean _thumbnail_on_schedule_high_quality_gsource_func (gpointer self);
static void thumbnail_on_high_quality_fetched (Thumbnail* self,
                                        GdkPixbuf* pixbuf,
                                        GdkPixbuf* unscaled,
                                        Dimensions* dim,
                                        GdkInterpType interp,
                                        GError* err);
static void _thumbnail_on_high_quality_fetched_thumbnail_cache_async_fetch_callback (GdkPixbuf* pixbuf,
                                                                              GdkPixbuf* unscaled,
                                                                              Dimensions* dim,
                                                                              GdkInterpType interp,
                                                                              GError* err,
                                                                              gpointer self);
gchar* data_object_to_string (DataObject* self);
static void thumbnail_real_exposed (CheckerboardItem* base);
void checkerboard_item_exposed (CheckerboardItem* self);
static void thumbnail_real_unexposed (CheckerboardItem* base);
void checkerboard_item_unexposed (CheckerboardItem* self);
static GdkPixbuf* thumbnail_real_get_top_right_trinket (CheckerboardItem* base,
                                                 gint scale);
GType flaggable_get_type (void) G_GNUC_CONST;
gboolean flaggable_is_flagged (Flaggable* self);
GdkPixbuf* resources_get_icon (const gchar* name,
                               gint scale);
#define RESOURCES_ICON_FLAGGED_TRINKET "flag-trinket.png"
#define RESOURCES_DEFAULT_ICON_SCALE 24
static GdkPixbuf* thumbnail_real_get_bottom_left_trinket (CheckerboardItem* base,
                                                   gint scale);
void data_object_get_collection_property (DataObject* self,
                                          const gchar* name,
                                          GValue* def,
                                          GValue* result);
static void _vala_GValue_free (GValue* self);
GdkPixbuf* resources_get_rating_trinket (Rating rating,
                                         gint scale);
gint thumbnail_cache_size_get_scale (ThumbnailCacheSize self);
gint thumbnail_get_DEFAULT_SCALE (void);
static void thumbnail_finalize (GObject * obj);
static void _vala_thumbnail_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec);


static void
_thumbnail_on_tag_contents_altered_container_source_collection_container_contents_altered (ContainerSourceCollection* _sender,
                                                                                           ContainerSource* container,
                                                                                           GeeCollection* added,
                                                                                           gboolean relinked,
                                                                                           GeeCollection* removed,
                                                                                           gboolean unlinked,
                                                                                           gpointer self)
{
#line 76 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	thumbnail_on_tag_contents_altered ((Thumbnail*) self, container, added, relinked, removed, unlinked);
#line 726 "Thumbnail.c"
}


static void
_thumbnail_on_tags_altered_data_collection_items_altered (DataCollection* _sender,
                                                          GeeMap* items,
                                                          gpointer self)
{
#line 77 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	thumbnail_on_tags_altered ((Thumbnail*) self, items);
#line 737 "Thumbnail.c"
}


static gpointer
_g_object_ref0 (gpointer self)
{
#line 53 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return self ? g_object_ref (self) : NULL;
#line 746 "Thumbnail.c"
}


Thumbnail*
thumbnail_construct (GType object_type,
                     MediaSource* media,
                     gint scale)
{
	Thumbnail * self = NULL;
	Dimensions _tmp0_ = {0};
	Dimensions _tmp1_ = {0};
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	MediaSource* _tmp6_;
	TagSourceCollection* _tmp7_;
	TagSourceCollection* _tmp8_;
	gboolean _tmp9_ = FALSE;
	Dimensions _tmp10_ = {0};
	Dimensions _tmp11_ = {0};
#line 49 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_val_if_fail (IS_MEDIA_SOURCE (media), NULL);
#line 50 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	media_source_get_dimensions (media, PHOTO_EXCEPTION_NONE, &_tmp0_);
#line 50 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	dimensions_get_scaled (&_tmp0_, scale, TRUE, &_tmp1_);
#line 50 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp2_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (media, TYPE_DATA_OBJECT, DataObject));
#line 50 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp3_ = _tmp2_;
#line 50 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp4_ = media_source_get_comment (media);
#line 50 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp5_ = _tmp4_;
#line 50 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self = (Thumbnail*) media_source_item_construct (object_type, G_TYPE_CHECK_INSTANCE_CAST (media, TYPE_THUMBNAIL_SOURCE, ThumbnailSource), &_tmp1_, _tmp3_, _tmp5_, FALSE, PANGO_ALIGN_LEFT);
#line 50 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_free0 (_tmp5_);
#line 50 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_free0 (_tmp3_);
#line 53 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp6_ = _g_object_ref0 (media);
#line 53 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_object_unref0 (self->priv->media);
#line 53 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self->priv->media = _tmp6_;
#line 54 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self->priv->scale = scale;
#line 56 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp7_ = tag_global;
#line 56 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection), "container-contents-altered", (GCallback) _thumbnail_on_tag_contents_altered_container_source_collection_container_contents_altered, self, 0);
#line 57 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp8_ = tag_global;
#line 57 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_DATA_COLLECTION, DataCollection), "items-altered", (GCallback) _thumbnail_on_tags_altered_data_collection_items_altered, self, 0);
#line 59 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (media, TYPE_LIBRARY_PHOTO)) {
#line 59 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp9_ = TRUE;
#line 808 "Thumbnail.c"
	} else {
#line 59 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp9_ = G_TYPE_CHECK_INSTANCE_TYPE (media, TYPE_VIDEO);
#line 812 "Thumbnail.c"
	}
#line 59 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_vala_assert (_tmp9_, "(media is LibraryPhoto) || (media is Video)");
#line 60 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	media_source_item_set_enable_sprockets (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_ITEM, MediaSourceItem), G_TYPE_CHECK_INSTANCE_TYPE (media, TYPE_VIDEO));
#line 62 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	media_source_get_dimensions (media, PHOTO_EXCEPTION_NONE, &_tmp10_);
#line 62 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self->priv->original_dim = _tmp10_;
#line 63 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	dimensions_get_scaled (&self->priv->original_dim, scale, TRUE, &_tmp11_);
#line 63 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self->priv->dim = _tmp11_;
#line 67 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	thumbnail_update_title (self, TRUE);
#line 68 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	thumbnail_update_comment (self, TRUE);
#line 69 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	thumbnail_update_tags (self, TRUE);
#line 49 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return self;
#line 834 "Thumbnail.c"
}


Thumbnail*
thumbnail_new (MediaSource* media,
               gint scale)
{
#line 49 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return thumbnail_construct (TYPE_THUMBNAIL, media, scale);
#line 844 "Thumbnail.c"
}


static void
thumbnail_update_tags (Thumbnail* self,
                       gboolean init)
{
	GeeCollection* tags = NULL;
	TagSourceCollection* _tmp0_;
	MediaSource* _tmp1_;
	GeeSortedSet* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GeeCollection* _tmp4_;
#line 80 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail (IS_THUMBNAIL (self));
#line 81 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = tag_global;
#line 81 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = self->priv->media;
#line 81 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp2_ = tag_source_collection_fetch_sorted_for_source (_tmp0_, _tmp1_);
#line 81 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	tags = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection);
#line 82 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp4_ = tags;
#line 82 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp4_ == NULL) {
#line 82 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp3_ = TRUE;
#line 874 "Thumbnail.c"
	} else {
		GeeCollection* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
#line 82 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp5_ = tags;
#line 82 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp6_ = gee_collection_get_size (_tmp5_);
#line 82 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp7_ = _tmp6_;
#line 82 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp3_ = _tmp7_ == 0;
#line 887 "Thumbnail.c"
	}
#line 82 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp3_) {
#line 83 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		checkerboard_item_clear_tags (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
#line 893 "Thumbnail.c"
	} else {
		GeeCollection* _tmp8_;
#line 85 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp8_ = tags;
#line 85 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		checkerboard_item_set_tags (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), _tmp8_, PANGO_ALIGN_LEFT);
#line 900 "Thumbnail.c"
	}
#line 80 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_object_unref0 (tags);
#line 904 "Thumbnail.c"
}


static void
thumbnail_on_tag_contents_altered (Thumbnail* self,
                                   ContainerSource* container,
                                   GeeCollection* added,
                                   gboolean relinking,
                                   GeeCollection* removed,
                                   gboolean unlinking)
{
	gboolean _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean tag_added = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean tag_removed = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_;
#line 88 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail (IS_THUMBNAIL (self));
#line 88 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail (IS_CONTAINER_SOURCE (container));
#line 88 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail ((added == NULL) || GEE_IS_COLLECTION (added));
#line 88 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail ((removed == NULL) || GEE_IS_COLLECTION (removed));
#line 90 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = self->priv->exposure;
#line 90 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (!_tmp0_) {
#line 91 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		return;
#line 937 "Thumbnail.c"
	}
#line 93 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (added != NULL) {
#line 941 "Thumbnail.c"
		MediaSource* _tmp2_;
#line 93 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp2_ = self->priv->media;
#line 93 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp1_ = gee_collection_contains (added, G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_DATA_SOURCE, DataSource));
#line 947 "Thumbnail.c"
	} else {
#line 93 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp1_ = FALSE;
#line 951 "Thumbnail.c"
	}
#line 93 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	tag_added = _tmp1_;
#line 94 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (removed != NULL) {
#line 957 "Thumbnail.c"
		MediaSource* _tmp4_;
#line 94 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp4_ = self->priv->media;
#line 94 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp3_ = gee_collection_contains (removed, G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_DATA_SOURCE, DataSource));
#line 963 "Thumbnail.c"
	} else {
#line 94 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp3_ = FALSE;
#line 967 "Thumbnail.c"
	}
#line 94 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	tag_removed = _tmp3_;
#line 97 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp6_ = tag_added;
#line 97 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp6_) {
#line 97 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp5_ = TRUE;
#line 977 "Thumbnail.c"
	} else {
		gboolean _tmp7_;
#line 97 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp7_ = tag_removed;
#line 97 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp5_ = _tmp7_;
#line 984 "Thumbnail.c"
	}
#line 97 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp5_) {
#line 98 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		thumbnail_update_tags (self, FALSE);
#line 990 "Thumbnail.c"
	}
}


static void
thumbnail_on_tags_altered (Thumbnail* self,
                           GeeMap* altered)
{
	gboolean _tmp0_;
#line 101 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail (IS_THUMBNAIL (self));
#line 101 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail (GEE_IS_MAP (altered));
#line 102 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = self->priv->exposure;
#line 102 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (!_tmp0_) {
#line 103 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		return;
#line 1010 "Thumbnail.c"
	}
	{
		GeeIterator* _object_it = NULL;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
#line 105 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp1_ = gee_map_get_keys (altered);
#line 105 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp2_ = _tmp1_;
#line 105 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp3_ = _tmp2_;
#line 105 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp4_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ITERABLE, GeeIterable));
#line 105 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp5_ = _tmp4_;
#line 105 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_g_object_unref0 (_tmp3_);
#line 105 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_object_it = _tmp5_;
#line 105 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		while (TRUE) {
#line 1035 "Thumbnail.c"
			GeeIterator* _tmp6_;
			DataObject* object = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			Tag* tag = NULL;
			DataObject* _tmp9_;
			Tag* _tmp10_;
			Tag* _tmp11_;
			MediaSource* _tmp12_;
#line 105 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_tmp6_ = _object_it;
#line 105 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			if (!gee_iterator_next (_tmp6_)) {
#line 105 "/home/jens/Source/shotwell/src/Thumbnail.vala"
				break;
#line 1051 "Thumbnail.c"
			}
#line 105 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_tmp7_ = _object_it;
#line 105 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_tmp8_ = gee_iterator_get (_tmp7_);
#line 105 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			object = (DataObject*) _tmp8_;
#line 106 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_tmp9_ = object;
#line 106 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_TAG, Tag));
#line 106 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			tag = _tmp10_;
#line 108 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_tmp11_ = tag;
#line 108 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_tmp12_ = self->priv->media;
#line 108 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			if (tag_contains (_tmp11_, _tmp12_)) {
#line 109 "/home/jens/Source/shotwell/src/Thumbnail.vala"
				thumbnail_update_tags (self, FALSE);
#line 111 "/home/jens/Source/shotwell/src/Thumbnail.vala"
				_g_object_unref0 (tag);
#line 111 "/home/jens/Source/shotwell/src/Thumbnail.vala"
				_g_object_unref0 (object);
#line 111 "/home/jens/Source/shotwell/src/Thumbnail.vala"
				break;
#line 1079 "Thumbnail.c"
			}
#line 105 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_g_object_unref0 (tag);
#line 105 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_g_object_unref0 (object);
#line 1085 "Thumbnail.c"
		}
#line 105 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_g_object_unref0 (_object_it);
#line 1089 "Thumbnail.c"
	}
}


static void
thumbnail_update_title (Thumbnail* self,
                        gboolean init)
{
	gchar* title = NULL;
	MediaSource* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
#line 116 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail (IS_THUMBNAIL (self));
#line 117 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = self->priv->media;
#line 117 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DATA_OBJECT, DataObject));
#line 117 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	title = _tmp1_;
#line 118 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp2_ = title;
#line 118 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (is_string_empty (_tmp2_)) {
#line 119 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		checkerboard_item_clear_title (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
#line 1116 "Thumbnail.c"
	} else {
#line 120 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		if (!init) {
#line 1120 "Thumbnail.c"
			const gchar* _tmp3_;
#line 121 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_tmp3_ = title;
#line 121 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			media_source_item_set_title (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_ITEM, MediaSourceItem), _tmp3_, FALSE, PANGO_ALIGN_LEFT);
#line 1126 "Thumbnail.c"
		}
	}
#line 116 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_free0 (title);
#line 1131 "Thumbnail.c"
}


static void
thumbnail_update_comment (Thumbnail* self,
                          gboolean init)
{
	gchar* comment = NULL;
	MediaSource* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
#line 124 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail (IS_THUMBNAIL (self));
#line 125 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = self->priv->media;
#line 125 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = media_source_get_comment (_tmp0_);
#line 125 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	comment = _tmp1_;
#line 126 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp2_ = comment;
#line 126 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (is_string_empty (_tmp2_)) {
#line 127 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		checkerboard_item_clear_comment (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
#line 1157 "Thumbnail.c"
	} else {
#line 128 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		if (!init) {
#line 1161 "Thumbnail.c"
			const gchar* _tmp3_;
#line 129 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_tmp3_ = comment;
#line 129 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			checkerboard_item_set_comment (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), _tmp3_, FALSE, PANGO_ALIGN_LEFT);
#line 1167 "Thumbnail.c"
		}
	}
#line 124 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_free0 (comment);
#line 1172 "Thumbnail.c"
}


static void
thumbnail_real_notify_altered (DataObject* base,
                               Alteration* alteration)
{
	Thumbnail * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
#line 132 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_THUMBNAIL, Thumbnail);
#line 132 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail (IS_ALTERATION (alteration));
#line 133 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = self->priv->exposure;
#line 133 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp1_) {
#line 133 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp0_ = alteration_has_detail (alteration, "metadata", "name");
#line 1195 "Thumbnail.c"
	} else {
#line 133 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp0_ = FALSE;
#line 1199 "Thumbnail.c"
	}
#line 133 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp0_) {
#line 134 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		thumbnail_update_title (self, FALSE);
#line 1205 "Thumbnail.c"
	}
#line 135 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp3_ = self->priv->exposure;
#line 135 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp3_) {
#line 135 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp2_ = alteration_has_detail (alteration, "metadata", "comment");
#line 1213 "Thumbnail.c"
	} else {
#line 135 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp2_ = FALSE;
#line 1217 "Thumbnail.c"
	}
#line 135 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp2_) {
#line 136 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		thumbnail_update_comment (self, FALSE);
#line 1223 "Thumbnail.c"
	}
#line 138 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	DATA_OBJECT_CLASS (thumbnail_parent_class)->notify_altered (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_ITEM, MediaSourceItem), TYPE_DATA_OBJECT, DataObject), alteration);
#line 1227 "Thumbnail.c"
}


MediaSource*
thumbnail_get_media_source (Thumbnail* self)
{
	MediaSource* result = NULL;
	MediaSource* _tmp0_;
	MediaSource* _tmp1_;
#line 141 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_val_if_fail (IS_THUMBNAIL (self), NULL);
#line 142 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = self->priv->media;
#line 142 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 142 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	result = _tmp1_;
#line 142 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 1247 "Thumbnail.c"
}


gint64
thumbnail_photo_id_ascending_comparator (void* a,
                                         void* b)
{
	gint64 result = 0LL;
	MediaSource* _tmp0_;
	MediaSource* _tmp1_;
#line 150 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST ((Thumbnail*) a, TYPE_THUMBNAIL, Thumbnail)->priv->media;
#line 150 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST ((Thumbnail*) b, TYPE_THUMBNAIL, Thumbnail)->priv->media;
#line 150 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	result = data_source_get_instance_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DATA_SOURCE, DataSource)) - data_source_get_instance_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_DATA_SOURCE, DataSource));
#line 150 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 1266 "Thumbnail.c"
}


gint64
thumbnail_photo_id_descending_comparator (void* a,
                                          void* b)
{
	gint64 result = 0LL;
#line 154 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	result = thumbnail_photo_id_ascending_comparator (b, a);
#line 154 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 1279 "Thumbnail.c"
}


gint64
thumbnail_title_ascending_comparator (void* a,
                                      void* b)
{
	gint64 result = 0LL;
	gint64 _result_ = 0LL;
	GCompareFunc _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gint64 _tmp5_;
	gint64 _tmp6_ = 0LL;
	gint64 _tmp7_;
#line 158 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = g_strcmp0;
#line 158 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = media_source_item_get_natural_collation_key (G_TYPE_CHECK_INSTANCE_CAST ((Thumbnail*) a, TYPE_MEDIA_SOURCE_ITEM, MediaSourceItem));
#line 158 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp2_ = _tmp1_;
#line 158 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp3_ = media_source_item_get_natural_collation_key (G_TYPE_CHECK_INSTANCE_CAST ((Thumbnail*) b, TYPE_MEDIA_SOURCE_ITEM, MediaSourceItem));
#line 158 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp4_ = _tmp3_;
#line 158 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp5_ = (gint64) _tmp0_ (_tmp2_, _tmp4_);
#line 158 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_free0 (_tmp4_);
#line 158 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_free0 (_tmp2_);
#line 158 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_result_ = _tmp5_;
#line 159 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp7_ = _result_;
#line 159 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp7_ != ((gint64) 0)) {
#line 1319 "Thumbnail.c"
		gint64 _tmp8_;
#line 159 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp8_ = _result_;
#line 159 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp6_ = _tmp8_;
#line 1325 "Thumbnail.c"
	} else {
#line 159 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp6_ = thumbnail_photo_id_ascending_comparator (a, b);
#line 1329 "Thumbnail.c"
	}
#line 159 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	result = _tmp6_;
#line 159 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 1335 "Thumbnail.c"
}


gint64
thumbnail_title_descending_comparator (void* a,
                                       void* b)
{
	gint64 result = 0LL;
	gint64 _result_ = 0LL;
	gint64 _tmp0_ = 0LL;
	gint64 _tmp1_;
#line 163 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_result_ = thumbnail_title_ascending_comparator (b, a);
#line 165 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = _result_;
#line 165 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp1_ != ((gint64) 0)) {
#line 1353 "Thumbnail.c"
		gint64 _tmp2_;
#line 165 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp2_ = _result_;
#line 165 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp0_ = _tmp2_;
#line 1359 "Thumbnail.c"
	} else {
#line 165 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp0_ = thumbnail_photo_id_descending_comparator (a, b);
#line 1363 "Thumbnail.c"
	}
#line 165 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	result = _tmp0_;
#line 165 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 1369 "Thumbnail.c"
}


gboolean
thumbnail_title_comparator_predicate (DataObject* object,
                                      Alteration* alteration)
{
	gboolean result = FALSE;
#line 168 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
#line 168 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_val_if_fail (IS_ALTERATION (alteration), FALSE);
#line 169 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	result = alteration_has_detail (alteration, "metadata", "title");
#line 169 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 1386 "Thumbnail.c"
}


gint64
thumbnail_exposure_time_ascending_comparator (void* a,
                                              void* b)
{
	gint64 result = 0LL;
	gint64 time_a = 0LL;
	MediaSource* _tmp0_;
	gint64 time_b = 0LL;
	MediaSource* _tmp1_;
	gint64 _result_ = 0LL;
	gint64 _tmp2_;
	gint64 _tmp3_;
	gint64 _tmp4_ = 0LL;
	gint64 _tmp5_;
#line 173 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST ((Thumbnail*) a, TYPE_THUMBNAIL, Thumbnail)->priv->media;
#line 173 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	time_a = (gint64) media_source_get_exposure_time (_tmp0_);
#line 174 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST ((Thumbnail*) b, TYPE_THUMBNAIL, Thumbnail)->priv->media;
#line 174 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	time_b = (gint64) media_source_get_exposure_time (_tmp1_);
#line 175 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp2_ = time_a;
#line 175 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp3_ = time_b;
#line 175 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_result_ = _tmp2_ - _tmp3_;
#line 177 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp5_ = _result_;
#line 177 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp5_ != ((gint64) 0)) {
#line 1422 "Thumbnail.c"
		gint64 _tmp6_;
#line 177 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp6_ = _result_;
#line 177 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp4_ = _tmp6_;
#line 1428 "Thumbnail.c"
	} else {
#line 177 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp4_ = thumbnail_filename_ascending_comparator (a, b);
#line 1432 "Thumbnail.c"
	}
#line 177 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	result = _tmp4_;
#line 177 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 1438 "Thumbnail.c"
}


gint64
thumbnail_exposure_time_desending_comparator (void* a,
                                              void* b)
{
	gint64 result = 0LL;
	gint64 _result_ = 0LL;
	gint64 _tmp0_ = 0LL;
	gint64 _tmp1_;
#line 181 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_result_ = thumbnail_exposure_time_ascending_comparator (b, a);
#line 183 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = _result_;
#line 183 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp1_ != ((gint64) 0)) {
#line 1456 "Thumbnail.c"
		gint64 _tmp2_;
#line 183 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp2_ = _result_;
#line 183 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp0_ = _tmp2_;
#line 1462 "Thumbnail.c"
	} else {
#line 183 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp0_ = thumbnail_filename_descending_comparator (a, b);
#line 1466 "Thumbnail.c"
	}
#line 183 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	result = _tmp0_;
#line 183 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 1472 "Thumbnail.c"
}


gboolean
thumbnail_exposure_time_comparator_predicate (DataObject* object,
                                              Alteration* alteration)
{
	gboolean result = FALSE;
#line 186 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
#line 186 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_val_if_fail (IS_ALTERATION (alteration), FALSE);
#line 187 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	result = alteration_has_detail (alteration, "metadata", "exposure-time");
#line 187 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 1489 "Thumbnail.c"
}


gboolean
thumbnail_filename_comparator_predicate (DataObject* object,
                                         Alteration* alteration)
{
	gboolean result = FALSE;
#line 190 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
#line 190 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_val_if_fail (IS_ALTERATION (alteration), FALSE);
#line 191 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	result = alteration_has_detail (alteration, "metadata", "filename");
#line 191 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 1506 "Thumbnail.c"
}


gint64
thumbnail_filename_ascending_comparator (void* a,
                                         void* b)
{
	gint64 result = 0LL;
	gchar* path_a = NULL;
	MediaSource* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* path_b = NULL;
	MediaSource* _tmp7_;
	GFile* _tmp8_;
	GFile* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gint64 _result_ = 0LL;
	GCompareFunc _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gint64 _tmp21_;
	gint64 _tmp22_ = 0LL;
	gint64 _tmp23_;
#line 195 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST ((Thumbnail*) a, TYPE_THUMBNAIL, Thumbnail)->priv->media;
#line 195 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = media_source_get_file (_tmp0_);
#line 195 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp2_ = _tmp1_;
#line 195 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp3_ = g_file_get_basename (_tmp2_);
#line 195 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp4_ = _tmp3_;
#line 195 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp5_ = g_utf8_strdown (_tmp4_, (gssize) -1);
#line 195 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp6_ = _tmp5_;
#line 195 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_free0 (_tmp4_);
#line 195 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_object_unref0 (_tmp2_);
#line 195 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	path_a = _tmp6_;
#line 196 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp7_ = G_TYPE_CHECK_INSTANCE_CAST ((Thumbnail*) b, TYPE_THUMBNAIL, Thumbnail)->priv->media;
#line 196 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp8_ = media_source_get_file (_tmp7_);
#line 196 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp9_ = _tmp8_;
#line 196 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp10_ = g_file_get_basename (_tmp9_);
#line 196 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp11_ = _tmp10_;
#line 196 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp12_ = g_utf8_strdown (_tmp11_, (gssize) -1);
#line 196 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp13_ = _tmp12_;
#line 196 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_free0 (_tmp11_);
#line 196 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_object_unref0 (_tmp9_);
#line 196 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	path_b = _tmp13_;
#line 198 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp14_ = g_strcmp0;
#line 198 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp15_ = path_a;
#line 198 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp16_ = g_utf8_collate_key_for_filename (_tmp15_, (gssize) -1);
#line 198 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp17_ = _tmp16_;
#line 198 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp18_ = path_b;
#line 198 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp19_ = g_utf8_collate_key_for_filename (_tmp18_, (gssize) -1);
#line 198 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp20_ = _tmp19_;
#line 198 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp21_ = (gint64) _tmp14_ (_tmp17_, _tmp20_);
#line 198 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_free0 (_tmp20_);
#line 198 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_free0 (_tmp17_);
#line 198 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_result_ = _tmp21_;
#line 199 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp23_ = _result_;
#line 199 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp23_ != ((gint64) 0)) {
#line 1608 "Thumbnail.c"
		gint64 _tmp24_;
#line 199 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp24_ = _result_;
#line 199 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp22_ = _tmp24_;
#line 1614 "Thumbnail.c"
	} else {
#line 199 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp22_ = thumbnail_photo_id_ascending_comparator (a, b);
#line 1618 "Thumbnail.c"
	}
#line 199 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	result = _tmp22_;
#line 199 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_free0 (path_b);
#line 199 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_free0 (path_a);
#line 199 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 1628 "Thumbnail.c"
}


gint64
thumbnail_filename_descending_comparator (void* a,
                                          void* b)
{
	gint64 result = 0LL;
	gint64 _result_ = 0LL;
	gint64 _tmp0_ = 0LL;
	gint64 _tmp1_;
#line 203 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_result_ = thumbnail_filename_ascending_comparator (b, a);
#line 205 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = _result_;
#line 205 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp1_ != ((gint64) 0)) {
#line 1646 "Thumbnail.c"
		gint64 _tmp2_;
#line 205 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp2_ = _result_;
#line 205 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp0_ = _tmp2_;
#line 1652 "Thumbnail.c"
	} else {
#line 205 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp0_ = thumbnail_photo_id_descending_comparator (a, b);
#line 1656 "Thumbnail.c"
	}
#line 205 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	result = _tmp0_;
#line 205 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 1662 "Thumbnail.c"
}


gint64
thumbnail_rating_ascending_comparator (void* a,
                                       void* b)
{
	gint64 result = 0LL;
	gint64 _result_ = 0LL;
	MediaSource* _tmp0_;
	MediaSource* _tmp1_;
	gint64 _tmp2_ = 0LL;
	gint64 _tmp3_;
#line 209 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST ((Thumbnail*) a, TYPE_THUMBNAIL, Thumbnail)->priv->media;
#line 209 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST ((Thumbnail*) b, TYPE_THUMBNAIL, Thumbnail)->priv->media;
#line 209 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_result_ = (gint64) (media_source_get_rating (_tmp0_) - media_source_get_rating (_tmp1_));
#line 211 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp3_ = _result_;
#line 211 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp3_ != ((gint64) 0)) {
#line 1686 "Thumbnail.c"
		gint64 _tmp4_;
#line 211 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp4_ = _result_;
#line 211 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp2_ = _tmp4_;
#line 1692 "Thumbnail.c"
	} else {
#line 211 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp2_ = thumbnail_photo_id_ascending_comparator (a, b);
#line 1696 "Thumbnail.c"
	}
#line 211 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	result = _tmp2_;
#line 211 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 1702 "Thumbnail.c"
}


gint64
thumbnail_rating_descending_comparator (void* a,
                                        void* b)
{
	gint64 result = 0LL;
	gint64 _result_ = 0LL;
	gint64 _tmp0_ = 0LL;
	gint64 _tmp1_;
#line 215 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_result_ = thumbnail_rating_ascending_comparator (b, a);
#line 217 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = _result_;
#line 217 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp1_ != ((gint64) 0)) {
#line 1720 "Thumbnail.c"
		gint64 _tmp2_;
#line 217 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp2_ = _result_;
#line 217 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp0_ = _tmp2_;
#line 1726 "Thumbnail.c"
	} else {
#line 217 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp0_ = thumbnail_photo_id_descending_comparator (a, b);
#line 1730 "Thumbnail.c"
	}
#line 217 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	result = _tmp0_;
#line 217 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 1736 "Thumbnail.c"
}


gboolean
thumbnail_rating_comparator_predicate (DataObject* object,
                                       Alteration* alteration)
{
	gboolean result = FALSE;
#line 220 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
#line 220 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_val_if_fail (IS_ALTERATION (alteration), FALSE);
#line 221 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	result = alteration_has_detail (alteration, "metadata", "rating");
#line 221 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 1753 "Thumbnail.c"
}


static void
thumbnail_real_thumbnail_altered (ThumbnailView* base)
{
	Thumbnail * self;
	MediaSource* _tmp0_;
	Dimensions _tmp1_ = {0};
	gint _tmp2_;
	Dimensions _tmp3_ = {0};
	gboolean _tmp4_;
#line 224 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_THUMBNAIL, Thumbnail);
#line 225 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = self->priv->media;
#line 225 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	media_source_get_dimensions (_tmp0_, PHOTO_EXCEPTION_NONE, &_tmp1_);
#line 225 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self->priv->original_dim = _tmp1_;
#line 226 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp2_ = self->priv->scale;
#line 226 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	dimensions_get_scaled (&self->priv->original_dim, _tmp2_, TRUE, &_tmp3_);
#line 226 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self->priv->dim = _tmp3_;
#line 228 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp4_ = self->priv->exposure;
#line 228 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp4_) {
#line 229 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		thumbnail_delayed_high_quality_fetch (self);
#line 1786 "Thumbnail.c"
	} else {
#line 231 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		thumbnail_paint_empty (self);
#line 1790 "Thumbnail.c"
	}
#line 233 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	THUMBNAIL_VIEW_CLASS (thumbnail_parent_class)->thumbnail_altered (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_ITEM, MediaSourceItem), TYPE_THUMBNAIL_VIEW, ThumbnailView));
#line 1794 "Thumbnail.c"
}


static void
thumbnail_real_notify_collection_property_set (DataObject* base,
                                               const gchar* name,
                                               GValue* old,
                                               GValue* val)
{
	Thumbnail * self;
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	GValue _tmp4_;
#line 236 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_THUMBNAIL, Thumbnail);
#line 236 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail (name != NULL);
#line 236 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail (val != NULL);
#line 237 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = name;
#line 237 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
#line 237 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp2_ == g_quark_from_string (THUMBNAIL_PROP_SIZE)) {
#line 237 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		switch (0) {
#line 1822 "Thumbnail.c"
			default:
			{
				GValue _tmp3_;
#line 239 "/home/jens/Source/shotwell/src/Thumbnail.vala"
				_tmp3_ = *val;
#line 239 "/home/jens/Source/shotwell/src/Thumbnail.vala"
				thumbnail_resize (self, g_value_get_int (&_tmp3_));
#line 240 "/home/jens/Source/shotwell/src/Thumbnail.vala"
				break;
#line 1832 "Thumbnail.c"
			}
		}
	} else if (_tmp2_ == g_quark_from_string (THUMBNAIL_PROP_SHOW_RATINGS)) {
#line 237 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		switch (0) {
#line 1838 "Thumbnail.c"
			default:
			{
#line 243 "/home/jens/Source/shotwell/src/Thumbnail.vala"
				data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 244 "/home/jens/Source/shotwell/src/Thumbnail.vala"
				break;
#line 1845 "Thumbnail.c"
			}
		}
	}
#line 247 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp4_ = *val;
#line 247 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	DATA_OBJECT_CLASS (thumbnail_parent_class)->notify_collection_property_set (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_ITEM, MediaSourceItem), TYPE_DATA_OBJECT, DataObject), name, old, &_tmp4_);
#line 1853 "Thumbnail.c"
}


static void
thumbnail_resize (Thumbnail* self,
                  gint new_scale)
{
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	Dimensions _tmp6_ = {0};
	gboolean _tmp7_;
#line 250 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail (IS_THUMBNAIL (self));
#line 251 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = thumbnail_get_MIN_SCALE ();
#line 251 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = _tmp0_;
#line 251 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_vala_assert (new_scale >= _tmp1_, "new_scale >= MIN_SCALE");
#line 252 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp2_ = thumbnail_get_MAX_SCALE ();
#line 252 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp3_ = _tmp2_;
#line 252 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_vala_assert (new_scale <= _tmp3_, "new_scale <= MAX_SCALE");
#line 254 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp4_ = self->priv->scale;
#line 254 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp4_ == new_scale) {
#line 255 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		return;
#line 1889 "Thumbnail.c"
	}
#line 257 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self->priv->scale = new_scale;
#line 258 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp5_ = self->priv->scale;
#line 258 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	dimensions_get_scaled (&self->priv->original_dim, _tmp5_, TRUE, &_tmp6_);
#line 258 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self->priv->dim = _tmp6_;
#line 260 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	thumbnail_cancel_async_fetch (self);
#line 262 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp7_ = self->priv->exposure;
#line 262 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp7_) {
#line 1905 "Thumbnail.c"
		GdkPixbuf* resizable = NULL;
		GdkPixbuf* _tmp8_;
		GdkPixbuf* _tmp12_;
#line 267 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		resizable = NULL;
#line 268 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp8_ = self->priv->unscaled_pixbuf;
#line 268 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		if (_tmp8_ != NULL) {
#line 1915 "Thumbnail.c"
			GdkPixbuf* _tmp9_;
			GdkPixbuf* _tmp10_;
#line 269 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_tmp9_ = self->priv->unscaled_pixbuf;
#line 269 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_tmp10_ = _g_object_ref0 (_tmp9_);
#line 269 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_g_object_unref0 (resizable);
#line 269 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			resizable = _tmp10_;
#line 1926 "Thumbnail.c"
		} else {
#line 270 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			if (checkerboard_item_has_image (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem))) {
#line 1930 "Thumbnail.c"
				GdkPixbuf* _tmp11_;
#line 271 "/home/jens/Source/shotwell/src/Thumbnail.vala"
				_tmp11_ = checkerboard_item_get_image (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
#line 271 "/home/jens/Source/shotwell/src/Thumbnail.vala"
				_g_object_unref0 (resizable);
#line 271 "/home/jens/Source/shotwell/src/Thumbnail.vala"
				resizable = _tmp11_;
#line 1938 "Thumbnail.c"
			}
		}
#line 273 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp12_ = resizable;
#line 273 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		if (_tmp12_ != NULL) {
#line 1945 "Thumbnail.c"
			GdkPixbuf* _tmp13_;
			Dimensions _tmp14_;
			GdkPixbuf* _tmp15_;
			GdkPixbuf* _tmp16_;
#line 274 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_tmp13_ = resizable;
#line 274 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_tmp14_ = self->priv->dim;
#line 274 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_tmp15_ = resize_pixbuf (_tmp13_, &_tmp14_, THUMBNAIL_LOW_QUALITY_INTERP);
#line 274 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_tmp16_ = _tmp15_;
#line 274 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			checkerboard_item_set_image (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), _tmp16_);
#line 274 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_g_object_unref0 (_tmp16_);
#line 1962 "Thumbnail.c"
		}
#line 276 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		thumbnail_delayed_high_quality_fetch (self);
#line 262 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_g_object_unref0 (resizable);
#line 1968 "Thumbnail.c"
	} else {
		Dimensions _tmp17_;
#line 278 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp17_ = self->priv->dim;
#line 278 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		checkerboard_item_clear_image (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), &_tmp17_);
#line 1975 "Thumbnail.c"
	}
}


static void
thumbnail_paint_empty (Thumbnail* self)
{
	Dimensions _tmp0_;
#line 282 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail (IS_THUMBNAIL (self));
#line 283 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	thumbnail_cancel_async_fetch (self);
#line 284 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = self->priv->dim;
#line 284 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	checkerboard_item_clear_image (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), &_tmp0_);
#line 285 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_object_unref0 (self->priv->unscaled_pixbuf);
#line 285 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self->priv->unscaled_pixbuf = NULL;
#line 1996 "Thumbnail.c"
}


static void
_thumbnail_on_low_quality_fetched_thumbnail_cache_async_fetch_callback (GdkPixbuf* pixbuf,
                                                                        GdkPixbuf* unscaled,
                                                                        Dimensions* dim,
                                                                        GdkInterpType interp,
                                                                        GError* err,
                                                                        gpointer self)
{
#line 292 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	thumbnail_on_low_quality_fetched ((Thumbnail*) self, pixbuf, unscaled, dim, interp, err);
#line 2010 "Thumbnail.c"
}


static void
thumbnail_schedule_low_quality_fetch (Thumbnail* self)
{
	GCancellable* _tmp0_;
	MediaSource* _tmp1_;
	Dimensions _tmp2_;
	GCancellable* _tmp3_;
#line 288 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail (IS_THUMBNAIL (self));
#line 289 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	thumbnail_cancel_async_fetch (self);
#line 290 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = g_cancellable_new ();
#line 290 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_object_unref0 (self->priv->cancellable);
#line 290 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self->priv->cancellable = _tmp0_;
#line 292 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = self->priv->media;
#line 292 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp2_ = self->priv->dim;
#line 292 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp3_ = self->priv->cancellable;
#line 292 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	thumbnail_cache_fetch_async_scaled (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_THUMBNAIL_SOURCE, ThumbnailSource), (gint) THUMBNAIL_CACHE_SIZE_SMALLEST, &_tmp2_, THUMBNAIL_LOW_QUALITY_INTERP, _thumbnail_on_low_quality_fetched_thumbnail_cache_async_fetch_callback, self, _tmp3_);
#line 2039 "Thumbnail.c"
}


static gboolean
_thumbnail_on_schedule_high_quality_gsource_func (gpointer self)
{
	gboolean result;
	result = thumbnail_on_schedule_high_quality ((Thumbnail*) self);
#line 303 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 2050 "Thumbnail.c"
}


static void
thumbnail_delayed_high_quality_fetch (Thumbnail* self)
{
	gboolean _tmp0_;
#line 296 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail (IS_THUMBNAIL (self));
#line 297 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = self->priv->hq_scheduled;
#line 297 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp0_) {
#line 298 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		self->priv->hq_reschedule = TRUE;
#line 300 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		return;
#line 2068 "Thumbnail.c"
	}
#line 303 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) THUMBNAIL_HQ_IMPROVEMENT_MSEC, _thumbnail_on_schedule_high_quality_gsource_func, g_object_ref (self), g_object_unref);
#line 304 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self->priv->hq_scheduled = TRUE;
#line 2074 "Thumbnail.c"
}


static void
_thumbnail_on_high_quality_fetched_thumbnail_cache_async_fetch_callback (GdkPixbuf* pixbuf,
                                                                         GdkPixbuf* unscaled,
                                                                         Dimensions* dim,
                                                                         GdkInterpType interp,
                                                                         GError* err,
                                                                         gpointer self)
{
#line 318 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	thumbnail_on_high_quality_fetched ((Thumbnail*) self, pixbuf, unscaled, dim, interp, err);
#line 2088 "Thumbnail.c"
}


static gboolean
thumbnail_on_schedule_high_quality (Thumbnail* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_;
	GCancellable* _tmp1_;
	gboolean _tmp2_;
#line 307 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_val_if_fail (IS_THUMBNAIL (self), FALSE);
#line 308 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = self->priv->hq_reschedule;
#line 308 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp0_) {
#line 309 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		self->priv->hq_reschedule = FALSE;
#line 311 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		result = TRUE;
#line 311 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		return result;
#line 2111 "Thumbnail.c"
	}
#line 314 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	thumbnail_cancel_async_fetch (self);
#line 315 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = g_cancellable_new ();
#line 315 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_object_unref0 (self->priv->cancellable);
#line 315 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self->priv->cancellable = _tmp1_;
#line 317 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp2_ = self->priv->exposure;
#line 317 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp2_) {
#line 2125 "Thumbnail.c"
		MediaSource* _tmp3_;
		gint _tmp4_;
		Dimensions _tmp5_;
		GCancellable* _tmp6_;
#line 318 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp3_ = self->priv->media;
#line 318 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp4_ = self->priv->scale;
#line 318 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp5_ = self->priv->dim;
#line 318 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp6_ = self->priv->cancellable;
#line 318 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		thumbnail_cache_fetch_async_scaled (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_THUMBNAIL_SOURCE, ThumbnailSource), _tmp4_, &_tmp5_, THUMBNAIL_HIGH_QUALITY_INTERP, _thumbnail_on_high_quality_fetched_thumbnail_cache_async_fetch_callback, self, _tmp6_);
#line 2140 "Thumbnail.c"
	}
#line 322 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self->priv->hq_scheduled = FALSE;
#line 324 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	result = FALSE;
#line 324 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 2148 "Thumbnail.c"
}


static void
thumbnail_cancel_async_fetch (Thumbnail* self)
{
	GCancellable* _tmp0_;
#line 327 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail (IS_THUMBNAIL (self));
#line 329 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = self->priv->cancellable;
#line 329 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp0_ != NULL) {
#line 2162 "Thumbnail.c"
		GCancellable* _tmp1_;
#line 330 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp1_ = self->priv->cancellable;
#line 330 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		g_cancellable_cancel (_tmp1_);
#line 2168 "Thumbnail.c"
	}
}


static void
thumbnail_on_low_quality_fetched (Thumbnail* self,
                                  GdkPixbuf* pixbuf,
                                  GdkPixbuf* unscaled,
                                  Dimensions* dim,
                                  GdkInterpType interp,
                                  GError* err)
{
#line 333 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail (IS_THUMBNAIL (self));
#line 333 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail ((pixbuf == NULL) || GDK_IS_PIXBUF (pixbuf));
#line 333 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail ((unscaled == NULL) || GDK_IS_PIXBUF (unscaled));
#line 333 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail (dim != NULL);
#line 335 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (err != NULL) {
#line 2191 "Thumbnail.c"
		gchar* _tmp0_;
		gchar* _tmp1_;
		gint _tmp2_;
		const gchar* _tmp3_;
#line 336 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp0_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
#line 336 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp1_ = _tmp0_;
#line 336 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp2_ = self->priv->scale;
#line 336 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp3_ = err->message;
#line 336 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		g_critical ("Thumbnail.vala:336: Unable to fetch low-quality thumbnail for %s (scal" \
"e: %d): %s", _tmp1_, _tmp2_, _tmp3_);
#line 336 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_g_free0 (_tmp1_);
#line 2208 "Thumbnail.c"
	}
#line 339 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (pixbuf != NULL) {
#line 340 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		checkerboard_item_set_image (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), pixbuf);
#line 2214 "Thumbnail.c"
	}
#line 342 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (unscaled != NULL) {
#line 2218 "Thumbnail.c"
		GdkPixbuf* _tmp4_;
#line 343 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp4_ = _g_object_ref0 (unscaled);
#line 343 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_g_object_unref0 (self->priv->unscaled_pixbuf);
#line 343 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		self->priv->unscaled_pixbuf = _tmp4_;
#line 2226 "Thumbnail.c"
	}
#line 345 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	thumbnail_delayed_high_quality_fetch (self);
#line 2230 "Thumbnail.c"
}


static void
thumbnail_on_high_quality_fetched (Thumbnail* self,
                                   GdkPixbuf* pixbuf,
                                   GdkPixbuf* unscaled,
                                   Dimensions* dim,
                                   GdkInterpType interp,
                                   GError* err)
{
#line 348 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail (IS_THUMBNAIL (self));
#line 348 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail ((pixbuf == NULL) || GDK_IS_PIXBUF (pixbuf));
#line 348 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail ((unscaled == NULL) || GDK_IS_PIXBUF (unscaled));
#line 348 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail (dim != NULL);
#line 350 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (err != NULL) {
#line 2252 "Thumbnail.c"
		gchar* _tmp0_;
		gchar* _tmp1_;
		gint _tmp2_;
		const gchar* _tmp3_;
#line 351 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp0_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
#line 351 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp1_ = _tmp0_;
#line 351 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp2_ = self->priv->scale;
#line 351 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp3_ = err->message;
#line 351 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		g_critical ("Thumbnail.vala:351: Unable to fetch high-quality thumbnail for %s (sca" \
"le: %d): %s", _tmp1_, _tmp2_, _tmp3_);
#line 351 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_g_free0 (_tmp1_);
#line 2269 "Thumbnail.c"
	}
#line 354 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (pixbuf != NULL) {
#line 355 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		checkerboard_item_set_image (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), pixbuf);
#line 2275 "Thumbnail.c"
	}
#line 357 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (unscaled != NULL) {
#line 2279 "Thumbnail.c"
		GdkPixbuf* _tmp4_;
#line 358 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp4_ = _g_object_ref0 (unscaled);
#line 358 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_g_object_unref0 (self->priv->unscaled_pixbuf);
#line 358 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		self->priv->unscaled_pixbuf = _tmp4_;
#line 2287 "Thumbnail.c"
	}
}


static void
thumbnail_real_exposed (CheckerboardItem* base)
{
	Thumbnail * self;
#line 361 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_THUMBNAIL, Thumbnail);
#line 362 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self->priv->exposure = TRUE;
#line 364 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (!checkerboard_item_has_image (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem))) {
#line 365 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		thumbnail_schedule_low_quality_fetch (self);
#line 2304 "Thumbnail.c"
	}
#line 367 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	thumbnail_update_title (self, FALSE);
#line 368 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	thumbnail_update_comment (self, FALSE);
#line 369 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	thumbnail_update_tags (self, FALSE);
#line 371 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	CHECKERBOARD_ITEM_CLASS (thumbnail_parent_class)->exposed (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_ITEM, MediaSourceItem), TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
#line 2314 "Thumbnail.c"
}


static void
thumbnail_real_unexposed (CheckerboardItem* base)
{
	Thumbnail * self;
#line 374 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_THUMBNAIL, Thumbnail);
#line 375 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self->priv->exposure = FALSE;
#line 377 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	thumbnail_paint_empty (self);
#line 379 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	CHECKERBOARD_ITEM_CLASS (thumbnail_parent_class)->unexposed (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_ITEM, MediaSourceItem), TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
#line 2330 "Thumbnail.c"
}


static GdkPixbuf*
thumbnail_real_get_top_right_trinket (CheckerboardItem* base,
                                      gint scale)
{
	Thumbnail * self;
	GdkPixbuf* result = NULL;
	Flaggable* flaggable = NULL;
	MediaSource* _tmp0_;
	Flaggable* _tmp1_;
	GdkPixbuf* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	Flaggable* _tmp4_;
#line 382 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_THUMBNAIL, Thumbnail);
#line 383 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = self->priv->media;
#line 383 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_FLAGGABLE) ? ((Flaggable*) _tmp0_) : NULL);
#line 383 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	flaggable = _tmp1_;
#line 385 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp4_ = flaggable;
#line 385 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp4_ != NULL) {
#line 2358 "Thumbnail.c"
		Flaggable* _tmp5_;
#line 385 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp5_ = flaggable;
#line 385 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp3_ = flaggable_is_flagged (_tmp5_);
#line 2364 "Thumbnail.c"
	} else {
#line 385 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp3_ = FALSE;
#line 2368 "Thumbnail.c"
	}
#line 385 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp3_) {
#line 2372 "Thumbnail.c"
		GdkPixbuf* _tmp6_;
#line 386 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp6_ = resources_get_icon (RESOURCES_ICON_FLAGGED_TRINKET, RESOURCES_DEFAULT_ICON_SCALE);
#line 386 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_g_object_unref0 (_tmp2_);
#line 386 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp2_ = _tmp6_;
#line 2380 "Thumbnail.c"
	} else {
#line 386 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_g_object_unref0 (_tmp2_);
#line 386 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp2_ = NULL;
#line 2386 "Thumbnail.c"
	}
#line 385 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	result = _tmp2_;
#line 385 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_object_unref0 (flaggable);
#line 385 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 2394 "Thumbnail.c"
}


static void
_vala_GValue_free (GValue* self)
{
#line 391 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_value_unset (self);
#line 391 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_free (self);
#line 2405 "Thumbnail.c"
}


static GdkPixbuf*
thumbnail_real_get_bottom_left_trinket (CheckerboardItem* base,
                                        gint scale)
{
	Thumbnail * self;
	GdkPixbuf* result = NULL;
	Rating rating = 0;
	MediaSource* _tmp0_;
	gboolean show_ratings = FALSE;
	GValue* _tmp1_ = NULL;
	GValue _tmp2_ = {0};
	gboolean _tmp3_;
	GdkPixbuf* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	Rating _tmp6_;
#line 389 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_THUMBNAIL, Thumbnail);
#line 390 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = self->priv->media;
#line 390 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	rating = media_source_get_rating (_tmp0_);
#line 391 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = g_new0 (GValue, 1);
#line 391 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_value_init (_tmp1_, G_TYPE_BOOLEAN);
#line 391 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_value_set_boolean (_tmp1_, FALSE);
#line 391 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	data_object_get_collection_property (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), THUMBNAIL_PROP_SHOW_RATINGS, _tmp1_, &_tmp2_);
#line 391 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp3_ = g_value_get_boolean (&_tmp2_);
#line 391 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	__vala_GValue_free0 (_tmp1_);
#line 391 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	show_ratings = _tmp3_;
#line 393 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp6_ = rating;
#line 393 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp6_ != RATING_UNRATED) {
#line 2448 "Thumbnail.c"
		gboolean _tmp7_;
#line 393 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp7_ = show_ratings;
#line 393 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp5_ = _tmp7_;
#line 2454 "Thumbnail.c"
	} else {
#line 393 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp5_ = FALSE;
#line 2458 "Thumbnail.c"
	}
#line 393 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp5_) {
#line 2462 "Thumbnail.c"
		Rating _tmp8_;
		GdkPixbuf* _tmp9_;
#line 394 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp8_ = rating;
#line 394 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp9_ = resources_get_rating_trinket (_tmp8_, scale);
#line 394 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_g_object_unref0 (_tmp4_);
#line 394 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp4_ = _tmp9_;
#line 2473 "Thumbnail.c"
	} else {
#line 394 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_g_object_unref0 (_tmp4_);
#line 394 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp4_ = NULL;
#line 2479 "Thumbnail.c"
	}
#line 393 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	result = _tmp4_;
#line 393 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 2485 "Thumbnail.c"
}


gint
thumbnail_get_MIN_SCALE (void)
{
	gint result;
#line 18 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	result = 72;
#line 18 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 2497 "Thumbnail.c"
}


gint
thumbnail_get_MAX_SCALE (void)
{
	gint result;
#line 23 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	result = thumbnail_cache_size_get_scale (THUMBNAIL_CACHE_SIZE_LARGEST);
#line 23 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 2509 "Thumbnail.c"
}


gint
thumbnail_get_DEFAULT_SCALE (void)
{
	gint result;
#line 28 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	result = thumbnail_cache_size_get_scale (THUMBNAIL_CACHE_SIZE_MEDIUM);
#line 28 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 2521 "Thumbnail.c"
}


static void
thumbnail_class_init (ThumbnailClass * klass)
{
#line 7 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	thumbnail_parent_class = g_type_class_peek_parent (klass);
#line 7 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_type_class_add_private (klass, sizeof (ThumbnailPrivate));
#line 7 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	((DataObjectClass *) klass)->notify_altered = (void (*) (DataObject *, Alteration*)) thumbnail_real_notify_altered;
#line 7 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	((ThumbnailViewClass *) klass)->thumbnail_altered = (void (*) (ThumbnailView *)) thumbnail_real_thumbnail_altered;
#line 7 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	((DataObjectClass *) klass)->notify_collection_property_set = (void (*) (DataObject *, const gchar*, GValue*, GValue*)) thumbnail_real_notify_collection_property_set;
#line 7 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	((CheckerboardItemClass *) klass)->exposed = (void (*) (CheckerboardItem *)) thumbnail_real_exposed;
#line 7 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	((CheckerboardItemClass *) klass)->unexposed = (void (*) (CheckerboardItem *)) thumbnail_real_unexposed;
#line 7 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	((CheckerboardItemClass *) klass)->get_top_right_trinket = (GdkPixbuf* (*) (CheckerboardItem *, gint)) thumbnail_real_get_top_right_trinket;
#line 7 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	((CheckerboardItemClass *) klass)->get_bottom_left_trinket = (GdkPixbuf* (*) (CheckerboardItem *, gint)) thumbnail_real_get_bottom_left_trinket;
#line 7 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_thumbnail_get_property;
#line 7 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	G_OBJECT_CLASS (klass)->finalize = thumbnail_finalize;
#line 2550 "Thumbnail.c"
}


static void
thumbnail_instance_init (Thumbnail * self)
{
#line 7 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self->priv = THUMBNAIL_GET_PRIVATE (self);
#line 41 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self->priv->unscaled_pixbuf = NULL;
#line 42 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self->priv->cancellable = NULL;
#line 43 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self->priv->hq_scheduled = FALSE;
#line 44 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self->priv->hq_reschedule = FALSE;
#line 47 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self->priv->exposure = FALSE;
#line 2569 "Thumbnail.c"
}


static void
thumbnail_finalize (GObject * obj)
{
	Thumbnail * self;
	GCancellable* _tmp0_;
	TagSourceCollection* _tmp2_;
	guint _tmp3_;
	TagSourceCollection* _tmp4_;
	guint _tmp5_;
#line 7 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_THUMBNAIL, Thumbnail);
#line 73 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = self->priv->cancellable;
#line 73 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp0_ != NULL) {
#line 2588 "Thumbnail.c"
		GCancellable* _tmp1_;
#line 74 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp1_ = self->priv->cancellable;
#line 74 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		g_cancellable_cancel (_tmp1_);
#line 2594 "Thumbnail.c"
	}
#line 76 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp2_ = tag_global;
#line 76 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_signal_parse_name ("container-contents-altered", TYPE_CONTAINER_SOURCE_COLLECTION, &_tmp3_, NULL, FALSE);
#line 76 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _thumbnail_on_tag_contents_altered_container_source_collection_container_contents_altered, self);
#line 77 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp4_ = tag_global;
#line 77 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_signal_parse_name ("items-altered", TYPE_DATA_COLLECTION, &_tmp5_, NULL, FALSE);
#line 77 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_DATA_COLLECTION, DataCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _thumbnail_on_tags_altered_data_collection_items_altered, self);
#line 37 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_object_unref0 (self->priv->media);
#line 41 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_object_unref0 (self->priv->unscaled_pixbuf);
#line 42 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_object_unref0 (self->priv->cancellable);
#line 7 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	G_OBJECT_CLASS (thumbnail_parent_class)->finalize (obj);
#line 2616 "Thumbnail.c"
}


GType
thumbnail_get_type (void)
{
	static volatile gsize thumbnail_type_id__volatile = 0;
	if (g_once_init_enter (&thumbnail_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ThumbnailClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) thumbnail_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Thumbnail), 0, (GInstanceInitFunc) thumbnail_instance_init, NULL };
		GType thumbnail_type_id;
		thumbnail_type_id = g_type_register_static (TYPE_MEDIA_SOURCE_ITEM, "Thumbnail", &g_define_type_info, 0);
		g_once_init_leave (&thumbnail_type_id__volatile, thumbnail_type_id);
	}
	return thumbnail_type_id__volatile;
}


static void
_vala_thumbnail_get_property (GObject * object,
                              guint property_id,
                              GValue * value,
                              GParamSpec * pspec)
{
	Thumbnail * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_THUMBNAIL, Thumbnail);
#line 7 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	switch (property_id) {
#line 2644 "Thumbnail.c"
		default:
#line 7 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 7 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		break;
#line 2650 "Thumbnail.c"
	}
}



