/*
 * Copyright 2010 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "br" locale.
 */
public class LocalizedNamesImpl_br extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AF",
        "DE",
        "AL",
        "DZ",
        "AD",
        "AO",
        "AI",
        "AQ",
        "AG",
        "AN",
        "CI",
        "AU",
        "AT",
        "SA",
        "AR",
        "AM",
        "AW",
        "AZ",
        "BS",
        "BH",
        "BD",
        "BB",
        "BY",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "BT",
        "BL",
        "BO",
        "BA",
        "BW",
        "BR",
        "BN",
        "BG",
        "BF",
        "BI",
        "EA",
        "CL",
        "CR",
        "DK",
        "DG",
        "DJ",
        "DM",
        "TF",
        "EC",
        "EG",
        "AE",
        "AC",
        "BV",
        "CX",
        "CP",
        "NF",
        "PN",
        "IM",
        "ER",
        "EE",
        "ET",
        "FJ",
        "PH",
        "FI",
        "FR",
        "GA",
        "GM",
        "GH",
        "GN",
        "GQ",
        "GW",
        "GD",
        "GR",
        "GL",
        "GU",
        "GT",
        "GY",
        "GP",
        "GG",
        "GF",
        "HT",
        "HN",
        "HK",
        "HU",
        "IN",
        "ID",
        "AX",
        "KY",
        "CK",
        "FO",
        "FK",
        "GS",
        "VI",
        "VG",
        "HM",
        "IC",
        "CC",
        "MP",
        "MH",
        "TC",
        "IR",
        "IQ",
        "IS",
        "IL",
        "IT",
        "IE",
        "NL",
        "JM",
        "JP",
        "JE",
        "GI",
        "JO",
        "GE",
        "CV",
        "NC",
        "KH",
        "CM",
        "CA",
        "KZ",
        "KE",
        "CY",
        "KI",
        "CO",
        "KM",
        "CG",
        "CD",
        "KP",
        "KR",
        "KW",
        "HR",
        "CU",
        "KG",
        "LA",
        "LV",
        "LS",
        "LB",
        "LR",
        "LY",
        "LI",
        "LT",
        "LU",
        "MO",
        "MG",
        "MK",
        "MW",
        "MY",
        "MV",
        "ML",
        "MT",
        "MR",
        "MA",
        "MQ",
        "YT",
        "MX",
        "MF",
        "FM",
        "MD",
        "MC",
        "MN",
        "ME",
        "MS",
        "MU",
        "MZ",
        "MM",
        "NA",
        "NR",
        "NP",
        "NI",
        "NE",
        "NG",
        "NU",
        "NO",
        "OM",
        "UG",
        "UZ",
        "PK",
        "PW",
        "PA",
        "PG",
        "PY",
        "PE",
        "PF",
        "PL",
        "PT",
        "PR",
        "QA",
        "QO",
        "DO",
        "CF",
        "CZ",
        "RE",
        "GB",
        "RO",
        "RU",
        "RW",
        "EH",
        "SH",
        "KN",
        "LC",
        "SB",
        "SV",
        "WS",
        "AS",
        "SM",
        "PM",
        "VC",
        "ST",
        "SC",
        "SN",
        "RS",
        "SL",
        "CN",
        "SG",
        "SY",
        "SK",
        "SI",
        "SO",
        "SD",
        "ES",
        "LK",
        "US",
        "ZA",
        "CH",
        "SR",
        "SJ",
        "SE",
        "SZ",
        "TJ",
        "TW",
        "TZ",
        "TD",
        "TH",
        "TL",
        "IO",
        "PS",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TN",
        "TR",
        "TM",
        "TV",
        "UA",
        "UM",
        "EU",
        "UY",
        "VU",
        "VA",
        "VE",
        "VN",
        "WF",
        "YE",
        "ZM",
        "NZ",
        "ZW",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "bed");
    namesMap.put("002", "Afrika");
    namesMap.put("009", "Oseania");
    namesMap.put("029", "Karib");
    namesMap.put("053", "Aostralia ha Zeland-Nevez");
    namesMap.put("054", "Melanezia");
    namesMap.put("061", "Polinezia");
    namesMap.put("142", "Azia");
    namesMap.put("150", "Europa");
    namesMap.put("155", "Europa ar C'hornôg");
    namesMap.put("419", "Amerika Latin ha Karib");
    namesMap.put("AC", "Enez Ascension");
    namesMap.put("AE", "Emirelezhioù Arab Unanet");
    namesMap.put("AG", "Antigua ha Barbuda");
    namesMap.put("AN", "Antilhez Nederlandat");
    namesMap.put("AQ", "Antarktika");
    namesMap.put("AR", "Arc'hantina");
    namesMap.put("AS", "Samoa Amerikan");
    namesMap.put("AT", "Aostria");
    namesMap.put("AU", "Aostralia");
    namesMap.put("AX", "Inizi Åland");
    namesMap.put("AZ", "Azerbaidjan");
    namesMap.put("BA", "Bosnia ha Herzegovina");
    namesMap.put("BE", "Belgia");
    namesMap.put("BH", "Bahrein");
    namesMap.put("BT", "Bhoutan");
    namesMap.put("BV", "Enez Bouvet");
    namesMap.put("CA", "Kanada");
    namesMap.put("CC", "Inizi Kokoz");
    namesMap.put("CD", "Kongo - Kinshasa");
    namesMap.put("CF", "Republik Kreizafrikan");
    namesMap.put("CG", "Kongo - Brazzaville");
    namesMap.put("CH", "Suis");
    namesMap.put("CI", "Aod an Olifant");
    namesMap.put("CK", "Inizi Cook");
    namesMap.put("CM", "Kameroun");
    namesMap.put("CN", "Sina");
    namesMap.put("CO", "Kolombia");
    namesMap.put("CP", "Enez Clipperton");
    namesMap.put("CU", "Kuba");
    namesMap.put("CV", "Kab Glas");
    namesMap.put("CX", "Enez Christmas");
    namesMap.put("CY", "Kiprenez");
    namesMap.put("CZ", "Republik Tchek");
    namesMap.put("DE", "Alamagn");
    namesMap.put("DK", "Danmark");
    namesMap.put("DO", "Republik Dominikan");
    namesMap.put("DZ", "Aljeria");
    namesMap.put("EA", "Ceuta ha Melilla");
    namesMap.put("EG", "Egipt");
    namesMap.put("EH", "Sahara ar C'hornôg");
    namesMap.put("ES", "Spagn");
    namesMap.put("ET", "Etiopia");
    namesMap.put("EU", "Unaniezh Europa");
    namesMap.put("FJ", "Fidji");
    namesMap.put("FK", "Inizi Falkland");
    namesMap.put("FM", "Mikronezia");
    namesMap.put("FO", "Inizi Faero");
    namesMap.put("FR", "Frañs");
    namesMap.put("GB", "Rouantelezh-Unanet");
    namesMap.put("GE", "Jorjia");
    namesMap.put("GF", "Gwiana c'hall");
    namesMap.put("GG", "Gwernenez");
    namesMap.put("GI", "Jibraltar");
    namesMap.put("GL", "Greunland");
    namesMap.put("GN", "Ginea");
    namesMap.put("GP", "Gwadeloup");
    namesMap.put("GQ", "Ginea ar C'heheder");
    namesMap.put("GR", "Gres");
    namesMap.put("GS", "Inizi Georgia ar Su hag Inizi Sandwich ar Su");
    namesMap.put("GW", "Ginea-Bissau");
    namesMap.put("HK", "Hong Kong RMD Sina");
    namesMap.put("HM", "Inizi Heard ha McDonald");
    namesMap.put("HR", "Kroatia");
    namesMap.put("HU", "Hungaria");
    namesMap.put("IC", "Inizi Kanariez");
    namesMap.put("ID", "Indonezia");
    namesMap.put("IE", "Iwerzhon");
    namesMap.put("IM", "Enez Vanav");
    namesMap.put("IO", "Tiriad breizhveurat Meurvor Indez");
    namesMap.put("IS", "Island");
    namesMap.put("IT", "Italia");
    namesMap.put("JE", "Jerzenez");
    namesMap.put("JM", "Jamaika");
    namesMap.put("JO", "Jordania");
    namesMap.put("KH", "Kambodja");
    namesMap.put("KM", "Komorez");
    namesMap.put("KN", "Saint Kitts ha Nevis");
    namesMap.put("KP", "Korea an Norzh");
    namesMap.put("KR", "Korea ar Su");
    namesMap.put("KW", "Koweit");
    namesMap.put("KY", "Inizi Cayman");
    namesMap.put("KZ", "Kazakstan");
    namesMap.put("LB", "Liban");
    namesMap.put("LT", "Lituania");
    namesMap.put("LU", "Luksembourg");
    namesMap.put("LY", "Libia");
    namesMap.put("MA", "Maroko");
    namesMap.put("MG", "Madagaskar");
    namesMap.put("MH", "Inizi Marshall");
    namesMap.put("MK", "Makedonia");
    namesMap.put("MM", "Myanmar [Birmania]");
    namesMap.put("MO", "Macau RMD Sina");
    namesMap.put("MP", "Inizi Mariana an Norzh");
    namesMap.put("MQ", "Martinik");
    namesMap.put("MR", "Maouritania");
    namesMap.put("MU", "Moris");
    namesMap.put("MV", "Maldivez");
    namesMap.put("MX", "Mec'hiko");
    namesMap.put("MZ", "Mozambik");
    namesMap.put("NC", "Kaledonia Nevez");
    namesMap.put("NF", "Enez Norfolk");
    namesMap.put("NL", "Izelvroioù");
    namesMap.put("NO", "Norvegia");
    namesMap.put("NZ", "Zeland-Nevez");
    namesMap.put("PA", "Panamá");
    namesMap.put("PE", "Perou");
    namesMap.put("PF", "Polinezia c'hall");
    namesMap.put("PG", "Papoua Ginea-Nevez");
    namesMap.put("PH", "Filipinez");
    namesMap.put("PL", "Polonia");
    namesMap.put("PM", "Sant-Pêr-ha-Mikelon");
    namesMap.put("PN", "Enez Pitcairn");
    namesMap.put("PS", "Tiriadoù Palestina");
    namesMap.put("RE", "Reünion");
    namesMap.put("RO", "Roumania");
    namesMap.put("RU", "Rusia");
    namesMap.put("SA", "Arabia Saoudat");
    namesMap.put("SB", "Salomon");
    namesMap.put("SC", "Sechelez");
    namesMap.put("SD", "Soudan");
    namesMap.put("SE", "Sveden");
    namesMap.put("SG", "Singapour");
    namesMap.put("SJ", "Svalbard");
    namesMap.put("SR", "Surinam");
    namesMap.put("ST", "São Tomé ha Príncipe");
    namesMap.put("SV", "Salvador");
    namesMap.put("SY", "Siria");
    namesMap.put("TC", "Inizi Turks ha Caicos");
    namesMap.put("TD", "Tchad");
    namesMap.put("TF", "Douaroù aostral Frañs");
    namesMap.put("TJ", "Tadjikistan");
    namesMap.put("TN", "Tunizia");
    namesMap.put("TR", "Turkia");
    namesMap.put("TT", "Trinidad ha Tobago");
    namesMap.put("UA", "Ukraina");
    namesMap.put("UG", "Ouganda");
    namesMap.put("US", "Stadoù-Unanet");
    namesMap.put("UZ", "Ouzbekistan");
    namesMap.put("VA", "Vatikan");
    namesMap.put("VC", "Sant Visant hag ar Grenadinez");
    namesMap.put("VG", "Inizi Gwerc'h Breizh-Veur");
    namesMap.put("VI", "Inizi Gwerc'h ar Stadoù-Unanet");
    namesMap.put("VN", "Viêt Nam");
    namesMap.put("WF", "Wallis ha Futuna");
    namesMap.put("ZA", "Suafrika");
    namesMap.put("ZZ", "Tachad dianav pe direizh");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "bed",
        "002": "Afrika",
        "009": "Oseania",
        "029": "Karib",
        "053": "Aostralia ha Zeland-Nevez",
        "054": "Melanezia",
        "061": "Polinezia",
        "142": "Azia",
        "150": "Europa",
        "155": "Europa ar C'hornôg",
        "419": "Amerika Latin ha Karib",
        "AC": "Enez Ascension",
        "AE": "Emirelezhioù Arab Unanet",
        "AG": "Antigua ha Barbuda",
        "AN": "Antilhez Nederlandat",
        "AQ": "Antarktika",
        "AR": "Arc'hantina",
        "AS": "Samoa Amerikan",
        "AT": "Aostria",
        "AU": "Aostralia",
        "AX": "Inizi Åland",
        "AZ": "Azerbaidjan",
        "BA": "Bosnia ha Herzegovina",
        "BE": "Belgia",
        "BH": "Bahrein",
        "BT": "Bhoutan",
        "BV": "Enez Bouvet",
        "CA": "Kanada",
        "CC": "Inizi Kokoz",
        "CD": "Kongo - Kinshasa",
        "CF": "Republik Kreizafrikan",
        "CG": "Kongo - Brazzaville",
        "CH": "Suis",
        "CI": "Aod an Olifant",
        "CK": "Inizi Cook",
        "CM": "Kameroun",
        "CN": "Sina",
        "CO": "Kolombia",
        "CP": "Enez Clipperton",
        "CU": "Kuba",
        "CV": "Kab Glas",
        "CX": "Enez Christmas",
        "CY": "Kiprenez",
        "CZ": "Republik Tchek",
        "DE": "Alamagn",
        "DK": "Danmark",
        "DO": "Republik Dominikan",
        "DZ": "Aljeria",
        "EA": "Ceuta ha Melilla",
        "EG": "Egipt",
        "EH": "Sahara ar C'hornôg",
        "ES": "Spagn",
        "ET": "Etiopia",
        "EU": "Unaniezh Europa",
        "FJ": "Fidji",
        "FK": "Inizi Falkland",
        "FM": "Mikronezia",
        "FO": "Inizi Faero",
        "FR": "Frañs",
        "GB": "Rouantelezh-Unanet",
        "GE": "Jorjia",
        "GF": "Gwiana c'hall",
        "GG": "Gwernenez",
        "GI": "Jibraltar",
        "GL": "Greunland",
        "GN": "Ginea",
        "GP": "Gwadeloup",
        "GQ": "Ginea ar C'heheder",
        "GR": "Gres",
        "GS": "Inizi Georgia ar Su hag Inizi Sandwich ar Su",
        "GW": "Ginea-Bissau",
        "HK": "Hong Kong RMD Sina",
        "HM": "Inizi Heard ha McDonald",
        "HR": "Kroatia",
        "HU": "Hungaria",
        "IC": "Inizi Kanariez",
        "ID": "Indonezia",
        "IE": "Iwerzhon",
        "IM": "Enez Vanav",
        "IO": "Tiriad breizhveurat Meurvor Indez",
        "IS": "Island",
        "IT": "Italia",
        "JE": "Jerzenez",
        "JM": "Jamaika",
        "JO": "Jordania",
        "KH": "Kambodja",
        "KM": "Komorez",
        "KN": "Saint Kitts ha Nevis",
        "KP": "Korea an Norzh",
        "KR": "Korea ar Su",
        "KW": "Koweit",
        "KY": "Inizi Cayman",
        "KZ": "Kazakstan",
        "LB": "Liban",
        "LT": "Lituania",
        "LU": "Luksembourg",
        "LY": "Libia",
        "MA": "Maroko",
        "MG": "Madagaskar",
        "MH": "Inizi Marshall",
        "MK": "Makedonia",
        "MM": "Myanmar [Birmania]",
        "MO": "Macau RMD Sina",
        "MP": "Inizi Mariana an Norzh",
        "MQ": "Martinik",
        "MR": "Maouritania",
        "MU": "Moris",
        "MV": "Maldivez",
        "MX": "Mec'hiko",
        "MZ": "Mozambik",
        "NC": "Kaledonia Nevez",
        "NF": "Enez Norfolk",
        "NL": "Izelvroioù",
        "NO": "Norvegia",
        "NZ": "Zeland-Nevez",
        "PA": "Panamá",
        "PE": "Perou",
        "PF": "Polinezia c'hall",
        "PG": "Papoua Ginea-Nevez",
        "PH": "Filipinez",
        "PL": "Polonia",
        "PM": "Sant-Pêr-ha-Mikelon",
        "PN": "Enez Pitcairn",
        "PS": "Tiriadoù Palestina",
        "RE": "Reünion",
        "RO": "Roumania",
        "RU": "Rusia",
        "SA": "Arabia Saoudat",
        "SB": "Salomon",
        "SC": "Sechelez",
        "SD": "Soudan",
        "SE": "Sveden",
        "SG": "Singapour",
        "SJ": "Svalbard",
        "SR": "Surinam",
        "ST": "São Tomé ha Príncipe",
        "SV": "Salvador",
        "SY": "Siria",
        "TC": "Inizi Turks ha Caicos",
        "TD": "Tchad",
        "TF": "Douaroù aostral Frañs",
        "TJ": "Tadjikistan",
        "TN": "Tunizia",
        "TR": "Turkia",
        "TT": "Trinidad ha Tobago",
        "UA": "Ukraina",
        "UG": "Ouganda",
        "US": "Stadoù-Unanet",
        "UZ": "Ouzbekistan",
        "VA": "Vatikan",
        "VC": "Sant Visant hag ar Grenadinez",
        "VG": "Inizi Gwerc'h Breizh-Veur",
        "VI": "Inizi Gwerc'h ar Stadoù-Unanet",
        "VN": "Viêt Nam",
        "WF": "Wallis ha Futuna",
        "ZA": "Suafrika",
        "ZZ": "Tachad dianav pe direizh"
    };
  }-*/;
}
