/**************************************************************************\
 gatos (General ATI TV and Overlay Software)

  Project Coordinated By Insomnia (Steaphan Greene)
  (insomnia@core.binghamton.edu)

  Copyright (C) 1999 Steaphan Greene, yvind Aabling, Octavian Purdila, 
	Vladimir Dergachev and Christian Lupien.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.

\**************************************************************************/

#ifndef GATOS_R128REGS_H
#define GATOS_R128REGS_H 1

#ifdef __cplusplus
extern "C" {
#endif

#ifdef GATOS_GATOS_C
#define WHERE       
#else
#define WHERE	extern
#endif

/* PLL Clock Registers */
#define R128_CLOCK_CNTL_INDEX		(*((u32*)(MMR+0x0008)))
#define R128_CLOCK_CNTL_INDEX0		(*(( u8*)(MMR+0x0008)))
#define R128_CLOCK_CNTL_INDEX1		(*(( u8*)(MMR+0x0009)))
#define R128_CLOCK_CNTL_DATA		(*((u32*)(MMR+0x000C)))

/* PLL index registers values */
#define FCP_CNTL			0x012


/* Accelerator CRTC Registers */
#define R128_CRTC_H_TOTAL_DISP		(*((u32*)(MMR+0x0200)))
#define R128_CRTC_H_SYNC_STRT_WID	(*((u32*)(MMR+0x0204)))
#define R128_CRTC_V_TOTAL_DISP		(*((u32*)(MMR+0x0208)))
#define R128_CRTC_V_SYNC_STRT_WID	(*((u32*)(MMR+0x020C)))
#define R128_CRTC_OFFSET		(*((u32*)(MMR+0x0224)))
#define R128_CRTC_PITCH			(*((u32*)(MMR+0x022C)))
#define R128_CRTC_GEN_CNTL		(*((u32*)(MMR+0x0050)))

/* Framebuffer Memory Address and Size and Device ID Registers */
#define R128_CONFIG_MEMSIZE		(*((u32*)(MMR+0x00F8)))
#define R128_CONFIG_APER_0_BASE		(*((u32*)(MMR+0x0100)))
#define R128_DEVICE_ID			(*((u16*)(MMR+0x0F02)))
#define R128_REVISION_ID		(*(( u8*)(MMR+0x0F08)))

/* GUI registers */
#define R128_GUI_STAT		(*((u32*)(MMR+0x1740)))


/* I2C Registers */
#define R128_I2C_CNTL_0			(*((u32*)(MMR+0x0090)))
#define R128_I2C_CNTL_0_0		(*(( u8*)(MMR+0x0090)))
#define R128_I2C_CNTL_0_1		(*(( u8*)(MMR+0x0091)))
#define R128_I2C_CNTL_1			(*((u32*)(MMR+0x0094)))
#define R128_I2C_DATA			(*(( u8*)(MMR+0x0098)))

/* R128_I2C_CNTL_0 bits */
#define I2C_DONE	0x00000001
#define I2C_NACK	0x00000002
#define I2C_HALT	0x00000004
#define I2C_SOFT_RST	0x00000020
#define I2C_DRIVE_EN	0x00000040
#define I2C_DRIVE_SEL	0x00000080
#define I2C_START	0x00000100
#define I2C_STOP	0x00000200
#define I2C_RECEIVE	0x00000400
#define I2C_ABORT	0x00000800
#define I2C_GO		0x00001000
#define I2C_CLEAR	(I2C_DONE|I2C_NACK|I2C_HALT|I2C_SOFT_RST)

/* R128_I2C_CNTL_1 bits */
#define I2C_SEL		0x00010000
#define I2C_EN		0x00020000

/* Overlay Scaler Registers */
#define OV0_Y_X_START			(*((u32*)(MMR+0x0400)))
#define OV0_Y_X_END			(*((u32*)(MMR+0x0404)))
#define OV0_EXCLUSIVE_HORZ		(*((u32*)(MMR+0x0408)))
#define OV0_EXCLUSIVE_VERT		(*((u32*)(MMR+0x040C)))
#define OV0_REG_LOAD_CNTL		(*((u32*)(MMR+0x0410)))
#define OV0_SCALE_CNTL			(*((u32*)(MMR+0x0420)))
#define OV0_V_INC			(*((u32*)(MMR+0x0424)))
#define OV0_P1_V_ACCUM_INIT		(*((u32*)(MMR+0x0428)))
#define OV0_P23_V_ACCUM_INIT		(*((u32*)(MMR+0x042C)))
#define OV0_P1_BLANK_LINES_AT_TOP	(*((u32*)(MMR+0x0430)))
#define OV0_P23_BLANK_LINES_AT_TOP	(*((u32*)(MMR+0x0434)))
#define OV0_VID_BUF0_BASE_ADRS		(*((u32*)(MMR+0x0440)))
#define OV0_VID_BUF1_BASE_ADRS		(*((u32*)(MMR+0x0444)))
#define OV0_VID_BUF2_BASE_ADRS		(*((u32*)(MMR+0x0448)))
#define OV0_VID_BUF3_BASE_ADRS		(*((u32*)(MMR+0x044C)))
#define OV0_VID_BUF4_BASE_ADRS		(*((u32*)(MMR+0x0450)))
#define OV0_VID_BUF5_BASE_ADRS		(*((u32*)(MMR+0x0454)))
#define OV0_VID_BUF_PITCH0_VALUE	(*((u32*)(MMR+0x0460)))
#define OV0_VID_BUF_PITCH1_VALUE	(*((u32*)(MMR+0x0464)))
#define OV0_AUTO_FLIP_CNTRL		(*((u32*)(MMR+0x0470)))
#define OV0_DEINTERLACE_PATTERN		(*((u32*)(MMR+0x0474)))
#define OV0_H_INC			(*((u32*)(MMR+0x0480)))
#define OV0_STEP_BY			(*((u32*)(MMR+0x0484)))
#define OV0_P1_H_ACCUM_INIT		(*((u32*)(MMR+0x0488)))
#define OV0_P23_H_ACCUM_INIT		(*((u32*)(MMR+0x048C)))
#define OV0_P1_X_START_END		(*((u32*)(MMR+0x0494)))
#define OV0_P2_X_START_END		(*((u32*)(MMR+0x0498)))
#define OV0_P3_X_START_END		(*((u32*)(MMR+0x049C)))
#define OV0_FILTER_CNTL			(*((u32*)(MMR+0x04A0)))
#define OV0_FOUR_TAP_COEF_0		(*((u32*)(MMR+0x04B0)))
#define OV0_FOUR_TAP_COEF_1		(*((u32*)(MMR+0x04B4)))
#define OV0_FOUR_TAP_COEF_2		(*((u32*)(MMR+0x04B8)))
#define OV0_FOUR_TAP_COEF_3		(*((u32*)(MMR+0x04BC)))
#define OV0_FOUR_TAP_COEF_4		(*((u32*)(MMR+0x04C0)))
#define OV0_COLOUR_CNTL			(*((u32*)(MMR+0x04E0)))
#define OV0_VIDEO_KEY_CLR		(*((u32*)(MMR+0x04E4)))
#define OV0_VIDEO_KEY_MSK		(*((u32*)(MMR+0x04E8)))
#define OV0_GRAPHICS_KEY_CLR		(*((u32*)(MMR+0x04EC)))
#define OV0_GRAPHICS_KEY_MSK		(*((u32*)(MMR+0x04F0)))
#define OV0_KEY_CNTL			(*((u32*)(MMR+0x04F4)))
#define OV0_TEST			(*((u32*)(MMR+0x04F8)))

/* Video Capture Registers */
#define VID_BUFFER_CONTROL		(*((u32*)(MMR+0x0900)))
#define CAP_INT_CNTL			(*((u32*)(MMR+0x0908)))
#define CAP_INT_STATUS			(*((u32*)(MMR+0x090C)))
#define CAP0_BUF0_OFFSET		(*((u32*)(MMR+0x0920)))
#define CAP0_BUF1_OFFSET		(*((u32*)(MMR+0x0924)))
#define CAP0_BUF0_EVEN_OFFSET		(*((u32*)(MMR+0x0928)))
#define CAP0_BUF1_EVEN_OFFSET		(*((u32*)(MMR+0x092C)))
#define CAP0_BUF_PITCH			(*((u32*)(MMR+0x0930)))
#define CAP0_V_WINDOW			(*((u32*)(MMR+0x0934)))
#define CAP0_H_WINDOW			(*((u32*)(MMR+0x0938)))
#define CAP0_VBI_ODD_OFFSET		(*((u32*)(MMR+0x093C)))
#define CAP0_VBI_EVEN_OFFSET		(*((u32*)(MMR+0x0940)))
#define CAP0_VBI_V_WINDOW		(*((u32*)(MMR+0x0944)))
#define CAP0_VBI_H_WINDOW		(*((u32*)(MMR+0x0948)))
#define CAP0_PORT_MODE_CNTL		(*((u32*)(MMR+0x094C)))
#define CAP0_TRIG_CNTL			(*((u32*)(MMR+0x0950)))
#define CAP0_DEBUG			(*((u32*)(MMR+0x0954)))
#define CAP0_CONFIG			(*((u32*)(MMR+0x0958)))
#define CAP0_ANC_ODD_OFFSET		(*((u32*)(MMR+0x095C)))
#define CAP0_ANC_EVEN_OFFSET		(*((u32*)(MMR+0x0960)))
#define CAP0_ANC_H_WINDOW		(*((u32*)(MMR+0x0964)))
#define CAP0_VIDEO_SYNC_TEST		(*((u32*)(MMR+0x0968)))
#define CAP0_ONESHOT_BUF_OFFSET		(*((u32*)(MMR+0x096C)))
#define CAP0_BUF_STATUS			(*((u32*)(MMR+0x0970)))
#define CAP0_DWNSC_XRATIO		(*((u32*)(MMR+0x0978)))
#define CAP0_XSHARPNESS			(*((u32*)(MMR+0x097C)))
#define CAP1_BUF0_OFFSET		(*((u32*)(MMR+0x0990)))
#define CAP1_BUF1_OFFSET		(*((u32*)(MMR+0x0994)))
#define CAP1_BUF0_EVEN_OFFSET		(*((u32*)(MMR+0x0998)))
#define CAP1_BUF1_EVEN_OFFSET		(*((u32*)(MMR+0x099C)))
#define CAP1_BUF_PITCH			(*((u32*)(MMR+0x09A0)))
#define CAP1_V_WINDOW			(*((u32*)(MMR+0x09A4)))
#define CAP1_H_WINDOW			(*((u32*)(MMR+0x09A8)))
#define CAP1_VBI_ODD_OFFSET		(*((u32*)(MMR+0x09AC)))
#define CAP1_VBI_EVEN_OFFSET		(*((u32*)(MMR+0x09B0)))
#define CAP1_VBI_V_WINDOW		(*((u32*)(MMR+0x09B4)))
#define CAP1_VBI_H_WINDOW		(*((u32*)(MMR+0x09B8)))
#define CAP1_PORT_MODE_CNTL		(*((u32*)(MMR+0x09BC)))
#define CAP1_TRIG_CNTL			(*((u32*)(MMR+0x09C0)))
#define CAP1_DEBUG			(*((u32*)(MMR+0x09C4)))
#define CAP1_CONFIG			(*((u32*)(MMR+0x09C8)))
#define CAP1_ANC_ODD_OFFSET		(*((u32*)(MMR+0x09CC)))
#define CAP1_ANC_EVEN_OFFSET		(*((u32*)(MMR+0x09D0)))
#define CAP1_ANC_H_WINDOW		(*((u32*)(MMR+0x09D4)))
#define CAP1_VIDEO_SYNC_TEST		(*((u32*)(MMR+0x09D8)))
#define CAP1_ONESHOT_BUF_OFFSET		(*((u32*)(MMR+0x09DC)))
#define CAP1_BUF_STATUS			(*((u32*)(MMR+0x09E0)))
#define CAP1_DWNSC_XRATIO		(*((u32*)(MMR+0x09E8)))
#define CAP1_XSHARPNESS			(*((u32*)(MMR+0x09EC)))

/* Multimedia Peripheral Port (MPP) Registers */
#define R128_MPP_TB_ADDR		(*((u32*)(MMR+0x0070)))
#define R128_MPP_TB_DATA		(*((u32*)(MMR+0x0074)))
#define R128_MPP_GP_ADDR		(*((u32*)(MMR+0x0078)))
#define R128_MPP_GP_DATA		(*((u32*)(MMR+0x007C)))
#define R128_MPP_GP_ALT_REG_ADDR	(*((u32*)(MMR+0x0088)))
#define R128_MPP_GP_ALT_REG_DATA	(*((u32*)(MMR+0x008C)))
#define R128_AMCGPIO_MASK		(*((u32*)(MMR+0x0194)))
#define R128_MDGPIO_MASK		(*((u32*)(MMR+0x0198)))
#define R128_AMCGPIO_A_REG		(*((u32*)(MMR+0x01A0)))
#define R128_AMCGPIO_Y_REG		(*((u32*)(MMR+0x01A4)))
#define R128_AMCGPIO_EN_REG		(*((u32*)(MMR+0x01A8)))
#define R128_MDGPIO_A_REG		(*((u32*)(MMR+0x01AC)))
#define R128_MDGPIO_EN_REG		(*((u32*)(MMR+0x01B0)))
#define R128_MDGPIO_Y_REG		(*((u32*)(MMR+0x01B4)))
#define R128_MPP_TB_CONFIG		(*((u32*)(MMR+0x01C0)))
#define R128_MPP_TB_STROBE_SEQ		(*((u32*)(MMR+0x01C4)))
#define R128_MPP_GP_CONFIG		(*((u32*)(MMR+0x01C8)))
#define R128_MPP_GP_STROBE_SEQ		(*((u32*)(MMR+0x01CC)))

/* Video mux register */
#define R128_VIDEOMUX_CNTL		(*((u32*)(MMR+0x0190)))


#ifdef __cplusplus
}
#endif

#undef WHERE
#endif
