// Code generated by protoc-gen-ts_proto. DO NOT EDIT.
// versions:
//   protoc-gen-ts_proto  v2.7.5
//   protoc               v6.30.2
// source: sigstore_verification.proto

/* eslint-disable */
import { Bundle } from "./sigstore_bundle";
import { HashOutput, ObjectIdentifierValuePair, PublicKey, SubjectAlternativeName } from "./sigstore_common";
import { TrustedRoot } from "./sigstore_trustroot";

/** The identity of a X.509 Certificate signer. */
export interface CertificateIdentity {
  /** The X.509v3 issuer extension (OID 1.3.6.1.4.1.57264.1.1) */
  issuer: string;
  san:
    | SubjectAlternativeName
    | undefined;
  /**
   * An unordered list of OIDs that must be verified.
   * All OID/values provided in this list MUST exactly match against
   * the values in the certificate for verification to be successful.
   */
  oids: ObjectIdentifierValuePair[];
}

export interface CertificateIdentities {
  identities: CertificateIdentity[];
}

export interface PublicKeyIdentities {
  publicKeys: PublicKey[];
}

/**
 * A light-weight set of options/policies for identifying trusted signers,
 * used during verification of a single artifact.
 */
export interface ArtifactVerificationOptions {
  /**
   * At least one identity MUST be provided. Providing zero identities
   * is an error. If at least one provided identity is found as a
   * signer, the verification is considered successful.
   */
  signers?:
    | { $case: "certificateIdentities"; certificateIdentities: CertificateIdentities }
    | //
    /**
     * To simplify verification implementation, the logic for
     * bundle verification should be implemented as a
     * higher-order function, where one of argument should be an
     * interface over the set of trusted public keys, like this:
     * `Verify(bytes artifact, bytes signature, string key_id)`.
     * This way the caller is in full control of mapping the
     * identified (or hinted) key in the bundle to one of the
     * trusted keys, as this process is inherently application
     * specific.
     */
    { $case: "publicKeys"; publicKeys: PublicKeyIdentities }
    | undefined;
  /**
   * Optional options for artifact transparency log verification.
   * If none is provided, the default verification options are:
   * Threshold: 1
   * Online verification: false
   * Disable: false
   */
  tlogOptions?:
    | ArtifactVerificationOptions_TlogOptions
    | undefined;
  /**
   * Optional options for certificate transparency log verification.
   * If none is provided, the default verification options are:
   * Threshold: 1
   * Disable: false
   */
  ctlogOptions?:
    | ArtifactVerificationOptions_CtlogOptions
    | undefined;
  /**
   * Optional options for certificate signed timestamp verification.
   * If none is provided, the default verification options are:
   * Threshold: 0
   * Disable: true
   */
  tsaOptions?:
    | ArtifactVerificationOptions_TimestampAuthorityOptions
    | undefined;
  /**
   * Optional options for integrated timestamp verification.
   * If none is provided, the default verification options are:
   * Threshold: 0
   * Disable: true
   */
  integratedTsOptions?:
    | ArtifactVerificationOptions_TlogIntegratedTimestampOptions
    | undefined;
  /**
   * Optional options for observed timestamp verification.
   * If none is provided, the default verification options are:
   * Threshold 1
   * Disable: false
   */
  observerOptions?: ArtifactVerificationOptions_ObserverTimestampOptions | undefined;
}

export interface ArtifactVerificationOptions_TlogOptions {
  /** Number of transparency logs the entry must appear on. */
  threshold: number;
  /** Perform an online inclusion proof. */
  performOnlineVerification: boolean;
  /** Disable verification for transparency logs. */
  disable: boolean;
}

export interface ArtifactVerificationOptions_CtlogOptions {
  /**
   * The number of ct transparency logs the certificate must
   * appear on.
   */
  threshold: number;
  /** Disable ct transparency log verification */
  disable: boolean;
}

export interface ArtifactVerificationOptions_TimestampAuthorityOptions {
  /** The number of signed timestamps that are expected. */
  threshold: number;
  /** Disable signed timestamp verification. */
  disable: boolean;
}

export interface ArtifactVerificationOptions_TlogIntegratedTimestampOptions {
  /** The number of integrated timestamps that are expected. */
  threshold: number;
  /** Disable integrated timestamp verification. */
  disable: boolean;
}

export interface ArtifactVerificationOptions_ObserverTimestampOptions {
  /**
   * The number of external observers of the timestamp.
   * This is a union of RFC3161 signed timestamps, and
   * integrated timestamps from a transparency log, that
   * could include additional timestamp sources in the
   * future.
   */
  threshold: number;
  /** Disable observer timestamp verification. */
  disable: boolean;
}

export interface Artifact {
  data?:
    | //
    /** Location of the artifact */
    { $case: "artifactUri"; artifactUri: string }
    | //
    /** The raw bytes of the artifact */
    { $case: "artifact"; artifact: Buffer }
    | //
    /**
     * Digest of the artifact. SHOULD NOT be used when verifying an
     * in-toto attestation as the subject digest cannot be
     * reconstructed. This option will not work with Ed25519
     * signatures, use Ed25519Ph or another algorithm instead.
     */
    { $case: "artifactDigest"; artifactDigest: HashOutput }
    | undefined;
}

/**
 * Input captures all that is needed to call the bundle verification method,
 * to verify a single artifact referenced by the bundle.
 */
export interface Input {
  /**
   * The verification materials provided during a bundle verification.
   * The running process is usually preloaded with a "global"
   * dev.sisgtore.trustroot.TrustedRoot.v1 instance. Prior to
   * verifying an artifact (i.e a bundle), and/or based on current
   * policy, some selection is expected to happen, to filter out the
   * exact certificate authority to use, which transparency logs are
   * relevant etc. The result should b ecaptured in the
   * `artifact_trust_root`.
   */
  artifactTrustRoot: TrustedRoot | undefined;
  artifactVerificationOptions: ArtifactVerificationOptions | undefined;
  bundle:
    | Bundle
    | undefined;
  /**
   * If the bundle contains a message signature, the artifact must be
   * provided.
   */
  artifact?: Artifact | undefined;
}

export const CertificateIdentity: MessageFns<CertificateIdentity> = {
  fromJSON(object: any): CertificateIdentity {
    return {
      issuer: isSet(object.issuer) ? globalThis.String(object.issuer) : "",
      san: isSet(object.san) ? SubjectAlternativeName.fromJSON(object.san) : undefined,
      oids: globalThis.Array.isArray(object?.oids)
        ? object.oids.map((e: any) => ObjectIdentifierValuePair.fromJSON(e))
        : [],
    };
  },

  toJSON(message: CertificateIdentity): unknown {
    const obj: any = {};
    if (message.issuer !== "") {
      obj.issuer = message.issuer;
    }
    if (message.san !== undefined) {
      obj.san = SubjectAlternativeName.toJSON(message.san);
    }
    if (message.oids?.length) {
      obj.oids = message.oids.map((e) => ObjectIdentifierValuePair.toJSON(e));
    }
    return obj;
  },
};

export const CertificateIdentities: MessageFns<CertificateIdentities> = {
  fromJSON(object: any): CertificateIdentities {
    return {
      identities: globalThis.Array.isArray(object?.identities)
        ? object.identities.map((e: any) => CertificateIdentity.fromJSON(e))
        : [],
    };
  },

  toJSON(message: CertificateIdentities): unknown {
    const obj: any = {};
    if (message.identities?.length) {
      obj.identities = message.identities.map((e) => CertificateIdentity.toJSON(e));
    }
    return obj;
  },
};

export const PublicKeyIdentities: MessageFns<PublicKeyIdentities> = {
  fromJSON(object: any): PublicKeyIdentities {
    return {
      publicKeys: globalThis.Array.isArray(object?.publicKeys)
        ? object.publicKeys.map((e: any) => PublicKey.fromJSON(e))
        : [],
    };
  },

  toJSON(message: PublicKeyIdentities): unknown {
    const obj: any = {};
    if (message.publicKeys?.length) {
      obj.publicKeys = message.publicKeys.map((e) => PublicKey.toJSON(e));
    }
    return obj;
  },
};

export const ArtifactVerificationOptions: MessageFns<ArtifactVerificationOptions> = {
  fromJSON(object: any): ArtifactVerificationOptions {
    return {
      signers: isSet(object.certificateIdentities)
        ? {
          $case: "certificateIdentities",
          certificateIdentities: CertificateIdentities.fromJSON(object.certificateIdentities),
        }
        : isSet(object.publicKeys)
        ? { $case: "publicKeys", publicKeys: PublicKeyIdentities.fromJSON(object.publicKeys) }
        : undefined,
      tlogOptions: isSet(object.tlogOptions)
        ? ArtifactVerificationOptions_TlogOptions.fromJSON(object.tlogOptions)
        : undefined,
      ctlogOptions: isSet(object.ctlogOptions)
        ? ArtifactVerificationOptions_CtlogOptions.fromJSON(object.ctlogOptions)
        : undefined,
      tsaOptions: isSet(object.tsaOptions)
        ? ArtifactVerificationOptions_TimestampAuthorityOptions.fromJSON(object.tsaOptions)
        : undefined,
      integratedTsOptions: isSet(object.integratedTsOptions)
        ? ArtifactVerificationOptions_TlogIntegratedTimestampOptions.fromJSON(object.integratedTsOptions)
        : undefined,
      observerOptions: isSet(object.observerOptions)
        ? ArtifactVerificationOptions_ObserverTimestampOptions.fromJSON(object.observerOptions)
        : undefined,
    };
  },

  toJSON(message: ArtifactVerificationOptions): unknown {
    const obj: any = {};
    if (message.signers?.$case === "certificateIdentities") {
      obj.certificateIdentities = CertificateIdentities.toJSON(message.signers.certificateIdentities);
    } else if (message.signers?.$case === "publicKeys") {
      obj.publicKeys = PublicKeyIdentities.toJSON(message.signers.publicKeys);
    }
    if (message.tlogOptions !== undefined) {
      obj.tlogOptions = ArtifactVerificationOptions_TlogOptions.toJSON(message.tlogOptions);
    }
    if (message.ctlogOptions !== undefined) {
      obj.ctlogOptions = ArtifactVerificationOptions_CtlogOptions.toJSON(message.ctlogOptions);
    }
    if (message.tsaOptions !== undefined) {
      obj.tsaOptions = ArtifactVerificationOptions_TimestampAuthorityOptions.toJSON(message.tsaOptions);
    }
    if (message.integratedTsOptions !== undefined) {
      obj.integratedTsOptions = ArtifactVerificationOptions_TlogIntegratedTimestampOptions.toJSON(
        message.integratedTsOptions,
      );
    }
    if (message.observerOptions !== undefined) {
      obj.observerOptions = ArtifactVerificationOptions_ObserverTimestampOptions.toJSON(message.observerOptions);
    }
    return obj;
  },
};

export const ArtifactVerificationOptions_TlogOptions: MessageFns<ArtifactVerificationOptions_TlogOptions> = {
  fromJSON(object: any): ArtifactVerificationOptions_TlogOptions {
    return {
      threshold: isSet(object.threshold) ? globalThis.Number(object.threshold) : 0,
      performOnlineVerification: isSet(object.performOnlineVerification)
        ? globalThis.Boolean(object.performOnlineVerification)
        : false,
      disable: isSet(object.disable) ? globalThis.Boolean(object.disable) : false,
    };
  },

  toJSON(message: ArtifactVerificationOptions_TlogOptions): unknown {
    const obj: any = {};
    if (message.threshold !== 0) {
      obj.threshold = Math.round(message.threshold);
    }
    if (message.performOnlineVerification !== false) {
      obj.performOnlineVerification = message.performOnlineVerification;
    }
    if (message.disable !== false) {
      obj.disable = message.disable;
    }
    return obj;
  },
};

export const ArtifactVerificationOptions_CtlogOptions: MessageFns<ArtifactVerificationOptions_CtlogOptions> = {
  fromJSON(object: any): ArtifactVerificationOptions_CtlogOptions {
    return {
      threshold: isSet(object.threshold) ? globalThis.Number(object.threshold) : 0,
      disable: isSet(object.disable) ? globalThis.Boolean(object.disable) : false,
    };
  },

  toJSON(message: ArtifactVerificationOptions_CtlogOptions): unknown {
    const obj: any = {};
    if (message.threshold !== 0) {
      obj.threshold = Math.round(message.threshold);
    }
    if (message.disable !== false) {
      obj.disable = message.disable;
    }
    return obj;
  },
};

export const ArtifactVerificationOptions_TimestampAuthorityOptions: MessageFns<
  ArtifactVerificationOptions_TimestampAuthorityOptions
> = {
  fromJSON(object: any): ArtifactVerificationOptions_TimestampAuthorityOptions {
    return {
      threshold: isSet(object.threshold) ? globalThis.Number(object.threshold) : 0,
      disable: isSet(object.disable) ? globalThis.Boolean(object.disable) : false,
    };
  },

  toJSON(message: ArtifactVerificationOptions_TimestampAuthorityOptions): unknown {
    const obj: any = {};
    if (message.threshold !== 0) {
      obj.threshold = Math.round(message.threshold);
    }
    if (message.disable !== false) {
      obj.disable = message.disable;
    }
    return obj;
  },
};

export const ArtifactVerificationOptions_TlogIntegratedTimestampOptions: MessageFns<
  ArtifactVerificationOptions_TlogIntegratedTimestampOptions
> = {
  fromJSON(object: any): ArtifactVerificationOptions_TlogIntegratedTimestampOptions {
    return {
      threshold: isSet(object.threshold) ? globalThis.Number(object.threshold) : 0,
      disable: isSet(object.disable) ? globalThis.Boolean(object.disable) : false,
    };
  },

  toJSON(message: ArtifactVerificationOptions_TlogIntegratedTimestampOptions): unknown {
    const obj: any = {};
    if (message.threshold !== 0) {
      obj.threshold = Math.round(message.threshold);
    }
    if (message.disable !== false) {
      obj.disable = message.disable;
    }
    return obj;
  },
};

export const ArtifactVerificationOptions_ObserverTimestampOptions: MessageFns<
  ArtifactVerificationOptions_ObserverTimestampOptions
> = {
  fromJSON(object: any): ArtifactVerificationOptions_ObserverTimestampOptions {
    return {
      threshold: isSet(object.threshold) ? globalThis.Number(object.threshold) : 0,
      disable: isSet(object.disable) ? globalThis.Boolean(object.disable) : false,
    };
  },

  toJSON(message: ArtifactVerificationOptions_ObserverTimestampOptions): unknown {
    const obj: any = {};
    if (message.threshold !== 0) {
      obj.threshold = Math.round(message.threshold);
    }
    if (message.disable !== false) {
      obj.disable = message.disable;
    }
    return obj;
  },
};

export const Artifact: MessageFns<Artifact> = {
  fromJSON(object: any): Artifact {
    return {
      data: isSet(object.artifactUri)
        ? { $case: "artifactUri", artifactUri: globalThis.String(object.artifactUri) }
        : isSet(object.artifact)
        ? { $case: "artifact", artifact: Buffer.from(bytesFromBase64(object.artifact)) }
        : isSet(object.artifactDigest)
        ? { $case: "artifactDigest", artifactDigest: HashOutput.fromJSON(object.artifactDigest) }
        : undefined,
    };
  },

  toJSON(message: Artifact): unknown {
    const obj: any = {};
    if (message.data?.$case === "artifactUri") {
      obj.artifactUri = message.data.artifactUri;
    } else if (message.data?.$case === "artifact") {
      obj.artifact = base64FromBytes(message.data.artifact);
    } else if (message.data?.$case === "artifactDigest") {
      obj.artifactDigest = HashOutput.toJSON(message.data.artifactDigest);
    }
    return obj;
  },
};

export const Input: MessageFns<Input> = {
  fromJSON(object: any): Input {
    return {
      artifactTrustRoot: isSet(object.artifactTrustRoot) ? TrustedRoot.fromJSON(object.artifactTrustRoot) : undefined,
      artifactVerificationOptions: isSet(object.artifactVerificationOptions)
        ? ArtifactVerificationOptions.fromJSON(object.artifactVerificationOptions)
        : undefined,
      bundle: isSet(object.bundle) ? Bundle.fromJSON(object.bundle) : undefined,
      artifact: isSet(object.artifact) ? Artifact.fromJSON(object.artifact) : undefined,
    };
  },

  toJSON(message: Input): unknown {
    const obj: any = {};
    if (message.artifactTrustRoot !== undefined) {
      obj.artifactTrustRoot = TrustedRoot.toJSON(message.artifactTrustRoot);
    }
    if (message.artifactVerificationOptions !== undefined) {
      obj.artifactVerificationOptions = ArtifactVerificationOptions.toJSON(message.artifactVerificationOptions);
    }
    if (message.bundle !== undefined) {
      obj.bundle = Bundle.toJSON(message.bundle);
    }
    if (message.artifact !== undefined) {
      obj.artifact = Artifact.toJSON(message.artifact);
    }
    return obj;
  },
};

function bytesFromBase64(b64: string): Uint8Array {
  return Uint8Array.from(globalThis.Buffer.from(b64, "base64"));
}

function base64FromBytes(arr: Uint8Array): string {
  return globalThis.Buffer.from(arr).toString("base64");
}

function isSet(value: any): boolean {
  return value !== null && value !== undefined;
}

interface MessageFns<T> {
  fromJSON(object: any): T;
  toJSON(message: T): unknown;
}
