INCLUDE(K3DParseArguments)

FUNCTION(K3D_CHECK CONFIG)
	K3D_PARSE_ARGUMENTS(BUILD "REQUIRES;RESOURCE;URL;MESSAGE" "" ${ARGN})

	IF(CONFIG STREQUAL "K-3D" OR ${CONFIG})
		FOREACH(REQUIREMENT ${BUILD_REQUIRES})
			IF(NOT ${REQUIREMENT})
				IF(BUILD_RESOURCE AND BUILD_URL)
					MESSAGE(SEND_ERROR "${CONFIG} requires ${BUILD_RESOURCE}, which can be obtained from ${BUILD_URL}. ${BUILD_MESSAGE}")
				ELSEIF(BUILD_RESOURCE)
					MESSAGE(SEND_ERROR "${CONFIG} requires ${BUILD_RESOURCE}. ${BUILD_MESSAGE}")
				ELSE()
					MESSAGE(SEND_ERROR "${CONFIG} requires ${REQUIREMENT}. ${BUILD_MESSAGE}")
				ENDIF()
			ENDIF()
		ENDFOREACH()
	ENDIF()
ENDFUNCTION()

FUNCTION(K3D_ADD_SUBDIRECTORY DIRECTORY)
	K3D_PARSE_ARGUMENTS(DIRECTORY "REQUIRES" "" ${ARGN})

	FOREACH(REQUIREMENT ${DIRECTORY_REQUIRES})
		IF(NOT ${REQUIREMENT})
			RETURN()
		ENDIF()
	ENDFOREACH()

	ADD_SUBDIRECTORY(${DIRECTORY})
ENDFUNCTION()

FUNCTION(K3D_ADD_CUSTOM_TARGET TARGET_NAME)
	K3D_PARSE_ARGUMENTS(TARGET "REQUIRES;COMMAND" "" ${ARGN})

	FOREACH(REQUIREMENT ${TARGET_REQUIRES})
		IF(NOT ${REQUIREMENT})
			RETURN()
		ENDIF()
	ENDFOREACH()

	ADD_CUSTOM_TARGET(${TARGET_NAME} COMMAND ${TARGET_COMMAND})
ENDFUNCTION()

FUNCTION(K3D_ADD_LIBRARY LIBRARY_NAME)
	ADD_LIBRARY(${LIBRARY_NAME} ${ARGN})
	SET_TARGET_PROPERTIES(${LIBRARY_NAME} PROPERTIES VERSION "${K3D_SO_VERSION}")
ENDFUNCTION()

MACRO(K3D_ADD_LIBRARY LIBRARY_NAME)
	ADD_LIBRARY(${LIBRARY_NAME} ${ARGN})
	SET_TARGET_PROPERTIES(${LIBRARY_NAME} PROPERTIES VERSION "${K3D_SO_VERSION}")
ENDMACRO()

