/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.listener;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.email.EmailAddress;
import org.apache.tools.ant.taskdefs.email.Mailer;
import org.apache.tools.ant.taskdefs.email.Message;
import org.apache.tools.ant.util.DateUtils;
import org.apache.tools.ant.util.StringUtils;
import org.apache.tools.mail.MailMessage;

public class MailLogger
extends DefaultLogger {
    private StringBuffer buffer = new StringBuffer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void buildFinished(BuildEvent event) {
        block18: {
            block17: {
                super.buildFinished(event);
                project = event.getProject();
                properties = project.getProperties();
                fileProperties = new Properties();
                filename = (String)properties.get("MailLogger.properties.file");
                if (filename != null) {
                    is = null;
                    try {
                        is = new FileInputStream(filename);
                        fileProperties.load(is);
                        var9_7 = null;
                        ** if (is == null) goto lbl-1000
                    }
                    catch (Throwable var8_16) {
                        var9_8 = null;
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                        }
                        throw var8_16;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            is.close();
                        }
                        catch (IOException e) {}
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block17;
                        catch (IOException ioe) {
                            var9_7 = null;
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (IOException e) {}
                            }
                        }
                    }
                }
            }
            e = fileProperties.keys();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                value = fileProperties.getProperty(key);
                properties.put(key, project.replaceProperties(value));
            }
            success = event.getException() == null;
            prefix = success != false ? "success" : "failure";
            try {
                notify = Project.toBoolean(this.getValue(properties, prefix + ".notify", "on"));
                if (!notify) {
                    return;
                }
                mailhost = this.getValue(properties, "mailhost", "localhost");
                port = Integer.parseInt(this.getValue(properties, "port", String.valueOf(25)));
                user = this.getValue(properties, "user", "");
                password = this.getValue(properties, "password", "");
                ssl = Project.toBoolean(this.getValue(properties, "ssl", "off"));
                from = this.getValue(properties, "from", null);
                replytoList = this.getValue(properties, "replyto", "");
                toList = this.getValue(properties, prefix + ".to", null);
                subject = this.getValue(properties, prefix + ".subject", success != false ? "Build Success" : "Build Failure");
                if (user.equals("") && password.equals("") && !ssl) {
                    this.sendMail(mailhost, port, from, replytoList, toList, subject, this.buffer.substring(0));
                    break block18;
                }
                this.sendMimeMail(event.getProject(), mailhost, port, user, password, ssl, from, replytoList, toList, subject, this.buffer.substring(0));
            }
            catch (Exception e) {
                System.out.println("MailLogger failed to send e-mail!");
                e.printStackTrace(System.err);
            }
        }
    }

    protected void log(String message) {
        this.buffer.append(message).append(StringUtils.LINE_SEP);
    }

    private String getValue(Hashtable properties, String name, String defaultValue) throws Exception {
        String propertyName = "MailLogger." + name;
        String value = (String)properties.get(propertyName);
        if (value == null) {
            value = defaultValue;
        }
        if (value == null) {
            throw new Exception("Missing required parameter: " + propertyName);
        }
        return value;
    }

    private void sendMail(String mailhost, int port, String from, String replyToList, String toList, String subject, String message) throws IOException {
        StringTokenizer t;
        MailMessage mailMessage = new MailMessage(mailhost, port);
        mailMessage.setHeader("Date", DateUtils.getDateForHeader());
        mailMessage.from(from);
        if (!replyToList.equals("")) {
            t = new StringTokenizer(replyToList, ", ", false);
            while (t.hasMoreTokens()) {
                mailMessage.replyto(t.nextToken());
            }
        }
        t = new StringTokenizer(toList, ", ", false);
        while (t.hasMoreTokens()) {
            mailMessage.to(t.nextToken());
        }
        mailMessage.setSubject(subject);
        PrintStream ps = mailMessage.getPrintStream();
        ps.println(message);
        mailMessage.sendAndClose();
    }

    private void sendMimeMail(Project project, String host, int port, String user, String password, boolean ssl, String from, String replyToString, String toString, String subject, String message) {
        Mailer mailer = null;
        try {
            mailer = (Mailer)Class.forName("org.apache.tools.ant.taskdefs.email.MimeMailer").newInstance();
        }
        catch (Throwable e) {
            this.log("Failed to initialise MIME mail: " + e.getMessage());
            return;
        }
        Vector replyToList = this.vectorizeEmailAddresses(replyToString);
        mailer.setHost(host);
        mailer.setPort(port);
        mailer.setUser(user);
        mailer.setPassword(password);
        mailer.setSSL(ssl);
        Message mymessage = new Message(message);
        mymessage.setProject(project);
        mailer.setMessage(mymessage);
        mailer.setFrom(new EmailAddress(from));
        mailer.setReplyToList(replyToList);
        Vector toList = this.vectorizeEmailAddresses(toString);
        mailer.setToList(toList);
        mailer.setCcList(new Vector());
        mailer.setBccList(new Vector());
        mailer.setFiles(new Vector());
        mailer.setSubject(subject);
        mailer.send();
    }

    private Vector vectorizeEmailAddresses(String listString) {
        Vector<EmailAddress> emailList = new Vector<EmailAddress>();
        StringTokenizer tokens = new StringTokenizer(listString, ",");
        while (tokens.hasMoreTokens()) {
            emailList.addElement(new EmailAddress(tokens.nextToken()));
        }
        return emailList;
    }
}

