#ifndef _OAUTH2_JQ_H
#define _OAUTH2_JQ_H

/***************************************************************************
 *
 * Copyright (C) 2018-2025 - ZmartZone Holding BV
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @Author: Hans Zandbelt - hans.zandbelt@openidc.com
 *
 **************************************************************************/

#include "oauth2/cache.h"
#include "oauth2/log.h"

typedef struct jq_state jq_state;

bool oauth2_jq_filter_compile(oauth2_log_t *log, const char *filter,
			      jq_state **r_jq);
bool oauth2_jq_filter(oauth2_log_t *log, oauth2_cache_t *cache,
		      const char *input, const char *filter, char **result);

#endif /* _OAUTH2_JQ_H */
