---
name: DRAGEN-FastQC
url: https://www.illumina.com/products/by-type/informatics-products/dragen-bio-it-platform.html
description: >
  Illumina Bio-IT Platform that uses FPGA for accelerated primary and secondary analysis
---

[Illumina DRAGEN](https://www.illumina.com/products/by-type/informatics-products/dragen-bio-it-platform.html)
is a Bio-IT Platform that provides ultra-rapid primary and secondary analysis of sequencing data using
field-programmable gate array technology (FPGA).

DRAGEN has a number of different pipelines and outputs, including base calling, DNA and RNA alignment, and
many others. Starting with the release of DRAGEN v3.6, it also supports primary analysis of sequencing
data, modelled after the QC metrics generated by the widely used FastQC tool.

This module parses the output from that hardware-accelerated QC tool, and uses it to generate similar
plots to both FastQC and MultiQC's current FastQC module. These plots are presented in their own
section and module, such that they can be run indepedently or in conjunction with other MultiQC
DRAGEN modules as desired.

- `<output prefix>.fastqc_metrics.csv`
  - Pre-calculated positional QV quantiles
  - Mean QVs by read position and base
  - A histogram of estimated read-level qualities
  - A histogram of read lengths
  - A smoothed histogram of sample GC content
  - Average read quality values for each GC content bin
  - Positional prevalence of ambiguous bases
  - Positional base content
  - Adapter/Kmer sequence start positions

#### Quality score box plots

By default, the box plots showing the range of quality scores are only shown if there are maximum 2 samples in the report. You can change this threshold with the following MultiQC config (eg. to max 10 samples):

```yaml
dragen_fastqc:
  quality_range_boxplots_max_samples: 10
```

If you prefer, you can force MultiQC to generate these box plots for _all_ samples using the following configuration:

```yaml
dragen_fastqc:
  force_quality_range_boxplots: true
```
