// Copyright (c) 1999-2014 OPEN CASCADE SAS
//
// This file is part of Open CASCADE Technology software library.
//
// This library is free software; you can redistribute it and / or modify it
// under the terms of the GNU Lesser General Public version 2.1 as published
// by the Free Software Foundation, with special exception defined in the file
// OCCT_LGPL_EXCEPTION.txt. Consult the file LICENSE_LGPL_21.txt included in OCCT
// distribution for complete text of the license and disclaimer of any warranty.
//
// Alternatively, this file may be used under the terms of Open CASCADE
// commercial license or contractual agreement.

// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _BRepExtrema_SolutionElem_HeaderFile
#define _BRepExtrema_SolutionElem_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineAlloc_HeaderFile
#include <Standard_DefineAlloc.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _gp_Pnt_HeaderFile
#include <gp_Pnt.hxx>
#endif
#ifndef _BRepExtrema_SupportType_HeaderFile
#include <BRepExtrema_SupportType.hxx>
#endif
#ifndef _TopoDS_Vertex_HeaderFile
#include <TopoDS_Vertex.hxx>
#endif
#ifndef _TopoDS_Edge_HeaderFile
#include <TopoDS_Edge.hxx>
#endif
#ifndef _TopoDS_Face_HeaderFile
#include <TopoDS_Face.hxx>
#endif
class gp_Pnt;
class TopoDS_Vertex;
class TopoDS_Edge;
class TopoDS_Face;


//! This class is used to store information relative to the <br>
//! minimum distance between two shapes. <br>
class BRepExtrema_SolutionElem
{
 public:

  DEFINE_STANDARD_ALLOC

  Standard_EXPORT BRepExtrema_SolutionElem()
  : myDist(0.), myPoint(0.,0.,0.), mySupType(BRepExtrema_IsVertex), myPar1(0.), myPar2(0.)
  {
  }
  //! initialisation of the fields <br>
  //! This constructor is used when the solution of a distance is a Vertex. <br>
  //! The different initialized fields are: <br>
  //!            _ the distance d <br>
  //!            _ the solution point <br>
  //!            _ the type of solution <br>
  //!            _ and the Vertex. <br>
  Standard_EXPORT BRepExtrema_SolutionElem(const Standard_Real d,const gp_Pnt& Pt,const BRepExtrema_SupportType SolType,const TopoDS_Vertex& vertex)
  : myDist(d), myPoint(Pt), mySupType(SolType), myVertex(vertex), myPar1(0.), myPar2(0.)
  {
  }
  //! initialisation of  the fiels. <br>
  //! This constructor is used when the  solution of distance is on an Edge. <br>
  //! The different initialized fields are: <br>
  //!            _ the distance d, <br>
  //!            _ the solution point, <br>
  //!            _ the type of solution, <br>
  //!            _ the Edge, <br>
  //!            _ and the parameter t to locate the solution. <br>
  Standard_EXPORT BRepExtrema_SolutionElem(const Standard_Real d,const gp_Pnt& Pt,const BRepExtrema_SupportType SolType,const TopoDS_Edge& edge,const Standard_Real t)
  : myDist(d), myPoint(Pt), mySupType(SolType), myEdge(edge), myPar1(t), myPar2(0.)
  {
  }
  //! initialisation of the fields <br>
  //! This constructor is used when the  solution of distance is in <br>
  //! a Face. The different initialized fields are: <br>
  //!            _ the distance d, <br>
  //!            _ the solution point, <br>
  //!            _ the type of solution, <br>
  //!            _ the Face, <br>
  //!            _ and the parameter u et v to locate the solution. <br>
  Standard_EXPORT BRepExtrema_SolutionElem(const Standard_Real d,const gp_Pnt& Pt,const BRepExtrema_SupportType SolType,const TopoDS_Face& face,const Standard_Real u,const Standard_Real v)
  : myDist(d), myPoint(Pt), mySupType(SolType), myFace(face), myPar1(u), myPar2(v)
  {
  }
  //! returns the value of the minimum distance. <br>
  Standard_EXPORT Standard_Real Dist() const
  {
    return myDist;
  }
  //! returns the solution point. <br>
  Standard_EXPORT const gp_Pnt & Point() const
  {
    return myPoint;
  }
  //! returns the Support type : <br>
  //!	    IsVertex => The solution is a vertex. <br>
  //! 	    IsOnEdge => The solution belongs to an Edge. <br>
  //! 	    IsInFace => The solution is inside a Face. <br>
  Standard_EXPORT BRepExtrema_SupportType SupportKind() const
  {
    return mySupType;
  }
  //! returns the vertex if the solution is a Vertex. <br>
  Standard_EXPORT const TopoDS_Vertex & Vertex() const
  {
    return myVertex;
  }
  //! returns the vertex if the solution is an Edge. <br>
  Standard_EXPORT const TopoDS_Edge & Edge() const
  {
    return myEdge;
  }
  //! returns the vertex if the solution is an Face. <br>
  Standard_EXPORT const TopoDS_Face & Face() const
  {
    return myFace;
  }
  //! returns the parameter t if the solution is on Edge. <br>
  Standard_EXPORT void EdgeParameter(Standard_Real& par1) const
  {
    par1 = myPar1;
  }
  //! returns the parameters u et v if the solution is in a Face. <br>
  Standard_EXPORT void FaceParameter(Standard_Real& par1,Standard_Real& par2) const
  {
    par1 = myPar1;
    par2 = myPar2;
  }

 private:

  Standard_Real myDist;
  gp_Pnt myPoint;
  BRepExtrema_SupportType mySupType;
  TopoDS_Vertex myVertex;
  TopoDS_Edge myEdge;
  TopoDS_Face myFace;
  Standard_Real myPar1;
  Standard_Real myPar2;
};

#endif
