/*
 *  Copyright (c) 2009,2010 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _OPENRIJN_LIGHT_PARSER_H_
#define _OPENRIJN_LIGHT_PARSER_H_

#include "GTLCore/ParserBase_p.h"

#include "Source.h"

namespace GTLCore {
  class String;
};

namespace GTLFragment {
  class Lexer;
}

namespace OpenRijn {
  /**
   * @internal
   * @ingroup OpenRijn
   *
   * This is a light parser that is only used to extract a few information from a
   * kernel. Such as the parameters of the evaluatePixel function.
   */
  class LightParser : public GTLCore::ParserBase {
    public:
      LightParser( GTLFragment::Lexer* );
      ~LightParser();
      GTLCore::AST::Tree* parse();
      virtual GTLCore::AST::Tree* tree() { return 0; }
      virtual GTLCore::AST::Statement* parseStatement() { return 0; }
      Source::SourceType sourceType() const;
      GTLCore::String name() const;
    private:
      void eatUntil( GTLCore::Token::Type type1,  GTLCore::Token::Type type2);
      void eatLoopOf( GTLCore::Token::Type start, GTLCore::Token::Type end);
    private:
      struct Private;
      Private* const d;
  };
}

#endif
