###############################################################################
# Local Security Check Automation Framework
#
# Authors:
# Veerendra GG <veerendragg@secpod.com>
#
# Revision 1.0
# Date: 2008/12/26
#
# Copyright:
# Copyright (c) 2009 SecPod , http://www.secpod.org
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################


#
# Parser package
#
#
# Interfaces:
# 1. parser(html_content, debug=0)
#    Sets the parsed content into 'parse' object's attributes. The parse
#    object attributes are described below.
#    - html_content: HTML based vendor advisory
#
# 2. fetchHTML(self, year, debug=0)
#    Retuns the advisory pages for the specified year
#    - year: The year for which the advisories are to be fetched
#
# Parser implementation must parse the respective vendor advisories and set
# the following mandatory attributes, in the format specified below,
#   Attribute Name	Type	Description
#
#   AdvID               String      Security Advisory ID
#
#   Description         String      Vulnerability description
#
#   Packages            Dictionary  List of affected packages
#                                   ({'platform1':['package1', 'package2'],
#                                     'platform2':['package1', 'package2']})
#
#   CVEs                String      ('"CVE1","CVE2", "CVE3"')
#
#   Name                String      Name of the advisory (a unique
#                                   value containing Advisory ID)
#
#   Summary             String      Affected package name
#
#   Platforms           String      Affected platforms ("OpenSuSE 10.1, 11.0")
#
#   FileName		String      Advisory ID underscore seperated for use as NASL file name
#                                   Example: SUSE_2008_059
#
#   XREF		List	    Advisory ID to be used in script_xref("key", "value")
#                                   Example: script_xref("SUSE-SA" "2008:059")
#
import suse
import fedora
import redhat
import centos
import debian
import ubuntu
import mandriva
import hp_ux
import gentoo
import solaris
