##############################################################################
# Local Security Check Automation Framework
#
# Authors:
# Veerendra GG <veerendragg@secpod.com>
#
# Revision 1.0
# Date: 2009/04/30
#
# Copyright:
# Copyright (c) 2009 SecPod , http://www.secpod.org
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

import unittest
from parser import hp_ux


class HPUXParserTestCase(unittest.TestCase):

    ## Initial Setup
    hpux_parser_obj = hp_ux.Parser()

    def setUp(self):
        ptr = open('./test/unit_test/work/input/hp_ux_emr_na_c01650939_4.html', 'r')
        lines = ptr.readlines()
        ptr.close

        self.Html_content = "".join(lines)
        setattr(self.hpux_parser_obj, 'Html_content', self.Html_content)


    def test_getCVE(self):
        print "\nTesting HP-UX Parser Test Suite ..."
        req_out_put = 'CVE-2007-6420", "CVE-2008-1232", "CVE-2008-1947", "CVE-2008-2364", "CVE-2008-2370", "CVE-2008-2938", "CVE-2008-2939", "CVE-2008-3658'

        out_put = self.hpux_parser_obj.getCVE()
        self.assertEquals(out_put, req_out_put)


    def test_getAdvID(self):
        req_out_put = 'HPSBUX02401'

        out_put = self.hpux_parser_obj.getAdvID()
        self.assertEquals(out_put, req_out_put)


    def test_getAffectedPackage1(self):
        req_out_put = 'Apache Web Server Suite'

        out_put = self.hpux_parser_obj.getAffectedPackage()
        self.assertEquals(out_put, req_out_put)


    def test_getAffectedPackage2(self):
        ptr = open('./test/unit_test/work/input/hp_ux_emr_na_c01683026_2.html', 'r')
        lines = ptr.readlines()
        ptr.close

        self.Html_content = "".join(lines)
        setattr(self.hpux_parser_obj, 'Html_content', self.Html_content)

        req_out_put = 'Java'

        out_put = self.hpux_parser_obj.getAffectedPackage()
        self.assertEquals(out_put, req_out_put)


    def acbd_getDescription(self):
        req_out_put = "Potential security vulnerabilities have been identified with HP-UX running \n  Apache-based Web Server or Tomcat-based Servelet Engine. The vulnerabilities \n  could be exploited remotely to cause a Denial of Service (DoS), cross-site \n  scripting (XSS), execution of arbitrary code, or cross-site request forgery \n  (CSRF). Apache-based Web Server and Tomcat-based Servelet Engine are \n  contained in the Apache Web Server Suite. " 

        out_put = self.hpux_parser_obj.getDescription()
        self.assertEquals(out_put, req_out_put)


    def test_getAffectedProduct(self):
        req_out_put = ['HP-UX B.11.23 and B.11.31 running Apache-based Web Server v2.2.8.01.01 or v2.0.59.07.02 or earlier or Tomcat-based Servelet Engine v5.5.27.01 or earlier', 'HP-UX B.11.11 running Apache-based Web Server v2.0.59.07.02 or earlier or Tomcat-based Servelet Engine v5.5.27.01 or earlier']

        out_put = self.hpux_parser_obj.getAffectedProduct()
        self.assertEquals(out_put, req_out_put)


    def test_getRPM1(self):
        req_out_put = {'HPUX11.31': ['hpuxws22APACHE.APACHE~B.2.2.8.01.02', 'hpuxws22APACHE.APACHE2~B.2.2.8.01.02', 'hpuxws22TOMCAT.TOMCAT~B.2.2.8.01.02', 'hpuxwsAPCH32.APACHE~B.2.0.59.07.03', 'hpuxwsAPCH32.APACHE2~B.2.0.59.07.03', 'hpuxwsTOMCAT.TOMCAT~B.2.0.59.07.03'], 'HPUX11.23': ['hpuxws22APCH32.APACHE~B.2.2.8.01.02', 'hpuxws22APCH32.APACHE2~B.2.2.8.01.02', 'hpuxws22TOMCAT.TOMCAT~B.2.2.8.01.02', 'hpuxwsAPCH32.APACHE~B.2.0.59.07.03', 'hpuxwsAPCH32.APACHE2~B.2.0.59.07.03', 'hpuxwsTOMCAT.TOMCAT~B.2.0.59.07.03'], 'HPUX11.11': ['hpuxwsAPACHE.APACHE~B.2.0.59.07.03', 'hpuxwsAPACHE.APACHE2~B.2.0.59.07.03', 'hpuxwsTOMCAT.TOMCAT~B.2.0.59.07.03']} 

        out_put = self.hpux_parser_obj.getRPM()
        self.assertEquals(out_put, req_out_put)


    def test_getRPM2(self):
        req_out_put = {'HPUX11.31': ['Jdk14.JDK14-COM~1.4.2.21.00', 'Jdk14.JDK14-IPF32~1.4.2.21.00', 'Jdk14.JDK14-IPF64~1.4.2.21.00', 'Jdk14.JDK14-PA11~1.4.2.21.00', 'Jdk14.JDK14-PA20~1.4.2.21.00', 'Jdk14.JDK14-PA20W~1.4.2.21.00', 'Jre14.JRE14-COM~1.4.2.21.00', 'Jre14.JRE14-IPF32~1.4.2.21.00', 'Jre14.JRE14-IPF32-HS~1.4.2.21.00', 'Jre14.JRE14-IPF64~1.4.2.21.00', 'Jre14.JRE14-IPF64-HS~1.4.2.21.00', 'Jre14.JRE14-PA11~1.4.2.21.00', 'Jre14.JRE14-PA11-HS~1.4.2.21.00', 'Jre14.JRE14-PA20~1.4.2.21.00', 'Jre14.JRE14-PA20-HS~1.4.2.21.00', 'Jre14.JRE14-PA20W~1.4.2.21.00', 'Jre14.JRE14-PA20W-HS~1.4.2.21.00', 'Jdk15.JDK15-COM~1.5.0.15.00', 'Jdk15.JDK15-PA20~1.5.0.15.00', 'Jdk15.JDK15-PA20W~1.5.0.15.00', 'Jdk15.JDK15-IPF32~1.5.0.15.00', 'Jdk15.JDK15-IPF64~1.5.0.15.00', 'Jre15.JRE15-COM~1.5.0.15.00', 'Jre15.JRE15-PA20~1.5.0.15.00', 'Jre15.JRE15-PA20-HS~1.5.0.15.00', 'Jre15.JRE15-PA20W~1.5.0.15.00', 'Jre15.JRE15-PA20W-HS~1.5.0.15.00', 'Jre15.JRE15-IPF32~1.5.0.15.00', 'Jre15.JRE15-IPF32-HS~1.5.0.15.00', 'Jre15.JRE15-IPF64~1.5.0.15.00', 'Jre15.JRE15-IPF64-HS~1.5.0.15.00', 'Jdk60.JDK60-COM~1.6.0.03.00', 'Jdk60.JDK60-PA20~1.6.0.03.00', 'Jdk60.JDK60-PA20W~1.6.0.03.00', 'Jdk60.JDK60-IPF32~1.6.0.03.00', 'Jdk60.JDK60-IPF64~1.6.0.03.00', 'Jre60.JRE60-COM~1.6.0.03.00', 'Jre60.JRE60-IPF32~1.6.0.03.00', 'Jre60.JRE60-IPF32-HS~1.6.0.03.00', 'Jre60.JRE60-IPF64~1.6.0.03.00', 'Jre60.JRE60-IPF64-HS~1.6.0.03.00', 'Jre60.JRE60-PA20~1.6.0.03.00', 'Jre60.JRE60-PA20-HS~1.6.0.03.00', 'Jre60.JRE60-PA20W~1.6.0.03.00', 'Jre60.JRE60-PA20W-HS~1.6.0.03.00'], 'HPUX11.23': ['Jdk14.JDK14-COM~1.4.2.21.00', 'Jdk14.JDK14-IPF32~1.4.2.21.00', 'Jdk14.JDK14-IPF64~1.4.2.21.00', 'Jdk14.JDK14-PA11~1.4.2.21.00', 'Jdk14.JDK14-PA20~1.4.2.21.00', 'Jdk14.JDK14-PA20W~1.4.2.21.00', 'Jre14.JRE14-COM~1.4.2.21.00', 'Jre14.JRE14-IPF32~1.4.2.21.00', 'Jre14.JRE14-IPF32-HS~1.4.2.21.00', 'Jre14.JRE14-IPF64~1.4.2.21.00', 'Jre14.JRE14-IPF64-HS~1.4.2.21.00', 'Jre14.JRE14-PA11~1.4.2.21.00', 'Jre14.JRE14-PA11-HS~1.4.2.21.00', 'Jre14.JRE14-PA20~1.4.2.21.00', 'Jre14.JRE14-PA20-HS~1.4.2.21.00', 'Jre14.JRE14-PA20W~1.4.2.21.00', 'Jre14.JRE14-PA20W-HS~1.4.2.21.00', 'Jdk15.JDK15-COM~1.5.0.15.00', 'Jdk15.JDK15-PA20~1.5.0.15.00', 'Jdk15.JDK15-PA20W~1.5.0.15.00', 'Jdk15.JDK15-IPF32~1.5.0.15.00', 'Jdk15.JDK15-IPF64~1.5.0.15.00', 'Jre15.JRE15-COM~1.5.0.15.00', 'Jre15.JRE15-PA20~1.5.0.15.00', 'Jre15.JRE15-PA20-HS~1.5.0.15.00', 'Jre15.JRE15-PA20W~1.5.0.15.00', 'Jre15.JRE15-PA20W-HS~1.5.0.15.00', 'Jre15.JRE15-IPF32~1.5.0.15.00', 'Jre15.JRE15-IPF32-HS~1.5.0.15.00', 'Jre15.JRE15-IPF64~1.5.0.15.00', 'Jre15.JRE15-IPF64-HS~1.5.0.15.00', 'Jdk60.JDK60-COM~1.6.0.03.00', 'Jdk60.JDK60-PA20~1.6.0.03.00', 'Jdk60.JDK60-PA20W~1.6.0.03.00', 'Jdk60.JDK60-IPF32~1.6.0.03.00', 'Jdk60.JDK60-IPF64~1.6.0.03.00', 'Jre60.JRE60-COM~1.6.0.03.00', 'Jre60.JRE60-IPF32~1.6.0.03.00', 'Jre60.JRE60-IPF32-HS~1.6.0.03.00', 'Jre60.JRE60-IPF64~1.6.0.03.00', 'Jre60.JRE60-IPF64-HS~1.6.0.03.00', 'Jre60.JRE60-PA20~1.6.0.03.00', 'Jre60.JRE60-PA20-HS~1.6.0.03.00', 'Jre60.JRE60-PA20W~1.6.0.03.00', 'Jre60.JRE60-PA20W-HS~1.6.0.03.00'], 'HPUX11.11': ['Jdk14.JDK14-COM~1.4.2.21.00', 'Jdk14.JDK14-IPF32~1.4.2.21.00', 'Jdk14.JDK14-IPF64~1.4.2.21.00', 'Jdk14.JDK14-PA11~1.4.2.21.00', 'Jdk14.JDK14-PA20~1.4.2.21.00', 'Jdk14.JDK14-PA20W~1.4.2.21.00', 'Jre14.JRE14-COM~1.4.2.21.00', 'Jre14.JRE14-IPF32~1.4.2.21.00', 'Jre14.JRE14-IPF32-HS~1.4.2.21.00', 'Jre14.JRE14-IPF64~1.4.2.21.00', 'Jre14.JRE14-IPF64-HS~1.4.2.21.00', 'Jre14.JRE14-PA11~1.4.2.21.00', 'Jre14.JRE14-PA11-HS~1.4.2.21.00', 'Jre14.JRE14-PA20~1.4.2.21.00', 'Jre14.JRE14-PA20-HS~1.4.2.21.00', 'Jre14.JRE14-PA20W~1.4.2.21.00', 'Jre14.JRE14-PA20W-HS~1.4.2.21.00', 'Jdk15.JDK15-COM~1.5.0.15.00', 'Jdk15.JDK15-PA20~1.5.0.15.00', 'Jdk15.JDK15-PA20W~1.5.0.15.00', 'Jdk15.JDK15-IPF32~1.5.0.15.00', 'Jdk15.JDK15-IPF64~1.5.0.15.00', 'Jre15.JRE15-COM~1.5.0.15.00', 'Jre15.JRE15-PA20~1.5.0.15.00', 'Jre15.JRE15-PA20-HS~1.5.0.15.00', 'Jre15.JRE15-PA20W~1.5.0.15.00', 'Jre15.JRE15-PA20W-HS~1.5.0.15.00', 'Jre15.JRE15-IPF32~1.5.0.15.00', 'Jre15.JRE15-IPF32-HS~1.5.0.15.00', 'Jre15.JRE15-IPF64~1.5.0.15.00', 'Jre15.JRE15-IPF64-HS~1.5.0.15.00', 'Jdk60.JDK60-COM~1.6.0.03.00', 'Jdk60.JDK60-PA20~1.6.0.03.00', 'Jdk60.JDK60-PA20W~1.6.0.03.00', 'Jdk60.JDK60-IPF32~1.6.0.03.00', 'Jdk60.JDK60-IPF64~1.6.0.03.00', 'Jre60.JRE60-COM~1.6.0.03.00', 'Jre60.JRE60-IPF32~1.6.0.03.00', 'Jre60.JRE60-IPF32-HS~1.6.0.03.00', 'Jre60.JRE60-IPF64~1.6.0.03.00', 'Jre60.JRE60-IPF64-HS~1.6.0.03.00', 'Jre60.JRE60-PA20~1.6.0.03.00', 'Jre60.JRE60-PA20-HS~1.6.0.03.00', 'Jre60.JRE60-PA20W~1.6.0.03.00', 'Jre60.JRE60-PA20W-HS~1.6.0.03.00']}

        ptr = open('./test/unit_test/work/input/hp_ux_emr_na_c01683026_2.html', 'r')
        lines = ptr.readlines()
        ptr.close

        self.Html_content = "".join(lines)
        setattr(self.hpux_parser_obj, 'Html_content', self.Html_content)

        out_put = self.hpux_parser_obj.getRPM()
        self.assertEquals(out_put, req_out_put)


    def test_getRPM3(self):
        req_out_put = {'HPUX11.31': ['VRTSodm.ODM-KRN~PHCO_38913, PHCO_39132, PHKL_39130', 'VRTSodm.ODM-RUN~PHCO_38913, PHCO_39132, PHKL_39130', 'VRTSodm.ODM-MAN~PHCO_38913, PHCO_39132, PHKL_39130', 'VRTSvxfs.VXFS-RUN~PHCO_38913, PHCO_39132, PHKL_39130'], 'HPUX11.23': ['VRTSodm.ODM-KRN~PHCO_39027, PHKL_39029', 'VRTSodm.ODM-RUN~PHCO_39027, PHKL_39029', 'VRTSodm.ODM-MAN~PHCO_39027, PHKL_39029', 'VRTSvxfs.VXFS-RUN~PHCO_39027, PHKL_39029', 'VRTSvxfs.VXFS-RUN-PALIB~PHCO_39027, PHKL_39029', 'VRTSvxfs.VXFS-PRG~PHCO_39027, PHKL_39029', 'VRTSodm.ODM-KRN~PHCO_39103, PHCO_39104, PHKL_38795', 'VRTSodm.ODM-RUN~PHCO_39103, PHCO_39104, PHKL_38795', 'VRTSodm.ODM-MAN~PHCO_39103, PHCO_39104, PHKL_38795', 'VRTSvxfs.VXFS-RUN~PHCO_39103, PHCO_39104, PHKL_38795', 'VRTSvxfs.VXFS-RUN-PALIB~PHCO_39103, PHCO_39104, PHKL_38795', 'VRTSvxfs.VXFS-PRG~PHCO_39103, PHCO_39104, PHKL_38795'], 'HPUX11.11': ['VRTSvxfs.VXFS-RUN~PHCO_39124']} 

        ptr = open('./test/unit_test/work/input/hp_ux_emr_na_c01674733_1.html', 'r')
        lines = ptr.readlines()
        ptr.close

        self.Html_content = "".join(lines)
        setattr(self.hpux_parser_obj, 'Html_content', self.Html_content)

        out_put = self.hpux_parser_obj.getRPM()
        self.assertEquals(out_put, req_out_put)


    def test_formatReference(self):
        req_out_put = 'http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c01674733-1'

        main_url = 'http://www11.itrc.hp.com/service/cki/docDisplay.do?docId='
        file_name = 'hp_ux_emr_na_c01674733_1.html'
        out_put = self.hpux_parser_obj.formatReference(main_url, file_name)
        self.assertEquals(out_put, req_out_put)


    def test_parser(self):
        req_out_put = True

        out_put = self.hpux_parser_obj.parser(self.Html_content)
        self.assertEquals(out_put, req_out_put)


    def test_getYearLinks(self):
        req_out_put = ['http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c01539431-1', 'http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c01690019-1', 'http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c01706219-2', 'http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c01674733-1', 'http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c01683026-2', 'http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c01650939-4', 'http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c01666473-2', 'http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c01662367-1']

        ptr = open('./test/unit_test/work/input/hpux_advisory-main.html', 'r')
        lines = ptr.readlines()
        ptr.close

        content = "".join(lines)

        link = './test/unit_test/work/input/hpux_advisory-main.html'
        year = '2009'
        out_put = self.hpux_parser_obj._getYearLinks(content, year)
        self.assertEquals(out_put, req_out_put)


if __name__ == '__main__':
    unittest.main()

