# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 364-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53653);
 script_cve_id("CVE-2003-0620", "CVE-2003-0645");
 script_version ("$");
 script_tag(name:"cvss_base", value:"4.6");
 script_tag(name:"risk_factor", value:"Medium");
 name = "Debian Security Advisory DSA 364-1 (man-db)";
 script_name(name);

 desc = "The remote host is missing an update to man-db
announced via advisory DSA 364-1.

man-db provides the standard man(1) command on Debian systems.  During
configuration of this package, the administrator is asked whether
man(1) should run setuid to a dedicated user ('man') in order to
provide a shared cache of preformatted manual pages.  The default is
for man(1) NOT to be setuid, and in this configuration no known
vulnerability exists.  However, if the user explicitly requests setuid
operation, a local attacker could exploit either of the following bugs to
execute arbitrary code as the 'man' user.

Again, these vulnerabilities do not affect the default configuration,
where man is not setuid.

- - CVE-2003-0620: Multiple buffer overflows in man-db 2.4.1 and
earlier, when installed setuid, allow local users to gain privileges
via (1) MANDATORY_MANPATH, MANPATH_MAP, and MANDB_MAP arguments to
add_to_dirlist in manp.c, (2) a long pathname to ult_src in
ult_src.c, (3) a long .so argument to test_for_include in ult_src.c,
(4) a long MANPATH environment variable, or (5) a long PATH
environment variable.

- - CVE-2003-0645: Certain DEFINE directives in ~/.manpath, which
contained commands to be executed, would be honored even when
running setuid, allowing any user to execute commands as the
'man' user.

For the current stable distribution (woody), these problems have been
fixed in version 2.3.20-18.woody.2.

For the unstable distribution (sid), these problems have been fixed in
version 2.4.1-12.

We recommend that you update your man-db package.



Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20364-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 364-1 (man-db)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"man-db", ver:"2.3.20-18.woody.2", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
