#
#VID 1033750f-cab4-11d9-9aed-000e0c2e438a
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52762);
 script_cve_id("CVE-2005-1121");
 script_bugtraq_id(13172);
 script_version ("$");
 script_tag(name:"cvss_base", value:"5.0");
 script_tag(name:"risk_factor", value:"Medium");
 name = "FreeBSD Ports: oops";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: oops

CVE-2005-1121
Format string vulnerability in the my_xlog function in lib.c for Oops!
Proxy Server 1.5.23 and earlier, as called by the auth functions in
the passwd_mysql and passwd_pgsql modules, may allow attackers to
execute arbitrary code via a URL.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://rst.void.ru/papers/advisory24.txt
http://www.vuxml.org/freebsd/1033750f-cab4-11d9-9aed-000e0c2e438a.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: oops";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"oops");
if(!isnull(bver) && revcomp(a:bver, b:"1.5.24")<=0) {
    security_note(0, data:"Package oops version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
