###############################################################################
# OpenVAS Vulnerability Test
# $Id: phpbb_3_0_4.nasl 112 2009-03-09 09:50:21Z mime $
#
# phpBB 'ucp.php' Cross Site Scripting Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################


if (description)
{
 script_id(100035);
 script_bugtraq_id(33995);
 script_version ("1.0");
 script_tag(name:"risk_factor", value:"Medium");

 script_name("phpBB 'ucp.php' Cross Site Scripting Vulnerability");
 desc = "

 Overview:
  According to its version number, the remote version of phpbb
  is prone to a cross-site scripting vulnerability because it fails to
  sufficiently sanitize user-supplied data.

  An attacker may leverage this issue to execute arbitrary script code in the
  browser of an unsuspecting user in the context of the affected site. This may
  allow the attacker to steal cookie-based authentication credentials and to
  launch other attacks.

  This issue affects phpBB 3.x; other versions may also be affected. 

 See also;
  http://www.securityfocus.com/bid/33995
  http://www.phpbb.com/

 Solution:
  Upgrade to newer Version if available.
  

 Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if phpbb 3.0.x is vulnerable to xss");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("phpbb_detect.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("global_settings.inc");
include("http_func.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);

install = get_kb_item(string("www/", port, "/phpBB"));
if (isnull(install)) exit(0);

matches = eregmatch(string:install, pattern:"^(.+) under (/.*)$");
if (!isnull(matches)) {
	version = matches[1];
	if ( ereg(pattern:"3\.0\.*[1-4]*", string:version)) {
	   security_warning(port);
	   exit(0);
	}
}
