#  This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
#  based on work from
# (C) Tenable Network Security
#
# This script is released under the GNU GPLv2

if(description)
{
 script_id(14226);
 script_bugtraq_id(10868, 10893);
 script_xref(name:"OSVDB", value:"8353");

 script_version("$Revision: 7518 $");
 script_tag(name:"risk_factor", value:"High");
 name = "phpBB Fetch All < 2.0.12";
 script_name(name);
 
 desc = "
The remote host is running a version of phpBB FetchAll older than 2.0.12.

It is reported that this version of phpBB Fetch All is susceptible 
to an SQL injection vulnerability. This issue is due to a failure of
the application to properly sanitize user-supplied input before using 
it in an SQL query.

The successful exploitation of this vulnerability depends on the 
implementation of the web application that includes phpBB Fetch All 
as a component.  It may or may not be possible to effectively pass 
malicious SQL statements to the underlying function. 

Successful exploitation could result in compromise of the application, 
disclosure or modification of data or may permit an attacker to exploit 
vulnerabilities in the underlying database implementation.


Solution : Upgrade to phpBB Fetch All 2.0.12 or later
Risk factor : High";


 script_description(desc);
 
 summary = "Check for phpBB Fetch All version";
 
 script_summary(summary);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright("This script is Copyright (C) 2004 David Maciejak");
 
 family = "Web application abuses";
 script_family(family);
 script_dependencie("phpbb_detect.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

# Check starts here

include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);
if(!get_port_state(port)) exit(0);

kb = get_kb_item("www/" + port + "/phpBB");
if ( ! kb ) exit(0);
matches = eregmatch(pattern:"(.*) under (.*)", string:kb);
location = matches[2];

req = http_get(item:location + "/index.php", port:port);
res = http_keepalive_send_recv(port:port, data:req);
if ( ! res ) exit(0);

if ( ereg(pattern:"Fetch by phpBB Fetch All ([01]\..*|2\.0\.([0-9]|1[01])[^0-9])", string:version))
	security_hole(port);

